/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import koala.dynamicjava.classfile.AttributeInfo;
import koala.dynamicjava.classfile.AttributeOwnerComponent;
import koala.dynamicjava.classfile.ConstantPool;
import koala.dynamicjava.classfile.ConstantValueAttribute;
import koala.dynamicjava.classfile.JVMUtilities;

public class FieldInfo
extends AttributeOwnerComponent {
    private short descriptorIndex;

    public FieldInfo(ConstantPool cp, String tp, String nm) {
        this.constantPool = cp;
        this.nameIndex = this.constantPool.putUTF8(nm);
        this.descriptorIndex = this.constantPool.putUTF8(JVMUtilities.getReturnTypeName(tp));
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeShort(this.accessFlags);
        out.writeShort(this.nameIndex);
        out.writeShort(this.descriptorIndex);
        out.writeShort(this.attributes.size());
        Iterator it = this.attributes.iterator();
        while (it.hasNext()) {
            ((AttributeInfo)it.next()).write(out);
        }
    }

    public void setPublic() {
        this.accessFlags = (short)(this.accessFlags | 1);
    }

    public void setPrivate() {
        this.accessFlags = (short)(this.accessFlags | 2);
    }

    public void setProtected() {
        this.accessFlags = (short)(this.accessFlags | 4);
    }

    public void setStatic() {
        this.accessFlags = (short)(this.accessFlags | 8);
    }

    public void setFinal() {
        this.accessFlags = (short)(this.accessFlags | 0x10);
    }

    public void setVolatile() {
        this.accessFlags = (short)(this.accessFlags | 0x40);
    }

    public void setTransient() {
        this.accessFlags = (short)(this.accessFlags | 0x80);
    }

    public void setConstantValueAttribute(Integer value) {
        this.attributes.add(new ConstantValueAttribute(this.constantPool, value));
    }

    public void setConstantValueAttribute(Long value) {
        this.attributes.add(new ConstantValueAttribute(this.constantPool, value));
    }

    public void setConstantValueAttribute(Float value) {
        this.attributes.add(new ConstantValueAttribute(this.constantPool, value));
    }

    public void setConstantValueAttribute(Double value) {
        this.attributes.add(new ConstantValueAttribute(this.constantPool, value));
    }

    public void setConstantValueAttribute(String value) {
        this.attributes.add(new ConstantValueAttribute(this.constantPool, value));
    }
}

