/*
 * Decompiled with CFR 0.152.
 */
package gj.util;

import gj.util.Enumeration;
import gj.util.VectorEnumerator;
import java.io.Serializable;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vector<A>
implements Serializable,
Cloneable {
    protected A[] elementData;
    protected int elementCount;
    protected int capacityIncrement;

    public Vector(int n, int n2) {
        this.elementData = new Object[n];
        this.capacityIncrement = n2;
    }

    public Vector(int n) {
        this(n, 0);
    }

    public Vector() {
        this(10);
    }

    public final synchronized void copyInto(A[] AArray) {
        int n = this.elementCount;
        while (n-- > 0) {
            AArray[n] = this.elementData[n];
        }
    }

    public final synchronized void trimToSize() {
        int n = this.elementData.length;
        if (this.elementCount < n) {
            A[] AArray = this.elementData;
            this.elementData = new Object[this.elementCount];
            System.arraycopy(AArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final synchronized void ensureCapacity(int n) {
        int n2 = this.elementData.length;
        if (n > n2) {
            int n3;
            A[] AArray = this.elementData;
            int n4 = n3 = this.capacityIncrement > 0 ? n2 + this.capacityIncrement : n2 * 2;
            if (n3 < n) {
                n3 = n;
            }
            this.elementData = new Object[n3];
            System.arraycopy(AArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final synchronized void setSize(int n) {
        if (n > this.elementCount) {
            this.ensureCapacity(n);
        } else {
            for (int i = n; i < this.elementCount; ++i) {
                this.elementData[i] = null;
            }
        }
        this.elementCount = n;
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public final int size() {
        return this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final synchronized Enumeration<A> elements() {
        return new VectorEnumerator(this);
    }

    public final boolean contains(A a) {
        return this.indexOf(a, 0) >= 0;
    }

    public final int indexOf(A a) {
        return this.indexOf(a, 0);
    }

    public final synchronized int indexOf(A a, int n) {
        for (int i = n; i < this.elementCount; ++i) {
            if (!a.equals(this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOf(A a) {
        return this.lastIndexOf(a, this.elementCount);
    }

    public final synchronized int lastIndexOf(A a, int n) {
        int n2 = n;
        while (--n2 >= 0) {
            if (!a.equals(this.elementData[n2])) continue;
            return n2;
        }
        return -1;
    }

    public final synchronized A elementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(String.valueOf(n).concat(String.valueOf(" >= "))).concat(String.valueOf(this.elementCount)));
        }
        try {
            return this.elementData[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n).concat(String.valueOf(" < 0")));
        }
    }

    public final synchronized A firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public final synchronized A lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public final synchronized void setElementAt(A a, int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(String.valueOf(n).concat(String.valueOf(" >= "))).concat(String.valueOf(this.elementCount)));
        }
        this.elementData[n] = a;
    }

    public final synchronized void removeElementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(String.valueOf(n).concat(String.valueOf(" >= "))).concat(String.valueOf(this.elementCount)));
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
    }

    public final synchronized void insertElementAt(A a, int n) {
        if (n >= this.elementCount + 1) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(String.valueOf(String.valueOf(n).concat(String.valueOf(" >= "))).concat(String.valueOf(this.elementCount))).concat(String.valueOf(1)));
        }
        this.ensureCapacity(this.elementCount + 1);
        System.arraycopy(this.elementData, n, this.elementData, n + 1, this.elementCount - n);
        this.elementData[n] = a;
        ++this.elementCount;
    }

    public final synchronized void addElement(A a) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount++] = a;
    }

    public final synchronized boolean removeElement(A a) {
        int n = this.indexOf(a);
        if (n >= 0) {
            this.removeElementAt(n);
            return true;
        }
        return false;
    }

    public final synchronized void removeAllElements() {
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = null;
        }
        this.elementCount = 0;
    }

    public synchronized Object clone() {
        Vector<A> vector = new Vector<A>(this.elementCount, this.capacityIncrement);
        System.arraycopy(this.elementData, 0, vector.elementData, 0, this.elementCount);
        return vector;
    }

    public final synchronized String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<A> enumeration = this.elements();
        stringBuffer.append("[");
        for (int i = 0; i <= n; ++i) {
            stringBuffer.append(enumeration.nextElement());
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

