/*
 * Decompiled with CFR 0.152.
 */
package gj.util;

import gj.util.Dictionary;
import gj.util.Enumeration;
import gj.util.HashtableEntry;
import gj.util.KeyEnumerator;
import gj.util.ValueEnumerator;
import java.io.Serializable;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hashtable<A, B>
extends Dictionary<A, B>
implements Serializable,
Cloneable {
    private HashtableEntry<A, B>[] table;
    private int count;
    private int threshold;
    private float loadFactor;

    public Hashtable(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = f;
        this.table = new HashtableEntry[n];
        this.threshold = (int)((float)n * f);
    }

    public Hashtable(int n) {
        this(n, 0.75f);
    }

    public Hashtable() {
        this(101, 0.75f);
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public synchronized Enumeration<A> keys() {
        return new KeyEnumerator<A, B>(this.table);
    }

    @Override
    public synchronized Enumeration<B> elements() {
        return new ValueEnumerator<A, B>(this.table);
    }

    public synchronized boolean contains(B b) {
        HashtableEntry<A, B>[] hashtableEntryArray = this.table;
        int n = hashtableEntryArray.length;
        while (n-- > 0) {
            HashtableEntry<A, B> hashtableEntry = hashtableEntryArray[n];
            while (hashtableEntry != null) {
                if (hashtableEntry.value.equals(b)) {
                    return true;
                }
                hashtableEntry = hashtableEntry.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(A a) {
        HashtableEntry<A, B>[] hashtableEntryArray = this.table;
        int n = a.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry<A, B> hashtableEntry = hashtableEntryArray[n2];
        while (hashtableEntry != null) {
            if (hashtableEntry.hash == n && hashtableEntry.key.equals(a)) {
                return true;
            }
            hashtableEntry = hashtableEntry.next;
        }
        return false;
    }

    @Override
    public synchronized B get(A a) {
        HashtableEntry<A, B>[] hashtableEntryArray = this.table;
        int n = a.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry<A, B> hashtableEntry = hashtableEntryArray[n2];
        while (hashtableEntry != null) {
            if (hashtableEntry.hash == n && hashtableEntry.key.equals(a)) {
                return hashtableEntry.value;
            }
            hashtableEntry = hashtableEntry.next;
        }
        return null;
    }

    protected void rehash() {
        int n = this.table.length;
        HashtableEntry<A, B>[] hashtableEntryArray = this.table;
        int n2 = n * 2 + 1;
        HashtableEntry[] hashtableEntryArray2 = new HashtableEntry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = hashtableEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            HashtableEntry<A, B> hashtableEntry = hashtableEntryArray[n3];
            while (hashtableEntry != null) {
                HashtableEntry<A, B> hashtableEntry2 = hashtableEntry;
                hashtableEntry = hashtableEntry.next;
                int n4 = (hashtableEntry2.hash & Integer.MAX_VALUE) % n2;
                hashtableEntry2.next = hashtableEntryArray2[n4];
                hashtableEntryArray2[n4] = hashtableEntry2;
            }
        }
    }

    @Override
    public synchronized B put(A a, B b) {
        HashtableEntry<A, B>[] hashtableEntryArray = this.table;
        int n = a.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry<A, B> hashtableEntry = hashtableEntryArray[n2];
        while (hashtableEntry != null) {
            if (hashtableEntry.hash == n && hashtableEntry.key.equals(a)) {
                Object b2 = hashtableEntry.value;
                hashtableEntry.value = b;
                return b2;
            }
            hashtableEntry = hashtableEntry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(a, b);
        }
        hashtableEntryArray[n2] = new HashtableEntry<A, B>(a, b, n, hashtableEntryArray[n2]);
        ++this.count;
        return null;
    }

    @Override
    public synchronized B remove(A a) {
        HashtableEntry<A, B>[] hashtableEntryArray = this.table;
        int n = a.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry<A, B> hashtableEntry = hashtableEntryArray[n2];
        HashtableEntry<A, B> hashtableEntry2 = null;
        while (hashtableEntry != null) {
            if (hashtableEntry.hash == n && hashtableEntry.key.equals(a)) {
                if (hashtableEntry2 != null) {
                    hashtableEntry2.next = hashtableEntry.next;
                } else {
                    hashtableEntryArray[n2] = hashtableEntry.next;
                }
                --this.count;
                return hashtableEntry.value;
            }
            hashtableEntry2 = hashtableEntry;
            hashtableEntry = hashtableEntry.next;
        }
        return null;
    }

    public synchronized void clear() {
        HashtableEntry<A, B>[] hashtableEntryArray = this.table;
        int n = hashtableEntryArray.length;
        while (--n >= 0) {
            hashtableEntryArray[n] = null;
        }
        this.count = 0;
    }

    public synchronized Object clone() {
        Hashtable<A, B> hashtable = new Hashtable<A, B>(this.table.length, this.loadFactor);
        int n = this.table.length;
        while (n-- > 0) {
            hashtable.table[n] = this.table[n] != null ? this.table[n].copy() : null;
        }
        return hashtable;
    }

    public synchronized String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<A> enumeration = this.keys();
        Enumeration<B> enumeration2 = this.elements();
        stringBuffer.append("{");
        for (int i = 0; i <= n; ++i) {
            String string = enumeration.nextElement().toString();
            String string2 = enumeration2.nextElement().toString();
            stringBuffer.append(String.valueOf(String.valueOf(string).concat(String.valueOf("="))).concat(String.valueOf(string2)));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

