/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.text;

import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.text.AbstractDocumentInterface;
import edu.rice.cs.util.text.ConsoleInterface;
import edu.rice.cs.util.text.DocumentAdapterException;
import edu.rice.cs.util.text.DocumentEditCondition;
import java.util.Hashtable;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;

public class SwingDocument
extends DefaultStyledDocument
implements ConsoleInterface,
AbstractDocumentInterface {
    protected final Hashtable<String, AttributeSet> _styles = new Hashtable();
    protected DocumentEditCondition _condition = new DocumentEditCondition();

    public void setDocStyle(String name, AttributeSet s) {
        this._styles.put(name, s);
    }

    public AttributeSet getDocStyle(String name) {
        return this._styles.get(name);
    }

    public DocumentEditCondition getEditCondition() {
        return this._condition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEditCondition(DocumentEditCondition condition) {
        this.writeLock();
        try {
            this._condition = condition;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertText(int offs, String str, String style) {
        this.writeLock();
        try {
            if (this._condition.canInsertText(offs)) {
                this.forceInsertText(offs, str, style);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public void forceInsertText(int offs, String str, String style) {
        AttributeSet s = null;
        if (style != null) {
            s = this.getDocStyle(style);
        }
        try {
            super.insertString(offs, str, s);
        }
        catch (BadLocationException e) {
            throw new DocumentAdapterException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertString(int offs, String str, AttributeSet set) throws BadLocationException {
        this.writeLock();
        try {
            if (this._condition.canInsertText(offs)) {
                super.insertString(offs, str, set);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeText(int offs, int len) {
        this.writeLock();
        try {
            if (this._condition.canRemoveText(offs)) {
                this.forceRemoveText(offs, len);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public void forceRemoveText(int offs, int len) {
        try {
            super.remove(offs, len);
        }
        catch (BadLocationException e) {
            throw new DocumentAdapterException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int offs, int len) throws BadLocationException {
        this.writeLock();
        try {
            if (this._condition.canRemoveText(offs)) {
                super.remove(offs, len);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public String getDocText(int offs, int len) {
        try {
            return this.getText(offs, len);
        }
        catch (BadLocationException e) {
            throw new DocumentAdapterException(e);
        }
    }

    public String getText() {
        this.readLock();
        try {
            String string = this.getText(0, this.getLength());
            return string;
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    public void append(String str, AttributeSet set) {
        this.writeLock();
        try {
            this.insertString(this.getLength(), str, set);
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        finally {
            this.writeUnlock();
        }
    }

    public void append(String str, Style style) {
        this.writeLock();
        try {
            this.insertString(this.getLength(), str, style);
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        finally {
            this.writeUnlock();
        }
    }

    public void acquireReadLock() {
        this.readLock();
    }

    public void releaseReadLock() {
        this.readUnlock();
    }

    public void acquireWriteLock() {
        this.writeLock();
    }

    public void releaseWriteLock() {
        this.writeUnlock();
    }
}

