/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.swing;

import edu.rice.cs.util.UnexpectedException;
import java.awt.EventQueue;
import javax.swing.JOptionPane;

public class Utilities {
    public static void invokeLater(Runnable task) {
        if (EventQueue.isDispatchThread()) {
            task.run();
            return;
        }
        EventQueue.invokeLater(task);
    }

    public static void invokeAndWait(Runnable task) {
        if (EventQueue.isDispatchThread()) {
            task.run();
            return;
        }
        try {
            EventQueue.invokeAndWait(task);
        }
        catch (Exception e) {
            throw new UnexpectedException(e);
        }
    }

    public static void main(String[] args) {
        Utilities.clearEventQueue();
    }

    public static void clearEventQueue() {
        Utilities.invokeAndWait(new Runnable(){

            public void run() {
            }
        });
    }

    public static void showDebug(final String msg) {
        Utilities.invokeAndWait(new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(null, msg);
            }
        });
    }
}

