/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.swing;

import javax.swing.SwingUtilities;

public abstract class SwingWorker {
    private Object _value;
    private ThreadVar _threadVar;

    protected synchronized Object getValue() {
        return this._value;
    }

    private synchronized void setValue(Object x) {
        this._value = x;
    }

    public abstract Object construct();

    public void finished() {
    }

    public void interrupt() {
        Thread t = this._threadVar.get();
        if (t != null) {
            t.interrupt();
        }
        this._threadVar.clear();
    }

    public Object get() {
        Thread t;
        while ((t = this._threadVar.get()) != null) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.getValue();
    }

    public SwingWorker() {
        final Runnable doFinished = new Runnable(){

            public void run() {
                SwingWorker.this.finished();
            }
        };
        Runnable doConstruct = new Runnable(){

            public void run() {
                try {
                    SwingWorker.this.setValue(SwingWorker.this.construct());
                }
                catch (RuntimeException e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            throw e;
                        }
                    });
                    throw e;
                }
                catch (Error e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            throw e;
                        }
                    });
                    throw e;
                }
                finally {
                    SwingWorker.this._threadVar.clear();
                }
                SwingUtilities.invokeLater(doFinished);
            }
        };
        Thread t = new Thread(doConstruct);
        this._threadVar = new ThreadVar(t);
    }

    public void start() {
        Thread t = this._threadVar.get();
        if (t != null) {
            t.start();
        }
    }

    private static class ThreadVar {
        private Thread _thread;

        ThreadVar(Thread t) {
            this._thread = t;
        }

        synchronized Thread get() {
            return this._thread;
        }

        synchronized void clear() {
            this._thread = null;
        }
    }
}

