/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.swing;

import edu.rice.cs.util.Lambda;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class PopupConsole {
    protected static final String INPUT_ENTERED_NAME = "Input Entered";
    protected static final String INSERT_NEWLINE_NAME = "Insert Newline";
    protected JTextArea _inputBox;
    private Action _insertNewlineAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            JTextArea source = (JTextArea)e.getSource();
            source.insert("\n", source.getCaretPosition());
        }
    };
    protected String _title;
    protected Component _parentComponent;
    protected Runnable _interruptCommand;
    protected Lambda<Object, String> _insertTextCommand;
    protected final Object commandLock = new Object();

    public PopupConsole(Component owner) {
        this(owner, null, null);
    }

    public PopupConsole(Component owner, String title) {
        this(owner, null, title);
    }

    public PopupConsole(Component owner, JTextArea inputBox, String title) {
        this.setParent(owner);
        this.setInputBox(inputBox);
        this.setTitle(title);
    }

    public String getConsoleInput() {
        Frame parentFrame = JOptionPane.getFrameForComponent(this._parentComponent);
        if (parentFrame.isVisible()) {
            return this.showDialog(parentFrame) + "\n";
        }
        return this.silentInput() + "\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptConsole() {
        Object object = this.commandLock;
        synchronized (object) {
            if (this._interruptCommand != null) {
                this._interruptCommand.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertConsoleText(String txt) {
        Object object = this.commandLock;
        synchronized (object) {
            if (this._insertTextCommand == null) {
                throw new IllegalStateException("Console not ready for text insertion");
            }
            this._insertTextCommand.apply(txt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForConsoleReady() throws InterruptedException {
        Object object = this.commandLock;
        synchronized (object) {
            if (this._interruptCommand == null) {
                this.commandLock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConsoleReady() {
        Object object = this.commandLock;
        synchronized (object) {
            return this._interruptCommand != null;
        }
    }

    public void setInputBox(JTextArea inputBox) {
        this._inputBox = inputBox == null ? new InputBox() : inputBox;
        InputMap im = this._inputBox.getInputMap();
        im.put(KeyStroke.getKeyStroke(10, 1), INSERT_NEWLINE_NAME);
        ActionMap am = this._inputBox.getActionMap();
        am.put(INSERT_NEWLINE_NAME, this._insertNewlineAction);
    }

    public JTextArea getInputBox() {
        return this._inputBox;
    }

    public void setParent(Component c) {
        this._parentComponent = c;
    }

    public Component getParent() {
        return this._parentComponent;
    }

    public void setTitle(String title) {
        this._title = title == null ? "Console" : title;
    }

    public String getTitle() {
        return this._title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String showDialog(Frame parentFrame) {
        final JDialog dialog = this.createDialog(this._inputBox, parentFrame);
        Object object = this.commandLock;
        synchronized (object) {
            this._interruptCommand = new Runnable(){

                public void run() {
                    dialog.setVisible(false);
                }
            };
            this._insertTextCommand = new Lambda<Object, String>(){

                @Override
                public Object apply(String input) {
                    PopupConsole.this._inputBox.insert(input, PopupConsole.this._inputBox.getCaretPosition());
                    return null;
                }

                @Override
                public /* synthetic */ Object apply(Object x0) {
                    return this.apply((String)x0);
                }
            };
            this.commandLock.notifyAll();
        }
        dialog.setVisible(true);
        dialog.dispose();
        object = this.commandLock;
        synchronized (object) {
            this._interruptCommand = null;
            this._insertTextCommand = null;
        }
        return this._inputBox.getText();
    }

    protected JDialog createDialog(JTextArea inputBox, Frame parentFrame) {
        final JDialog dialog = new JDialog(parentFrame, this._title, true);
        inputBox.setText("");
        Container cp = dialog.getContentPane();
        cp.add((Component)new JScrollPane(inputBox), "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JLabel label = new JLabel("Hit SHIFT+<Enter> For New Line  ");
        buttonPanel.add(label);
        AbstractAction inputEnteredAction = new AbstractAction("Done"){

            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        };
        JButton doneButton = new JButton(inputEnteredAction);
        doneButton.setMargin(new Insets(1, 5, 1, 5));
        buttonPanel.add(doneButton);
        dialog.getRootPane().setDefaultButton(doneButton);
        cp.add((Component)buttonPanel, "South");
        inputBox.getInputMap().put(KeyStroke.getKeyStroke(10, 0), INPUT_ENTERED_NAME);
        inputBox.getActionMap().put(INPUT_ENTERED_NAME, inputEnteredAction);
        dialog.setSize(400, 115);
        dialog.setLocationRelativeTo(parentFrame);
        return dialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String silentInput() {
        final Object monitor = new Object();
        final StringBuffer input = new StringBuffer();
        Object object = monitor;
        synchronized (object) {
            Object object2 = this.commandLock;
            synchronized (object2) {
                this._insertTextCommand = new Lambda<Object, String>(){

                    @Override
                    public Object apply(String s) {
                        input.append(s);
                        return null;
                    }

                    @Override
                    public /* synthetic */ Object apply(Object x0) {
                        return this.apply((String)x0);
                    }
                };
                this._interruptCommand = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        PopupConsole.this._insertTextCommand = null;
                        PopupConsole.this._interruptCommand = null;
                        Object object = monitor;
                        synchronized (object) {
                            monitor.notifyAll();
                        }
                    }
                };
                this.commandLock.notifyAll();
            }
            try {
                monitor.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return input.toString();
    }

    protected static class InputBox
    extends JTextArea {
        private static final int BORDER_WIDTH = 1;
        private static final int INNER_BUFFER_WIDTH = 3;
        private static final int OUTER_BUFFER_WIDTH = 2;

        public InputBox() {
            this.setBorder(this._createBorder());
            this.setLineWrap(true);
        }

        private Border _createBorder() {
            Border outerouter = BorderFactory.createLineBorder(this.getBackground(), 2);
            Border outer = BorderFactory.createLineBorder(this.getForeground(), 1);
            Border inner = BorderFactory.createLineBorder(this.getBackground(), 3);
            CompoundBorder temp = BorderFactory.createCompoundBorder(outer, inner);
            return BorderFactory.createCompoundBorder(outerouter, temp);
        }
    }
}

