/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.swing;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class FileSelectorComponent
extends JPanel {
    public static final int DEFAULT_NUM_COLS = 30;
    public static final float DEFAULT_FONT_SIZE = 10.0f;
    protected final Frame _parent;
    protected final JTextField _fileField;
    protected final JButton _chooserButton;
    protected final JFileChooser _chooser;
    protected FileFilter _fileFilter;
    protected File _file;

    public FileSelectorComponent(Frame parent, JFileChooser chooser) {
        this(parent, chooser, 30, 10.0f);
    }

    public FileSelectorComponent(Frame parent, JFileChooser chooser, int numCols, float fontSize) {
        this._parent = parent;
        this._chooser = chooser;
        this._fileFilter = null;
        this._fileField = new JTextField(numCols){

            public Dimension getMaximumSize() {
                return new Dimension(Short.MAX_VALUE, super.getPreferredSize().height);
            }
        };
        this._fileField.setFont(this._fileField.getFont().deriveFont(fontSize));
        this._fileField.setPreferredSize(new Dimension(22, 22));
        this._fileField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileSelectorComponent.this.validateTextField();
            }
        });
        this._fileField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                FileSelectorComponent.this.validateTextField();
            }
        });
        this._chooserButton = new JButton("...");
        this._chooserButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileSelectorComponent.this._chooseFile();
            }
        });
        this._chooserButton.setMaximumSize(new Dimension(22, 22));
        this._chooserButton.setMargin(new Insets(0, 5, 0, 5));
        this.setLayout(new BoxLayout(this, 0));
        this.add(this._fileField);
        this.add(this._chooserButton);
    }

    public void setEnabled(boolean enabled) {
        this._fileField.setEnabled(enabled);
        this._chooserButton.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public JTextField getFileField() {
        return this._fileField;
    }

    public JFileChooser getFileChooser() {
        return this._chooser;
    }

    public File getFileFromField() {
        String txt = this._fileField.getText().trim();
        this._file = txt.equals("") ? null : new File(txt);
        return this._file;
    }

    public void setFileField(File file) {
        this._file = file;
        if (file != null && !file.getPath().equals("")) {
            try {
                this._file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.resetFileField();
    }

    public void resetFileField() {
        if (this._file == null) {
            this._fileField.setText("");
        } else {
            this._fileField.setText(this._file.getPath());
            this._fileField.setCaretPosition(this._fileField.getText().length());
        }
    }

    public void setFileFilter(FileFilter filter) {
        this._fileFilter = filter;
    }

    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this._fileField.setToolTipText(text);
        this._chooser.setToolTipText(text);
    }

    private void _chooseFile() {
        File chosen;
        int returnValue;
        if (this._file != null && this._file.exists()) {
            this._chooser.setCurrentDirectory(this._file);
            this._chooser.setSelectedFile(this._file);
        }
        if (this._fileFilter != null) {
            this._chooser.setFileFilter(this._fileFilter);
        }
        if ((returnValue = this._chooser.showDialog(this._parent, null)) == 0 && (chosen = this._chooser.getSelectedFile()) != null) {
            this.setFileField(chosen);
        }
    }

    public synchronized boolean validateTextField() {
        String newValue = this._fileField.getText().trim();
        File newFile = null;
        if (!newValue.equals("")) {
            newFile = new File(newValue);
        }
        if (newFile != null && !newFile.exists()) {
            JOptionPane.showMessageDialog(this._parent, "The file '" + newValue + "'\n" + "is invalid because it does not exist.", "Invalid File Name", 0);
            if (!this._file.exists()) {
                this._file = null;
            }
            this.resetFileField();
            return false;
        }
        this.setFileField(newFile);
        return true;
    }
}

