/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.newjvm;

import edu.rice.cs.util.newjvm.MasterRemote;
import edu.rice.cs.util.newjvm.SlaveRemote;
import java.rmi.RemoteException;

public abstract class AbstractSlaveJVM
implements SlaveRemote {
    public static final int CHECK_MAIN_VM_ALIVE_MINUTES = 1;
    protected String _quitSlaveThreadName = "Quit SlaveJVM Thread";
    protected String _pollMasterThreadName = "Poll MasterJVM Thread";
    private Object _slaveJVMLock = new Object();
    private boolean _slaveExited = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void quit() {
        this.beforeQuit();
        this._slaveExited = false;
        Thread t = new Thread(this._quitSlaveThreadName){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Object object = AbstractSlaveJVM.this._slaveJVMLock;
                    synchronized (object) {
                        while (!AbstractSlaveJVM.this._slaveExited) {
                            AbstractSlaveJVM.this._slaveJVMLock.wait();
                        }
                    }
                    System.exit(0);
                }
                catch (Throwable th) {
                    AbstractSlaveJVM.this.quitFailed(th);
                }
            }
        };
        t.start();
        Object object = this._slaveJVMLock;
        synchronized (object) {
            this._slaveExited = true;
            this._slaveJVMLock.notify();
        }
    }

    protected void beforeQuit() {
    }

    protected void quitFailed(Throwable th) {
    }

    public final void start(final MasterRemote master) throws RemoteException {
        Thread thread = new Thread(this._pollMasterThreadName){

            public void run() {
                while (true) {
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    try {
                        master.checkStillAlive();
                        continue;
                    }
                    catch (RemoteException re) {
                        AbstractSlaveJVM.this.quit();
                        continue;
                    }
                    break;
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
        this.handleStart(master);
    }

    protected abstract void handleStart(MasterRemote var1);
}

