/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.newjvm;

import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.newjvm.ExecJVM;
import edu.rice.cs.util.newjvm.MasterRemote;
import edu.rice.cs.util.newjvm.RemoteClassLoader;
import edu.rice.cs.util.newjvm.SlaveJVMRunner;
import edu.rice.cs.util.newjvm.SlaveRemote;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public abstract class AbstractMasterJVM
implements MasterRemote {
    protected String _waitForQuitThreadName = "Wait for SlaveJVM Exit Thread";
    protected String _exportMasterThreadName = "Export MasterJVM Thread";
    protected Object _masterJVMLock = new Object();
    private static final String RUNNER = SlaveJVMRunner.class.getName();
    private SlaveRemote _slave = null;
    private boolean _startupInProgress = false;
    private boolean _quitOnStartup = false;
    private Remote _stub;
    private File _stubFile;
    Remote _classLoaderStub;
    File _classLoaderStubFile;
    private final String _slaveClassName;
    static final Object lock = new Object();

    protected AbstractMasterJVM(String slaveClassName) {
        this._slaveClassName = slaveClassName;
        System.setProperty("java.rmi.server.hostname", "127.0.0.1");
    }

    protected abstract void handleSlaveConnected();

    protected abstract void handleSlaveQuit(int var1);

    protected final void invokeSlave() throws IOException, RemoteException {
        this.invokeSlave(new String[0]);
    }

    protected final void invokeSlave(String[] jvmArgs) throws IOException, RemoteException {
        this.invokeSlave(jvmArgs, System.getProperty("java.class.path"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void invokeSlave(String[] jvmArgs, String cp) throws IOException, RemoteException {
        Object object = this._masterJVMLock;
        synchronized (object) {
            if (this._startupInProgress) {
                throw new IllegalStateException("startup is in progress in invokeSlave");
            }
            if (this._slave != null) {
                throw new IllegalStateException("slave nonnull in invoke: " + this._slave);
            }
            this._startupInProgress = true;
            Thread t = new Thread(this._exportMasterThreadName){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = lock;
                    synchronized (object) {
                        try {
                            AbstractMasterJVM.this._stub = UnicastRemoteObject.exportObject(AbstractMasterJVM.this);
                        }
                        catch (RemoteException re) {
                            throw new UnexpectedException(re);
                        }
                        lock.notify();
                    }
                }
            };
            Object object2 = lock;
            synchronized (object2) {
                t.start();
                while (this._stub == null) {
                    try {
                        lock.wait();
                    }
                    catch (InterruptedException ie) {
                        throw new UnexpectedException(ie);
                    }
                }
            }
            this._stubFile = File.createTempFile("DrJava-remote-stub", ".tmp");
            this._stubFile.deleteOnExit();
            FileOutputStream fstream = new FileOutputStream(this._stubFile);
            ObjectOutputStream ostream = new ObjectOutputStream(fstream);
            ostream.writeObject(this._stub);
            ostream.flush();
            fstream.close();
            final RemoteClassLoader rClassLoader = new RemoteClassLoader(this.getClass().getClassLoader());
            t = new Thread(this._exportMasterThreadName){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = lock;
                    synchronized (object) {
                        try {
                            AbstractMasterJVM.this._classLoaderStub = UnicastRemoteObject.exportObject(rClassLoader);
                        }
                        catch (RemoteException re) {
                            throw new UnexpectedException(re);
                        }
                        lock.notify();
                    }
                }
            };
            Object object3 = lock;
            synchronized (object3) {
                t.start();
                while (this._classLoaderStub == null) {
                    try {
                        lock.wait();
                    }
                    catch (InterruptedException ie) {
                        throw new UnexpectedException(ie);
                    }
                }
            }
            this._classLoaderStubFile = File.createTempFile("DrJava-remote-stub", ".tmp");
            this._classLoaderStubFile.deleteOnExit();
            fstream = new FileOutputStream(this._classLoaderStubFile);
            ostream = new ObjectOutputStream(fstream);
            ostream.writeObject(this._classLoaderStub);
            ostream.flush();
            fstream.close();
            String[] args = new String[]{this._stubFile.getAbsolutePath(), this._slaveClassName, this._classLoaderStubFile.getAbsolutePath()};
            final Process process = ExecJVM.runJVM(RUNNER, args, cp, jvmArgs);
            Thread thread = new Thread(this._waitForQuitThreadName){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        int status = process.waitFor();
                        AbstractMasterJVM abstractMasterJVM = AbstractMasterJVM.this;
                        synchronized (abstractMasterJVM) {
                            if (AbstractMasterJVM.this._startupInProgress) {
                                AbstractMasterJVM.this.slaveQuitDuringStartup(status);
                            }
                            AbstractMasterJVM.this._slave = null;
                            UnicastRemoteObject.unexportObject(AbstractMasterJVM.this, true);
                            AbstractMasterJVM.this.handleSlaveQuit(status);
                        }
                    }
                    catch (NoSuchObjectException e) {
                        throw new UnexpectedException(e);
                    }
                    catch (InterruptedException ie) {
                        throw new UnexpectedException(ie);
                    }
                }
            };
            thread.start();
        }
    }

    protected void slaveQuitDuringStartup(int status) {
        String msg = "SlaveJVM quit before registering!  Status: " + status;
        throw new IllegalStateException(msg);
    }

    public abstract void errorStartingSlave(Throwable var1) throws RemoteException;

    public void checkStillAlive() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSlave(SlaveRemote slave) throws RemoteException {
        Object object = this._masterJVMLock;
        synchronized (object) {
            this._slave = slave;
            this._startupInProgress = false;
            this._stubFile.delete();
            this._stub = null;
            this._classLoaderStub = null;
            this._classLoaderStubFile.delete();
            this.handleSlaveConnected();
            if (this._quitOnStartup) {
                this._quitOnStartup = false;
                this.quitSlave();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void quitSlave() throws RemoteException {
        Object object = this._masterJVMLock;
        synchronized (object) {
            if (this.isStartupInProgress()) {
                this._quitOnStartup = true;
            } else {
                if (this._slave == null) {
                    throw new IllegalStateException("tried to quit when no slave running and startup not in progress");
                }
                this._slave.quit();
            }
        }
    }

    protected final SlaveRemote getSlave() {
        return this._slave;
    }

    protected boolean isStartupInProgress() {
        return this._startupInProgress;
    }
}

