/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.docnavigation;

import edu.rice.cs.util.BidirectionalHashMap;
import edu.rice.cs.util.docnavigation.FileNode;
import edu.rice.cs.util.docnavigation.GroupNode;
import edu.rice.cs.util.docnavigation.GroupNotSelectedException;
import edu.rice.cs.util.docnavigation.IDocumentNavigator;
import edu.rice.cs.util.docnavigation.IDocumentNavigatorAlgo;
import edu.rice.cs.util.docnavigation.INavigationListener;
import edu.rice.cs.util.docnavigation.INavigatorItem;
import edu.rice.cs.util.docnavigation.INavigatorItemFilter;
import edu.rice.cs.util.docnavigation.InnerNode;
import edu.rice.cs.util.docnavigation.LeafNode;
import edu.rice.cs.util.docnavigation.NodeData;
import edu.rice.cs.util.docnavigation.NodeDataVisitor;
import edu.rice.cs.util.docnavigation.RootNode;
import edu.rice.cs.util.docnavigation.StringNode;
import edu.rice.cs.util.swing.DisplayManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTreeSortNavigator
extends JTree
implements IDocumentNavigator,
TreeSelectionListener,
TreeExpansionListener {
    private DefaultTreeModel _model;
    private NodeData _current;
    private HashMap<INavigatorItem, LeafNode> _doc2node = new HashMap();
    private BidirectionalHashMap<String, InnerNode> _path2node = new BidirectionalHashMap();
    private StringNode _nonProjRoot = new StringNode("[External Files]");
    private boolean _hasNonProjFilesOpen = false;
    private Vector<INavigationListener> navListeners = new Vector();
    private CustomTreeCellRenderer _renderer;
    private DisplayManager<INavigatorItem> _displayManager;
    private Icon _rootIcon;
    private List<GroupNode> _roots = new LinkedList<GroupNode>();
    private NodeDataVisitor<INavigatorItem> _leafVisitor = new NodeDataVisitor<INavigatorItem>(){

        @Override
        public INavigatorItem fileCase(File f) {
            return null;
        }

        @Override
        public INavigatorItem stringCase(String s) {
            return null;
        }

        @Override
        public INavigatorItem itemCase(INavigatorItem ini) {
            return ini;
        }

        @Override
        public /* synthetic */ Object itemCase(INavigatorItem x0) {
            return this.itemCase(x0);
        }

        @Override
        public /* synthetic */ Object stringCase(String x0) {
            return this.stringCase(x0);
        }

        @Override
        public /* synthetic */ Object fileCase(File x0) {
            return this.fileCase(x0);
        }
    };

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        this._renderer.setTextNonSelectionColor(c);
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        if (this._renderer != null) {
            this._renderer.setBackgroundNonSelectionColor(c);
        }
    }

    public JTreeSortNavigator(String projfilepath) {
        super(new DefaultTreeModel(new RootNode(projfilepath.substring(projfilepath.lastIndexOf(File.separator) + 1))));
        this.addTreeSelectionListener(this);
        this.addTreeExpansionListener(this);
        this._model = (DefaultTreeModel)this.getModel();
        this._renderer = new CustomTreeCellRenderer();
        this._renderer.setOpaque(false);
        this.setCellRenderer(this._renderer);
        this.getSelectionModel().setSelectionMode(1);
        this.setRowHeight(18);
    }

    public JTreeSortNavigator(String projfilepath, DisplayManager<INavigatorItem> dm) {
        this(projfilepath);
        this._displayManager = dm;
    }

    public void setDisplayManager(DisplayManager<INavigatorItem> manager) {
        this._displayManager = manager;
    }

    public void setRootIcon(Icon ico) {
        this._rootIcon = ico;
    }

    @Override
    public Container asContainer() {
        return this;
    }

    @Override
    public void addDocument(INavigatorItem doc) {
        this.addDocument(doc, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDocument(INavigatorItem doc, String path) {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            GroupNode root = null;
            for (GroupNode r : this._roots) {
                if (!r.getFilter().accept(doc)) continue;
                root = r;
                break;
            }
            if (root == null) {
                return;
            }
            StringTokenizer tok = new StringTokenizer(path, File.separator);
            StringBuffer pathSoFarBuf = new StringBuffer();
            InnerNode lastNode = root;
            while (tok.hasMoreTokens()) {
                InnerNode thisNode;
                String element = tok.nextToken();
                pathSoFarBuf.append(element).append('/');
                String pathSoFar = pathSoFarBuf.toString();
                if (!this._path2node.containsKey(pathSoFar)) {
                    thisNode = new FileNode(new File(pathSoFar));
                    this.insertFolderSortedInto(thisNode, lastNode);
                    this.expandPath(new TreePath(lastNode.getPath()));
                    this._path2node.put(pathSoFar, thisNode);
                } else {
                    thisNode = this._path2node.getValue(pathSoFar);
                }
                lastNode = thisNode;
            }
            LeafNode child = new LeafNode(doc);
            this._doc2node.put(doc, child);
            this.insertNodeSortedInto(child, lastNode);
            this._hasNonProjFilesOpen = lastNode == root;
            this.expandPath(new TreePath(lastNode.getPath()));
            child.setUserObject(doc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTopLevelGroupToRoot(InnerNode parent) {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            TreeNode n;
            int i;
            int indexInRoots = this._roots.indexOf(parent);
            int num = this._model.getChildCount(this._model.getRoot());
            for (i = 0; i < num && this._roots.indexOf(n = (TreeNode)this._model.getChild(this._model.getRoot(), i)) <= indexInRoots; ++i) {
            }
            this._model.insertNodeInto(parent, (MutableTreeNode)this._model.getRoot(), i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertNodeSortedInto(LeafNode child, InnerNode parent) {
        int numChildren = parent.getChildCount();
        String newName = child.toString();
        String oldName = parent.getUserObject().toString();
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            int i;
            if (((DefaultMutableTreeNode)this._model.getRoot()).getIndex(parent) == -1 && this._roots.contains(parent)) {
                this.addTopLevelGroupToRoot(parent);
            }
            for (i = 0; i < numChildren; ++i) {
                DefaultMutableTreeNode parentsKid = (DefaultMutableTreeNode)parent.getChildAt(i);
                if (parentsKid instanceof InnerNode) continue;
                if (parentsKid instanceof LeafNode) {
                    oldName = ((LeafNode)parentsKid).getData().getName();
                    if (newName.toUpperCase().compareTo(oldName.toUpperCase()) >= 0) continue;
                    break;
                }
                throw new IllegalStateException("found a node in navigator that is not an InnerNode or LeafNode");
            }
            this._model.insertNodeInto(child, parent, i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertFolderSortedInto(InnerNode child, InnerNode parent) {
        int numChildren = parent.getChildCount();
        String newName = child.toString();
        String oldName = parent.getUserObject().toString();
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            int i;
            if (((DefaultMutableTreeNode)this._model.getRoot()).getIndex(parent) == -1 && this._roots.contains(parent)) {
                this.addTopLevelGroupToRoot(parent);
            }
            int countFolders = 0;
            for (i = 0; i < numChildren; ++i) {
                DefaultMutableTreeNode parentsKid = (DefaultMutableTreeNode)parent.getChildAt(i);
                if (parentsKid instanceof InnerNode) {
                    ++countFolders;
                    oldName = ((InnerNode)parentsKid).toString();
                    if (newName.toUpperCase().compareTo(oldName.toUpperCase()) >= 0) continue;
                    break;
                }
                if (parentsKid instanceof LeafNode) break;
                throw new IllegalStateException("found a node in navigator that is not an InnerNode or LeafNode");
            }
            this._model.insertNodeInto(child, parent, i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends INavigatorItem> T removeDocument(T doc) {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            LeafNode toRemove = this.getNodeForDoc(doc);
            if (toRemove == null) {
                return null;
            }
            return (T)this.removeNode(this.getNodeForDoc(doc));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LeafNode getNodeForDoc(INavigatorItem doc) {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            return this._doc2node.get(doc);
        }
    }

    private INavigatorItem removeNode(LeafNode toRemove) {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)toRemove.getParent();
        this._model.removeNodeFromParent(toRemove);
        this._doc2node.remove(toRemove.getData());
        this.cleanFolderNode(parent);
        if (this._nonProjRoot.getChildCount() == 0) {
            this._hasNonProjFilesOpen = false;
        }
        return (INavigatorItem)toRemove.getUserObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanFolderNode(DefaultMutableTreeNode node) {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            if (node instanceof InnerNode && node.getChildCount() == 0) {
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                this._model.removeNodeFromParent(node);
                this._path2node.removeKey((InnerNode)node);
                this.cleanFolderNode(parent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshDocument(INavigatorItem doc, String path) {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            InnerNode newParent;
            InnerNode oldParent;
            LeafNode node = this.getNodeForDoc(doc);
            if (node == null) {
                this.addDocument(doc, path);
                oldParent = null;
            } else {
                oldParent = (InnerNode)node.getParent();
            }
            String newPath = path;
            if (newPath.length() > 0) {
                if (newPath.substring(0, 1).equals("/")) {
                    newPath = newPath.substring(1);
                }
                if (!newPath.substring(newPath.length() - 1).equals("/")) {
                    newPath = new StringBuffer().append(newPath).append("/").toString();
                }
            }
            if ((newParent = this._path2node.getValue(newPath)) == oldParent) {
                if (!node.toString().equals(doc.getName())) {
                    LeafNode newLeaf = new LeafNode(doc);
                    this._doc2node.put(doc, newLeaf);
                    this.insertNodeSortedInto(newLeaf, newParent);
                    this._model.removeNodeFromParent(node);
                }
            } else {
                this.removeNode(node);
                this.addDocument(doc, path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setActiveDoc(INavigatorItem doc) {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            DefaultMutableTreeNode node = this._doc2node.get(doc);
            if (node == this._current) {
                return;
            }
            if (this.contains(doc)) {
                Object[] nodes = node.getPath();
                TreePath path = new TreePath(nodes);
                this.expandPath(path);
                this.setSelectionPath(path);
                this.scrollPathToVisible(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends INavigatorItem> T getNext(T doc) {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            DefaultMutableTreeNode node = this._doc2node.get(doc);
            DefaultMutableTreeNode next = node.getNextLeaf();
            if (next == null || next == this._model.getRoot()) {
                return doc;
            }
            return (T)((INavigatorItem)next.getUserObject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends INavigatorItem> T getPrevious(T doc) {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            DefaultMutableTreeNode node = this._doc2node.get(doc);
            DefaultMutableTreeNode prev = node.getPreviousLeaf();
            if (prev == null || prev == this._model.getRoot()) {
                return doc;
            }
            return (T)((INavigatorItem)prev.getUserObject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends INavigatorItem> T getFirst() {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this._model.getRoot();
            return (T)((INavigatorItem)root.getFirstLeaf().getUserObject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends INavigatorItem> T getLast() {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this._model.getRoot();
            return (T)((INavigatorItem)root.getLastLeaf().getUserObject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(INavigatorItem doc) {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            return this._doc2node.containsKey(doc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends INavigatorItem> Enumeration<T> getDocuments() {
        final ArrayList<INavigatorItem> list = new ArrayList<INavigatorItem>();
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            Enumeration<TreeNode> e = ((DefaultMutableTreeNode)this._model.getRoot()).depthFirstEnumeration();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
                if (!node.isLeaf() || node == this._model.getRoot()) continue;
                list.add((INavigatorItem)node.getUserObject());
            }
        }
        return new Enumeration<T>(){
            private Iterator<T> it;
            {
                this.it = list.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.it.hasNext();
            }

            @Override
            public T nextElement() {
                return (INavigatorItem)this.it.next();
            }

            @Override
            public /* synthetic */ Object nextElement() {
                return this.nextElement();
            }
        };
    }

    @Override
    public int getDocumentCount() {
        return this._doc2node.size();
    }

    @Override
    public boolean isEmpty() {
        return this._doc2node.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            this._doc2node.clear();
            ((DefaultMutableTreeNode)this._model.getRoot()).removeAllChildren();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNavigationListener(INavigationListener listener) {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            this.navListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNavigationListener(INavigationListener listener) {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            this.navListeners.remove(listener);
        }
    }

    @Override
    public Collection<INavigationListener> getNavigatorListeners() {
        return this.navListeners;
    }

    @Override
    public <InType, ReturnType> ReturnType execute(IDocumentNavigatorAlgo<InType, ReturnType> algo, InType input) {
        return algo.forTree(this, input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            Object treeNode = this.getLastSelectedPathComponent();
            if (treeNode == null || !(treeNode instanceof NodeData)) {
                return;
            }
            NodeData newSelection = (NodeData)treeNode;
            if (this._current != newSelection) {
                for (INavigationListener listener : this.navListeners) {
                    listener.lostSelection(this._current);
                    listener.gainedSelection(newSelection);
                }
                this._current = newSelection;
            }
        }
    }

    @Override
    public Component getRenderer() {
        return this._renderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean selectDocumentAt(int x, int y) {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            TreePath path = this.getPathForLocation(x, y);
            if (path == null) {
                return false;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node instanceof LeafNode) {
                this.expandPath(path);
                this.setSelectionPath(path);
                this.scrollPathToVisible(path);
                return true;
            }
            if (node instanceof InnerNode) {
                this.expandPath(path);
                this.setSelectionPath(path);
                this.scrollPathToVisible(path);
                return true;
            }
            if (node instanceof RootNode) {
                this.expandPath(path);
                this.setSelectionPath(path);
                this.scrollPathToVisible(path);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isGroupSelected() {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            TreePath p = this.getSelectionPath();
            TreeNode n = (TreeNode)p.getLastPathComponent();
            return n instanceof InnerNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTopLevelGroupSelected() {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            TreePath p = this.getSelectionPath();
            TreeNode n = (TreeNode)p.getLastPathComponent();
            return n instanceof GroupNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNameOfSelectedTopLevelGroup() throws GroupNotSelectedException {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            TreePath p = this.getSelectionPath();
            TreeNode n = (TreeNode)p.getLastPathComponent();
            if (n == this._model.getRoot()) {
                throw new GroupNotSelectedException("there is no top level group for the root of the tree");
            }
            while (!this._roots.contains(n)) {
                n = n.getParent();
            }
            return ((GroupNode)n).getData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INavigatorItem getCurrent() {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            if (this._current == null) {
                return null;
            }
            return this._current.execute(this._leafVisitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSelectedInGroup(INavigatorItem i) {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            TreePath p = this.getSelectionPath();
            TreeNode n = (TreeNode)p.getLastPathComponent();
            TreeNode l = this._doc2node.get(i);
            if (n == this._model.getRoot()) {
                return true;
            }
            while (l.getParent() != this._model.getRoot()) {
                if (l.getParent() == n) {
                    return true;
                }
                l = l.getParent();
            }
            return false;
        }
    }

    @Override
    public synchronized void addTopLevelGroup(String name, INavigatorItemFilter f) {
        if (f == null) {
            throw new IllegalArgumentException("parameter 'f' is not allowed to be null");
        }
        GroupNode n = new GroupNode(name, f);
        this._roots.add(n);
    }

    @Override
    public synchronized void treeCollapsed(TreeExpansionEvent event) {
        Object o = event.getPath().getLastPathComponent();
        if (o instanceof InnerNode) {
            ((InnerNode)o).setCollapsed(true);
        }
    }

    @Override
    public synchronized void treeExpanded(TreeExpansionEvent event) {
        Object o = event.getPath().getLastPathComponent();
        if (o instanceof InnerNode) {
            ((InnerNode)o).setCollapsed(false);
        }
    }

    public void collapsePaths(String[] paths) {
        HashSet<String> set = new HashSet<String>();
        for (String s : paths) {
            set.add(s);
        }
        this.collapsePaths(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void collapsePaths(HashSet<String> paths) {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this._model.getRoot();
            Enumeration<TreeNode> nodes = rootNode.depthFirstEnumeration();
            ArrayList list = new ArrayList();
            while (nodes.hasMoreElements()) {
                TreePath tp;
                String s;
                boolean shouldCollapse;
                DefaultMutableTreeNode tn = (DefaultMutableTreeNode)nodes.nextElement();
                if (!(tn instanceof InnerNode) || !(shouldCollapse = paths.contains(s = this.generatePathString(tp = new TreePath(tn.getPath()))))) continue;
                this.collapsePath(tp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCollapsedPaths() {
        ArrayList<String> list = new ArrayList<String>();
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this._model.getRoot();
            Enumeration<TreeNode> nodes = rootNode.depthFirstEnumeration();
            while (nodes.hasMoreElements()) {
                DefaultMutableTreeNode tn = (DefaultMutableTreeNode)nodes.nextElement();
                if (!(tn instanceof InnerNode) || !((InnerNode)tn).isCollapsed()) continue;
                TreePath tp = new TreePath(tn.getPath());
                list.add(this.generatePathString(tp));
            }
        }
        return list.toArray(new String[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generatePathString(TreePath tp) {
        String path = "";
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            TreeNode root = (TreeNode)this._model.getRoot();
            while (tp != null) {
                TreeNode curr = (TreeNode)tp.getLastPathComponent();
                path = curr == root ? new StringBuffer().append("./").append(path).toString() : new StringBuffer().append(curr).append("/").append(path).toString();
                tp = tp.getParentPath();
            }
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestSelectionUpdate(INavigatorItem ini) {
        DefaultTreeModel defaultTreeModel = this._model;
        synchronized (defaultTreeModel) {
            if (this.getCurrent() == null) {
                this.setActiveDoc(ini);
            }
        }
    }

    private class CustomTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private CustomTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node instanceof RootNode && JTreeSortNavigator.this._rootIcon != null) {
                this.setIcon(JTreeSortNavigator.this._rootIcon);
            } else if (node.getUserObject() instanceof INavigatorItem) {
                INavigatorItem doc = (INavigatorItem)node.getUserObject();
                if (leaf && JTreeSortNavigator.this._displayManager != null) {
                    this.setIcon(JTreeSortNavigator.this._displayManager.getIcon(doc));
                    this.setText(JTreeSortNavigator.this._displayManager.getName(doc));
                }
            }
            return this;
        }
    }
}

