/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.docnavigation;

import edu.rice.cs.util.docnavigation.GroupNotSelectedException;
import edu.rice.cs.util.docnavigation.IDocumentNavigator;
import edu.rice.cs.util.docnavigation.IDocumentNavigatorAlgo;
import edu.rice.cs.util.docnavigation.INavigationListener;
import edu.rice.cs.util.docnavigation.INavigatorItem;
import edu.rice.cs.util.docnavigation.INavigatorItemFilter;
import edu.rice.cs.util.docnavigation.NodeData;
import edu.rice.cs.util.docnavigation.NodeDataVisitor;
import edu.rice.cs.util.swing.Utilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JListNavigator
extends JList
implements IDocumentNavigator {
    protected DefaultListModel _model;
    private INavigatorItem _current = null;
    private int _currentIndex = -1;
    private CustomListCellRenderer _renderer;
    private final Vector<INavigationListener> navListeners = new Vector();

    public JListNavigator() {
        this.init(new DefaultListModel());
    }

    private void init(DefaultListModel m) {
        this._model = m;
        this.setModel(m);
        this.setSelectionMode(0);
        this.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(final ListSelectionEvent e) {
                Utilities.invokeLater(new Runnable(){

                    public void run() {
                        if (!e.getValueIsAdjusting() && !(this).JListNavigator.this._model.isEmpty()) {
                            final INavigatorItem newItem = (INavigatorItem)JListNavigator.this.getSelectedValue();
                            int newIndex = JListNavigator.this.getSelectedIndex();
                            if (JListNavigator.this._current != newItem) {
                                final INavigatorItem oldItem = JListNavigator.this._current;
                                NodeData oldData = new NodeData(){

                                    @Override
                                    public <T> T execute(NodeDataVisitor<T> v) {
                                        return v.itemCase(oldItem);
                                    }
                                };
                                NodeData newData = new NodeData(){

                                    @Override
                                    public <T> T execute(NodeDataVisitor<T> v) {
                                        return v.itemCase(newItem);
                                    }
                                };
                                Iterator i$ = JListNavigator.this.navListeners.iterator();
                                while (i$.hasNext()) {
                                    INavigationListener listener = (INavigationListener)i$.next();
                                    if (oldItem != null) {
                                        listener.lostSelection(oldData);
                                    }
                                    if (newItem == null) continue;
                                    listener.gainedSelection(newData);
                                }
                                JListNavigator.this._current = newItem;
                                JListNavigator.this._currentIndex = newIndex;
                            }
                        }
                    }
                });
            }
        });
        this._renderer = new CustomListCellRenderer();
        this._renderer.setOpaque(true);
        this.setCellRenderer(this._renderer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDocument(INavigatorItem doc) {
        DefaultListModel defaultListModel = this._model;
        synchronized (defaultListModel) {
            this._model.addElement(doc);
        }
    }

    @Override
    public void addDocument(INavigatorItem doc, String path) {
        this.addDocument(doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends INavigatorItem> T getNext(T doc) {
        DefaultListModel defaultListModel = this._model;
        synchronized (defaultListModel) {
            int i = this._model.indexOf(doc);
            if (i == -1) {
                throw new IllegalArgumentException(new StringBuffer().append("No such document ").append(doc.toString()).append(" found in collection of open documents").toString());
            }
            if (i + 1 == this._model.size()) {
                return doc;
            }
            return (T)((INavigatorItem)this._model.get(i + 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends INavigatorItem> T getPrevious(T doc) {
        DefaultListModel defaultListModel = this._model;
        synchronized (defaultListModel) {
            int i = this._model.indexOf(doc);
            if (i == -1) {
                throw new IllegalArgumentException(new StringBuffer().append("No such document ").append(doc.toString()).append(" found in collection of open documents").toString());
            }
            if (i == 0) {
                return doc;
            }
            return (T)((INavigatorItem)this._model.get(i - 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends INavigatorItem> T getFirst() {
        DefaultListModel defaultListModel = this._model;
        synchronized (defaultListModel) {
            return (T)((INavigatorItem)this._model.get(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends INavigatorItem> T getLast() {
        DefaultListModel defaultListModel = this._model;
        synchronized (defaultListModel) {
            return (T)((INavigatorItem)this._model.get(this._model.size() - 1));
        }
    }

    @Override
    public INavigatorItem getCurrent() {
        return this._current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends INavigatorItem> T removeDocument(T doc) {
        DefaultListModel defaultListModel = this._model;
        synchronized (defaultListModel) {
            int i = this._model.indexOf(doc);
            if (i == -1) {
                throw new IllegalArgumentException(new StringBuffer().append("Document ").append(doc).append(" not found in Document Navigator").toString());
            }
            return (T)((INavigatorItem)this._model.remove(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshDocument(INavigatorItem doc, String path) {
        DefaultListModel defaultListModel = this._model;
        synchronized (defaultListModel) {
            this.removeDocument(doc);
            this.addDocument(doc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setActiveDoc(INavigatorItem doc) {
        DefaultListModel defaultListModel = this._model;
        synchronized (defaultListModel) {
            if (this._current == doc) {
                return;
            }
            if (this._model.contains(doc)) {
                this.setSelectedValue(doc, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(INavigatorItem doc) {
        DefaultListModel defaultListModel = this._model;
        synchronized (defaultListModel) {
            return this._model.contains(doc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends INavigatorItem> Enumeration<T> getDocuments() {
        DefaultListModel defaultListModel = this._model;
        synchronized (defaultListModel) {
            return this._model.elements();
        }
    }

    @Override
    public int getDocumentCount() {
        return this._model.size();
    }

    @Override
    public boolean isEmpty() {
        return this._model.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNavigationListener(INavigationListener listener) {
        DefaultListModel defaultListModel = this._model;
        synchronized (defaultListModel) {
            this.navListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNavigationListener(INavigationListener listener) {
        DefaultListModel defaultListModel = this._model;
        synchronized (defaultListModel) {
            this.navListeners.remove(listener);
        }
    }

    @Override
    public Collection<INavigationListener> getNavigatorListeners() {
        return this.navListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        DefaultListModel defaultListModel = this._model;
        synchronized (defaultListModel) {
            this._model.clear();
        }
    }

    @Override
    public <InType, ReturnType> ReturnType execute(IDocumentNavigatorAlgo<InType, ReturnType> algo, InType input) {
        return algo.forList(this, input);
    }

    @Override
    public Container asContainer() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean selectDocumentAt(int x, int y) {
        DefaultListModel defaultListModel = this._model;
        synchronized (defaultListModel) {
            int idx = this.locationToIndex(new Point(x, y));
            Rectangle rect = this.getCellBounds(idx, idx);
            if (rect.contains(x, y)) {
                this.setActiveDoc((INavigatorItem)this._model.getElementAt(idx));
                return true;
            }
            return false;
        }
    }

    @Override
    public Component getRenderer() {
        return this._renderer;
    }

    @Override
    public boolean isGroupSelected() {
        return false;
    }

    @Override
    public boolean isSelectedInGroup(INavigatorItem i) {
        return false;
    }

    @Override
    public void addTopLevelGroup(String name, INavigatorItemFilter f) {
    }

    @Override
    public boolean isTopLevelGroupSelected() {
        return false;
    }

    @Override
    public String getNameOfSelectedTopLevelGroup() throws GroupNotSelectedException {
        throw new GroupNotSelectedException("A top level group is not selected");
    }

    @Override
    public void requestSelectionUpdate(INavigatorItem doc) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        DefaultListModel defaultListModel = this._model;
        synchronized (defaultListModel) {
            return this._model.toString();
        }
    }

    private class CustomListCellRenderer
    extends DefaultListCellRenderer {
        private CustomListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
            this.setText(((INavigatorItem)value).getName());
            return this;
        }
    }
}

