/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.docnavigation;

import edu.rice.cs.util.Pair;
import edu.rice.cs.util.docnavigation.IDocumentNavigator;
import edu.rice.cs.util.docnavigation.IDocumentNavigatorFactory;
import edu.rice.cs.util.docnavigation.INavigationListener;
import edu.rice.cs.util.docnavigation.INavigatorItem;
import edu.rice.cs.util.docnavigation.INavigatorItemFilter;
import edu.rice.cs.util.docnavigation.JListSortNavigator;
import edu.rice.cs.util.docnavigation.JTreeSortNavigator;
import edu.rice.cs.util.swing.Utilities;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AWTContainerNavigatorFactory
implements IDocumentNavigatorFactory {
    public static final AWTContainerNavigatorFactory Singleton = new AWTContainerNavigatorFactory();

    private AWTContainerNavigatorFactory() {
    }

    @Override
    public IDocumentNavigator makeListNavigator() {
        return new JListSortNavigator();
    }

    @Override
    public IDocumentNavigator makeTreeNavigator(String name) {
        return new JTreeSortNavigator(name);
    }

    @Override
    public IDocumentNavigator makeListNavigator(final IDocumentNavigator parent) {
        final IDocumentNavigator tbr = this.makeListNavigator();
        Utilities.invokeAndWait(new Runnable(){

            public void run() {
                AWTContainerNavigatorFactory.this.migrateNavigatorItems(tbr, parent);
                AWTContainerNavigatorFactory.this.migrateListeners(tbr, parent);
            }
        });
        return tbr;
    }

    @Override
    public IDocumentNavigator makeTreeNavigator(String name, final IDocumentNavigator parent, final List<Pair<String, INavigatorItemFilter>> l) {
        final IDocumentNavigator tbr = this.makeTreeNavigator(name);
        Utilities.invokeAndWait(new Runnable(){

            public void run() {
                Iterator i$ = l.iterator();
                while (i$.hasNext()) {
                    Pair p = (Pair)i$.next();
                    tbr.addTopLevelGroup((String)p.getFirst(), (INavigatorItemFilter)p.getSecond());
                }
                AWTContainerNavigatorFactory.this.migrateNavigatorItems(tbr, parent);
                AWTContainerNavigatorFactory.this.migrateListeners(tbr, parent);
            }
        });
        return tbr;
    }

    private void migrateNavigatorItems(IDocumentNavigator child, IDocumentNavigator parent) {
        Enumeration enumerator = parent.getDocuments();
        while (enumerator.hasMoreElements()) {
            INavigatorItem navitem = (INavigatorItem)enumerator.nextElement();
            parent.removeDocument(navitem);
            child.addDocument(navitem);
            enumerator = parent.getDocuments();
        }
    }

    private void migrateListeners(IDocumentNavigator child, IDocumentNavigator parent) {
        Collection<INavigationListener> listeners = parent.getNavigatorListeners();
        Iterator<INavigationListener> it = listeners.iterator();
        while (it.hasNext()) {
            INavigationListener listener = it.next();
            child.addNavigationListener(listener);
            parent.removeNavigationListener(listener);
            it = listeners.iterator();
        }
    }
}

