/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.classloader;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;

public class ToolsJarClassLoader
extends URLClassLoader {
    public ToolsJarClassLoader() {
        super(ToolsJarClassLoader.getToolsJarURLs());
    }

    public static File[] getToolsJarFiles() {
        File jar3;
        File libDir2;
        File jar2;
        String javaHome = System.getProperty("java.home");
        File home = new File(javaHome);
        ArrayList<File> files = new ArrayList<File>();
        File libDir = new File(home, "lib");
        File jar = new File(libDir, "tools.jar");
        if (jar.exists()) {
            files.add(jar);
        }
        if ((jar2 = new File(libDir2 = new File(home.getParentFile(), "lib"), "tools.jar")).exists()) {
            files.add(jar2);
        }
        if (javaHome.toLowerCase().indexOf("program files") != -1 && (jar3 = new File(ToolsJarClassLoader.getWindowsToolsJar(javaHome))).exists()) {
            files.add(jar3);
        }
        File[] fileArray = new File[files.size()];
        files.toArray(fileArray);
        return fileArray;
    }

    public static URL[] getToolsJarURLs() {
        File[] files = ToolsJarClassLoader.getToolsJarFiles();
        try {
            URL[] urls = new URL[files.length];
            for (int i = 0; i < files.length; ++i) {
                urls[i] = files[i].toURL();
            }
            return urls;
        }
        catch (MalformedURLException e) {
            return new URL[0];
        }
    }

    public static String getToolsJarClasspath() {
        File[] files = ToolsJarClassLoader.getToolsJarFiles();
        StringBuffer classpath = new StringBuffer();
        String pathSep = System.getProperty("path.separator");
        for (int i = 0; i < files.length; ++i) {
            if (i > 0) {
                classpath.append(pathSep);
            }
            classpath.append(files[i].getAbsolutePath());
        }
        return classpath.toString();
    }

    public static String getWindowsToolsJar(String javaHome) {
        int versionIndex;
        if (javaHome.indexOf("Program Files") == -1) {
            return "";
        }
        String prefix = "C:\\j2sdk";
        String suffix = "\\lib\\tools.jar";
        if (javaHome.indexOf("JavaSoft") != -1) {
            prefix = "C:\\jdk";
            versionIndex = javaHome.indexOf("JRE\\") + 4;
        } else {
            versionIndex = javaHome.indexOf("j2re") + 4;
        }
        String version = javaHome.substring(versionIndex);
        return prefix + version + suffix;
    }

    public URL getResource(String name) {
        return this.findResource(name);
    }
}

