/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.classloader;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class LimitingClassLoader
extends ClassLoader {
    private List<String> _restrictedList = new LinkedList<String>();

    public LimitingClassLoader(ClassLoader parent) {
        super(parent);
    }

    public void addToRestrictedList(String name) {
        this._restrictedList.add(name);
    }

    public void clearRestrictedList() {
        this._restrictedList.clear();
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        ListIterator<String> itor = this._restrictedList.listIterator();
        while (itor.hasNext()) {
            String current = itor.next();
            if (!current.equals(name)) continue;
            throw new ClassNotFoundException("Class " + name + " is on the restricted list.");
        }
        Class<?> clazz = this.getParent().loadClass(name);
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }
}

