/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import edu.rice.cs.javalanglevels.Data;
import edu.rice.cs.javalanglevels.IntermediateVisitor;
import edu.rice.cs.javalanglevels.LanguageLevelVisitor;
import edu.rice.cs.javalanglevels.MethodData;
import edu.rice.cs.javalanglevels.Pair;
import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.SymbolData;
import edu.rice.cs.javalanglevels.VariableData;
import edu.rice.cs.javalanglevels.tree.AbstractMethodDef;
import edu.rice.cs.javalanglevels.tree.ComplexAnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.ConcreteMethodDef;
import edu.rice.cs.javalanglevels.tree.ConstructorDef;
import edu.rice.cs.javalanglevels.tree.InstanceInitializer;
import edu.rice.cs.javalanglevels.tree.SimpleAnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.Statement;
import edu.rice.cs.javalanglevels.tree.SuperReference;
import edu.rice.cs.javalanglevels.tree.ThisReference;
import edu.rice.cs.javalanglevels.tree.VariableDeclaration;
import java.io.File;
import java.util.Hashtable;
import java.util.LinkedList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceBodyIntermediateVisitor
extends IntermediateVisitor {
    private SymbolData _symbolData;

    public InterfaceBodyIntermediateVisitor(SymbolData sd, File file, String packageName, LinkedList<String> importedFiles, LinkedList<String> importedPackages, LinkedList<String> classDefsInThisFile, Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>> continuations) {
        super(file, packageName, importedFiles, importedPackages, classDefsInThisFile, continuations);
        this._symbolData = sd;
    }

    @Override
    public void forStatementDoFirst(Statement that) {
        InterfaceBodyIntermediateVisitor._addError("Statements cannot appear outside of method bodies", that);
    }

    @Override
    public void forConcreteMethodDefDoFirst(ConcreteMethodDef that) {
        InterfaceBodyIntermediateVisitor._addError("You cannot have concrete methods definitions in interfaces", that);
    }

    @Override
    public void forInstanceInitializerDoFirst(InstanceInitializer that) {
        InterfaceBodyIntermediateVisitor._addError("This open brace must mark the beginning of an interface body", that);
    }

    @Override
    public void forVariableDeclarationDoFirst(VariableDeclaration that) {
        InterfaceBodyIntermediateVisitor._addError("You cannot have fields in interfaces at the Intermediate level", that);
    }

    @Override
    public void forSuperReferenceDoFirst(SuperReference that) {
        InterfaceBodyIntermediateVisitor._addAndIgnoreError("The field 'super' does not exist in interfaces.  Only classes have a 'super' field", that);
    }

    @Override
    public void forThisReferenceDoFirst(ThisReference that) {
        InterfaceBodyIntermediateVisitor._addAndIgnoreError("The field 'this' does not exist in interfaces.  Only classes have a 'this' field.", that);
    }

    @Override
    public void forAbstractMethodDef(AbstractMethodDef that) {
        this.forAbstractMethodDefDoFirst(that);
        if (InterfaceBodyIntermediateVisitor._checkError()) {
            return;
        }
        MethodData md = this.createMethodData(that, this._symbolData);
        if (md.hasModifier("private")) {
            InterfaceBodyIntermediateVisitor._addAndIgnoreError("Interface methods cannot be made private.  They must be public.", that.getMav());
        }
        if (md.hasModifier("protected")) {
            InterfaceBodyIntermediateVisitor._addAndIgnoreError("Interface methods cannot be made protected.  They must be public.", that.getMav());
        }
        md.addModifier("public");
        md.addModifier("abstract");
        String className = InterfaceBodyIntermediateVisitor.getUnqualifiedClassName(this._symbolData.getName());
        if (className.equals(md.getName())) {
            InterfaceBodyIntermediateVisitor._addAndIgnoreError("Only constructors can have the same name as the class they appear in, and constructors cannot appear in interfaces.", that);
        } else {
            this._symbolData.addMethod(md);
        }
    }

    @Override
    public void forConstructorDefDoFirst(ConstructorDef that) {
        InterfaceBodyIntermediateVisitor._addAndIgnoreError("Constructor definitions cannot appear in interfaces", that);
    }

    @Override
    protected VariableData[] _variableDeclaration2VariableData(VariableDeclaration vd, Data enclosingData) {
        VariableData[] vds = super._variableDeclaration2VariableData(vd, enclosingData);
        for (int i = 0; i < vds.length; ++i) {
            vds[i].setFinalAndStatic();
        }
        return vds;
    }

    @Override
    public void forComplexAnonymousClassInstantiation(ComplexAnonymousClassInstantiation that) {
        this.complexAnonymousClassInstantiationHelper(that, this._symbolData);
    }

    @Override
    public void forSimpleAnonymousClassInstantiation(SimpleAnonymousClassInstantiation that) {
        this.simpleAnonymousClassInstantiationHelper(that, this._symbolData);
    }

    static /* synthetic */ SymbolData access$000(InterfaceBodyIntermediateVisitor x0) {
        return x0._symbolData;
    }
}

