/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import edu.rice.cs.javalanglevels.Data;
import edu.rice.cs.javalanglevels.LanguageLevelConverter;
import edu.rice.cs.javalanglevels.LanguageLevelVisitor;
import edu.rice.cs.javalanglevels.MethodData;
import edu.rice.cs.javalanglevels.Pair;
import edu.rice.cs.javalanglevels.SymbolData;
import edu.rice.cs.javalanglevels.TypeChecker;
import edu.rice.cs.javalanglevels.TypeData;
import edu.rice.cs.javalanglevels.VariableData;
import edu.rice.cs.javalanglevels.parser.JExprParser;
import edu.rice.cs.javalanglevels.tree.AbstractMethodDef;
import edu.rice.cs.javalanglevels.tree.AnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.BracedBody;
import edu.rice.cs.javalanglevels.tree.ClassDef;
import edu.rice.cs.javalanglevels.tree.ComplexAnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.ConcreteMethodDef;
import edu.rice.cs.javalanglevels.tree.ConstructorDef;
import edu.rice.cs.javalanglevels.tree.FormalParameter;
import edu.rice.cs.javalanglevels.tree.InnerClassDef;
import edu.rice.cs.javalanglevels.tree.InnerInterfaceDef;
import edu.rice.cs.javalanglevels.tree.InterfaceDef;
import edu.rice.cs.javalanglevels.tree.JExpressionIFDepthFirstVisitor_void;
import edu.rice.cs.javalanglevels.tree.MethodDef;
import edu.rice.cs.javalanglevels.tree.ModifiersAndVisibility;
import edu.rice.cs.javalanglevels.tree.NullLiteral;
import edu.rice.cs.javalanglevels.tree.SimpleAnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.SourceFile;
import edu.rice.cs.javalanglevels.tree.TypeDefBase;
import edu.rice.cs.javalanglevels.tree.VariableDeclaration;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Augmentor
extends JExpressionIFDepthFirstVisitor_void {
    private static final String newLine = System.getProperty("line.separator");
    private static final int indentWidth = 2;
    private static BufferedReader _fileIn;
    private static int _fileInLine;
    private static int _fileInColumn;
    private static BufferedWriter _fileOut;
    private static LanguageLevelVisitor _llv;
    private static String _targetVersion;
    private static boolean _safeSupportCode;
    private static List<String> _endOfClassVarDefs;
    private Data _enclosingData;

    public Augmentor(String targetVersion, boolean safeSupportCode, BufferedReader fileIn, BufferedWriter fileOut, LanguageLevelVisitor llv) {
        _fileIn = fileIn;
        _fileInLine = 1;
        _fileInColumn = 1;
        _fileOut = fileOut;
        _llv = llv;
        _targetVersion = targetVersion;
        _safeSupportCode = safeSupportCode;
        _endOfClassVarDefs = new LinkedList<String>();
        this._enclosingData = null;
    }

    protected Augmentor(Data d) {
        this._enclosingData = d;
    }

    @Override
    public void forVariableDeclaration(VariableDeclaration that) {
        Augmentor._readAndWriteThroughIndex(that.getSourceInfo().getStartLine(), that.getSourceInfo().getStartColumn() - 1);
        String variableDeclarationModifiers = "";
        if (Augmentor._isElementaryFile()) {
            variableDeclarationModifiers = "private final ";
        } else if (Augmentor._isIntermediateFile()) {
            String[] mavs = that.getMav().getModifiers();
            variableDeclarationModifiers = "private final ";
            for (int i = 0; i < mavs.length; ++i) {
                if (!mavs[i].equals("static")) continue;
                variableDeclarationModifiers = "public final ";
                break;
            }
        }
        Augmentor._writeToFileOut(variableDeclarationModifiers);
        super.forVariableDeclaration(that);
    }

    @Override
    public void forFormalParameter(FormalParameter that) {
        Augmentor._readAndWriteThroughIndex(that.getSourceInfo().getStartLine(), that.getSourceInfo().getStartColumn() - 1);
        if (Augmentor._isElementaryFile() || Augmentor._isIntermediateFile()) {
            Augmentor._writeToFileOut("final ");
        }
    }

    @Override
    public void forConstructorDef(ConstructorDef that) {
        Augmentor._readAndWriteThroughIndex(that.getSourceInfo().getStartLine(), that.getSourceInfo().getStartColumn() - 1);
        if (Augmentor._isIntermediateFile()) {
            String[] modifiers = that.getMav().getModifiers();
            boolean hasVisibilityModifier = false;
            for (int i = 0; i < modifiers.length; ++i) {
                if (!modifiers[i].equals("private") && !modifiers[i].equals("public") && !modifiers[i].equals("protected")) continue;
                hasVisibilityModifier = true;
                break;
            }
            if (!hasVisibilityModifier) {
                Augmentor._writeToFileOut("public ");
            }
        }
        for (FormalParameter fp : that.getParameters()) {
            fp.visit(this);
        }
    }

    public void forMethodDef(MethodDef that) {
        Augmentor._readAndWriteThroughIndex(that.getSourceInfo().getStartLine(), that.getSourceInfo().getStartColumn() - 1);
        if (Augmentor._isElementaryFile()) {
            Augmentor._writeToFileOut("public ");
        }
        if (Augmentor._isIntermediateFile()) {
            String[] modifiers = that.getMav().getModifiers();
            boolean hasVisibilityModifier = false;
            for (int i = 0; i < modifiers.length; ++i) {
                if (!modifiers[i].equals("private") && !modifiers[i].equals("public") && !modifiers[i].equals("protected")) continue;
                hasVisibilityModifier = true;
                break;
            }
            if (!hasVisibilityModifier) {
                Augmentor._writeToFileOut("public ");
            }
        }
        for (FormalParameter fp : that.getParams()) {
            fp.visit(this);
        }
    }

    @Override
    public void forAbstractMethodDef(AbstractMethodDef that) {
        this.forMethodDef(that);
    }

    @Override
    public void forConcreteMethodDef(ConcreteMethodDef that) {
        this.forMethodDef(that);
        MethodData md = this._enclosingData.getSymbolData().getMethod(that.getName().getText(), Augmentor.formalParameters2TypeDatas(that.getParams(), this._enclosingData));
        if (md == null) {
            throw new RuntimeException(new StringBuffer().append("Internal Program Error: Can't find method data for ").append(that.getName()).append(" Please report this bug.").toString());
        }
        that.getBody().visit(new MethodBodyAugmentor(md));
    }

    @Override
    public void forClassDef(ClassDef cd) {
        String className = cd.getName().getText();
        SymbolData sd = LanguageLevelVisitor.symbolTable.get(_llv.getQualifiedClassName(className));
        if (sd == null) {
            throw new RuntimeException(new StringBuffer().append("Internal Program Error: Can't find SymbolData for ").append(cd.getName().getText()).append(" Please report this bug.").toString());
        }
        ModifiersAndVisibility m = cd.getMav();
        if (Augmentor._isElementaryFile() && sd.hasModifier("public")) {
            Augmentor._readAndWriteThroughIndex(m.getSourceInfo().getStartLine(), m.getSourceInfo().getStartColumn() - 1);
            Augmentor._writeToFileOut("public ");
        }
        BracedBody bb = cd.getBody();
        sd.setAnonymousInnerClassNum(0);
        bb.visit(new Augmentor(sd));
        int baseIndent = cd.getSourceInfo().getStartColumn() - 1;
        className = LanguageLevelVisitor.getUnqualifiedClassName(sd.getName());
        Augmentor._readAndWriteThroughIndex(cd.getSourceInfo().getEndLine(), cd.getSourceInfo().getEndColumn() - 1);
        if (Augmentor._isElementaryFile() || Augmentor._isIntermediateFile()) {
            Augmentor.writeConstructor(className, sd, baseIndent);
            Augmentor.writeAccessors(sd, baseIndent);
            String valueToStringName = Augmentor.writeValueToString(sd, baseIndent);
            String valueEqualsName = Augmentor.writeValueEquals(sd, baseIndent);
            String valueHashCodeName = Augmentor.writeValueHashCode(sd, baseIndent, valueEqualsName);
            Augmentor.writeToString(sd, baseIndent, valueToStringName);
            Augmentor.writeEquals(className, sd, baseIndent, valueEqualsName);
            Augmentor.writeHashCode(className, sd, baseIndent, false, valueHashCodeName);
            for (String s : _endOfClassVarDefs) {
                Augmentor._writeToFileOut(new StringBuffer().append(newLine).append(Augmentor.indentString(baseIndent, 1)).append(s).toString());
            }
            if (_endOfClassVarDefs.size() > 0) {
                Augmentor._writeToFileOut(newLine);
                _endOfClassVarDefs.clear();
            }
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 0));
        }
    }

    @Override
    public void forInnerClassDef(InnerClassDef cd) {
        String className = cd.getName().getText();
        if (this._enclosingData == null) {
            throw new RuntimeException("Internal Program Error: Enclosing Data is null.  Please report this bug.");
        }
        SymbolData sd = this._enclosingData.getInnerClassOrInterface(className);
        if (sd == null) {
            throw new RuntimeException(new StringBuffer().append("Internal Program Error: Can't find SymbolData for ").append(cd.getName().getText()).append(". Please report this bug.").toString());
        }
        BracedBody bb = cd.getBody();
        sd.setAnonymousInnerClassNum(0);
        bb.visit(new Augmentor(sd));
        Augmentor._readAndWriteThroughIndex(cd.getSourceInfo().getEndLine(), cd.getSourceInfo().getEndColumn() - 1);
    }

    @Override
    public void forInterfaceDef(InterfaceDef cd) {
        String interfaceName = cd.getName().getText();
        SymbolData sd = LanguageLevelVisitor.symbolTable.get(_llv.getQualifiedClassName(interfaceName));
        if (sd == null) {
            throw new RuntimeException(new StringBuffer().append("Internal Program Error: Can't find SymbolData for ").append(cd.getName().getText()).append(".  Please report this bug.").toString());
        }
        ModifiersAndVisibility m = cd.getMav();
        if (Augmentor._isElementaryFile()) {
            Augmentor._readAndWriteThroughIndex(m.getSourceInfo().getStartLine(), m.getSourceInfo().getStartColumn() - 1);
            Augmentor._writeToFileOut("public ");
        }
        BracedBody bb = cd.getBody();
        sd.setAnonymousInnerClassNum(0);
        bb.visit(new Augmentor(sd));
        int baseIndent = cd.getSourceInfo().getStartColumn() - 1;
        Augmentor._readAndWriteThroughIndex(cd.getSourceInfo().getEndLine(), cd.getSourceInfo().getEndColumn() - 1);
        for (String s : _endOfClassVarDefs) {
            Augmentor._writeToFileOut(new StringBuffer().append(newLine).append(Augmentor.indentString(baseIndent, 1)).append(s).toString());
        }
        if (_endOfClassVarDefs.size() > 0) {
            Augmentor._writeToFileOut(newLine);
            _endOfClassVarDefs.clear();
        }
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 0));
    }

    @Override
    public void forInnerInterfaceDef(InnerInterfaceDef cd) {
        String interfaceName = cd.getName().getText();
        if (this._enclosingData == null) {
            throw new RuntimeException("Internal Program Error: Enclosing Data is null.  Please report this bug.");
        }
        SymbolData sd = this._enclosingData.getInnerClassOrInterface(interfaceName);
        if (sd == null) {
            throw new RuntimeException(new StringBuffer().append("Internal Program Error: Can't find SymbolData for ").append(cd.getName().getText()).append(". Please report this bug.").toString());
        }
        BracedBody bb = cd.getBody();
        sd.setAnonymousInnerClassNum(0);
        bb.visit(new Augmentor(sd));
    }

    public void forAnonymousClassInstantiation(AnonymousClassInstantiation e) {
        SymbolData sd = this._enclosingData.getNextAnonymousInnerClass();
        if (sd == null) {
            throw new RuntimeException("Internal Program Error: Couldn't find the SymbolData for the anonymous inner class.  Please report this bug.");
        }
        BracedBody bb = e.getBody();
        sd.setAnonymousInnerClassNum(0);
        bb.visit(new Augmentor(sd));
        int baseIndent = e.getSourceInfo().getStartColumn() - 1;
        Augmentor._readAndWriteThroughIndex(e.getSourceInfo().getEndLine(), e.getSourceInfo().getEndColumn() - 1);
        if (Augmentor._isElementaryFile() || Augmentor._isIntermediateFile()) {
            String className = Data.dollarSignsToDots(e.getType().getName());
            Augmentor.writeAccessors(sd, baseIndent);
            String valueToStringName = Augmentor.writeValueToString(sd, baseIndent);
            String valueEqualsName = Augmentor.writeValueEquals(sd, baseIndent);
            String valueHashCodeName = Augmentor.writeValueHashCode(sd, baseIndent, valueEqualsName);
            Augmentor.writeToString(sd, baseIndent, valueToStringName);
            if (!_safeSupportCode) {
                Augmentor.writeAnonEquals(baseIndent);
            } else {
                Augmentor.writeEquals(className, sd, baseIndent, valueEqualsName);
            }
            Augmentor.writeHashCode(className, sd, baseIndent, true, valueHashCodeName);
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 0));
        }
    }

    @Override
    public void forSimpleAnonymousClassInstantiation(SimpleAnonymousClassInstantiation e) {
        this.forAnonymousClassInstantiation(e);
    }

    @Override
    public void forComplexAnonymousClassInstantiation(ComplexAnonymousClassInstantiation e) {
        e.getEnclosing().visit(this);
        this.forAnonymousClassInstantiation(e);
    }

    @Override
    public void forSourceFile(SourceFile sf) {
        TypeDefBase[] cds = sf.getTypes();
        if (Augmentor._isElementaryFile() && Augmentor._llv._importedPackages.contains("junit.framework")) {
            Augmentor._writeToFileOut(new StringBuffer().append("import junit.framework.*;").append(newLine).toString());
        }
        for (TypeDefBase cd : cds) {
            cd.visit(this);
        }
        Augmentor._readAndWriteThroughIndex(sf.getSourceInfo().getEndLine(), sf.getSourceInfo().getEndColumn());
    }

    protected static TypeData[] formalParameters2TypeDatas(FormalParameter[] fp, Data enclosing) {
        TypeData[] tds = new TypeData[fp.length];
        for (int j = 0; j < fp.length; ++j) {
            SymbolData type = _llv.getSymbolData(fp[j].getDeclarator().getType().getName(), fp[j].getSourceInfo());
            if (type == null) {
                type = enclosing.getInnerClassOrInterface(fp[j].getDeclarator().getType().getName());
            }
            tds[j] = type;
        }
        return tds;
    }

    protected static void writeConstructor(String className, SymbolData sd, int baseIndent) {
        MethodData constructor = null;
        for (MethodData currMd : sd.getMethods()) {
            if (!currMd.getName().equals(LanguageLevelVisitor.getUnqualifiedClassName(sd.getName())) || !currMd.isGenerated()) continue;
            constructor = currMd;
            break;
        }
        if (constructor == null) {
            return;
        }
        VariableData[] constructorParams = constructor.getParams();
        Augmentor._writeToFileOut(new StringBuffer().append(newLine).append(Augmentor.indentString(baseIndent, 1)).append("/** This method is automatically generated by the Language Level Converter. */").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append("public ").append(className).append("(").toString());
        for (int q = 0; q < constructorParams.length; ++q) {
            if (q > 0) {
                Augmentor._writeToFileOut(", ");
            }
            VariableData vd = constructorParams[q];
            Augmentor._writeToFileOut(new StringBuffer().append(Data.dollarSignsToDots(vd.getType().getName())).append(" ").append(vd.getName()).toString());
        }
        Augmentor._writeToFileOut(new StringBuffer().append(") {").append(newLine).toString());
        LinkedList<VariableData> superParams = new LinkedList<VariableData>();
        LinkedList<VariableData> localParams = new LinkedList<VariableData>();
        LinkedList<VariableData> localFields = sd.getVars();
        for (VariableData param : constructorParams) {
            boolean hasLocalField = false;
            for (VariableData field : localFields) {
                if (!(hasLocalField = hasLocalField || field.getName().equals(param.getName()))) continue;
                break;
            }
            if (hasLocalField) {
                localParams.add(param);
                continue;
            }
            if (param.getName().startsWith("super_")) {
                superParams.add(param);
                continue;
            }
            throw new RuntimeException(new StringBuffer().append("Internal Program Error: Unexpected parameter name in generated constructor: ").append(param.getName()).append(".  Please report this bug").toString());
        }
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("super(").toString());
        for (int z = 0; z < superParams.size(); ++z) {
            if (z > 0) {
                Augmentor._writeToFileOut(", ");
            }
            Augmentor._writeToFileOut(((VariableData)superParams.get(z)).getName());
        }
        Augmentor._writeToFileOut(new StringBuffer().append(");").append(newLine).toString());
        for (int i = 0; i < localParams.size(); ++i) {
            String varName = ((VariableData)localParams.get(i)).getName();
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("this.").append(varName).append(" = ").append(varName).append(";").append(newLine).toString());
        }
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append("}").append(newLine).toString());
    }

    protected static void writeAccessors(SymbolData sd, int baseIndent) {
        LinkedList<MethodData> methods = sd.getMethods();
        MethodData accessor = null;
        Iterator iter = methods.iterator();
        VariableData[] vars = sd.getVars().toArray(new VariableData[sd.getVars().size()]);
        for (int i = 0; i < vars.length; ++i) {
            accessor = null;
            for (MethodData currMd : methods) {
                if (!currMd.getName().equals(vars[i].getName()) || !currMd.isGenerated()) continue;
                accessor = currMd;
                break;
            }
            if (accessor == null) continue;
            Augmentor._writeToFileOut(new StringBuffer().append(newLine).append(Augmentor.indentString(baseIndent, 1)).append("/** This method is automatically generated by the Language Level Converter. */").append(newLine).toString());
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append("public ").append(Data.dollarSignsToDots(vars[i].getType().getName())).append(" ").append(LanguageLevelVisitor.getFieldAccessorName(vars[i].getName())).append("() {").append(newLine).toString());
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("return ").append(vars[i].getName()).append(";").append(newLine).append(Augmentor.indentString(baseIndent, 1)).append("}").append(newLine).toString());
        }
    }

    protected static void writeToString(SymbolData sd, int baseIndent, String valueToStringName) {
        LinkedList<MethodData> methods = sd.getMethods();
        MethodData toString = null;
        for (MethodData currMd : methods) {
            if (!currMd.getName().equals("toString") || !currMd.isGenerated()) continue;
            toString = currMd;
            break;
        }
        if (toString == null) {
            return;
        }
        LinkedList<MethodData> allMds = Augmentor._getVariableAccessorListHelper(sd);
        MethodData[] mds = allMds.toArray(new MethodData[allMds.size()]);
        if (_safeSupportCode) {
            Augmentor.writeSafeToString(sd, baseIndent, valueToStringName, mds);
        } else {
            Augmentor.writeSimpleToString(sd, baseIndent, valueToStringName, mds);
        }
    }

    protected static void writeSafeToString(SymbolData sd, int baseIndent, String valueToStringName, MethodData[] accessors) {
        String flagName = sd.createUniqueName("__toStringFlag");
        VariableData toStringFlag = new VariableData(flagName, new ModifiersAndVisibility(JExprParser.NO_SOURCE_INFO, new String[]{"private", "static"}), _llv.getSymbolDataHelper("java.util.LinkedList", JExprParser.NO_SOURCE_INFO, false, false, false, false), true, sd);
        toStringFlag.setGenerated(true);
        sd.addVar(toStringFlag);
        Augmentor._writeToFileOut(new StringBuffer().append(newLine).append(Augmentor.indentString(baseIndent, 1)).append("/** This field is automatically generated by the Language Level Converter. */").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append("private boolean ").append(flagName).append(" = false;").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(newLine).append(Augmentor.indentString(baseIndent, 1)).append("/** This method is automatically generated by the Language Level Converter. */").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append("public java.lang.String toString() {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("if (").append(flagName).append(") {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("return getClass().getName() + \"(...)\";").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("}").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("else {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append(flagName).append(" = true;").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("String result;").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("try {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("result = getClass().getName() + \"(\" + ").append(newLine).toString());
        for (int i = 0; i < accessors.length; ++i) {
            if (LanguageLevelConverter.versionSupportsAutoboxing(_targetVersion) || !accessors[i].getReturnType().getSymbolData().isPrimitiveType()) {
                Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 6)).append(valueToStringName).append("(").append(accessors[i].getName()).append("()) + ").toString());
            } else {
                Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 6)).append(accessors[i].getName()).append("() + ").toString());
            }
            if (i < accessors.length - 1) {
                Augmentor._writeToFileOut("\", \" + ");
            }
            Augmentor._writeToFileOut(newLine);
        }
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 6)).append("\")\";").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("}").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("catch (RuntimeException e) {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append(flagName).append(" = false;").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("throw e;").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("}").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append(flagName).append(" = false;").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("return result;").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("}").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append("}").append(newLine).toString());
    }

    protected static void writeSimpleToString(SymbolData sd, int baseIndent, String valueToStringName, MethodData[] accessors) {
        Augmentor._writeToFileOut(new StringBuffer().append(newLine).append(Augmentor.indentString(baseIndent, 1)).append("/** This method is automatically generated by the Language Level Converter. */").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append("public java.lang.String toString() {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("return getClass().getName() + \"(\" + ").append(newLine).toString());
        for (int i = 0; i < accessors.length; ++i) {
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append(accessors[i].getName()).append("() + ").toString());
            if (i < accessors.length - 1) {
                Augmentor._writeToFileOut("\", \" + ");
            }
            Augmentor._writeToFileOut(newLine);
        }
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("\")\";").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append("}").append(newLine).toString());
    }

    protected static void writeEquals(String className, SymbolData sd, int baseIndent, String valueEqualsName) {
        LinkedList<MethodData> methods = sd.getMethods();
        MethodData equals = null;
        for (MethodData currMd : methods) {
            if (!currMd.getName().equals("equals") || !currMd.isGenerated()) continue;
            equals = currMd;
            break;
        }
        if (equals == null) {
            return;
        }
        LinkedList<MethodData> allMds = Augmentor._getVariableAccessorListHelper(sd);
        MethodData[] mds = allMds.toArray(new MethodData[allMds.size()]);
        if (_safeSupportCode) {
            Augmentor.writeSafeEquals(className, sd, baseIndent, valueEqualsName, mds);
        } else {
            Augmentor.writeSimpleEquals(className, sd, baseIndent, valueEqualsName, mds);
        }
    }

    protected static void writeSafeEquals(String className, SymbolData sd, int baseIndent, String valueEqualsName, MethodData[] accessors) {
        String listName = sd.createUniqueName("__equalsList");
        VariableData equalsList = new VariableData(listName, new ModifiersAndVisibility(JExprParser.NO_SOURCE_INFO, new String[]{"private", "static"}), _llv.getSymbolDataHelper("java.util.LinkedList", JExprParser.NO_SOURCE_INFO, false, false, false, false), true, sd);
        equalsList.setGenerated(true);
        sd.addVar(equalsList);
        Augmentor._writeToFileOut(new StringBuffer().append(newLine).append(Augmentor.indentString(baseIndent, 1)).append("/** This field is automatically generated by the Language Level Converter. */").toString());
        if (LanguageLevelConverter.versionSupportsGenerics(_targetVersion)) {
            Augmentor._writeToFileOut(new StringBuffer().append(newLine).append(Augmentor.indentString(baseIndent, 1)).append("private java.util.LinkedList<").append(className).append("> ").append(listName).append(" = new java.util.LinkedList<").append(className).append(">();").append(newLine).toString());
        } else {
            Augmentor._writeToFileOut(new StringBuffer().append(newLine).append(Augmentor.indentString(baseIndent, 1)).append("private java.util.LinkedList ").append(listName).append(" = new java.util.LinkedList();").append(newLine).append(newLine).toString());
        }
        Augmentor._writeToFileOut(new StringBuffer().append(newLine).append(Augmentor.indentString(baseIndent, 1)).append("/** This method is automatically generated by the Language Level Converter. */").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append("public boolean equals(java.lang.Object o) {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("if (this == o) {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("return true;").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("}").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("else if ((o == null) || (! o.getClass().equals(getClass()))) {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("return false;").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("}").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("else {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("boolean alreadyTested = false;").append(newLine).toString());
        if (LanguageLevelConverter.versionSupportsForEach(_targetVersion)) {
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("for (").append(className).append(" element : ").append(listName).append(")").append(newLine).toString());
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("alreadyTested = alreadyTested || (o == element);").append(newLine).append(newLine).toString());
        } else {
            if (LanguageLevelConverter.versionSupportsGenerics(_targetVersion)) {
                Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("java.util.Iterator<").append(className).append("> i = ").append(listName).append(".iterator();").append(newLine).toString());
            } else {
                Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("java.util.Iterator i = ").append(listName).append(".iterator();").append(newLine).toString());
            }
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("while (!alreadyTested && i.hasNext())").append(newLine).toString());
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("alreadyTested = alreadyTested || (o == i.next());").append(newLine).append(newLine).toString());
        }
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("if (alreadyTested) { ").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("return true;").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("}").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("else {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append(className).append(" cast = ((").append(className).append(") o);").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append(listName).append(".addLast(cast);").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("boolean result;").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("try {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("result = ").toString());
        int variablesCompared = 0;
        for (int i = 0; i < accessors.length; ++i) {
            if (variablesCompared > 0) {
                Augmentor._writeToFileOut(new StringBuffer().append(" && ").append(newLine).append(Augmentor.indentString(baseIndent, 7)).toString());
            }
            ++variablesCompared;
            String varName = new StringBuffer().append(accessors[i].getName()).append("()").toString();
            if (LanguageLevelConverter.versionSupportsAutoboxing(_targetVersion) || !accessors[i].getReturnType().getSymbolData().isPrimitiveType()) {
                Augmentor._writeToFileOut(new StringBuffer().append(valueEqualsName).append("(").append(varName).append(", cast.").append(varName).append(")").toString());
                continue;
            }
            Augmentor._writeToFileOut(new StringBuffer().append("(").append(varName).append(" == cast.").append(varName).append(")").toString());
        }
        if (variablesCompared == 0) {
            Augmentor._writeToFileOut("true");
        }
        Augmentor._writeToFileOut(new StringBuffer().append(";").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("}").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("catch (RuntimeException e) {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append(listName).append(".removeLast();").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("throw e;").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("}").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append(listName).append(".removeLast();").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("return result;").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("}").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("}").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append("}").append(newLine).toString());
    }

    protected static void writeSimpleEquals(String className, SymbolData sd, int baseIndent, String valueEqualsName, MethodData[] accessors) {
        Augmentor._writeToFileOut(new StringBuffer().append(newLine).append(Augmentor.indentString(baseIndent, 1)).append("/** This method is automatically generated by the Language Level Converter. */").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append("public boolean equals(java.lang.Object o) {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("if (this == o) {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("return true;").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("}").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("else if ((o == null) || (! o.getClass().equals(getClass()))) {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("return false;").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("}").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("else {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append(className).append(" cast = ((").append(className).append(") o);").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("return ").toString());
        int variablesCompared = 0;
        for (int i = 0; i < accessors.length; ++i) {
            if (variablesCompared > 0) {
                Augmentor._writeToFileOut(new StringBuffer().append(" && ").append(newLine).append(Augmentor.indentString(baseIndent, 5)).toString());
            }
            ++variablesCompared;
            String varName = new StringBuffer().append(accessors[i].getName()).append("()").toString();
            if (!accessors[i].getReturnType().getSymbolData().isPrimitiveType()) {
                Augmentor._writeToFileOut(new StringBuffer().append("(").append(varName).append(" != null && ").append(varName).append(".equals(cast.").append(varName).append("))").toString());
                continue;
            }
            Augmentor._writeToFileOut(new StringBuffer().append("(").append(varName).append(" == cast.").append(varName).append(")").toString());
        }
        if (variablesCompared == 0) {
            Augmentor._writeToFileOut("true");
        }
        Augmentor._writeToFileOut(new StringBuffer().append(";").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("}").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append("}").append(newLine).toString());
    }

    protected static void writeAnonEquals(int baseIndent) {
        Augmentor._writeToFileOut(new StringBuffer().append(newLine).append(Augmentor.indentString(baseIndent, 1)).append("/** This method is automatically generated by the Language Level Converter. */").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append("public boolean equals(java.lang.Object o) {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("return (this == o);").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append("}").append(newLine).toString());
    }

    protected static void writeHashCode(String className, SymbolData sd, int baseIndent, boolean waitForVarDef, String valueHashCodeName) {
        LinkedList<MethodData> methods = sd.getMethods();
        MethodData hashCode = null;
        for (MethodData currMd : methods) {
            if (!currMd.getName().equals("hashCode") || !currMd.isGenerated()) continue;
            hashCode = currMd;
            break;
        }
        if (hashCode == null) {
            return;
        }
        LinkedList<MethodData> allMds = Augmentor._getVariableAccessorListHelper(sd);
        MethodData[] mds = allMds.toArray(new MethodData[allMds.size()]);
        if (_safeSupportCode) {
            Augmentor.writeSafeHashCode(className, sd, baseIndent, waitForVarDef, valueHashCodeName, mds);
        } else {
            Augmentor.writeSimpleHashCode(className, sd, baseIndent, waitForVarDef, valueHashCodeName, mds);
        }
    }

    protected static void writeSafeHashCode(String className, SymbolData sd, int baseIndent, boolean waitForVarDef, String valueHashCodeName, MethodData[] accessors) {
        String listName = "__hashCodeList";
        listName = sd.createUniqueName(listName);
        VariableData hashCodeList = new VariableData(listName, new ModifiersAndVisibility(JExprParser.NO_SOURCE_INFO, new String[]{"private", "static"}), _llv.getSymbolDataHelper("java.util.LinkedList", JExprParser.NO_SOURCE_INFO, false, false, false, false), true, sd);
        hashCodeList.setGenerated(true);
        if (waitForVarDef) {
            SymbolData outermostData = sd;
            while (outermostData.getOuterData() != null) {
                outermostData = outermostData.getOuterData().getSymbolData();
            }
            outermostData.addVar(hashCodeList);
            _endOfClassVarDefs.add("/** This field is automatically generated by the Language Level Converter. */");
            if (LanguageLevelConverter.versionSupportsGenerics(_targetVersion)) {
                _endOfClassVarDefs.add(new StringBuffer().append("private static java.util.LinkedList<Object> ").append(listName).append(" = new java.util.LinkedList<Object>();").toString());
            } else {
                _endOfClassVarDefs.add(new StringBuffer().append("private static java.util.LinkedList ").append(listName).append(" = new java.util.LinkedList();").toString());
            }
            _endOfClassVarDefs.add("");
        } else {
            sd.addVar(hashCodeList);
            Augmentor._writeToFileOut(new StringBuffer().append(newLine).append(Augmentor.indentString(baseIndent, 1)).append("/** This field is automatically generated by the Language Level Converter. */").toString());
            if (LanguageLevelConverter.versionSupportsGenerics(_targetVersion)) {
                Augmentor._writeToFileOut(new StringBuffer().append(newLine).append(Augmentor.indentString(baseIndent, 1)).append("private static java.util.LinkedList<").append(className).append("> ").append(listName).append(" = new java.util.LinkedList<").append(className).append(">();").append(newLine).toString());
            } else {
                Augmentor._writeToFileOut(new StringBuffer().append(newLine).append(Augmentor.indentString(baseIndent, 1)).append("private static java.util.LinkedList ").append(listName).append(" = new java.util.LinkedList();").append(newLine).toString());
            }
        }
        Augmentor._writeToFileOut(new StringBuffer().append(newLine).append(Augmentor.indentString(baseIndent, 1)).append("/** This method is automatically generated by the Language Level Converter. */").toString());
        Augmentor._writeToFileOut(new StringBuffer().append(newLine).append(Augmentor.indentString(baseIndent, 1)).append("public int hashCode() {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("if (").append(listName).append(".contains(this)) {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("return -1;").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("}").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("else {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append(listName).append(".addLast(this);").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("int result;").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("try {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("result = getClass().hashCode()").toString());
        for (int i = 0; i < accessors.length; ++i) {
            Augmentor._writeToFileOut(new StringBuffer().append(" ^ ").append(newLine).append(Augmentor.indentString(baseIndent, 6)).toString());
            SymbolData type = accessors[i].getReturnType().getSymbolData();
            if (LanguageLevelConverter.versionSupportsAutoboxing(_targetVersion) || !type.isPrimitiveType()) {
                Augmentor._writeToFileOut(new StringBuffer().append(valueHashCodeName).append("(").append(accessors[i].getName()).append("())").toString());
                continue;
            }
            if (type == SymbolData.BOOLEAN_TYPE) {
                Augmentor._writeToFileOut(new StringBuffer().append("(").append(accessors[i].getName()).append("() ? 1 : 0)").toString());
                continue;
            }
            if (type.isAssignableTo(SymbolData.INT_TYPE, _targetVersion)) {
                Augmentor._writeToFileOut(new StringBuffer().append(accessors[i].getName()).append("()").toString());
                continue;
            }
            Augmentor._writeToFileOut(new StringBuffer().append("(int) ").append(accessors[i].getName()).append("()").toString());
        }
        Augmentor._writeToFileOut(new StringBuffer().append(";").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("}").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("catch (RuntimeException e) {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append(listName).append(".removeLast();").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("throw e;").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("}").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append(listName).append(".removeLast();").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("return result;").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("}").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append("}").append(newLine).toString());
    }

    protected static void writeSimpleHashCode(String className, SymbolData sd, int baseIndent, boolean waitForVarDef, String valueHashCodeName, MethodData[] accessors) {
        Augmentor._writeToFileOut(new StringBuffer().append(newLine).append(Augmentor.indentString(baseIndent, 1)).append("/** This method is automatically generated by the Language Level Converter. */").toString());
        Augmentor._writeToFileOut(new StringBuffer().append(newLine).append(Augmentor.indentString(baseIndent, 1)).append("public int hashCode() {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("return getClass().hashCode()").toString());
        for (int i = 0; i < accessors.length; ++i) {
            Augmentor._writeToFileOut(new StringBuffer().append(" ^ ").append(newLine).append(Augmentor.indentString(baseIndent, 4)).toString());
            SymbolData type = accessors[i].getReturnType().getSymbolData();
            if (!type.isPrimitiveType()) {
                Augmentor._writeToFileOut(new StringBuffer().append("(").append(accessors[i].getName()).append("() == null ? 0 : ").append(accessors[i].getName()).append("().hashCode())").toString());
                continue;
            }
            if (type == SymbolData.BOOLEAN_TYPE) {
                Augmentor._writeToFileOut(new StringBuffer().append("(").append(accessors[i].getName()).append("() ? 1 : 0)").toString());
                continue;
            }
            if (type.isAssignableTo(SymbolData.INT_TYPE, _targetVersion)) {
                Augmentor._writeToFileOut(new StringBuffer().append(accessors[i].getName()).append("()").toString());
                continue;
            }
            Augmentor._writeToFileOut(new StringBuffer().append("(int) ").append(accessors[i].getName()).append("()").toString());
        }
        Augmentor._writeToFileOut(new StringBuffer().append(";").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append("}").append(newLine).toString());
    }

    private static String writeValueToString(SymbolData sd, int baseIndent) {
        String methodName = sd.createUniqueMethodName("__valueToString");
        if (_safeSupportCode) {
            Augmentor.writeSafeValueToString(sd, baseIndent, methodName);
        }
        return methodName;
    }

    private static void writeSafeValueToString(SymbolData sd, int baseIndent, String methodName) {
        String[] primitiveTypes = new String[]{"byte[]", "short[]", "char[]", "int[]", "long[]", "float[]", "double[]", "boolean[]"};
        boolean useGenerics = LanguageLevelConverter.versionSupportsGenerics(_targetVersion);
        Augmentor._writeToFileOut(newLine);
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append("/**").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append(" * This method is automatically generated by the LanguageLevelConverter.").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append(" * As a helper to toString(), it recursively generates a string for any object,").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append(" * including nulls, arrays, and standard reference types.").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append(" */").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append("private java.lang.String ").append(methodName).append("(java.lang.Object o) {").append(newLine).append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("class ArrayToString {").append(newLine).append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("public String valueFor(java.lang.Object o) {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("if (o instanceof java.lang.Object[]) {").append(newLine).toString());
        if (useGenerics) {
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("return arrayToString((java.lang.Object[]) o, new java.util.HashSet<java.lang.Object[]>());").append(newLine).toString());
        } else {
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("return arrayToString((java.lang.Object[]) o, new java.util.HashSet());").append(newLine).toString());
        }
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("}").append(newLine).toString());
        for (String type : primitiveTypes) {
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("else if (o instanceof ").append(type).append(") {").append(newLine).toString());
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("return arrayToString((").append(type).append(") o);").append(newLine).toString());
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("}").append(newLine).toString());
        }
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("else {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("// o should be an array, but if not, toString() is called").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("return o.toString();").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("}").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("}").append(newLine).append(newLine).toString());
        for (String type : primitiveTypes) {
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("public java.lang.String arrayToString(").append(type).append(" array) {").append(newLine).toString());
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("java.lang.StringBuffer result = new java.lang.StringBuffer();").append(newLine).toString());
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("result.append(\"[\");").append(newLine).toString());
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("if (array.length > 0) { result.append(array[0]); }").append(newLine).toString());
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("for (int i = 1; i < array.length; i++) {").append(newLine).toString());
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("result.append(\", \");").append(newLine).toString());
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("result.append(array[i]);").append(newLine).toString());
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("}").append(newLine).toString());
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("result.append(\"]\");").append(newLine).toString());
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("return result.toString();").append(newLine).toString());
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("}").append(newLine).append(newLine).toString());
        }
        if (useGenerics) {
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("public java.lang.String arrayToString(java.lang.Object[] array, java.util.HashSet<java.lang.Object[]> alreadyPrinted) {").append(newLine).toString());
        } else {
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("public java.lang.String arrayToString(java.lang.Object[] array, java.util.HashSet alreadyPrinted) {").append(newLine).toString());
        }
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("if (alreadyPrinted.contains(array)) { return (\"[...]\"); }").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("else { alreadyPrinted.add(array); }").append(newLine).append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("java.lang.StringBuffer result = new java.lang.StringBuffer();").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("result.append(\"[\");").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("boolean nonEmpty = false;").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("for (int i = 0; i < array.length; i++) {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("if (nonEmpty) { result.append(\", \"); }").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("nonEmpty = true;").append(newLine).append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("if (array[i] instanceof java.lang.Object[]) {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 6)).append("result.append(arrayToString((java.lang.Object[]) array[i], alreadyPrinted));").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("}").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("else {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 6)).append("result.append(").append(methodName).append("(array[i]));").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("}").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("}").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("result.append(\"]\");").append(newLine).append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("alreadyPrinted.remove(array);").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("return result.toString();").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("}").append(newLine).append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("}").append(newLine).append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("if (o == null) { return \"\" + null; }").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("else if (o.getClass().isArray()) { return new ArrayToString().valueFor(o); }").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("else { return o.toString(); }").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append("}").append(newLine).toString());
    }

    private static void writeSimpleValueToString(SymbolData sd, int baseIndent, String methodName) {
        Augmentor._writeToFileOut(newLine);
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append("/**").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append(" * This method is automatically generated by the LanguageLevelConverter.").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append(" * As a helper to toString(), it generates a string for any object,").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append(" * including nulls and standard reference types.").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append(" */").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append("private java.lang.String ").append(methodName).append("(java.lang.Object o) {").append(newLine).append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("if (o == null) { return \"\" + null; }").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("else { return o.toString(); }").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append("}").append(newLine).toString());
    }

    private static String writeValueEquals(SymbolData sd, int baseIndent) {
        String methodName = sd.createUniqueMethodName("__valueEquals");
        if (_safeSupportCode) {
            Augmentor.writeSafeValueEquals(sd, baseIndent, methodName);
        }
        return methodName;
    }

    private static void writeSafeValueEquals(SymbolData sd, int baseIndent, String methodName) {
        String[] primitiveTypes = new String[]{"byte[]", "short[]", "char[]", "int[]", "long[]", "float[]", "double[]", "boolean[]"};
        boolean useGenerics = LanguageLevelConverter.versionSupportsGenerics(_targetVersion);
        Augmentor._writeToFileOut(newLine);
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append("/**").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append(" * This method is automatically generated by the LanguageLevelConverter.").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append(" * As a helper to equals(Object), it recursively compares any two objects,").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append(" * including nulls, arrays, and standard reference types.").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append(" */").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append("private boolean ").append(methodName).append("(java.lang.Object o1, java.lang.Object o2) {").append(newLine).append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("class ArrayEquals {").append(newLine).append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("public boolean valueFor(java.lang.Object o1, java.lang.Object o2) {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("if (o1 instanceof java.lang.Object[] && o2 instanceof java.lang.Object[]) {").append(newLine).toString());
        if (useGenerics) {
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("return arrayEquals((java.lang.Object[]) o1, (java.lang.Object[]) o2, new java.util.HashSet<java.lang.Object>());").append(newLine).toString());
        } else {
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("return arrayEquals((java.lang.Object[]) o1, (java.lang.Object[]) o2, new java.util.HashSet());").append(newLine).toString());
        }
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("}").append(newLine).toString());
        for (String type : primitiveTypes) {
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("else if (o1 instanceof ").append(type).append(" && o2 instanceof ").append(type).append(") {").append(newLine).toString());
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("return arrayEquals((").append(type).append(") o1, (").append(type).append(") o2);").append(newLine).toString());
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("}").append(newLine).toString());
        }
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("else {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("// o1 and o2 should be arrays, but if not, or if they have different types, equals(Object) is called").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("return o1.equals(o2);").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("}").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("}").append(newLine).append(newLine).toString());
        for (String type : primitiveTypes) {
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("public boolean arrayEquals(").append(type).append(" array1, ").append(type).append(" array2) {").append(newLine).toString());
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("if (array1.length != array2.length) { return false; }").append(newLine).append(newLine).toString());
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("else {").append(newLine).toString());
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("for (int i = 0; i < array1.length; i++) {").append(newLine).toString());
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 6)).append("if (array1[i] != array2[i]) { return false; }").append(newLine).toString());
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("}").append(newLine).toString());
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("return true;").append(newLine).toString());
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("}").append(newLine).toString());
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("}").append(newLine).append(newLine).toString());
        }
        if (useGenerics) {
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("public boolean arrayEquals(final java.lang.Object[] array1, final java.lang.Object[] array2, java.util.HashSet<java.lang.Object> alreadyCompared) {").append(newLine).append(newLine).toString());
        } else {
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("public boolean arrayEquals(final java.lang.Object[] array1, final java.lang.Object[] array2, java.util.HashSet alreadyCompared) {").append(newLine).append(newLine).toString());
        }
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("class ArrayPair {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("public java.lang.Object[] array1() { return array1; }").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("public java.lang.Object[] array2() { return array2; }").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("public boolean equals(java.lang.Object o) {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 6)).append("if ((o == null) || ! (o instanceof ArrayPair)) { return false; }").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 6)).append("else { return (array1.equals(((ArrayPair) o).array1())) && (array2.equals(((ArrayPair) o).array2())); }").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("}").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("public int hashCode() { return array1.hashCode() ^ (array2.hashCode() << 1); }").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("}").append(newLine).append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("if (array1.length != array2.length) { return false; }").append(newLine).append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("else {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("ArrayPair currentPair = new ArrayPair();").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("if (alreadyCompared.contains(currentPair)) { return true; }").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("alreadyCompared.add(currentPair);").append(newLine).append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("boolean result = true;").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("for (int i = 0; i < array1.length; i++) {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 6)).append("if (array1[i] instanceof java.lang.Object[] && array2[i] instanceof java.lang.Object[]) {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 7)).append("result = arrayEquals((java.lang.Object[]) array1[i], (java.lang.Object[]) array2[i], alreadyCompared);").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 6)).append("}").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 6)).append("else {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 7)).append("result = ").append(methodName).append("(array1[i], array2[i]);").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 6)).append("}").append(newLine).append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 6)).append("if (!result) { break; }").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("}").append(newLine).append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("alreadyCompared.remove(currentPair);").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("return result;").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("}").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("}").append(newLine).append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("}").append(newLine).append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("if (o1 == null) { return o2 == null; }").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("else if (o2 == null) { return false; }").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("else if (o1.getClass().isArray() && o2.getClass().isArray()) { return new ArrayEquals().valueFor(o1, o2); }").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("else { return o1.equals(o2); }").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append("}").append(newLine).toString());
    }

    private static void writeSimpleValueEquals(SymbolData sd, int baseIndent, String methodName) {
        Augmentor._writeToFileOut(newLine);
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append("/**").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append(" * This method is automatically generated by the LanguageLevelConverter.").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append(" * As a helper to equals(Object), it compares any two objects,").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append(" * including nulls and standard reference types.").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append(" */").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append("private boolean ").append(methodName).append("(java.lang.Object o1, java.lang.Object o2) {").append(newLine).append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("if (o1 == null) { return o2 == null; }").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("else if (o2 == null) { return false; }").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("else { return o1.equals(o2); }").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append("}").append(newLine).toString());
    }

    private static String writeValueHashCode(SymbolData sd, int baseIndent, String valueEqualsName) {
        String methodName = sd.createUniqueMethodName("__valueHashCode");
        if (_safeSupportCode) {
            Augmentor.writeSafeValueHashCode(sd, baseIndent, valueEqualsName, methodName);
        }
        return methodName;
    }

    private static void writeSafeValueHashCode(SymbolData sd, int baseIndent, String valueEqualsName, String methodName) {
        String[] primitiveTypes = new String[]{"byte[]", "short[]", "char[]", "int[]", "long[]", "float[]", "double[]", "boolean[]"};
        boolean useGenerics = LanguageLevelConverter.versionSupportsGenerics(_targetVersion);
        Augmentor._writeToFileOut(newLine);
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append("/**").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append(" * This method is automatically generated by the LanguageLevelConverter.").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append(" * As a helper to hashCode(), it recursively generates a hash code for any object,").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append(" * including nulls, arrays, and standard reference types.").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append(" */").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append("private int ").append(methodName).append("(java.lang.Object o) {").append(newLine).append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("class ArrayHashCode {").append(newLine).append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("public int valueFor(java.lang.Object o) {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("if (o instanceof java.lang.Object[]) {").append(newLine).toString());
        if (useGenerics) {
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("return arrayHashCode((java.lang.Object[]) o, new java.util.LinkedList<java.lang.Object>());").append(newLine).toString());
        } else {
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("return arrayHashCode((java.lang.Object[]) o, new java.util.LinkedList());").append(newLine).toString());
        }
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("}").append(newLine).toString());
        for (String type : primitiveTypes) {
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("else if (o instanceof ").append(type).append(") {").append(newLine).toString());
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("return arrayHashCode((").append(type).append(") o);").append(newLine).toString());
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("}").append(newLine).toString());
        }
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("else {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("// o should be an array, but if not, hashCode() is called").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("return o.hashCode();").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("}").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("}").append(newLine).append(newLine).toString());
        for (String type : primitiveTypes) {
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("public int arrayHashCode(").append(type).append(" array) {").append(newLine).toString());
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("int result = 0;").append(newLine).toString());
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("for (int i = 0; i < array.length; i++) {").append(newLine).toString());
            if (type.equals("boolean[]")) {
                Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("result = (result << 1) ^ (array[i] ? 1 : 0);").append(newLine).toString());
            } else {
                Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("result = (result << 1) ^ (int) array[i];").append(newLine).toString());
            }
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("}").append(newLine).toString());
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("return result;").append(newLine).toString());
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("}").append(newLine).append(newLine).toString());
        }
        if (useGenerics) {
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("public int arrayHashCode(final java.lang.Object[] array, final java.util.LinkedList<java.lang.Object> alreadyGenerated) {").append(newLine).append(newLine).toString());
        } else {
            Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("public int arrayHashCode(final java.lang.Object[] array, final java.util.LinkedList alreadyGenerated) {").append(newLine).append(newLine).toString());
        }
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("class ArrayWrapper {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("public java.lang.Object[] array() { return array; }").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("public boolean equals(java.lang.Object o) {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 6)).append("return (o != null) && (o instanceof ArrayWrapper)  && ").append(valueEqualsName).append("(array, ((ArrayWrapper) o).array());").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("}").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("public int hashCode() { return 0; } // This method should never be used -- only here for consistency.").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("}").append(newLine).append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("ArrayWrapper currentWrapper = new ArrayWrapper();").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("if (alreadyGenerated.contains(currentWrapper)) { return -1; }").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("alreadyGenerated.addLast(currentWrapper);").append(newLine).append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("int result = 0;").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("for (int i = 0; i < array.length; i++) {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("if (array[i] instanceof java.lang.Object[]) {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 6)).append("result = (result << 1) ^ (arrayHashCode((java.lang.Object[]) array[i], alreadyGenerated) >> 1);").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("}").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("else {").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 6)).append("result = (result << 1) ^ ").append(methodName).append("(array[i]);").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 5)).append("}").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("}").append(newLine).append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("alreadyGenerated.removeLast();").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 4)).append("return result;").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 3)).append("}").append(newLine).append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("}").append(newLine).append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("if (o == null) { return 0; }").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("else if (o.getClass().isArray()) { return new ArrayHashCode().valueFor(o); }").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("else { return o.hashCode(); }").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append("}").append(newLine).toString());
    }

    private static void writeSimpleValueHashCode(SymbolData sd, int baseIndent, String valueEqualsName, String methodName) {
        Augmentor._writeToFileOut(newLine);
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append("/**").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append(" * This method is automatically generated by the LanguageLevelConverter.").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append(" * As a helper to hashCode(), it generates a hash code for any object,").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append(" * including nulls and standard reference types.").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append(" */").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append("private int ").append(methodName).append("(java.lang.Object o) {").append(newLine).append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("if (o == null) { return 0; }").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 2)).append("else { return o.hashCode(); }").append(newLine).toString());
        Augmentor._writeToFileOut(new StringBuffer().append(Augmentor.indentString(baseIndent, 1)).append("}").append(newLine).toString());
    }

    private static String indentString(int baseIndent, int indentCount) {
        int length = indentCount * 2 + baseIndent;
        StringBuffer result = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            result.append(' ');
        }
        return result.toString();
    }

    private static boolean _isElementaryFile() {
        return LanguageLevelConverter.isElementaryFile(Augmentor._llv._file);
    }

    private static boolean _isIntermediateFile() {
        return LanguageLevelConverter.isIntermediateFile(Augmentor._llv._file);
    }

    private static boolean _isAdvancedFile() {
        return LanguageLevelConverter.isAdvancedFile(Augmentor._llv._file);
    }

    private static LinkedList<MethodData> _getVariableAccessorListHelper(SymbolData currClass) {
        MethodData md;
        SymbolData tempSd;
        Vector<Pair<VariableData, MethodData>> accessorMappings = new Vector<Pair<VariableData, MethodData>>();
        LinkedList<SymbolData> classes = new LinkedList<SymbolData>();
        classes.add(currClass);
        while (classes.size() > 0 && !LanguageLevelVisitor.isJavaLibraryClass((tempSd = (SymbolData)classes.removeFirst()).getName())) {
            Data outerData;
            for (int i = 0; i < tempSd.getVars().size(); ++i) {
                VariableData tempVd = tempSd.getVars().get(i);
                md = tempSd.getMethod(tempVd.getName(), new TypeData[0]);
                if (md == null) continue;
                accessorMappings.add(new Pair<VariableData, MethodData>(tempVd, md));
            }
            SymbolData superClass = tempSd.getSuperClass();
            if (superClass != null) {
                classes.addFirst(superClass);
            }
            if ((outerData = tempSd.getOuterData()) == null) continue;
            classes.addLast(outerData.getSymbolData());
        }
        LinkedList<MethodData> allMethods = new LinkedList<MethodData>();
        for (int i = accessorMappings.size() - 1; i >= 0; --i) {
            VariableData vd = (VariableData)((Pair)accessorMappings.get(i)).getFirst();
            md = (MethodData)((Pair)accessorMappings.get(i)).getSecond();
            boolean canSeeMethod = TypeChecker.checkAccessibility(new NullLiteral(JExprParser.NO_SOURCE_INFO), md.getMav(), md.getName(), md.getSymbolData(), currClass, "method", false);
            if (!canSeeMethod || md.hasModifier("static") || md.getThrown().length != 0 || !vd.getType().getSymbolData().isAssignableTo(md.getReturnType(), _targetVersion)) continue;
            boolean isShadowed = false;
            for (int j = i - 1; j >= 0; --j) {
                if (!((MethodData)((Pair)accessorMappings.get(j)).getSecond()).getName().equals(md.getName())) continue;
                isShadowed = true;
                break;
            }
            if (isShadowed) continue;
            allMethods.addFirst(md);
        }
        return allMethods;
    }

    private static void _readAndWriteThroughIndex(int line, int column) {
        if (_fileInLine > line || _fileInLine == line && _fileInColumn - 1 > column) {
            throw new RuntimeException(new StringBuffer().append("Internal Program Error: Attempt to read in ").append(Augmentor._llv._file.getName()).append(" through a point that is already past: line ").append(line).append(", column ").append(column).append("; (currently at ").append(_fileInLine).append(", ").append(_fileInColumn).append(").  Please report this bug.").toString());
        }
        try {
            StringBuffer result = new StringBuffer();
            while (_fileInLine < line) {
                String l = _fileIn.readLine();
                if (l == null) {
                    _fileOut.flush();
                    throw new RuntimeException(new StringBuffer().append("Internal Program Error: Attempt to read in ").append(Augmentor._llv._file.getName()).append(" past the end of file: line ").append(line).append(", column ").append(column).append("; (currently at ").append(_fileInLine).append(", ").append(_fileInColumn).append(").  Please report this bug.").toString());
                }
                result.append(l).append(newLine);
                ++_fileInLine;
                _fileInColumn = 1;
            }
            int lastLineLength = column - _fileInColumn + 1;
            char[] chars = new char[lastLineLength];
            int charsRead = _fileIn.read(chars, 0, lastLineLength);
            if (charsRead != lastLineLength) {
                _fileOut.flush();
                throw new RuntimeException(new StringBuffer().append("Internal Program Error: Attempt to read in ").append(Augmentor._llv._file.getName()).append(" past the end of file: line ").append(line).append(", column ").append(column).append("; (currently at ").append(_fileInLine).append(", ").append(_fileInColumn).append(").  Please report this bug.").toString());
            }
            result.append(chars);
            _fileInLine = line;
            _fileInColumn = column + 1;
            Augmentor._writeToFileOut(result.toString());
        }
        catch (IOException ioe) {
            throw new Exception(ioe);
        }
    }

    private static void _writeToFileOut(String s) {
        try {
            _fileOut.write(s);
        }
        catch (IOException ioe) {
            throw new Exception(ioe);
        }
    }

    static /* synthetic */ Data access$300(Augmentor x0) {
        return x0._enclosingData;
    }

    static /* synthetic */ Data access$302(Augmentor x0, Data x1) {
        x0._enclosingData = x1;
        return x0._enclosingData;
    }

    static /* synthetic */ String access$400(int x0, int x1) {
        return Augmentor.indentString(x0, x1);
    }

    static /* synthetic */ LanguageLevelVisitor access$502(LanguageLevelVisitor x0) {
        _llv = x0;
        return _llv;
    }

    static /* synthetic */ boolean access$600() {
        return Augmentor._isElementaryFile();
    }

    static /* synthetic */ boolean access$700() {
        return Augmentor._isIntermediateFile();
    }

    static /* synthetic */ LinkedList access$800(SymbolData x0) {
        return Augmentor._getVariableAccessorListHelper(x0);
    }

    public static class Exception
    extends RuntimeException {
        public Exception(java.lang.Exception nested) {
            super(nested);
        }
    }

    public static class MethodBodyAugmentor
    extends Augmentor {
        protected MethodBodyAugmentor(Data enclosing) {
            super(enclosing);
        }

        public void forVariableDeclaration(VariableDeclaration that) {
            Augmentor._readAndWriteThroughIndex(that.getSourceInfo().getStartLine(), that.getSourceInfo().getStartColumn() - 1);
            if (!Augmentor._isAdvancedFile()) {
                Augmentor._writeToFileOut("final ");
            }
        }
    }
}

