/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import edu.rice.cs.javalanglevels.Data;
import edu.rice.cs.javalanglevels.LanguageLevelVisitor;
import edu.rice.cs.javalanglevels.MethodData;
import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.SymbolData;
import edu.rice.cs.javalanglevels.VariableData;
import edu.rice.cs.javalanglevels.parser.JExprParser;
import edu.rice.cs.javalanglevels.tree.ModifiersAndVisibility;
import edu.rice.cs.javalanglevels.tree.TypeParameter;

public class ArrayData
extends SymbolData {
    private SymbolData _elementType;

    public ArrayData(SymbolData sd, LanguageLevelVisitor llv, SourceInfo si) {
        super(sd.getName() + "[]");
        this._elementType = sd;
        this.addVar(new VariableData("length", new ModifiersAndVisibility(JExprParser.NO_SOURCE_INFO, new String[]{"public", "final"}), SymbolData.INT_TYPE, true, this));
        SymbolData object = llv.getSymbolData("java.lang.Object", si);
        this.setSuperClass(object);
        SymbolData result = llv.getSymbolData("java.lang.Cloneable", si);
        if (result != null) {
            this.addInterface(result);
        }
        if ((result = llv.getSymbolData("java.io.Serializable", si)) != null) {
            this.addInterface(result);
        }
        this.addMethod(new MethodData("clone", new ModifiersAndVisibility(JExprParser.NO_SOURCE_INFO, new String[]{"public"}), new TypeParameter[0], object, new VariableData[0], new String[0], this, null));
        this.setIsContinuation(false);
    }

    public String getPackage() {
        return this._elementType.getPackage();
    }

    public void setPackage(String s) {
        this._elementType.setPackage(s);
    }

    public ModifiersAndVisibility getMav() {
        if (this._elementType.hasModifier("final")) {
            return this._elementType.getMav();
        }
        String[] elementMavs = this._elementType.getMav().getModifiers();
        String[] newMavs = new String[elementMavs.length + 1];
        for (int i = 0; i < elementMavs.length; ++i) {
            newMavs[i] = elementMavs[i];
        }
        newMavs[elementMavs.length] = "final";
        return new ModifiersAndVisibility(JExprParser.NO_SOURCE_INFO, newMavs);
    }

    public void setMav(ModifiersAndVisibility mv) {
        this._elementType.setMav(mv);
    }

    public SymbolData getElementType() {
        return this._elementType;
    }

    public Data getOuterData() {
        return this._elementType.getOuterData();
    }

    public void setOuterData(Data outerData) {
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ArrayData ad = (ArrayData)obj;
        return super.equals(obj) && this.getElementType().equals(ad.getElementType());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean isAssignableTo(SymbolData assignTo, String version) {
        if (assignTo instanceof ArrayData) {
            if (this.getElementType().isPrimitiveType()) {
                return this.getElementType() == ((ArrayData)assignTo).getElementType();
            }
            if (((ArrayData)assignTo).getElementType().isPrimitiveType()) {
                return false;
            }
            return this.getElementType().isAssignableTo(((ArrayData)assignTo).getElementType(), version);
        }
        return this.isSubClassOf(assignTo);
    }

    public boolean isCastableTo(SymbolData castTo, String version) {
        if (castTo instanceof ArrayData) {
            if (this.getElementType().isPrimitiveType()) {
                return this.getElementType() == ((ArrayData)castTo).getElementType();
            }
            if (((ArrayData)castTo).getElementType().isPrimitiveType()) {
                return false;
            }
            return this.getElementType().isCastableTo(((ArrayData)castTo).getElementType(), version);
        }
        if (this.isSubClassOf(castTo)) {
            return true;
        }
        return this.isSubClassOf(castTo);
    }

    public int getDimensions() {
        int dim = 1;
        SymbolData curData = this.getElementType();
        while (curData instanceof ArrayData) {
            ++dim;
            curData = ((ArrayData)curData).getElementType();
        }
        return dim;
    }
}

