/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui.config;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.IntegerOption;
import edu.rice.cs.drjava.config.OptionParseException;
import edu.rice.cs.drjava.ui.config.OptionComponent;
import java.awt.Frame;
import javax.swing.JComponent;
import javax.swing.JTextField;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerOptionComponent
extends OptionComponent<Integer> {
    private JTextField _jtf = new JTextField();

    public IntegerOptionComponent(IntegerOption opt, String text, Frame parent) {
        super(opt, text, parent);
        this._jtf.setText(this._option.format(DrJava.getConfig().getSetting(this._option)));
    }

    public IntegerOptionComponent(IntegerOption opt, String text, Frame parent, String description) {
        this(opt, text, parent);
        this.setDescription(description);
    }

    @Override
    public void setDescription(String description) {
        this._jtf.setToolTipText(description);
        this._label.setToolTipText(description);
    }

    @Override
    public boolean updateConfig() {
        Integer enteredValue;
        Integer currentValue = (Integer)DrJava.getConfig().getSetting(this._option);
        String enteredString = this._jtf.getText().trim();
        if (currentValue.toString().equals(enteredString)) {
            return true;
        }
        try {
            enteredValue = (Integer)this._option.parse(enteredString);
        }
        catch (OptionParseException ope) {
            this.showErrorMessage("Invalid Integer!", ope);
            return false;
        }
        DrJava.getConfig().setSetting(this._option, enteredValue);
        return true;
    }

    @Override
    public void setValue(Integer value) {
        this._jtf.setText(this._option.format(value));
    }

    @Override
    public JComponent getComponent() {
        return this._jtf;
    }

    @Override
    public /* synthetic */ void setValue(Object x0) {
        this.setValue((Integer)x0);
    }
}

