/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.BorderlessScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class UncaughtExceptionWindow
extends JDialog {
    private JComponent _exceptionInfo;
    private JTextArea _stackTrace;
    private JScrollPane _stackTraceScroll;
    private JPanel _okPanel;
    private JPanel _buttonPanel;
    private JButton _copyButton;
    private JButton _okButton;
    private Throwable _exception;
    private Action _okAction = new AbstractAction("OK"){

        public void actionPerformed(ActionEvent e) {
            UncaughtExceptionWindow.this.dispose();
        }
    };
    private Action _copyAction = new AbstractAction("Copy Stack Trace"){

        public void actionPerformed(ActionEvent e) {
            UncaughtExceptionWindow.this._stackTrace.grabFocus();
            UncaughtExceptionWindow.this._stackTrace.getActionMap().get("select-all").actionPerformed(e);
            UncaughtExceptionWindow.this._stackTrace.getActionMap().get("copy-to-clipboard").actionPerformed(e);
        }
    };
    private final String[] msg = new String[]{"A runtime exception occured!", "", "Please submit a bug report containing the system information in the Help>About ", "window and an account of the actions that caused the bug (if known) to", "http://sourceforge.net/projects/drjava.", "You may wish to save all your work and restart DrJava.", "Thanks for your help in making DrJava better!"};

    public UncaughtExceptionWindow(JFrame frame, Throwable exception) {
        super((Frame)frame, "Unexpected Error");
        System.out.println("Unexpected Window Exception: " + exception);
        this._exception = exception;
        this.setSize(600, 400);
        this.setLocationRelativeTo(frame);
        String trace = StringOps.getStackTrace(this._exception);
        if (this._exception instanceof UnexpectedException) {
            Throwable t = ((UnexpectedException)this._exception).getCause();
            trace = trace + "\nCaused by:\n" + StringOps.getStackTrace(t);
        }
        this._stackTrace = new JTextArea(trace);
        this.msg[1] = exception.toString();
        this._exceptionInfo = new JOptionPane(this.msg, 0, -1, null, new Object[0]);
        this._stackTrace.setEditable(false);
        this._copyButton = new JButton(this._copyAction);
        this._okButton = new JButton(this._okAction);
        this._okPanel = new JPanel(new BorderLayout());
        this._buttonPanel = new JPanel();
        this._buttonPanel.add(this._copyButton);
        this._buttonPanel.add(this._okButton);
        this._okPanel.add((Component)this._buttonPanel, "East");
        this._stackTraceScroll = new BorderlessScrollPane(this._stackTrace, 22, 32);
        JPanel cp = new JPanel(new BorderLayout(5, 5));
        cp.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(cp);
        cp.add((Component)this._exceptionInfo, "North");
        cp.add((Component)this._stackTraceScroll, "Center");
        cp.add((Component)this._okPanel, "South");
        this.setVisible(true);
    }
}

