/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.model.FileMovedException;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.SingleDisplayModel;
import edu.rice.cs.drjava.ui.MainFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreviewFrame
extends JFrame {
    private SingleDisplayModel _model;
    private OpenDefinitionsDocument _document;
    private MainFrame _mainFrame;
    private Pageable _print;
    private int _pageNumber;
    private final PageChangerUpdater _pageChanger;
    private int PREVIEW_WIDTH;
    private int PREVIEW_HEIGHT;
    private int PREVIEW_PAGE_WIDTH;
    private int PREVIEW_PAGE_HEIGHT;
    private double PAGE_ZOOM = 0.7;
    private static int PAGE_BORDER = 20;
    private int TOOLBAR_HEIGHT = 35;
    private static final String ICON_PATH = "/edu/rice/cs/drjava/ui/icons/";
    private JToolBar _toolBar;
    private PagePreview _pagePreview;
    private final ActionListener _printListener = new ActionListener(){

        public void actionPerformed(ActionEvent ae) {
            PreviewFrame.this._print();
            PreviewFrame.this._close();
        }
    };
    private Action _closeAction = new AbstractAction("Close"){

        public void actionPerformed(ActionEvent ae) {
            PreviewFrame.this._close();
        }
    };
    private Action _nextPageAction = new AbstractAction("Next Page"){

        public void actionPerformed(ActionEvent ae) {
            PreviewFrame.this._nextPage();
        }
    };
    private Action _prevPageAction = new AbstractAction("Previous Page"){

        public void actionPerformed(ActionEvent ae) {
            PreviewFrame.this._previousPage();
        }
    };
    private WindowListener _windowCloseListener = new WindowAdapter(){

        public void windowClosing(WindowEvent ev) {
            PreviewFrame.this._close();
        }
    };
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Comparable;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;
    static /* synthetic */ Class class$edu$rice$cs$drjava$ui$PreviewFrame;

    public PreviewFrame(SingleDisplayModel model, MainFrame mainFrame) throws IllegalStateException {
        super("Print Preview");
        mainFrame.hourglassOn();
        this._model = model;
        this._mainFrame = mainFrame;
        this._document = model.getActiveDocument();
        this._toolBar = new JToolBar();
        this._print = this._document.getPageable();
        this._pageChanger = this.createPageChanger();
        this._setUpActions();
        this._setUpToolBar();
        this._setUpConstants();
        this._pagePreview = new PagePreview(this.PREVIEW_PAGE_WIDTH, this.PREVIEW_PAGE_HEIGHT);
        this._pageNumber = 0;
        PagePreviewContainer ppc = new PagePreviewContainer();
        ppc.add(this._pagePreview);
        JPanel tbCont = new JPanel(new BorderLayout());
        JPanel cp = new JPanel(new BorderLayout());
        tbCont.add((Component)this._toolBar, "North");
        tbCont.add(Box.createVerticalStrut(10), "South");
        tbCont.setBorder(new EmptyBorder(0, 0, 5, 0));
        this.setContentPane(cp);
        cp.setBorder(new EmptyBorder(5, 5, 5, 5));
        cp.add((Component)tbCont, "North");
        cp.add((Component)ppc, "South");
        this.addWindowListener(this._windowCloseListener);
        this.showPage();
        this._updateActions();
        this.setSize(this.PREVIEW_WIDTH, this.PREVIEW_HEIGHT);
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    private void _print() {
        try {
            this._document.print();
        }
        catch (FileMovedException fme) {
            this._mainFrame._showFileMovedError(fme);
        }
        catch (PrinterException e) {
            this._showError(e, "Print Error", "An error occured while printing.");
        }
        catch (BadLocationException e) {
            this._showError(e, "Print Error", "An error occured while printing.");
        }
    }

    private void _close() {
        this.dispose();
        this._mainFrame.hourglassOff();
    }

    private void _nextPage() {
        ++this._pageNumber;
        this._goToPage(this._pageNumber);
    }

    private void _previousPage() {
        --this._pageNumber;
        this._goToPage(this._pageNumber);
    }

    private void _goToPage(int pi) {
        this._pageNumber = pi;
        this.showPage();
        this._updateActions();
    }

    private void _showError(Exception e, String title, String message) {
        JOptionPane.showMessageDialog(this, new StringBuffer().append(message).append("\n").append(e).toString(), title, 0);
    }

    private void _updateActions() {
        this._nextPageAction.setEnabled(this._print.getNumberOfPages() > this._pageNumber + 1);
        this._prevPageAction.setEnabled(this._pageNumber > 0);
        try {
            this._pageChanger.update(this._pageNumber + 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void _setUpConstants() {
        PageFormat first = this._print.getPageFormat(0);
        this.PREVIEW_PAGE_WIDTH = (int)(this.PAGE_ZOOM * first.getWidth());
        this.PREVIEW_PAGE_HEIGHT = (int)(this.PAGE_ZOOM * first.getHeight());
        this.PREVIEW_WIDTH = this.PREVIEW_PAGE_WIDTH + 2 * PAGE_BORDER;
        this.PREVIEW_HEIGHT = this.PREVIEW_PAGE_HEIGHT + 2 * PAGE_BORDER + this.TOOLBAR_HEIGHT;
    }

    private void _setUpActions() {
        this._closeAction.putValue("ShortDescription", "Close");
        this._nextPageAction.putValue("SmallIcon", this._getIcon("Forward16.gif"));
        this._nextPageAction.putValue("ShortDescription", "Next Page");
        this._prevPageAction.putValue("SmallIcon", this._getIcon("Back16.gif"));
        this._prevPageAction.putValue("ShortDescription", "Previous Page");
    }

    private PageChangerUpdater createPageChanger() {
        try {
            Class<?> spinnerClass = Class.forName("javax.swing.JSpinner");
            final JComponent spinner = (JComponent)spinnerClass.newInstance();
            final Method getter = spinnerClass.getMethod("getValue", new Class[0]);
            Object model = PreviewFrame.callMethod(spinner, spinnerClass, "getModel", null, null);
            Class<?> modelClass = model.getClass();
            Class[] ca = new Class[]{class$java$lang$Comparable == null ? (class$java$lang$Comparable = PreviewFrame.class$("java.lang.Comparable")) : class$java$lang$Comparable};
            Object[] aa = new Object[]{new Integer(1)};
            PreviewFrame.callMethod(model, modelClass, "setMinimum", ca, aa);
            aa[0] = new Integer(this._print.getNumberOfPages());
            PreviewFrame.callMethod(model, modelClass, "setMaximum", ca, aa);
            ca[0] = class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = PreviewFrame.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener;
            aa[0] = new ChangeListener(){

                public void stateChanged(ChangeEvent ev) {
                    int num = PreviewFrame.this._pageNumber;
                    try {
                        num = ((Number)getter.invoke((Object)spinner, new Object[0])).intValue() - 1;
                        if (num >= 0 && num < PreviewFrame.this._print.getNumberOfPages()) {
                            PreviewFrame.this._goToPage(num);
                        } else {
                            PreviewFrame.this._updateActions();
                        }
                    }
                    catch (Exception ex) {
                        PreviewFrame.this._updateActions();
                    }
                }
            };
            PreviewFrame.callMethod(spinner, spinnerClass, "addChangeListener", ca, aa);
            return new JSpinnerChanger(spinnerClass, spinner);
        }
        catch (Exception e) {
            final JTextField tf = new JTextField();
            tf.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    try {
                        int pageToGoTo = Integer.parseInt(tf.getText()) - 1;
                        if (pageToGoTo < 0 || pageToGoTo >= PreviewFrame.this._print.getNumberOfPages()) {
                            PreviewFrame.this._updateActions();
                        } else {
                            PreviewFrame.this._goToPage(pageToGoTo);
                        }
                    }
                    catch (NumberFormatException e) {
                        PreviewFrame.this._updateActions();
                    }
                }
            });
            return new JTextFieldChanger(tf);
        }
    }

    private static Object callMethod(Object rec, Class<?> c, String name, Class<?>[] ca, Object[] args) throws Exception {
        Method m = c.getMethod(name, ca);
        return m.invoke(rec, args);
    }

    private ImageIcon _getIcon(String name) {
        URL url = (class$edu$rice$cs$drjava$ui$PreviewFrame == null ? (class$edu$rice$cs$drjava$ui$PreviewFrame = PreviewFrame.class$("edu.rice.cs.drjava.ui.PreviewFrame")) : class$edu$rice$cs$drjava$ui$PreviewFrame).getResource(new StringBuffer().append(ICON_PATH).append(name).toString());
        if (url != null) {
            return new ImageIcon(url);
        }
        return null;
    }

    private void _setUpToolBar() {
        this._toolBar.setFloatable(false);
        JButton printButton = new JButton("Print...", this._getIcon("Print16.gif"));
        printButton.setToolTipText("Print this document");
        printButton.addActionListener(this._printListener);
        this._toolBar.add(printButton);
        this._toolBar.addSeparator();
        this._toolBar.add(this._closeAction);
        this._toolBar.add(Box.createHorizontalGlue());
        this._toolBar.add(this._prevPageAction);
        this._toolBar.add(this._nextPageAction);
        this._toolBar.addSeparator();
        JLabel gotop = new JLabel("Page");
        JLabel of = new JLabel(new StringBuffer().append(" of ").append(this._print.getNumberOfPages()).toString());
        this._toolBar.add(gotop);
        this._toolBar.addSeparator();
        JComponent c = this._pageChanger.getComponent();
        Dimension d = c.getPreferredSize();
        d = new Dimension(100, d.height);
        c.setMaximumSize(d);
        c.setPreferredSize(d);
        c.setMinimumSize(d);
        c.setToolTipText("Goto Page");
        this._toolBar.add(c);
        this._toolBar.add(of);
    }

    private void showPage() {
        BufferedImage img = new BufferedImage((int)this._model.getPageFormat().getWidth(), (int)this._model.getPageFormat().getHeight(), 1);
        Graphics g = img.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, (int)this._model.getPageFormat().getWidth(), (int)this._model.getPageFormat().getHeight());
        try {
            this._print.getPrintable(this._pageNumber).print(g, this._model.getPageFormat(), this._pageNumber);
            this._pagePreview.setImage(img);
        }
        catch (PrinterException printerException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static class PagePreview
    extends JPanel {
        protected int _width;
        protected int _height;
        protected Image _source;
        protected Image _image;

        public PagePreview(int width, int height) {
            this._width = width;
            this._height = height;
            this.setBorder(new MatteBorder(1, 1, 2, 2, Color.black));
            this.setBackground(Color.white);
        }

        private void updateScaled() {
            this._image = this._source.getScaledInstance(this._width, this._height, 4);
            this._image.flush();
        }

        public void setImage(Image i) {
            this._source = i;
            this.updateScaled();
            this.repaint();
        }

        public Dimension getPreferredSize() {
            return new Dimension(this._width, this._height);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void paint(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this._width, this._height);
            g.drawImage(this._image, 0, 0, this);
            this.paintBorder(g);
        }
    }

    class PagePreviewContainer
    extends JPanel {
        PagePreviewContainer() {
        }

        public Dimension getPreferredSize() {
            return this.getParent().getSize();
        }

        public void doLayout() {
            Component cp = this.getComponent(0);
            Dimension dm = cp.getPreferredSize();
            int Hindent = (int)(this.getPreferredSize().getWidth() - dm.getWidth()) / 2;
            int Vindent = PreviewFrame.this.TOOLBAR_HEIGHT + (int)((this.getPreferredSize().getHeight() - dm.getHeight() - (double)PreviewFrame.this.TOOLBAR_HEIGHT) / 2.0);
            PreviewFrame.this._pagePreview.setBounds(Hindent, Vindent, (int)dm.getWidth(), (int)dm.getHeight());
        }
    }

    private class JSpinnerChanger
    extends PageChangerUpdater {
        private final JComponent spinner;
        private final Method setValueMethod;
        private final Object[] args;

        private JSpinnerChanger(Class spinnerClass, JComponent spinnerObj) throws Exception {
            this.args = new Object[1];
            this.spinner = spinnerObj;
            this.setValueMethod = spinnerClass.getMethod("setValue", class$java$lang$Object == null ? (class$java$lang$Object = PreviewFrame.class$("java.lang.Object")) : class$java$lang$Object);
        }

        void update(int pageNumber) throws Exception {
            this.args[0] = new Integer(pageNumber);
            this.setValueMethod.invoke((Object)this.spinner, this.args);
        }

        JComponent getComponent() {
            return this.spinner;
        }
    }

    private class JTextFieldChanger
    extends PageChangerUpdater {
        private final JTextField textfield;

        private JTextFieldChanger(JTextField tf) {
            this.textfield = tf;
        }

        void update(int pageNumber) throws Exception {
            this.textfield.setText(String.valueOf(pageNumber));
        }

        JComponent getComponent() {
            return this.textfield;
        }
    }

    private static abstract class PageChangerUpdater {
        private PageChangerUpdater() {
        }

        abstract void update(int var1) throws Exception;

        abstract JComponent getComponent();
    }
}

