/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.KeyStrokeOption;
import edu.rice.cs.drjava.config.Option;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.ui.MainFrame;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyBindingManager {
    public static final KeyBindingManager Singleton = new KeyBindingManager();
    private Hashtable<KeyStroke, KeyStrokeData> _keyToDataMap = new Hashtable();
    private Hashtable<Action, KeyStrokeData> _actionToDataMap = new Hashtable();
    private MainFrame _mainFrame = null;
    private ActionMap _actionMap;
    private boolean _shouldCheckConflict = true;

    private KeyBindingManager() {
    }

    public void setMainFrame(MainFrame mainFrame) {
        this._mainFrame = mainFrame;
    }

    public void setActionMap(ActionMap actionMap) {
        this._actionMap = actionMap;
    }

    public void setShouldCheckConflict(boolean bool) {
        this._shouldCheckConflict = bool;
    }

    public Enumeration getKeyStrokeData() {
        return this._actionToDataMap.elements();
    }

    public void put(Option<KeyStroke> kso, Action a, JMenuItem jmi, String name) {
        KeyStroke ks = DrJava.getConfig().getSetting(kso);
        KeyStrokeData ksd = new KeyStrokeData(ks, a, jmi, name, kso);
        this._keyToDataMap.put(ks, ksd);
        this._actionToDataMap.put(a, ksd);
        if (kso != null) {
            DrJava.getConfig().addOptionListener(kso, new KeyStrokeOptionListener(jmi, a, ks));
        }
    }

    public Action get(KeyStroke ks) {
        KeyStrokeData ksd = this._keyToDataMap.get(ks);
        if (ksd == null) {
            return null;
        }
        return ksd.getAction();
    }

    public String getName(KeyStroke ks) {
        KeyStrokeData ksd = this._keyToDataMap.get(ks);
        if (ksd == null) {
            return null;
        }
        return ksd.getName();
    }

    public String getName(Action a) {
        KeyStrokeData ksd = this._actionToDataMap.get(a);
        if (ksd == null) {
            return null;
        }
        return ksd.getName();
    }

    public void addShiftAction(Option<KeyStroke> opt, String shiftS) {
        Action shiftA = this._actionMap.get(shiftS);
        this.addShiftAction(opt, shiftA);
    }

    public void addShiftAction(Option<KeyStroke> opt, Action shiftA) {
        KeyStroke ks = DrJava.getConfig().getSetting(opt);
        KeyStrokeData normal = this._keyToDataMap.get(ks);
        normal.setShiftAction(shiftA);
        KeyStrokeData ksd = new KeyStrokeData(this.addShiftModifier(ks), shiftA, null, new StringBuffer().append("Selection ").append(normal.getName()).toString(), null);
        this._keyToDataMap.put(this.addShiftModifier(ks), ksd);
        this._actionToDataMap.put(shiftA, ksd);
    }

    public KeyStroke addShiftModifier(KeyStroke k) {
        return KeyStroke.getKeyStroke(k.getKeyCode(), k.getModifiers() | 1, k.isOnKeyRelease());
    }

    private boolean shouldUpdate(KeyStroke ks, Action a) {
        if (ks == KeyStrokeOption.NULL_KEYSTROKE) {
            return true;
        }
        if (!this._keyToDataMap.containsKey(ks)) {
            return true;
        }
        if (this._keyToDataMap.get(ks).getAction().equals(a)) {
            return false;
        }
        if (this._shouldCheckConflict) {
            KeyStrokeOption opt = new KeyStrokeOption(null, null);
            KeyStrokeData conflictKSD = this._keyToDataMap.get(ks);
            String key = opt.format(ks);
            KeyStrokeData newKSD = this._actionToDataMap.get(a);
            String text = new StringBuffer().append("\"").append(key).append("\"").append(" is already assigned to \"").append(conflictKSD.getName()).append("\".\nWould you like to assign \"").append(key).append("\" to \"").append(newKSD.getName()).append("\"?").toString();
            int rc = JOptionPane.showConfirmDialog(this._mainFrame, text, "DrJava", 1);
            switch (rc) {
                case 0: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case -1: {
                    return false;
                }
                case 2: {
                    return false;
                }
            }
            throw new RuntimeException(new StringBuffer().append("Invalid rc: ").append(rc).toString());
        }
        return true;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeyStrokeData {
        private KeyStroke _ks;
        private Action _a;
        private JMenuItem _jmi;
        private String _name;
        private Option<KeyStroke> _kso;
        private Action _shiftA;

        public KeyStrokeData(KeyStroke ks, Action a, JMenuItem jmi, String name, Option<KeyStroke> kso) {
            this._ks = ks;
            this._a = a;
            this._jmi = jmi;
            this._name = name;
            this._kso = kso;
            this._shiftA = null;
        }

        public KeyStroke getKeyStroke() {
            return this._ks;
        }

        public Action getAction() {
            return this._a;
        }

        public JMenuItem getJMenuItem() {
            return this._jmi;
        }

        public String getName() {
            return this._name;
        }

        public Option<KeyStroke> getOption() {
            return this._kso;
        }

        public Action getShiftAction() {
            return this._shiftA;
        }

        public void setKeyStroke(KeyStroke ks) {
            this._ks = ks;
        }

        public void setAction(Action a) {
            this._a = a;
        }

        public void setJMenuItem(JMenuItem jmi) {
            this._jmi = jmi;
        }

        public void setName(String name) {
            this._name = name;
        }

        public void setOption(Option<KeyStroke> kso) {
            this._kso = kso;
        }

        public void setShiftAction(Action shiftA) {
            this._shiftA = shiftA;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class KeyStrokeOptionListener
    implements OptionListener<KeyStroke> {
        protected JMenuItem _jmi;
        protected Action _a;
        protected KeyStroke _ks;

        public KeyStrokeOptionListener(JMenuItem jmi, Action a, KeyStroke ks) {
            this._jmi = jmi;
            this._a = a;
            this._ks = ks;
        }

        public KeyStrokeOptionListener(Action a, KeyStroke ks) {
            this._jmi = null;
            this._a = a;
            this._ks = ks;
        }

        private void _updateMenuItem(KeyStrokeData data) {
            JMenuItem jmi = data.getJMenuItem();
            if (jmi != null) {
                KeyStroke ks = data.getKeyStroke();
                if (ks != KeyStrokeOption.NULL_KEYSTROKE) {
                    jmi.setAccelerator(ks);
                } else {
                    jmi.setAccelerator(null);
                }
            }
        }

        @Override
        public void optionChanged(OptionEvent<KeyStroke> oce) {
            if (KeyBindingManager.this.shouldUpdate((KeyStroke)oce.value, this._a)) {
                KeyStrokeData data = (KeyStrokeData)KeyBindingManager.this._actionToDataMap.get(this._a);
                if (data == null) {
                    return;
                }
                if (data.equals(KeyBindingManager.this._keyToDataMap.get(this._ks))) {
                    KeyBindingManager.this._keyToDataMap.remove(this._ks);
                }
                if (KeyBindingManager.this._keyToDataMap.containsKey(oce.value) && KeyBindingManager.this._shouldCheckConflict) {
                    KeyStrokeData conflictKSD = (KeyStrokeData)KeyBindingManager.this._keyToDataMap.get(oce.value);
                    conflictKSD.setKeyStroke(KeyStrokeOption.NULL_KEYSTROKE);
                    this._updateMenuItem(conflictKSD);
                    KeyBindingManager.this._keyToDataMap.remove(oce.value);
                    DrJava.getConfig().setSetting(conflictKSD.getOption(), KeyStrokeOption.NULL_KEYSTROKE);
                }
                if (oce.value != KeyStrokeOption.NULL_KEYSTROKE) {
                    KeyBindingManager.this._keyToDataMap.put(oce.value, data);
                }
                data.setKeyStroke((KeyStroke)oce.value);
                this._updateMenuItem(data);
                Action shiftAction = data.getShiftAction();
                if (shiftAction != null) {
                    KeyStrokeData shiftKSD = (KeyStrokeData)KeyBindingManager.this._actionToDataMap.get(shiftAction);
                    KeyBindingManager.this._keyToDataMap.remove(shiftKSD.getKeyStroke());
                    shiftKSD.setKeyStroke(KeyBindingManager.this.addShiftModifier((KeyStroke)oce.value));
                    KeyBindingManager.this._keyToDataMap.put(shiftKSD.getKeyStroke(), shiftKSD);
                }
                this._ks = (KeyStroke)oce.value;
            } else if (this._ks != oce.value) {
                DrJava.getConfig().setSetting(oce.option, this._ks);
            }
        }
    }
}

