/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.SingleDisplayModel;
import edu.rice.cs.drjava.model.compiler.CompilerError;
import edu.rice.cs.drjava.model.compiler.CompilerErrorModel;
import edu.rice.cs.drjava.model.junit.JUnitError;
import edu.rice.cs.drjava.model.junit.JUnitErrorModel;
import edu.rice.cs.drjava.ui.ErrorPanel;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.RightClickMouseAdapter;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.BorderlessScrollPane;
import edu.rice.cs.util.text.SwingDocument;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicProgressBarUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitPanel
extends ErrorPanel {
    private static final String START_JUNIT_MSG = "Testing in progress.  Please wait...\n";
    private static final String JUNIT_FINISHED_MSG = "All tests completed successfully.\n";
    private static final String NO_TESTS_MSG = "";
    private static final SimpleAttributeSet OUT_OF_SYNC_ATTRIBUTES = JUnitPanel._getOutOfSyncAttributes();
    private static final SimpleAttributeSet TEST_PASS_ATTRIBUTES = JUnitPanel._getTestPassAttributes();
    private static final SimpleAttributeSet TEST_FAIL_ATTRIBUTES = JUnitPanel._getTestFailAttributes();
    private static final String TEST_OUT_OF_SYNC = "The document(s) being tested have been modified and should be recompiled!\n";
    protected JUnitErrorListPane _errorListPane;
    private int _testCount = 0;
    private boolean _testsSuccessful = true;
    private JUnitProgressBar _progressBar;
    private List<OpenDefinitionsDocument> _odds = new ArrayList<OpenDefinitionsDocument>();
    private Action _showStackTraceAction = new AbstractAction("Show Stack Trace"){

        public void actionPerformed(ActionEvent ae) {
            if (JUnitPanel.this._error != null) {
                JUnitPanel.this._displayStackTrace(JUnitPanel.this._error);
            }
        }
    };
    private JButton _showStackTraceButton;
    private JUnitError _error = null;
    private Window _stackFrame = null;
    private JTextArea _stackTextArea;
    private final JLabel _errorLabel = new JLabel();
    private final JLabel _testLabel = new JLabel();
    private final JLabel _fileLabel = new JLabel();

    private static final SimpleAttributeSet _getOutOfSyncAttributes() {
        SimpleAttributeSet s = new SimpleAttributeSet();
        s.addAttribute(StyleConstants.Foreground, Color.red.darker());
        s.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        return s;
    }

    private static final SimpleAttributeSet _getTestPassAttributes() {
        SimpleAttributeSet s = new SimpleAttributeSet();
        s.addAttribute(StyleConstants.Foreground, Color.green.darker());
        return s;
    }

    private static final SimpleAttributeSet _getTestFailAttributes() {
        SimpleAttributeSet s = new SimpleAttributeSet();
        s.addAttribute(StyleConstants.Foreground, Color.red);
        return s;
    }

    public JUnitPanel(SingleDisplayModel model, MainFrame frame) {
        super(model, frame, "Test Output", "Test Progress");
        this._progressBar = new JUnitProgressBar();
        this._progressBar.setUI(new BasicProgressBarUI());
        this._showStackTraceButton = new JButton(this._showStackTraceAction);
        this.customPanel.add((Component)this._progressBar, "North");
        this.customPanel.add((Component)this._showStackTraceButton, "South");
        this._errorListPane = new JUnitErrorListPane();
        this.setErrorListPane(this._errorListPane);
    }

    @Override
    public JUnitErrorListPane getErrorListPane() {
        return this._errorListPane;
    }

    @Override
    protected JUnitErrorModel getErrorModel() {
        return this.getModel().getJUnitModel().getJUnitErrorModel();
    }

    @Override
    protected void _updateStyles(AttributeSet newSet) {
        super._updateStyles(newSet);
        OUT_OF_SYNC_ATTRIBUTES.addAttributes(newSet);
        StyleConstants.setBold(OUT_OF_SYNC_ATTRIBUTES, true);
        TEST_PASS_ATTRIBUTES.addAttributes(newSet);
        TEST_FAIL_ATTRIBUTES.addAttributes(newSet);
    }

    public void setJUnitInProgress(List<OpenDefinitionsDocument> odds) {
        this._odds = odds;
        this.setJUnitInProgress();
    }

    public void setJUnitInProgress() {
        this._errorListPane.setJUnitInProgress();
    }

    @Override
    protected void _close() {
        super._close();
        this.getModel().getJUnitModel().resetJUnitErrors();
        this.reset();
    }

    public void reset() {
        JUnitErrorModel juem = this.getModel().getJUnitModel().getJUnitErrorModel();
        boolean testsHaveRun = false;
        if (juem != null) {
            this._numErrors = juem.getNumErrors();
            testsHaveRun = juem.haveTestsRun();
        } else {
            this._numErrors = 0;
        }
        this._errorListPane.updateListPane(testsHaveRun);
    }

    public void progressReset(int numTests) {
        this._progressBar.reset();
        this._progressBar.start(numTests);
        this._testsSuccessful = true;
        this._testCount = 0;
    }

    public void progressStep(boolean successful) {
        ++this._testCount;
        this._testsSuccessful &= successful;
        this._progressBar.step(this._testCount, this._testsSuccessful);
    }

    public void testStarted(String className, String testName) {
    }

    private void _displayStackTrace(JUnitError e) {
        this._errorLabel.setText(new StringBuffer().append(e.isWarning() ? "Error: " : "Failure: ").append(e.message()).toString());
        this._fileLabel.setText(new StringBuffer().append("File: ").append(new File(e.fileName()).getName()).toString());
        if (!e.testName().equals(NO_TESTS_MSG)) {
            this._testLabel.setText(new StringBuffer().append("Test: ").append(e.testName()).toString());
        } else {
            this._testLabel.setText(NO_TESTS_MSG);
        }
        this._stackTextArea.setText(e.stackTrace());
        this._stackTextArea.setCaretPosition(0);
        this._stackFrame.setVisible(true);
    }

    @Override
    protected /* synthetic */ CompilerErrorModel getErrorModel() {
        return this.getErrorModel();
    }

    @Override
    public /* synthetic */ ErrorPanel.ErrorListPane getErrorListPane() {
        return this.getErrorListPane();
    }

    static class JUnitProgressBar
    extends JProgressBar {
        private boolean _hasError = false;

        public JUnitProgressBar() {
            this.setForeground(this.getStatusColor());
        }

        private Color getStatusColor() {
            if (this._hasError) {
                return Color.red;
            }
            return Color.green;
        }

        public void reset() {
            this._hasError = false;
            this.setForeground(this.getStatusColor());
            this.setValue(0);
        }

        public void start(int total) {
            this.setMaximum(total);
            this.reset();
        }

        public void step(int value, boolean successful) {
            this.setValue(value);
            if (!this._hasError && !successful) {
                this._hasError = true;
                this.setForeground(this.getStatusColor());
            }
        }
    }

    public class JUnitErrorListPane
    extends ErrorPanel.ErrorListPane {
        private JPopupMenu _popMenu;
        private String _runningTestName;
        private boolean _warnedOutOfSync;
        private static final String JUNIT_WARNING = "junit.framework.TestSuite$1.warning";
        private final HashMap<String, Position> _runningTestNamePositions;

        public JUnitErrorListPane() {
            this.removeMouseListener(this.defaultMouseListener);
            this._popMenu = new JPopupMenu();
            this._popMenu.add(JUnitPanel.this._showStackTraceAction);
            JUnitPanel.this._error = null;
            this._setupStackTraceFrame();
            this.addMouseListener(new PopupAdapter());
            this._runningTestName = null;
            this._runningTestNamePositions = new HashMap();
            JUnitPanel.this._showStackTraceButton.setEnabled(false);
        }

        private String _getTestFromName(String name) {
            int paren = name.indexOf(40);
            if (paren > -1 && paren < name.length()) {
                return name.substring(0, paren);
            }
            throw new IllegalArgumentException("Name does not contain any parens: " + name);
        }

        private String _getClassFromName(String name) {
            int paren = name.indexOf(40);
            if (paren > -1 && paren < name.length()) {
                return name.substring(paren + 1, name.length() - 1);
            }
            throw new IllegalArgumentException("Name does not contain any parens: " + name);
        }

        public void testStarted(String name) {
            String testName = this._getTestFromName(name);
            String className = this._getClassFromName(name);
            String fullName = className + "." + testName;
            if (fullName.equals(JUNIT_WARNING)) {
                return;
            }
            Document doc = this.getDocument();
            int index = doc.getLength();
            try {
                if (!className.equals(this._runningTestName)) {
                    this._runningTestName = className;
                    doc.insertString(index, "  " + className + "\n", ErrorPanel.NORMAL_ATTRIBUTES);
                    index = doc.getLength();
                }
                doc.insertString(index, "    ", ErrorPanel.NORMAL_ATTRIBUTES);
                index = doc.getLength();
                doc.insertString(index, testName + "\n", ErrorPanel.NORMAL_ATTRIBUTES);
                Position pos = doc.createPosition(index);
                this._runningTestNamePositions.put(fullName, pos);
                this.setCaretPosition(index);
            }
            catch (BadLocationException ble) {
                throw new UnexpectedException(ble);
            }
        }

        public void testEnded(String name, boolean wasSuccessful, boolean causedError) {
            String testName = this._getTestFromName(name);
            String fullName = this._getClassFromName(name) + "." + testName;
            if (fullName.equals(JUNIT_WARNING)) {
                return;
            }
            Document doc = this.getDocument();
            Position namePos = this._runningTestNamePositions.get(fullName);
            SimpleAttributeSet set = !wasSuccessful || causedError ? TEST_FAIL_ATTRIBUTES : TEST_PASS_ATTRIBUTES;
            if (namePos != null) {
                int index = namePos.getOffset();
                int length = testName.length();
                if (doc instanceof SwingDocument) {
                    ((SwingDocument)doc).setCharacterAttributes(index, length, set, false);
                }
            }
        }

        public void setJUnitInProgress() {
            this._errorListPositions = new Position[0];
            JUnitPanel.this.progressReset(0);
            this._runningTestNamePositions.clear();
            this._runningTestName = null;
            this._warnedOutOfSync = false;
            SwingDocument doc = new SwingDocument();
            this._checkSync(doc);
            doc.append(JUnitPanel.START_JUNIT_MSG, ErrorPanel.BOLD_ATTRIBUTES);
            this.setDocument(doc);
            this.selectNothing();
        }

        protected void _updateWithErrors() throws BadLocationException {
            SwingDocument doc = (SwingDocument)this.getDocument();
            this._checkSync(doc);
            this._updateWithErrors("test", "failed", doc);
        }

        protected void _updateWithErrors(String failureName, String failureMeaning, SwingDocument doc) throws BadLocationException {
            this._replaceInProgressText(this._getNumErrorsMessage(failureName, failureMeaning));
            this._insertErrors(doc);
            this.switchToError(0);
        }

        private void _replaceInProgressText(String msg) throws BadLocationException {
            int start = 0;
            if (this._warnedOutOfSync) {
                start = JUnitPanel.TEST_OUT_OF_SYNC.length();
            }
            int len = JUnitPanel.START_JUNIT_MSG.length();
            Document doc = this.getDocument();
            if (doc.getLength() >= len + start) {
                doc.remove(start, len);
                doc.insertString(start, msg, ErrorPanel.BOLD_ATTRIBUTES);
            }
        }

        protected String _getWarningText() {
            return "Error: ";
        }

        protected String _getErrorText() {
            return "Failure: ";
        }

        protected void _updateNoErrors(boolean haveTestsRun) throws BadLocationException {
            this._checkSync(this.getDocument());
            this._replaceInProgressText(haveTestsRun ? JUnitPanel.JUNIT_FINISHED_MSG : JUnitPanel.NO_TESTS_MSG);
            this.selectNothing();
            this.setCaretPosition(0);
        }

        private void _checkSync(Document doc) {
            if (this._warnedOutOfSync) {
                return;
            }
            List odds = JUnitPanel.this._odds;
            Iterator i$ = odds.iterator();
            while (i$.hasNext()) {
                OpenDefinitionsDocument odoc = (OpenDefinitionsDocument)i$.next();
                if (odoc.checkIfClassFileInSync()) continue;
                try {
                    doc.insertString(0, JUnitPanel.TEST_OUT_OF_SYNC, OUT_OF_SYNC_ATTRIBUTES);
                    this._warnedOutOfSync = true;
                    return;
                }
                catch (BadLocationException ble) {
                    throw new UnexpectedException(ble);
                }
            }
        }

        private void _setupStackTraceFrame() {
            JDialog _dialog = new JDialog(JUnitPanel.this._frame, "JUnit Error Stack Trace", false);
            JUnitPanel.this._stackFrame = _dialog;
            JUnitPanel.this._stackTextArea = new JTextArea();
            JUnitPanel.this._stackTextArea.setEditable(false);
            JUnitPanel.this._stackTextArea.setLineWrap(false);
            BorderlessScrollPane scroll = new BorderlessScrollPane(JUnitPanel.this._stackTextArea, 20, 30);
            ActionListener closeListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JUnitPanel.this._stackFrame.setVisible(false);
                }
            };
            JButton closeButton = new JButton("Close");
            closeButton.addActionListener(closeListener);
            JPanel closePanel = new JPanel(new BorderLayout());
            closePanel.setBorder(new EmptyBorder(5, 5, 0, 0));
            closePanel.add((Component)closeButton, "East");
            JPanel cp = new JPanel(new BorderLayout());
            _dialog.setContentPane(cp);
            cp.setBorder(new EmptyBorder(5, 5, 5, 5));
            cp.add((Component)scroll, "Center");
            cp.add((Component)closePanel, "South");
            JPanel topPanel = new JPanel(new GridLayout(0, 1, 0, 5));
            topPanel.setBorder(new EmptyBorder(0, 0, 5, 0));
            topPanel.add(JUnitPanel.this._fileLabel);
            topPanel.add(JUnitPanel.this._testLabel);
            topPanel.add(JUnitPanel.this._errorLabel);
            cp.add((Component)topPanel, "North");
            _dialog.setSize(600, 500);
            _dialog.setLocationRelativeTo(JUnitPanel.this._frame);
        }

        public void selectItem(CompilerError error) {
            super.selectItem(error);
            JUnitPanel.this._error = (JUnitError)error;
            JUnitPanel.this._showStackTraceButton.setEnabled(true);
        }

        protected void _removeListHighlight() {
            super._removeListHighlight();
            JUnitPanel.this._showStackTraceButton.setEnabled(false);
        }

        private class PopupAdapter
        extends RightClickMouseAdapter {
            private PopupAdapter() {
            }

            public void mousePressed(MouseEvent e) {
                if (this._selectError(e)) {
                    super.mousePressed(e);
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (this._selectError(e)) {
                    super.mouseReleased(e);
                }
            }

            private boolean _selectError(MouseEvent e) {
                JUnitPanel.this._error = (JUnitError)JUnitErrorListPane.this._errorAtPoint(e.getPoint());
                if (JUnitErrorListPane.this._isEmptySelection() && JUnitPanel.this._error != null) {
                    ((JUnitErrorListPane)JUnitErrorListPane.this).JUnitPanel.this._errorListPane.switchToError(JUnitPanel.this._error);
                    return true;
                }
                JUnitErrorListPane.this.selectNothing();
                return false;
            }

            protected void _popupAction(MouseEvent e) {
                JUnitErrorListPane.this._popMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

