/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.BorderlessScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;

public class HTMLFrame
extends JFrame {
    private static final int FRAME_WIDTH = 750;
    private static final int FRAME_HEIGHT = 600;
    private static final int LEFT_PANEL_WIDTH = 250;
    private JEditorPane _mainDocPane;
    private JScrollPane _mainScroll;
    private JSplitPane _splitPane;
    private JPanel _splitPaneHolder;
    private JEditorPane _contentsDocPane;
    private JPanel _closePanel;
    private JButton _closeButton;
    private JButton _backButton;
    private JButton _forwardButton;
    protected URL _baseURL;
    private Vector<HyperlinkListener> _hyperlinkListeners;
    private boolean _linkError;
    private URL _lastURL;
    private JPanel _navPane;
    protected HistoryList _history;
    private HyperlinkListener _resetListener = new HyperlinkListener(){

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (HTMLFrame.this._linkError && e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                HTMLFrame.this._resetMainPane();
            }
        }
    };
    private Action _forwardAction = new ConsolidatedAction("Forward"){

        public void actionPerformed(ActionEvent e) {
            HTMLFrame.this._history = HTMLFrame.this._history.next;
            HTMLFrame.this._backAction.setEnabled(true);
            if (HTMLFrame.this._history.next == null) {
                HTMLFrame.this._forwardAction.setEnabled(false);
            }
            HTMLFrame.this._displayPage(HTMLFrame.this._history.contents);
        }
    };
    private Action _backAction = new ConsolidatedAction("Back"){

        public void actionPerformed(ActionEvent e) {
            HTMLFrame.this._history = HTMLFrame.this._history.prev;
            HTMLFrame.this._forwardAction.setEnabled(true);
            if (HTMLFrame.this._history.prev == null) {
                HTMLFrame.this._backAction.setEnabled(false);
            }
            HTMLFrame.this._displayPage(HTMLFrame.this._history.contents);
        }
    };
    private Action _closeAction = new AbstractAction("Close"){

        public void actionPerformed(ActionEvent e) {
            HTMLFrame.this.setVisible(false);
        }
    };

    private static JButton makeButton(Action a, int horTextPos, int left, int right) {
        JButton j = new JButton(a);
        j.setHorizontalTextPosition(horTextPos);
        j.setVerticalTextPosition(0);
        j.setMargin(new Insets(3, left + 3, 3, right + 3));
        return j;
    }

    public void addHyperlinkListener(HyperlinkListener linkListener) {
        this._hyperlinkListeners.add(linkListener);
        this._contentsDocPane.addHyperlinkListener(linkListener);
        this._mainDocPane.addHyperlinkListener(linkListener);
    }

    public HTMLFrame(String frameName, URL introUrl, URL indexUrl, String iconString) {
        this(frameName, introUrl, indexUrl, iconString, null);
    }

    public HTMLFrame(String frameName, URL introUrl, URL indexUrl, String iconString, File baseDir) {
        super(frameName);
        this._contentsDocPane = new JEditorPane();
        this._contentsDocPane.setEditable(false);
        BorderlessScrollPane contentsScroll = new BorderlessScrollPane(this._contentsDocPane);
        this._mainDocPane = new JEditorPane();
        this._mainDocPane.setEditable(false);
        this._mainScroll = new BorderlessScrollPane(this._mainDocPane);
        this._splitPane = new JSplitPane(1, true, contentsScroll, this._mainScroll);
        this._splitPane.setDividerLocation(250);
        this._splitPaneHolder = new JPanel(new GridLayout(1, 1));
        this._splitPaneHolder.setBorder(new EmptyBorder(0, 5, 0, 5));
        this._splitPaneHolder.add(this._splitPane);
        this._closeButton = new JButton(this._closeAction);
        this._backButton = HTMLFrame.makeButton(this._backAction, 4, 0, 3);
        this._forwardButton = HTMLFrame.makeButton(this._forwardAction, 2, 3, 0);
        this._backAction.setEnabled(false);
        this._forwardAction.setEnabled(false);
        this._closePanel = new JPanel(new BorderLayout());
        this._closePanel.add((Component)this._closeButton, "East");
        this._closePanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this._navPane = new JPanel();
        this._navPane.setBackground(new Color(0xCCCCFF));
        this._navPane.setLayout(new BoxLayout(this._navPane, 0));
        JLabel icon = new JLabel(MainFrame.getIcon(iconString));
        this._navPane.add(icon);
        this._navPane.add(Box.createHorizontalStrut(8));
        this._navPane.add(Box.createHorizontalGlue());
        this._navPane.add(this._backButton);
        this._navPane.add(Box.createHorizontalStrut(8));
        this._navPane.add(this._forwardButton);
        this._navPane.add(Box.createHorizontalStrut(3));
        this._navPane.setBorder(new EmptyBorder(0, 0, 0, 5));
        JPanel navContainer = new JPanel(new GridLayout(1, 1));
        navContainer.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new EtchedBorder()));
        navContainer.add(this._navPane);
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        cp.add((Component)navContainer, "North");
        cp.add((Component)this._splitPaneHolder, "Center");
        cp.add((Component)this._closePanel, "South");
        this._linkError = false;
        this._hyperlinkListeners = new Vector();
        this._hyperlinkListeners.add(this._resetListener);
        this._mainDocPane.addHyperlinkListener(this._resetListener);
        if (baseDir != null) {
            try {
                this._baseURL = baseDir.toURL();
            }
            catch (MalformedURLException ex) {
                throw new UnexpectedException(ex);
            }
        } else {
            this._baseURL = null;
        }
        if (indexUrl != null) {
            try {
                this._contentsDocPane.setPage(indexUrl);
                if (this._baseURL != null) {
                    ((HTMLDocument)this._contentsDocPane.getDocument()).setBase(this._baseURL);
                }
            }
            catch (IOException ioe) {
                this._displayContentsError(indexUrl, ioe);
            }
        } else {
            this._displayContentsError(indexUrl);
        }
        if (introUrl != null) {
            this._history = new HistoryList(introUrl);
            this._displayPage(introUrl);
            this._displayPage(introUrl);
        } else {
            this._displayMainError(introUrl);
        }
        this.setSize(750, 600);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setSize(frameSize);
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    protected void _hideNavigationPane() {
        this._splitPaneHolder.remove(this._splitPane);
        this._splitPaneHolder.add(this._mainScroll);
    }

    private void _resetMainPane() {
        this._linkError = false;
        this._mainDocPane = new JEditorPane();
        this._mainDocPane.setEditable(false);
        for (int i = 0; i < this._hyperlinkListeners.size(); ++i) {
            this._mainDocPane.addHyperlinkListener(this._hyperlinkListeners.get(i));
        }
        this._displayPage(this._lastURL);
        this._splitPane.setRightComponent(new BorderlessScrollPane(this._mainDocPane));
        this._splitPane.setDividerLocation(250);
    }

    private void _displayPage(URL url) {
        try {
            this._mainDocPane.setPage(url);
            if (this._baseURL != null) {
                ((HTMLDocument)this._contentsDocPane.getDocument()).setBase(this._baseURL);
            }
            this._lastURL = url;
        }
        catch (IOException ioe) {
            String path = url.getPath();
            try {
                URL newURL = new URL(this._baseURL + path);
                this._mainDocPane.setPage(newURL);
                if (this._baseURL != null) {
                    ((HTMLDocument)this._contentsDocPane.getDocument()).setBase(this._baseURL);
                }
                this._lastURL = newURL;
            }
            catch (IOException ioe2) {
                this._displayMainError(url, ioe2);
            }
        }
    }

    private void _displayMainError(URL url) {
        if (!this._linkError) {
            this._linkError = true;
            this._mainDocPane.setText(this.getErrorText(url));
        } else {
            this._resetMainPane();
        }
    }

    private void _displayMainError(URL url, Exception ex) {
        if (!this._linkError) {
            this._linkError = true;
            this._mainDocPane.setText(this.getErrorText(url) + "\n" + ex);
        } else {
            this._resetMainPane();
        }
    }

    private void _displayContentsError(URL url) {
        this._contentsDocPane.setText(this.getErrorText(url));
    }

    private void _displayContentsError(URL url, Exception ex) {
        this._contentsDocPane.setText(this.getErrorText(url) + "\n" + ex);
    }

    protected String getErrorText(URL url) {
        return "Could not load the specified URL: " + url;
    }

    public void jumpTo(URL url) {
        this._history = new HistoryList(url, this._history);
        this._backAction.setEnabled(true);
        this._forwardAction.setEnabled(false);
        this._displayPage(url);
    }

    private static abstract class ConsolidatedAction
    extends ResourceAction {
        private ConsolidatedAction(String name) {
            super(name, name + "16.gif");
        }
    }

    public static abstract class ResourceAction
    extends AbstractAction {
        public ResourceAction(String name, String iconName) {
            super(name, MainFrame.getIcon(iconName));
        }
    }

    protected static class HistoryList {
        private HistoryList next = null;
        private final HistoryList prev;
        protected final URL contents;

        private HistoryList(URL contents) {
            this.contents = contents;
            this.prev = null;
        }

        private HistoryList(URL contents, HistoryList prev) {
            this.contents = contents;
            this.prev = prev;
            prev.next = this;
        }
    }
}

