/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.FindReplaceMachine;
import edu.rice.cs.drjava.model.FindResult;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.SingleDisplayModel;
import edu.rice.cs.drjava.ui.BackgroundColorListener;
import edu.rice.cs.drjava.ui.DefinitionsPane;
import edu.rice.cs.drjava.ui.ForegroundColorListener;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.TabbedPanel;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.BorderlessScrollPane;
import edu.rice.cs.util.swing.Utilities;
import edu.rice.cs.util.text.AbstractDocumentInterface;
import edu.rice.cs.util.text.SwingDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;

class FindReplaceDialog
extends TabbedPanel
implements OptionConstants {
    private JButton _findNextButton;
    private JButton _findPreviousButton;
    private JButton _replaceButton;
    private JButton _replaceFindNextButton;
    private JButton _replaceFindPreviousButton;
    private JButton _replaceAllButton;
    private JLabel _findLabelTop;
    private JLabel _findLabelBot;
    private JLabel _replaceLabelTop;
    private JLabel _replaceLabelBot;
    private JTextPane _findField = new JTextPane(new DefaultStyledDocument());
    private BorderlessScrollPane _findPane = new BorderlessScrollPane(this._findField);
    private JTextPane _replaceField = new JTextPane(new SwingDocument());
    private BorderlessScrollPane _replacePane = new BorderlessScrollPane(this._replaceField);
    private JLabel _message;
    private JPanel _labelPanel;
    private JCheckBox _ignoreCommentsAndStrings;
    private JCheckBox _matchCase;
    private JCheckBox _searchAllDocuments;
    private JPanel _lowerCheckPanel;
    private JCheckBox _matchWholeWord;
    private JPanel _matchCaseAndAllDocsPanel;
    private JPanel _rightPanel;
    private FindReplaceMachine _machine;
    private SingleDisplayModel _model;
    private DefinitionsPane _defPane = null;
    private boolean _caretChanged;
    private CaretListener _caretListener = new CaretListener(){

        public void caretUpdate(CaretEvent e) {
            Utilities.invokeAndWait(new Runnable(){

                public void run() {
                    FindReplaceDialog.this._replaceAction.setEnabled(false);
                    FindReplaceDialog.this._replaceFindNextAction.setEnabled(false);
                    FindReplaceDialog.this._replaceFindPreviousAction.setEnabled(false);
                    FindReplaceDialog.this._machine.positionChanged();
                    FindReplaceDialog.this._caretChanged = true;
                }
            });
        }
    };
    private Action _findEnterAction = new TextAction("Find on Pressing Enter"){

        public void actionPerformed(ActionEvent ae) {
            FindReplaceDialog.this._doFind();
        }
    };
    private Action _findFieldSwitchFocusForwardAction = new TextAction("Switch Focus from Find Field"){

        public void actionPerformed(ActionEvent ae) {
            FindReplaceDialog.this._findField.getNextFocusableComponent().requestFocusInWindow();
        }
    };
    private Action _replaceFieldSwitchFocusForwardAction = new TextAction("Switch Focus from Replace Field"){

        public void actionPerformed(ActionEvent ae) {
            FindReplaceDialog.this._replaceField.getNextFocusableComponent().requestFocusInWindow();
        }
    };
    private Action _findFieldSwitchFocusBackAction = new TextAction("Switch Focus from Find Field"){

        public void actionPerformed(ActionEvent ae) {
            FindReplaceDialog.this._closeButton.requestFocusInWindow();
        }
    };
    private Action _replaceFieldSwitchFocusBackAction = new TextAction("Switch Focus from Replace Field"){

        public void actionPerformed(ActionEvent ae) {
            FindReplaceDialog.this._findField.requestFocusInWindow();
        }
    };
    private Action _findNextAction = new AbstractAction("Find Next"){

        public void actionPerformed(ActionEvent e) {
            FindReplaceDialog.this.findNext();
        }
    };
    private Action _findPreviousAction = new AbstractAction("Find Previous"){

        public void actionPerformed(ActionEvent e) {
            FindReplaceDialog.this.findPrevious();
        }
    };
    private Action _replaceAction = new AbstractAction("Replace"){

        public void actionPerformed(ActionEvent e) {
            FindReplaceDialog.this._updateMachine();
            FindReplaceDialog.this._machine.setFindWord(FindReplaceDialog.this._findField.getText());
            String replaceWord = FindReplaceDialog.this._replaceField.getText();
            FindReplaceDialog.this._machine.setReplaceWord(replaceWord);
            FindReplaceDialog.this._mainframe.clearStatusMessage();
            boolean replaced = FindReplaceDialog.this._machine.replaceCurrent();
            if (replaced) {
                FindReplaceDialog.this._selectReplacedItem(replaceWord.length());
            }
            FindReplaceDialog.this._replaceAction.setEnabled(false);
            FindReplaceDialog.this._replaceFindNextAction.setEnabled(false);
            FindReplaceDialog.this._replaceFindPreviousAction.setEnabled(false);
            FindReplaceDialog.this._replaceButton.requestFocusInWindow();
        }
    };
    private Action _replaceFindNextAction = new AbstractAction("Replace/Find Next"){

        public void actionPerformed(ActionEvent e) {
            if (FindReplaceDialog.this.getSearchBackwards()) {
                FindReplaceDialog.this._machine.positionChanged();
                FindReplaceDialog.this.findNext();
            }
            FindReplaceDialog.this._updateMachine();
            FindReplaceDialog.this._machine.setFindWord(FindReplaceDialog.this._findField.getText());
            String replaceWord = FindReplaceDialog.this._replaceField.getText();
            FindReplaceDialog.this._machine.setReplaceWord(replaceWord);
            FindReplaceDialog.this._mainframe.clearStatusMessage();
            boolean replaced = FindReplaceDialog.this._machine.replaceCurrent();
            if (replaced) {
                FindReplaceDialog.this._selectReplacedItem(replaceWord.length());
                FindReplaceDialog.this.findNext();
                FindReplaceDialog.this._replaceFindNextButton.requestFocusInWindow();
            } else {
                FindReplaceDialog.this._replaceAction.setEnabled(false);
                FindReplaceDialog.this._replaceFindNextAction.setEnabled(false);
                FindReplaceDialog.this._replaceFindPreviousAction.setEnabled(false);
                Toolkit.getDefaultToolkit().beep();
                FindReplaceDialog.this._mainframe.setStatusMessage("Replace failed.");
            }
        }
    };
    private Action _replaceFindPreviousAction = new AbstractAction("Replace/Find Previous"){

        public void actionPerformed(ActionEvent e) {
            if (!FindReplaceDialog.this.getSearchBackwards()) {
                FindReplaceDialog.this._machine.positionChanged();
                FindReplaceDialog.this.findPrevious();
            }
            FindReplaceDialog.this._updateMachine();
            FindReplaceDialog.this._machine.setFindWord(FindReplaceDialog.this._findField.getText());
            String replaceWord = FindReplaceDialog.this._replaceField.getText();
            FindReplaceDialog.this._machine.setReplaceWord(replaceWord);
            FindReplaceDialog.this._mainframe.clearStatusMessage();
            boolean replaced = FindReplaceDialog.this._machine.replaceCurrent();
            if (replaced) {
                FindReplaceDialog.this._selectReplacedItem(replaceWord.length());
                FindReplaceDialog.this.findPrevious();
                FindReplaceDialog.this._replaceFindPreviousButton.requestFocusInWindow();
            } else {
                FindReplaceDialog.this._replaceAction.setEnabled(false);
                FindReplaceDialog.this._replaceFindNextAction.setEnabled(false);
                FindReplaceDialog.this._replaceFindPreviousAction.setEnabled(false);
                Toolkit.getDefaultToolkit().beep();
                FindReplaceDialog.this._mainframe.setStatusMessage("Replace failed.");
            }
        }
    };
    private Action _replaceAllAction = new AbstractAction("Replace All"){

        public void actionPerformed(ActionEvent e) {
            FindReplaceDialog.this._updateMachine();
            FindReplaceDialog.this._machine.setFindWord(FindReplaceDialog.this._findField.getText());
            FindReplaceDialog.this._machine.setReplaceWord(FindReplaceDialog.this._replaceField.getText());
            FindReplaceDialog.this._mainframe.clearStatusMessage();
            int count = FindReplaceDialog.this._machine.replaceAll();
            Toolkit.getDefaultToolkit().beep();
            FindReplaceDialog.this._mainframe.setStatusMessage("Replaced " + count + " occurrence" + (count == 1 ? "" : "s") + ".");
            FindReplaceDialog.this._replaceAction.setEnabled(false);
            FindReplaceDialog.this._replaceFindNextAction.setEnabled(false);
            FindReplaceDialog.this._replaceFindPreviousAction.setEnabled(false);
        }
    };
    private MainFrame _mainframe;

    public FindReplaceDialog(MainFrame frame, SingleDisplayModel model) {
        super(frame, "Find/Replace");
        this._model = model;
        this._mainframe = frame;
        this._machine = new FindReplaceMachine(this._model, this._model.getDocumentIterator());
        this._updateMachine();
        int i = 1;
        InputMap fim = this._findField.getInputMap(i);
        fim.put(KeyStroke.getKeyStroke(27, 0), "Close");
        fim.put(KeyStroke.getKeyStroke(10, 0), "Find Next");
        fim.put(KeyStroke.getKeyStroke(9, 0), "Switch Focus Forward");
        fim.put(KeyStroke.getKeyStroke(9, 1), "Switch Focus Back");
        ActionMap fam = this._findField.getActionMap();
        fam.put("Find Next", this._findNextAction);
        fam.put("Close", new AbstractAction("Close"){

            public void actionPerformed(ActionEvent ae) {
                FindReplaceDialog.this._frame.getCurrentDefPane().requestFocusInWindow();
                FindReplaceDialog.this._close();
            }
        });
        fam.put("Switch Focus Forward", new AbstractAction("Switch Focus Forward"){

            public void actionPerformed(ActionEvent ae) {
                FindReplaceDialog.this._findField.getNextFocusableComponent().requestFocusInWindow();
            }
        });
        fam.put("Switch Focus Back", new AbstractAction("Switch Focus Back"){

            public void actionPerformed(ActionEvent ae) {
                FindReplaceDialog.this._closeButton.requestFocusInWindow();
            }
        });
        InputMap rim = this._replaceField.getInputMap(i);
        rim.put(KeyStroke.getKeyStroke(9, 0), "Switch Focus Forward");
        rim.put(KeyStroke.getKeyStroke(9, 1), "Switch Focus Back");
        ActionMap ram = this._replaceField.getActionMap();
        ram.put("Switch Focus", new AbstractAction("Switch Focus"){

            public void actionPerformed(ActionEvent ae) {
                FindReplaceDialog.this._replaceField.getNextFocusableComponent().requestFocusInWindow();
            }
        });
        ram.put("Switch Focus Back", new AbstractAction("Switch Focus Back"){

            public void actionPerformed(ActionEvent ae) {
                FindReplaceDialog.this._findField.requestFocusInWindow();
            }
        });
        new ForegroundColorListener(this._findField);
        new BackgroundColorListener(this._findField);
        new ForegroundColorListener(this._replaceField);
        new BackgroundColorListener(this._replaceField);
        this._findNextButton = new JButton(this._findNextAction);
        this._findPreviousButton = new JButton(this._findPreviousAction);
        this._replaceButton = new JButton(this._replaceAction);
        this._replaceFindNextButton = new JButton(this._replaceFindNextAction);
        this._replaceFindPreviousButton = new JButton(this._replaceFindPreviousAction);
        this._replaceAllButton = new JButton(this._replaceAllAction);
        this._message = new JLabel("");
        this._replaceAction.setEnabled(false);
        this._replaceFindNextAction.setEnabled(false);
        this._replaceFindPreviousAction.setEnabled(false);
        Font font = DrJava.getConfig().getSetting(FONT_MAIN);
        this.setFieldFont(font);
        this._replaceLabelTop = new JLabel("Replace", 4);
        this._replaceLabelBot = new JLabel("With", 4);
        JPanel replaceLabelPanelTop = new JPanel(new BorderLayout(5, 5));
        JPanel replaceLabelPanelBot = new JPanel(new BorderLayout(5, 5));
        JPanel replaceLabelPanel = new JPanel(new GridLayout(2, 1));
        replaceLabelPanelTop.add((Component)this._replaceLabelTop, "South");
        replaceLabelPanelBot.add((Component)this._replaceLabelBot, "North");
        replaceLabelPanel.add(replaceLabelPanelTop);
        replaceLabelPanel.add(replaceLabelPanelBot);
        this._findLabelTop = new JLabel("Find", 4);
        this._findLabelBot = new JLabel("Next", 4);
        JPanel findLabelPanelTop = new JPanel(new BorderLayout(5, 5));
        JPanel findLabelPanelBot = new JPanel(new BorderLayout(5, 5));
        JPanel findLabelPanel = new JPanel(new GridLayout(2, 1));
        findLabelPanelTop.add((Component)this._findLabelTop, "South");
        findLabelPanelBot.add((Component)this._findLabelBot, "North");
        findLabelPanel.add(findLabelPanelTop);
        findLabelPanel.add(findLabelPanelBot);
        JPanel buttons = new JPanel();
        buttons.setLayout(new GridLayout(1, 0, 5, 0));
        buttons.add(this._findNextButton);
        buttons.add(this._findPreviousButton);
        buttons.add(this._replaceFindNextButton);
        buttons.add(this._replaceFindPreviousButton);
        buttons.add(this._replaceButton);
        buttons.add(this._replaceAllButton);
        MatchCaseListener mcl = new MatchCaseListener();
        this._matchCase = new JCheckBox("Match Case", (boolean)DrJava.getConfig().getSetting(OptionConstants.FIND_MATCH_CASE));
        this._machine.setMatchCase(DrJava.getConfig().getSetting(OptionConstants.FIND_MATCH_CASE));
        this._matchCase.addItemListener(mcl);
        this._machine.setSearchBackwards(DrJava.getConfig().getSetting(OptionConstants.FIND_SEARCH_BACKWARDS));
        SearchAllDocumentsListener sadl = new SearchAllDocumentsListener();
        this._searchAllDocuments = new JCheckBox("Search All Documents", (boolean)DrJava.getConfig().getSetting(OptionConstants.FIND_ALL_DOCUMENTS));
        this._machine.setSearchAllDocuments(DrJava.getConfig().getSetting(OptionConstants.FIND_ALL_DOCUMENTS));
        this._searchAllDocuments.addItemListener(sadl);
        MatchWholeWordListener mwwl = new MatchWholeWordListener();
        this._matchWholeWord = new JCheckBox("Whole Word", (boolean)DrJava.getConfig().getSetting(OptionConstants.FIND_WHOLE_WORD));
        if (DrJava.getConfig().getSetting(OptionConstants.FIND_WHOLE_WORD).booleanValue()) {
            this._machine.setMatchWholeWord();
        } else {
            this._machine.setFindAnyOccurrence();
        }
        this._matchWholeWord.addItemListener(mwwl);
        this._matchCase.setPreferredSize(this._matchWholeWord.getPreferredSize());
        IgnoreCommentsAndStringsListener icasl = new IgnoreCommentsAndStringsListener();
        this._ignoreCommentsAndStrings = new JCheckBox("No Comments/Strings", (boolean)DrJava.getConfig().getSetting(OptionConstants.FIND_NO_COMMENTS_STRINGS));
        this._machine.setIgnoreCommentsAndStrings(DrJava.getConfig().getSetting(OptionConstants.FIND_NO_COMMENTS_STRINGS));
        this._ignoreCommentsAndStrings.addItemListener(icasl);
        this.removeAll();
        this._closePanel = new JPanel(new BorderLayout());
        this._closePanel.add((Component)this._closeButton, "North");
        this._lowerCheckPanel = new JPanel(new FlowLayout(0, 0, 0));
        this._lowerCheckPanel.add(this._matchWholeWord);
        this._lowerCheckPanel.add(this._ignoreCommentsAndStrings);
        this._lowerCheckPanel.setMaximumSize(new Dimension(1000, 40));
        this._matchCaseAndAllDocsPanel = new JPanel(new FlowLayout(0, 0, 0));
        this._matchCaseAndAllDocsPanel.add(this._matchCase);
        this._matchCaseAndAllDocsPanel.add(this._searchAllDocuments);
        this._matchCaseAndAllDocsPanel.setMaximumSize(new Dimension(1000, 40));
        this._searchAllDocuments.setSelected(false);
        this._findPane.setHorizontalScrollBarPolicy(30);
        this._replacePane.setHorizontalScrollBarPolicy(30);
        JPanel findPanel = new JPanel(new BorderLayout(5, 5));
        findPanel.add((Component)findLabelPanel, "West");
        findPanel.add((Component)this._findPane, "Center");
        JPanel replacePanel = new JPanel(new BorderLayout(5, 5));
        replacePanel.add((Component)replaceLabelPanel, "West");
        replacePanel.add((Component)this._replacePane, "Center");
        JPanel leftPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        leftPanel.add(findPanel);
        leftPanel.add(replacePanel);
        Box optionsPanel = new Box(1);
        optionsPanel.add(this._matchCaseAndAllDocsPanel);
        optionsPanel.add(this._lowerCheckPanel);
        optionsPanel.add(Box.createGlue());
        JPanel midPanel = new JPanel(new BorderLayout(5, 5));
        midPanel.add((Component)leftPanel, "Center");
        midPanel.add((Component)optionsPanel, "East");
        this._rightPanel = new JPanel(new BorderLayout(5, 5));
        this._rightPanel.add((Component)midPanel, "Center");
        this._rightPanel.add((Component)this._closePanel, "East");
        JPanel newPanel = new JPanel();
        newPanel.setLayout(new BoxLayout(newPanel, 1));
        newPanel.add(this._rightPanel);
        newPanel.add(Box.createVerticalStrut(5));
        newPanel.add(buttons);
        newPanel.add(Box.createVerticalStrut(5));
        this.setLayout(new BoxLayout(this, 0));
        this.add(Box.createHorizontalStrut(5));
        this.add(newPanel);
        this._findField.setNextFocusableComponent(this._replaceField);
        this._replaceField.setNextFocusableComponent(this._matchCase);
        this._matchCase.setNextFocusableComponent(this._searchAllDocuments);
        this._searchAllDocuments.setNextFocusableComponent(this._matchWholeWord);
        this._matchWholeWord.setNextFocusableComponent(this._ignoreCommentsAndStrings);
        this._ignoreCommentsAndStrings.setNextFocusableComponent(this._findNextButton);
        this._findNextButton.setNextFocusableComponent(this._findPreviousButton);
        this._findPreviousButton.setNextFocusableComponent(this._replaceFindNextButton);
        this._replaceFindNextButton.setNextFocusableComponent(this._replaceFindPreviousButton);
        this._replaceFindPreviousButton.setNextFocusableComponent(this._replaceButton);
        this._replaceButton.setNextFocusableComponent(this._replaceAllButton);
        this._replaceAllButton.setNextFocusableComponent(this._closeButton);
        this._closeButton.setNextFocusableComponent(this._findField);
        this._findField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                this._updateHelper();
            }

            public void insertUpdate(DocumentEvent e) {
                this._updateHelper();
            }

            public void removeUpdate(DocumentEvent e) {
                this._updateHelper();
            }

            private void _updateHelper() {
                Utilities.invokeLater(new Runnable(){

                    public void run() {
                        FindReplaceDialog.this._machine.makeCurrentOffsetStart();
                        FindReplaceDialog.this.updateFirstDocInSearch();
                        FindReplaceDialog.this._replaceAction.setEnabled(false);
                        FindReplaceDialog.this._replaceFindNextAction.setEnabled(false);
                        FindReplaceDialog.this._replaceFindPreviousAction.setEnabled(false);
                        FindReplaceDialog.this._machine.positionChanged();
                        if (FindReplaceDialog.this._findField.getText().equals("")) {
                            FindReplaceDialog.this._replaceAllAction.setEnabled(false);
                        } else {
                            FindReplaceDialog.this._replaceAllAction.setEnabled(true);
                        }
                        FindReplaceDialog.this.updateUI();
                    }
                });
            }
        });
        Keymap km = JTextPane.addKeymap("Find Field Bindings", this._findField.getKeymap());
        KeyStroke findKey = KeyStroke.getKeyStroke(10, 0);
        km.addActionForKeyStroke(findKey, this._findEnterAction);
        KeyStroke switchFocusForwardKey = KeyStroke.getKeyStroke(9, 0);
        km.addActionForKeyStroke(switchFocusForwardKey, this._findFieldSwitchFocusForwardAction);
        KeyStroke switchFocusBackKey = KeyStroke.getKeyStroke(9, 1);
        km.addActionForKeyStroke(switchFocusBackKey, this._findFieldSwitchFocusBackAction);
        TextAction findNewLineAction = new TextAction("NewLine Action"){

            public void actionPerformed(ActionEvent e) {
                String text = FindReplaceDialog.this._findField.getText();
                int caretPos = FindReplaceDialog.this._findField.getCaretPosition();
                String textBeforeCaret = text.substring(0, caretPos);
                String textAfterCaret = text.substring(caretPos);
                FindReplaceDialog.this._findField.setText(textBeforeCaret.concat("\n").concat(textAfterCaret));
                FindReplaceDialog.this._findField.setCaretPosition(caretPos + 1);
            }
        };
        KeyStroke newLineKey = KeyStroke.getKeyStroke(10, 2);
        km.addActionForKeyStroke(newLineKey, findNewLineAction);
        DefaultEditorKit.InsertTabAction tabAction = new DefaultEditorKit.InsertTabAction();
        KeyStroke tabKey = KeyStroke.getKeyStroke(9, 2);
        km.addActionForKeyStroke(tabKey, tabAction);
        this._findField.setKeymap(km);
        Keymap rkm = JTextPane.addKeymap("Replace Field Bindings", this._replaceField.getKeymap());
        TextAction replaceNewLineAction = new TextAction("NewLine Action"){

            public void actionPerformed(ActionEvent e) {
                String text = FindReplaceDialog.this._replaceField.getText();
                int caretPos = FindReplaceDialog.this._replaceField.getCaretPosition();
                String textBeforeCaret = text.substring(0, caretPos);
                String textAfterCaret = text.substring(caretPos);
                FindReplaceDialog.this._replaceField.setText(textBeforeCaret.concat("\n").concat(textAfterCaret));
                FindReplaceDialog.this._replaceField.setCaretPosition(caretPos + 1);
            }
        };
        rkm.addActionForKeyStroke(newLineKey, replaceNewLineAction);
        rkm.addActionForKeyStroke(switchFocusForwardKey, this._replaceFieldSwitchFocusForwardAction);
        rkm.addActionForKeyStroke(switchFocusBackKey, this._replaceFieldSwitchFocusBackAction);
        rkm.addActionForKeyStroke(tabKey, tabAction);
        this._replaceField.setKeymap(rkm);
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        this._findField.selectAll();
        return this._findField.requestFocusInWindow();
    }

    JTextPane getFindField() {
        return this._findField;
    }

    void findNext() {
        this._machine.setSearchBackwards(false);
        this._findLabelTop.setText("Find");
        this._findLabelBot.setText("Next");
        this._doFind();
    }

    void findPrevious() {
        this._machine.setSearchBackwards(true);
        this._findLabelBot.setText("Prev");
        this._doFind();
    }

    void beginListeningTo(DefinitionsPane defPane) {
        if (this._defPane == null) {
            this._displayed = true;
            this._defPane = defPane;
            this._defPane.addCaretListener(this._caretListener);
            this._caretChanged = true;
            this._updateMachine();
            this._machine.setFindWord(this._findField.getText());
            this._machine.setReplaceWord(this._replaceField.getText());
            this._mainframe.clearStatusMessage();
            if (!this._machine.isOnMatch() || this._findField.getText().equals("")) {
                this._replaceAction.setEnabled(false);
                this._replaceFindNextAction.setEnabled(false);
                this._replaceFindPreviousAction.setEnabled(false);
            } else {
                this._replaceAction.setEnabled(true);
                this._replaceFindNextAction.setEnabled(true);
                this._replaceFindPreviousAction.setEnabled(true);
                this._machine.setLastFindWord();
            }
            if (this._findField.getText().equals("")) {
                this._replaceAllAction.setEnabled(false);
            } else {
                this._replaceAllAction.setEnabled(true);
            }
        } else {
            throw new UnexpectedException(new RuntimeException("FindReplaceDialog should not be listening to anything"));
        }
        this._mainframe.clearStatusMessage();
    }

    public void stopListening() {
        if (this._defPane != null) {
            this._defPane.removeCaretListener(this._caretListener);
            this._defPane = null;
            this._displayed = false;
            this._mainframe.clearStatusMessage();
        }
    }

    private void _doFind() {
        if (this._findField.getText().length() > 0) {
            this._updateMachine();
            this._machine.setFindWord(this._findField.getText());
            this._machine.setReplaceWord(this._replaceField.getText());
            this._mainframe.clearStatusMessage();
            FindResult fr = this._machine.findNext();
            AbstractDocumentInterface doc = fr.getDocument();
            OpenDefinitionsDocument matchDoc = this._model.getODDForDocument(doc);
            OpenDefinitionsDocument openDoc = this._defPane.getOpenDefDocument();
            int pos = fr.getFoundOffset();
            if (pos != -1) {
                Caret c = this._defPane.getCaret();
                c.setDot(c.getDot());
                if (!matchDoc.equals(openDoc)) {
                    this._model.setActiveDocument(matchDoc);
                } else {
                    this._model.refreshActiveDocument();
                }
                this._defPane.setCaretPosition(pos);
                this._caretChanged = true;
                this._updateMachine();
            }
            if (fr.getWrapped() && !this._machine.getSearchAllDocuments()) {
                Toolkit.getDefaultToolkit().beep();
                if (!this._machine.getSearchBackwards()) {
                    this._mainframe.setStatusMessage("Search wrapped to beginning.");
                } else {
                    this._mainframe.setStatusMessage("Search wrapped to end.");
                }
            }
            if (fr.getAllDocsWrapped() && this._machine.getSearchAllDocuments()) {
                Toolkit.getDefaultToolkit().beep();
                this._mainframe.setStatusMessage("Search wrapped around all documents.");
            }
            if (pos >= 0) {
                this._selectFoundItem();
                this._replaceAction.setEnabled(true);
                this._replaceFindNextAction.setEnabled(true);
                this._replaceFindPreviousAction.setEnabled(true);
                this._machine.setLastFindWord();
            } else {
                Toolkit.getDefaultToolkit().beep();
                StringBuffer statusMessage = new StringBuffer("Search text \"");
                if (this._machine.getFindWord().length() <= 50) {
                    statusMessage.append(this._machine.getFindWord());
                } else {
                    statusMessage.append(this._machine.getFindWord().substring(0, 49) + "...");
                }
                statusMessage.append("\" not found.");
                this._mainframe.setStatusMessage(statusMessage.toString());
            }
        }
        this._findField.requestFocusInWindow();
    }

    protected void _close() {
        this._defPane.requestFocusInWindow();
        if (this._displayed) {
            this.stopListening();
        }
        super._close();
    }

    public void setSearchBackwards(boolean b) {
        this._machine.setSearchBackwards(b);
    }

    public boolean getSearchBackwards() {
        return this._machine.getSearchBackwards();
    }

    public void setFieldFont(Font f) {
        this._findField.setFont(f);
        this._replaceField.setFont(f);
    }

    public void updateFirstDocInSearch() {
        this._machine.setFirstDoc(this._model.getActiveDocument());
    }

    private static Container wrap(JComponent comp) {
        Box stretcher = Box.createHorizontalBox();
        stretcher.add(comp);
        stretcher.add(Box.createHorizontalGlue());
        return stretcher;
    }

    private static void hookComponents(Container parent, JComponent q1, JComponent q2, JComponent q4) {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        parent.setLayout(gbl);
        c.fill = 1;
        FindReplaceDialog.addComp(parent, q2, c, gbl, 0, 0, 0.0f, 0.0f, 1, 0);
        FindReplaceDialog.addComp(parent, q1, c, gbl, 0, 1, 1.0f, 0.0f, 1, 0);
        FindReplaceDialog.addComp(parent, new JPanel(), c, gbl, 1, 0, 1.0f, 1.0f, 2, 0);
        FindReplaceDialog.addComp(parent, new JPanel(), c, gbl, 2, 0, 0.0f, 0.0f, 1, 0);
        FindReplaceDialog.addComp(parent, q4, c, gbl, 2, 1, 1.0f, 0.0f, 1, 0);
    }

    private static void addComp(Container p, JComponent child, GridBagConstraints c, GridBagLayout gbl, int row, int col, float weightx, float weighty, int gridw, int ipady) {
        c.gridx = col;
        c.gridy = row;
        c.weightx = weightx;
        c.weighty = weighty;
        c.gridwidth = gridw;
        c.ipady = ipady;
        gbl.setConstraints(child, c);
        p.add(child);
    }

    private void _updateMachine() {
        if (this._caretChanged) {
            OpenDefinitionsDocument doc = this._model.getActiveDocument();
            OpenDefinitionsDocument currentDoc = this._defPane.getOpenDefDocument();
            this._machine.setDocument(doc);
            if (this._machine.getFirstDoc() == null) {
                this._machine.setFirstDoc(doc);
            }
            this._machine.setStart(this._defPane.getCaretPosition());
            this._machine.setPosition(this._defPane.getCaretPosition());
            this._caretChanged = false;
        }
    }

    private void _selectReplacedItem(int length) {
        int to = this._machine.getCurrentOffset();
        int from = this._machine.getSearchBackwards() ? to + length : to - length;
        this._selectFoundItem(from, to);
    }

    private void _selectFoundItem() {
        int position;
        int to = position = this._machine.getCurrentOffset();
        int from = !this._machine.getSearchBackwards() ? position - this._machine.getFindWord().length() : position + this._machine.getFindWord().length();
        this._selectFoundItem(from, to);
    }

    private void _selectFoundItem(int from, int to) {
        this._defPane.centerViewOnOffset(from);
        this._defPane.select(from, to);
        this._defPane.getCaret().setSelectionVisible(true);
    }

    public DefinitionsPane getDefPane() {
        return this._defPane;
    }

    public JButton getFindNextButton() {
        return this._findNextButton;
    }

    class IgnoreCommentsAndStringsListener
    implements ItemListener {
        IgnoreCommentsAndStringsListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 2) {
                FindReplaceDialog.this._machine.setIgnoreCommentsAndStrings(false);
                DrJava.getConfig().setSetting(OptionConstants.FIND_NO_COMMENTS_STRINGS, false);
            } else if (e.getStateChange() == 1) {
                FindReplaceDialog.this._machine.setIgnoreCommentsAndStrings(true);
                DrJava.getConfig().setSetting(OptionConstants.FIND_NO_COMMENTS_STRINGS, true);
            }
            FindReplaceDialog.this._findField.requestFocusInWindow();
        }
    }

    class MatchWholeWordListener
    implements ItemListener {
        MatchWholeWordListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 2) {
                FindReplaceDialog.this._machine.setFindAnyOccurrence();
                DrJava.getConfig().setSetting(OptionConstants.FIND_WHOLE_WORD, false);
            } else if (e.getStateChange() == 1) {
                FindReplaceDialog.this._machine.setMatchWholeWord();
                DrJava.getConfig().setSetting(OptionConstants.FIND_WHOLE_WORD, true);
            }
            FindReplaceDialog.this._findField.requestFocusInWindow();
        }
    }

    class SearchAllDocumentsListener
    implements ItemListener {
        SearchAllDocumentsListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 2) {
                FindReplaceDialog.this._machine.setSearchAllDocuments(false);
                DrJava.getConfig().setSetting(OptionConstants.FIND_ALL_DOCUMENTS, false);
            } else if (e.getStateChange() == 1) {
                FindReplaceDialog.this._machine.setSearchAllDocuments(true);
                DrJava.getConfig().setSetting(OptionConstants.FIND_ALL_DOCUMENTS, true);
            }
            FindReplaceDialog.this._findField.requestFocusInWindow();
        }
    }

    class SearchBackwardsListener
    implements ItemListener {
        SearchBackwardsListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 2) {
                FindReplaceDialog.this._machine.setSearchBackwards(false);
                DrJava.getConfig().setSetting(OptionConstants.FIND_SEARCH_BACKWARDS, false);
            } else if (e.getStateChange() == 1) {
                FindReplaceDialog.this._machine.setSearchBackwards(true);
                DrJava.getConfig().setSetting(OptionConstants.FIND_SEARCH_BACKWARDS, true);
            }
            FindReplaceDialog.this._findField.requestFocusInWindow();
        }
    }

    class MatchCaseListener
    implements ItemListener {
        MatchCaseListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 2) {
                FindReplaceDialog.this._machine.setMatchCase(false);
                DrJava.getConfig().setSetting(OptionConstants.FIND_MATCH_CASE, false);
            } else if (e.getStateChange() == 1) {
                FindReplaceDialog.this._machine.setMatchCase(true);
                DrJava.getConfig().setSetting(OptionConstants.FIND_MATCH_CASE, true);
            }
            FindReplaceDialog.this._findField.requestFocusInWindow();
        }
    }
}

