/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.SingleDisplayModel;
import edu.rice.cs.drjava.model.compiler.CompilerError;
import edu.rice.cs.drjava.model.compiler.CompilerErrorModel;
import edu.rice.cs.drjava.ui.DefinitionsPane;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.TabbedPanel;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.BorderlessScrollPane;
import edu.rice.cs.util.swing.HighlightManager;
import edu.rice.cs.util.text.SwingDocument;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public abstract class ErrorPanel
extends TabbedPanel
implements OptionConstants {
    protected static final SimpleAttributeSet NORMAL_ATTRIBUTES = ErrorPanel._getNormalAttributes();
    protected static final SimpleAttributeSet BOLD_ATTRIBUTES = ErrorPanel._getBoldAttributes();
    protected int _numErrors;
    protected JCheckBox _showHighlightsCheckBox;
    protected SingleDisplayModel _model;
    private JScrollPane _scroller;
    private JPanel _leftPanel;
    private JPanel _rightPanel;
    private JPanel _errorNavPanel;
    private JPanel _errorNavButtonsPanel;
    protected JPanel customPanel;
    private JButton _nextErrorButton;
    private JButton _prevErrorButton;
    static DefaultHighlighter.DefaultHighlightPainter _listHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(DrJava.getConfig().getSetting(COMPILER_ERROR_COLOR));

    protected static final SimpleAttributeSet _getBoldAttributes() {
        SimpleAttributeSet s = new SimpleAttributeSet();
        StyleConstants.setBold(s, true);
        return s;
    }

    protected static final SimpleAttributeSet _getNormalAttributes() {
        SimpleAttributeSet s = new SimpleAttributeSet();
        return s;
    }

    public ErrorPanel(SingleDisplayModel model, MainFrame frame, String tabString, String labelString) {
        super(frame, tabString);
        this._model = model;
        this._mainPanel.setLayout(new BorderLayout());
        this._leftPanel = new JPanel(new BorderLayout());
        this._errorNavPanel = new JPanel(new GridBagLayout());
        this._errorNavButtonsPanel = new JPanel(new BorderLayout());
        this._nextErrorButton = new JButton(MainFrame.getIcon("Down16.gif"));
        this._prevErrorButton = new JButton(MainFrame.getIcon("Up16.gif"));
        this._nextErrorButton.setMargin(new Insets(0, 0, 0, 0));
        this._nextErrorButton.setToolTipText("Go to the next error");
        this._prevErrorButton.setMargin(new Insets(0, 0, 0, 0));
        this._prevErrorButton.setToolTipText("Go to the previous error");
        this._errorNavButtonsPanel.add((Component)this._prevErrorButton, "North");
        this._errorNavButtonsPanel.add((Component)this._nextErrorButton, "South");
        this._errorNavButtonsPanel.setBorder(new EmptyBorder(18, 5, 18, 5));
        this._errorNavPanel.add(this._errorNavButtonsPanel);
        this._showHighlightsCheckBox = new JCheckBox("Highlight source", true);
        this._scroller = new BorderlessScrollPane(22, 31);
        this._leftPanel.add((Component)this._scroller, "Center");
        this._leftPanel.add((Component)this._errorNavPanel, "East");
        this.customPanel = new JPanel(new BorderLayout());
        this._rightPanel = new JPanel(new BorderLayout());
        this._rightPanel.setBorder(new EmptyBorder(0, 5, 0, 5));
        this._rightPanel.add((Component)new JLabel(labelString, 2), "North");
        this._rightPanel.add((Component)this.customPanel, "Center");
        this._rightPanel.add((Component)this._showHighlightsCheckBox, "South");
        this._mainPanel.add((Component)this._leftPanel, "Center");
        this._mainPanel.add((Component)this._rightPanel, "East");
    }

    protected void setErrorListPane(final ErrorListPane elp) {
        this._scroller.setViewportView(elp);
        this._nextErrorButton.setEnabled(false);
        this._nextErrorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                elp.nextError();
            }
        });
        this._prevErrorButton.setEnabled(false);
        this._prevErrorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                elp.prevError();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListFont(Font f) {
        SimpleAttributeSet set = new SimpleAttributeSet();
        StyleConstants.setFontFamily(set, f.getFamily());
        StyleConstants.setFontSize(set, f.getSize());
        StyleConstants.setBold(set, f.isBold());
        StyleConstants.setItalic(set, f.isItalic());
        this._updateStyles(set);
        this.getErrorListPane().setFont(f);
        SwingDocument doc = (SwingDocument)this.getErrorListPane().getDocument();
        if (doc instanceof SwingDocument) {
            doc.acquireWriteLock();
            try {
                doc.setCharacterAttributes(0, doc.getLength() + 1, set, false);
            }
            finally {
                doc.releaseWriteLock();
            }
        }
    }

    protected void _updateStyles(AttributeSet newSet) {
        NORMAL_ATTRIBUTES.addAttributes(newSet);
        BOLD_ATTRIBUTES.addAttributes(newSet);
        StyleConstants.setBold(BOLD_ATTRIBUTES, true);
    }

    protected abstract ErrorListPane getErrorListPane();

    protected SingleDisplayModel getModel() {
        return this._model;
    }

    protected abstract CompilerErrorModel getErrorModel();

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class ErrorListPane
    extends JEditorPane {
        private int _selectedIndex;
        protected Position[] _errorListPositions;
        protected final Hashtable<Position, CompilerError> _errorTable = new Hashtable();
        private HighlightManager.HighlightInfo _listHighlightTag = null;
        private HighlightManager _highlightManager = new HighlightManager(this);
        protected MouseAdapter defaultMouseListener = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ErrorListPane.this.selectNothing();
            }

            public void mouseReleased(MouseEvent e) {
                CompilerError error = ErrorListPane.this._errorAtPoint(e.getPoint());
                if (ErrorListPane.this._isEmptySelection() && error != null) {
                    ErrorPanel.this.getErrorListPane().switchToError(error);
                } else {
                    ErrorListPane.this.selectNothing();
                }
            }
        };

        private Hashtable<Position, CompilerError> _setUpErrorTable() {
            return new Hashtable<Position, CompilerError>();
        }

        public ErrorListPane() {
            this.setContentType("text/rtf");
            this.setDocument(new SwingDocument());
            this.addMouseListener(this.defaultMouseListener);
            this._selectedIndex = 0;
            this._errorListPositions = new Position[0];
            this.setFont(new Font("Courier", 0, 20));
            this.setEditable(false);
            DrJava.getConfig().addOptionListener(OptionConstants.COMPILER_ERROR_COLOR, new CompilerErrorColorOptionListener());
            StyleConstants.setForeground(NORMAL_ATTRIBUTES, DrJava.getConfig().getSetting(OptionConstants.DEFINITIONS_NORMAL_COLOR));
            StyleConstants.setForeground(BOLD_ATTRIBUTES, DrJava.getConfig().getSetting(OptionConstants.DEFINITIONS_NORMAL_COLOR));
            this.setBackground(DrJava.getConfig().getSetting(OptionConstants.DEFINITIONS_BACKGROUND_COLOR));
            DrJava.getConfig().addOptionListener(OptionConstants.DEFINITIONS_NORMAL_COLOR, new ForegroundColorListener());
            DrJava.getConfig().addOptionListener(OptionConstants.DEFINITIONS_BACKGROUND_COLOR, new BackgroundColorListener());
            ErrorPanel.this._showHighlightsCheckBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    DefinitionsPane lastDefPane = ((ErrorListPane)ErrorListPane.this).ErrorPanel.this._frame.getCurrentDefPane();
                    if (e.getStateChange() == 2) {
                        lastDefPane.removeErrorHighlight();
                    } else if (e.getStateChange() == 1) {
                        ErrorPanel.this.getErrorListPane().switchToError(ErrorListPane.this.getSelectedIndex());
                    }
                }
            });
        }

        public boolean shouldShowHighlightsInSource() {
            return ErrorPanel.this._showHighlightsCheckBox.isSelected();
        }

        public int getSelectedIndex() {
            return this._selectedIndex;
        }

        protected CompilerError _errorAtPoint(Point p) {
            int modelPos = this.viewToModel(p);
            if (modelPos == -1) {
                return null;
            }
            int errorNum = -1;
            int i = 0;
            while (i < this._errorListPositions.length && this._errorListPositions[i].getOffset() <= modelPos) {
                errorNum = i++;
            }
            if (errorNum >= 0) {
                return this._errorTable.get(this._errorListPositions[errorNum]);
            }
            return null;
        }

        private int _getIndexForError(CompilerError error) {
            if (error == null) {
                throw new IllegalArgumentException("Couldn't find index for null error");
            }
            for (int i = 0; i < this._errorListPositions.length; ++i) {
                CompilerError e = this._errorTable.get(this._errorListPositions[i]);
                if (!error.equals(e)) continue;
                return i;
            }
            throw new IllegalArgumentException(new StringBuffer().append("Couldn't find index for error ").append(error).toString());
        }

        protected boolean _isEmptySelection() {
            return this.getSelectionStart() == this.getSelectionEnd();
        }

        protected void updateListPane(boolean done) {
            try {
                this._errorListPositions = new Position[ErrorPanel.this._numErrors];
                this._errorTable.clear();
                if (ErrorPanel.this._numErrors == 0) {
                    this._updateNoErrors(done);
                } else {
                    this._updateWithErrors();
                }
            }
            catch (BadLocationException e) {
                throw new UnexpectedException(e);
            }
        }

        protected abstract void _updateNoErrors(boolean var1) throws BadLocationException;

        protected abstract void _updateWithErrors() throws BadLocationException;

        protected String _getNumErrorsMessage(String failureName, String failureMeaning) {
            StringBuffer numErrMsg;
            int numCompErrs = ErrorPanel.this.getErrorModel().getNumCompErrors();
            int numWarnings = ErrorPanel.this.getErrorModel().getNumWarnings();
            if (!ErrorPanel.this.getErrorModel().hasOnlyWarnings()) {
                numErrMsg = new StringBuffer(new StringBuffer().append(numCompErrs).append(" ").append(failureName).toString());
                if (numCompErrs > 1) {
                    numErrMsg.append("s");
                }
                if (numWarnings > 0) {
                    numErrMsg.append(new StringBuffer().append(" and ").append(numWarnings).append(" warning").toString());
                }
            } else {
                numErrMsg = new StringBuffer(new StringBuffer().append(numWarnings).append(" warning").toString());
            }
            if (numWarnings > 1) {
                numErrMsg.append("s");
            }
            numErrMsg.append(new StringBuffer().append(" ").append(failureMeaning).append(":\n").toString());
            return numErrMsg.toString();
        }

        protected String _getErrorTitle() {
            CompilerErrorModel cem = ErrorPanel.this.getErrorModel();
            if (cem.getNumCompErrors() > 1) {
                return "--------------\n*** Errors ***\n--------------\n";
            }
            if (cem.getNumCompErrors() > 0) {
                return "-------------\n*** Error ***\n-------------\n";
            }
            return "";
        }

        protected String _getWarningTitle() {
            CompilerErrorModel cem = ErrorPanel.this.getErrorModel();
            if (cem.getNumWarnings() > 1) {
                return "--------------\n** Warnings **\n--------------\n";
            }
            if (cem.getNumWarnings() > 0) {
                return "-------------\n** Warning **\n-------------\n";
            }
            return "";
        }

        protected void _updateWithErrors(String failureName, String failureMeaning, SwingDocument doc) throws BadLocationException {
            String numErrsMsg = this._getNumErrorsMessage(failureName, failureMeaning);
            doc.append(numErrsMsg, BOLD_ATTRIBUTES);
            this._insertErrors(doc);
            this.setDocument(doc);
            if (!ErrorPanel.this.getErrorModel().hasOnlyWarnings()) {
                ErrorPanel.this.getErrorListPane().switchToError(0);
            }
        }

        public boolean hasNextError() {
            return this.getSelectedIndex() + 1 < ErrorPanel.this._numErrors;
        }

        public boolean hasPrevError() {
            return this.getSelectedIndex() > 0;
        }

        public void nextError() {
            if (this.hasNextError()) {
                ++this._selectedIndex;
                ErrorPanel.this.getErrorListPane().switchToError(this.getSelectedIndex());
            }
        }

        public void prevError() {
            if (this.hasPrevError()) {
                --this._selectedIndex;
                ErrorPanel.this.getErrorListPane().switchToError(this.getSelectedIndex());
            }
        }

        protected void _insertErrors(SwingDocument doc) throws BadLocationException {
            CompilerErrorModel cem = ErrorPanel.this.getErrorModel();
            int numErrors = cem.getNumErrors();
            int errorPositionInListOfErrors = 0;
            String errorTitle = this._getErrorTitle();
            if (cem.getNumWarnings() > 0) {
                doc.append(errorTitle, BOLD_ATTRIBUTES);
            }
            for (int errorNum = 0; errorNum < numErrors; ++errorNum) {
                Position pos;
                int startPos = doc.getLength();
                Object err = cem.getError(errorNum);
                if (((CompilerError)err).isWarning()) continue;
                this._insertErrorText((CompilerError)err, doc);
                this._errorListPositions[errorPositionInListOfErrors] = pos = doc.createPosition(startPos);
                this._errorTable.put(pos, (CompilerError)err);
                ++errorPositionInListOfErrors;
            }
            String warningTitle = this._getWarningTitle();
            if (cem.getNumCompErrors() > 0) {
                doc.append(warningTitle, BOLD_ATTRIBUTES);
            }
            for (int errorNum = 0; errorNum < numErrors; ++errorNum) {
                Position pos;
                int startPos = doc.getLength();
                Object err = cem.getError(errorNum);
                if (!((CompilerError)err).isWarning()) continue;
                this._insertErrorText((CompilerError)err, doc);
                this._errorListPositions[errorPositionInListOfErrors] = pos = doc.createPosition(startPos);
                this._errorTable.put(pos, (CompilerError)err);
                ++errorPositionInListOfErrors;
            }
        }

        protected void _insertErrorText(CompilerError error, SwingDocument doc) throws BadLocationException {
            doc.append("File: ", BOLD_ATTRIBUTES);
            String fileAndLineNumber = new StringBuffer().append(error.getFileMessage()).append("  [line: ").append(error.getLineMessage()).append("]").toString();
            doc.append(new StringBuffer().append(fileAndLineNumber).append("\n").toString(), NORMAL_ATTRIBUTES);
            if (error.isWarning()) {
                doc.append(this._getWarningText(), BOLD_ATTRIBUTES);
            } else {
                doc.append(this._getErrorText(), BOLD_ATTRIBUTES);
            }
            doc.append(error.message(), NORMAL_ATTRIBUTES);
            doc.append("\n", NORMAL_ATTRIBUTES);
        }

        protected String _getWarningText() {
            return "Warning: ";
        }

        protected String _getErrorText() {
            return "Error: ";
        }

        protected void _removeListHighlight() {
            if (this._listHighlightTag != null) {
                this._listHighlightTag.remove();
                this._listHighlightTag = null;
            }
        }

        public void selectNothing() {
            this._removeListHighlight();
            ErrorPanel.this._frame.getCurrentDefPane().removeErrorHighlight();
        }

        public void selectItem(CompilerError error) {
            block8: {
                CompilerErrorModel cem = ErrorPanel.this.getErrorModel();
                try {
                    int endPos;
                    int i;
                    this._selectedIndex = i = this._getIndexForError(error);
                    this._removeListHighlight();
                    int startPos = this._errorListPositions[i].getOffset();
                    if (i + 1 >= ErrorPanel.this._numErrors) {
                        endPos = this.getDocument().getLength();
                    } else {
                        endPos = this._errorListPositions[i + 1].getOffset();
                        CompilerError nextError = this._errorTable.get(this._errorListPositions[i + 1]);
                        if (!error.isWarning() && nextError.isWarning()) {
                            endPos -= this._getWarningTitle().length();
                        }
                    }
                    try {
                        this._listHighlightTag = this._highlightManager.addHighlight(startPos, endPos, _listHighlightPainter);
                        Rectangle startRect = i == 0 ? this.modelToView(0) : this.modelToView(startPos);
                        Rectangle endRect = this.modelToView(endPos - 1);
                        if (startRect != null && endRect != null) {
                            startRect.add(endRect);
                            this.scrollRectToVisible(startRect);
                            this._updateScrollButtons();
                            break block8;
                        }
                        this._removeListHighlight();
                    }
                    catch (BadLocationException badBadLocation) {}
                }
                catch (IllegalArgumentException iae) {
                    this._removeListHighlight();
                }
            }
        }

        protected void _updateScrollButtons() {
            if (this.hasNextError()) {
                ErrorPanel.this._nextErrorButton.setEnabled(true);
            } else {
                ErrorPanel.this._nextErrorButton.setEnabled(false);
            }
            if (this.hasPrevError()) {
                ErrorPanel.this._prevErrorButton.setEnabled(true);
            } else {
                ErrorPanel.this._prevErrorButton.setEnabled(false);
            }
        }

        void switchToError(CompilerError error) {
            if (error == null) {
                return;
            }
            SingleDisplayModel model = ErrorPanel.this.getModel();
            DefinitionsPane prevPane = ErrorPanel.this._frame.getCurrentDefPane();
            prevPane.removeErrorHighlight();
            OpenDefinitionsDocument prevDoc = prevPane.getOpenDefDocument();
            if (error.file() != null) {
                try {
                    int errPos;
                    OpenDefinitionsDocument doc = model.getDocumentForFile(error.file());
                    CompilerErrorModel errorModel = ErrorPanel.this.getErrorModel();
                    Position pos = errorModel.getPosition(error);
                    if (!prevDoc.equals(doc)) {
                        model.setActiveDocument(doc);
                    } else {
                        model.refreshActiveDocument();
                    }
                    DefinitionsPane defPane = ErrorPanel.this._frame.getCurrentDefPane();
                    if (pos != null && (errPos = pos.getOffset()) >= 0 && errPos <= doc.getLength()) {
                        defPane.centerViewOnOffset(errPos);
                        defPane.getErrorCaretListener().updateHighlight(errPos);
                    }
                    defPane.requestFocusInWindow();
                    defPane.getCaret().setVisible(true);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            ErrorPanel.this.getErrorListPane().selectItem(error);
        }

        void switchToError(int index) {
            if (index >= 0 && index < this._errorListPositions.length) {
                Position pos = this._errorListPositions[index];
                CompilerError error = this._errorTable.get(pos);
                this.switchToError(error);
            }
        }

        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class BackgroundColorListener
        implements OptionListener<Color> {
            private BackgroundColorListener() {
            }

            @Override
            public void optionChanged(OptionEvent<Color> oce) {
                ErrorListPane.this.setBackground((Color)oce.value);
                ErrorListPane.this.repaint();
            }
        }

        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class ForegroundColorListener
        implements OptionListener<Color> {
            private ForegroundColorListener() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void optionChanged(OptionEvent<Color> oce) {
                StyleConstants.setForeground(NORMAL_ATTRIBUTES, (Color)oce.value);
                StyleConstants.setForeground(BOLD_ATTRIBUTES, (Color)oce.value);
                Document doc = ErrorPanel.this.getErrorListPane().getDocument();
                if (doc instanceof SwingDocument) {
                    SimpleAttributeSet set = new SimpleAttributeSet();
                    set.addAttribute(StyleConstants.Foreground, oce.value);
                    SwingDocument sdoc = (SwingDocument)doc;
                    sdoc.acquireWriteLock();
                    try {
                        sdoc.setCharacterAttributes(0, sdoc.getLength(), set, false);
                    }
                    finally {
                        sdoc.releaseWriteLock();
                    }
                }
            }
        }

        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class CompilerErrorColorOptionListener
        implements OptionListener<Color> {
            private CompilerErrorColorOptionListener() {
            }

            @Override
            public void optionChanged(OptionEvent<Color> oce) {
                _listHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter((Color)oce.value);
                if (ErrorListPane.this._listHighlightTag != null) {
                    ErrorListPane.this._listHighlightTag.refresh(_listHighlightPainter);
                }
            }
        }
    }
}

