/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.BooleanOption;
import edu.rice.cs.drjava.config.ColorOption;
import edu.rice.cs.drjava.config.KeyStrokeOption;
import edu.rice.cs.drjava.config.Option;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.model.DJDocument;
import edu.rice.cs.drjava.model.Finalizable;
import edu.rice.cs.drjava.model.FinalizationEvent;
import edu.rice.cs.drjava.model.FinalizationListener;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.OperationCanceledException;
import edu.rice.cs.drjava.model.debug.Breakpoint;
import edu.rice.cs.drjava.model.definitions.CompoundUndoManager;
import edu.rice.cs.drjava.model.definitions.DefinitionsEditorKit;
import edu.rice.cs.drjava.model.definitions.NoSuchDocumentException;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelState;
import edu.rice.cs.drjava.ui.AbstractDJPane;
import edu.rice.cs.drjava.ui.BackgroundColorListener;
import edu.rice.cs.drjava.ui.ErrorCaretListener;
import edu.rice.cs.drjava.ui.ForegroundColorListener;
import edu.rice.cs.drjava.ui.KeyBindingManager;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.RightClickMouseAdapter;
import edu.rice.cs.util.Pair;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.HighlightManager;
import edu.rice.cs.util.text.SwingDocument;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Keymap;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefinitionsPane
extends AbstractDJPane
implements Finalizable<DefinitionsPane> {
    private static DefinitionsEditorKit EDITOR_KIT;
    private MainFrame _mainFrame;
    private final OpenDefinitionsDocument _doc;
    private UndoAction _undoAction;
    private RedoAction _redoAction;
    private boolean testVariable;
    private boolean _hasWarnedAboutModified = false;
    private boolean _antiAliasText = false;
    private HighlightManager.HighlightInfo _errorHighlightTag = null;
    static DefaultHighlighter.DefaultHighlightPainter BREAKPOINT_PAINTER;
    static DefaultHighlighter.DefaultHighlightPainter THREAD_PAINTER;
    public static final String INDENT_KEYMAP_NAME = "INDENT_KEYMAP";
    private UndoableEditListener _undoListener = new UndoableEditListener(){

        public void undoableEditHappened(UndoableEditEvent e) {
            UndoWithPosition undo = new UndoWithPosition(e.getEdit(), DefinitionsPane.this.getCaretPosition());
            if (!DefinitionsPane.this._inCompoundEdit) {
                CompoundUndoManager undoMan = DefinitionsPane.this._doc.getUndoManager();
                DefinitionsPane.this._inCompoundEdit = true;
                DefinitionsPane.this._compoundEditKey = undoMan.startCompoundEdit();
                DefinitionsPane.this.getUndoAction().updateUndoState();
                DefinitionsPane.this.getRedoAction().updateRedoState();
            }
            DefinitionsPane.this._doc.getUndoManager().addEdit(undo);
            DefinitionsPane.this.getRedoAction().setEnabled(false);
        }
    };
    private JMenuItem _toggleBreakpointMenuItem;
    private JPopupMenu _popMenu;
    private PopupMenuMouseAdapter _popupMenuMA;
    private ErrorCaretListener _errorListener;
    private ActionListener _setSizeListener = null;
    private Action _indentKeyActionTab = new IndentKeyActionTab();
    private Action _indentKeyActionLine = new IndentKeyAction("\n", (Action)this.getActionForKeyStroke(KeyStroke.getKeyStroke(10, 0)), true){

        protected int getIndentReason() {
            return 1;
        }
    };
    private Action _indentKeyActionSquiggly = new IndentKeyAction("}", this.getKeymap().getDefaultAction());
    private Action _indentKeyActionOpenSquiggly = new IndentKeyAction("{", this.getKeymap().getDefaultAction());
    private Action _indentKeyActionColon = new IndentKeyAction(":", this.getKeymap().getDefaultAction());
    private boolean _inCompoundEdit = false;
    private int _compoundEditKey;
    Keymap ourMap;
    private JScrollPane _scrollPane;
    private int _savedVScroll;
    private int _savedHScroll;
    private int _position;
    private int _selStart;
    private int _selEnd;
    private List<Pair<Option<Color>, OptionListener<Color>>> _colorOptionListeners = new LinkedList<Pair<Option<Color>, OptionListener<Color>>>();
    private List<Pair<Option<Boolean>, OptionListener<Boolean>>> _booleanOptionListeners = new LinkedList<Pair<Option<Boolean>, OptionListener<Boolean>>>();
    private List<FinalizationListener<DefinitionsPane>> _finalizationListeners = new LinkedList<FinalizationListener<DefinitionsPane>>();

    @Override
    protected void _updateMatchHighlight() {
        int to = this.getCaretPosition();
        int from = this.getDJDocument().balanceBackward();
        if (from > -1) {
            from = to - from;
            this._addHighlight(from, to);
            String matchText = this._matchText(from);
            if (matchText != null) {
                this._mainFrame.updateFileTitle(new StringBuffer().append("Matches: ").append(matchText).toString());
            } else {
                this._mainFrame.updateFileTitle();
            }
        } else {
            from = to;
            to = this.getDJDocument().balanceForward();
            if (to > -1) {
                this._addHighlight(from - 1, to += from);
            }
            this._mainFrame.updateFileTitle();
        }
    }

    private String _matchText(int braceIndex) {
        DJDocument doc = this.getDJDocument();
        String docText = doc.getText();
        if (docText.charAt(braceIndex) == '{') {
            Character charBefore = null;
            int charBeforeIndex = braceIndex - 1;
            boolean previousLine = false;
            if (charBeforeIndex != -1) {
                charBefore = new Character(docText.charAt(charBeforeIndex));
            }
            --charBeforeIndex;
            while (charBeforeIndex >= 0 && (charBefore.charValue() == '\n' || charBefore.charValue() == ' ')) {
                charBefore = new Character(docText.charAt(charBeforeIndex));
                if (!previousLine && charBefore.charValue() != '\n' && charBefore.charValue() != ' ') {
                    charBeforeIndex = braceIndex - 1;
                }
                if (charBefore.charValue() == '\n') {
                    previousLine = true;
                }
                --charBeforeIndex;
            }
            StringBuffer returnText = new StringBuffer(docText.substring(0, charBeforeIndex + 2));
            if (previousLine) {
                returnText.append("...");
            }
            returnText.append("{");
            int lastNewLineIndex = returnText.lastIndexOf("\n");
            return returnText.toString().substring(lastNewLineIndex + 1);
        }
        return null;
    }

    public DefinitionsPane(MainFrame mf, final OpenDefinitionsDocument doc) {
        super(new SwingDocument());
        this._mainFrame = mf;
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                DefinitionsPane.this._mainFrame.getModel().getDocumentNavigator().requestSelectionUpdate(doc);
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this._doc = doc;
        this._selStart = this._doc.getInitialSelectionStart();
        this._selEnd = this._doc.getInitialSelectionEnd();
        this._savedVScroll = this._doc.getInitialVerticalScroll();
        this._savedHScroll = this._doc.getInitialHorizontalScroll();
        this._resetUndo();
        Font mainFont = DrJava.getConfig().getSetting(FONT_MAIN);
        this.setFont(mainFont);
        this.setEditable(true);
        this.ourMap = DefinitionsPane.addKeymap(INDENT_KEYMAP_NAME, this.getKeymap());
        this.ourMap.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 0), this._indentKeyActionLine);
        this.ourMap.addActionForKeyStroke(KeyStroke.getKeyStroke(9, 0), this._indentKeyActionTab);
        this.ourMap.addActionForKeyStroke(KeyStroke.getKeyStroke('}'), this._indentKeyActionSquiggly);
        this.ourMap.addActionForKeyStroke(KeyStroke.getKeyStroke('{'), this._indentKeyActionOpenSquiggly);
        this.ourMap.addActionForKeyStroke(KeyStroke.getKeyStroke(':'), this._indentKeyActionColon);
        this.setKeymap(this.ourMap);
        this._antiAliasText = DrJava.getConfig().getSetting(TEXT_ANTIALIAS);
        OptionListener<Color> temp = new ForegroundColorListener(this);
        Pair<ColorOption, ForegroundColorListener> pair = new Pair<ColorOption, ForegroundColorListener>(OptionConstants.DEFINITIONS_NORMAL_COLOR, (ForegroundColorListener)temp);
        this._colorOptionListeners.add(pair);
        temp = new BackgroundColorListener(this);
        pair = new Pair<ColorOption, ForegroundColorListener>(OptionConstants.DEFINITIONS_BACKGROUND_COLOR, (ForegroundColorListener)temp);
        this._colorOptionListeners.add(pair);
        temp = new MatchColorOptionListener();
        pair = new Pair<ColorOption, ForegroundColorListener>(OptionConstants.DEFINITIONS_MATCH_COLOR, (ForegroundColorListener)temp);
        this._colorOptionListeners.add(pair);
        DrJava.getConfig().addOptionListener(OptionConstants.DEFINITIONS_MATCH_COLOR, temp);
        temp = new ErrorColorOptionListener();
        pair = new Pair<ColorOption, ForegroundColorListener>(OptionConstants.COMPILER_ERROR_COLOR, (ForegroundColorListener)temp);
        this._colorOptionListeners.add(pair);
        DrJava.getConfig().addOptionListener(OptionConstants.COMPILER_ERROR_COLOR, temp);
        temp = new BreakpointColorOptionListener();
        pair = new Pair<ColorOption, ForegroundColorListener>(OptionConstants.DEBUG_BREAKPOINT_COLOR, (ForegroundColorListener)temp);
        this._colorOptionListeners.add(pair);
        DrJava.getConfig().addOptionListener(OptionConstants.DEBUG_BREAKPOINT_COLOR, temp);
        temp = new ThreadColorOptionListener();
        pair = new Pair<ColorOption, ForegroundColorListener>(OptionConstants.DEBUG_THREAD_COLOR, (ForegroundColorListener)temp);
        this._colorOptionListeners.add(pair);
        DrJava.getConfig().addOptionListener(OptionConstants.DEBUG_THREAD_COLOR, temp);
        AntiAliasOptionListener aaTemp = new AntiAliasOptionListener();
        Pair<BooleanOption, AntiAliasOptionListener> aaPair = new Pair<BooleanOption, AntiAliasOptionListener>(OptionConstants.TEXT_ANTIALIAS, aaTemp);
        this._booleanOptionListeners.add(aaPair);
        DrJava.getConfig().addOptionListener(OptionConstants.TEXT_ANTIALIAS, aaTemp);
        this.createPopupMenu();
        this._popupMenuMA = new PopupMenuMouseAdapter();
        this.addMouseListener(this._popupMenuMA);
        this._highlightManager = new HighlightManager(this);
        int rate = this.getCaret().getBlinkRate();
        this.setCaret(new DefaultCaret(){

            public void focusLost(FocusEvent e) {
                this.setVisible(false);
            }
        });
        this.getCaret().setBlinkRate(rate);
    }

    public void endCompoundEdit() {
        if (this._inCompoundEdit) {
            CompoundUndoManager undoMan = this._doc.getUndoManager();
            this._inCompoundEdit = false;
            undoMan.endCompoundEdit(this._compoundEditKey);
        }
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        if (this._mainFrame.getAllowKeyEvents()) {
            KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
            Action a = KeyBindingManager.Singleton.get(ks);
            if (ks != KeyStrokeOption.NULL_KEYSTROKE && a != null) {
                this.endCompoundEdit();
                SwingUtilities.notifyAction(a, ks, e, e.getSource(), e.getModifiers());
                e.consume();
            } else {
                Keymap km = this.getKeymap();
                if (km.isLocallyDefined(ks) || km.isLocallyDefined(KeyStroke.getKeyStroke(ks.getKeyChar()))) {
                    if (e.getKeyCode() == 10) {
                        this.endCompoundEdit();
                    }
                    CompoundUndoManager undoMan = this._doc.getUndoManager();
                    super.processKeyEvent(e);
                    this.endCompoundEdit();
                } else {
                    if ((e.getModifiers() & 4) != 0 && e.getKeyCode() == 0) {
                        return;
                    }
                    if ((e.getModifiers() & 1) != 0) {
                        int newModifiers = e.getModifiers() & 0xFFFFFFFE;
                        KeyStroke newKs = KeyStroke.getKeyStroke(ks.getKeyCode(), newModifiers, ks.isOnKeyRelease());
                        String name = KeyBindingManager.Singleton.getName(newKs);
                        if (name != null && (name.equals("Delete Previous") || name.equals("Delete Next"))) {
                            this.endCompoundEdit();
                            SwingUtilities.notifyAction(KeyBindingManager.Singleton.get(newKs), newKs, e, e.getSource(), newModifiers);
                            e.consume();
                            return;
                        }
                    }
                    if (e.getID() != 400) {
                        super.processKeyEvent(e);
                        return;
                    }
                }
                this.testVariable = (e.getModifiers() & 8) != 0;
                super.processKeyEvent(e);
            }
        }
    }

    public static void setEditorKit(DefinitionsEditorKit editorKit) {
        EDITOR_KIT = editorKit;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this._antiAliasText && g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        super.paintComponent(g);
    }

    private void createPopupMenu() {
        this._popMenu = new JPopupMenu();
        this._popMenu.add(this._mainFrame.cutAction);
        this._popMenu.add(this._mainFrame.copyAction);
        this._popMenu.add(this._mainFrame.pasteAction);
        this._popMenu.addSeparator();
        JMenuItem indentItem = new JMenuItem("Indent Line(s)");
        indentItem.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent ae) {
                DefinitionsPane.this.indent();
            }
        });
        this._popMenu.add(indentItem);
        JMenuItem commentLinesItem = new JMenuItem("Comment Line(s)");
        commentLinesItem.addActionListener(new AbstractAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent ae) {
                DefinitionsPane.this._mainFrame.hourglassOn();
                try {
                    DefinitionsPane.this._doc.setCurrentLocation(DefinitionsPane.this.getCaretPosition());
                    DefinitionsPane.this._commentLines();
                }
                finally {
                    DefinitionsPane.this._mainFrame.hourglassOff();
                }
            }
        });
        this._popMenu.add(commentLinesItem);
        JMenuItem uncommentLinesItem = new JMenuItem("Uncomment Line(s)");
        uncommentLinesItem.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent ae) {
                DefinitionsPane.this._doc.setCurrentLocation(DefinitionsPane.this.getCaretPosition());
                DefinitionsPane.this._uncommentLines();
            }
        });
        this._popMenu.add(uncommentLinesItem);
        if (this._mainFrame.getModel().getDebugger().isAvailable()) {
            this._popMenu.addSeparator();
            JMenuItem breakpointItem = new JMenuItem("Toggle Breakpoint");
            breakpointItem.addActionListener(new AbstractAction(){

                public void actionPerformed(ActionEvent ae) {
                    DefinitionsPane.this.setCaretPosition(DefinitionsPane.this.viewToModel(DefinitionsPane.this._popupMenuMA.getLastMouseClick().getPoint()));
                    DefinitionsPane.this._mainFrame.debuggerToggleBreakpoint();
                }
            });
            this._toggleBreakpointMenuItem = this._popMenu.add(breakpointItem);
            this._toggleBreakpointMenuItem.setEnabled(false);
        }
    }

    private void _commentLines() {
        this._mainFrame.commentLines();
    }

    private void _uncommentLines() {
        this._mainFrame.uncommentLines();
    }

    public UndoAction getUndoAction() {
        return this._undoAction;
    }

    public RedoAction getRedoAction() {
        return this._redoAction;
    }

    public OpenDefinitionsDocument getOpenDefDocument() {
        return this._doc;
    }

    @Override
    public DJDocument getDJDocument() {
        return this._doc;
    }

    public HighlightManager getHighlightManager() {
        return this._highlightManager;
    }

    public void setPositionAndScroll(int pos) {
        try {
            this.setCaretPosition(pos);
            this.scrollRectToVisible(this.modelToView(pos));
        }
        catch (BadLocationException ble) {
            throw new UnexpectedException(ble);
        }
    }

    @Override
    public void setDocument(Document d) {
        if (!(this._doc == null || d != null && d.equals(this._doc))) {
            throw new IllegalStateException("Cannot set the document of a DefinitionsPane to a different document.");
        }
        super.setDocument(d);
    }

    public boolean checkAltKey() {
        return this.testVariable;
    }

    public void addErrorCaretListener(ErrorCaretListener listener) {
        this._errorListener = listener;
        this.addCaretListener(listener);
    }

    public ErrorCaretListener getErrorCaretListener() {
        return this._errorListener;
    }

    public void addErrorHighlight(int from, int to) {
        this.removeErrorHighlight();
        this._errorHighlightTag = this._highlightManager.addHighlight(from, to, ERROR_PAINTER);
    }

    public void removeErrorHighlight() {
        if (this._errorHighlightTag != null) {
            this._errorHighlightTag.remove();
            this._errorHighlightTag = null;
        }
    }

    public boolean hasWarnedAboutModified() {
        return this._hasWarnedAboutModified;
    }

    public void hasWarnedAboutModified(boolean hasWarned) {
        this._hasWarnedAboutModified = hasWarned;
    }

    public void addBreakpointHighlight(Breakpoint bp) {
    }

    public void removeBreakpointHighlight(Breakpoint bp) {
    }

    private void setDocument(OpenDefinitionsDocument doc) {
        super.setDocument(doc);
        this._resetUndo();
    }

    public void setScrollPane(JScrollPane s) {
        this._scrollPane = s;
    }

    public void notifyInactive() {
        try {
            this.getOpenDefDocument().setCurrentLocation(this.getCaretPosition());
            this.removeErrorHighlight();
            this._position = this._doc.getCurrentLocation();
            this._selStart = this.getSelectionStart();
            this._selEnd = this.getSelectionEnd();
            this._savedVScroll = this._scrollPane.getVerticalScrollBar().getValue();
            this._savedHScroll = this._scrollPane.getHorizontalScrollBar().getValue();
            super.setDocument(this.NULL_DOCUMENT);
        }
        catch (NoSuchDocumentException noSuchDocumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyActive() {
        int len;
        super.setDocument(this._doc);
        if (this._doc.getUndoableEditListeners().length == 0) {
            this._resetUndo();
        }
        if ((len = this.getDJDocument().getLength()) < this._position) {
            this._position = len;
            this._selStart = len;
            this._selEnd = len;
        }
        this._doc.acquireWriteLock();
        try {
            if (this._position == this._selStart) {
                this.setCaretPosition(this._selEnd);
                this.moveCaretPosition(this._selStart);
                this._doc.setCurrentLocation(this._selStart);
            } else {
                this.setCaretPosition(this._selStart);
                this.moveCaretPosition(this._selEnd);
                this._doc.setCurrentLocation(this._selEnd);
            }
        }
        finally {
            this._doc.releaseWriteLock();
        }
        this._scrollPane.getVerticalScrollBar().setValue(this._savedVScroll);
        this._scrollPane.getHorizontalScrollBar().setValue(this._savedHScroll);
    }

    public int getVerticalScroll() {
        if (this.getDocument() == this.NULL_DOCUMENT) {
            return this._savedVScroll;
        }
        return this._scrollPane.getVerticalScrollBar().getValue();
    }

    public int getHorizontalScroll() {
        if (this.getDocument() == this.NULL_DOCUMENT) {
            return this._savedHScroll;
        }
        return this._scrollPane.getHorizontalScrollBar().getValue();
    }

    public int getCurrentLine() {
        try {
            int pos = this.getCaretPosition();
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            Rectangle startRect = this.modelToView(pos);
            if (startRect == null) {
                return 1;
            }
            return new Double(startRect.getY() / (double)metrics.getHeight()).intValue() + 1;
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
    }

    public int getCurrentCol() {
        return this._doc.getCurrentCol();
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        if (this._setSizeListener != null) {
            this._setSizeListener.actionPerformed(null);
        }
    }

    public void addSetSizeListener(ActionListener listener) {
        this._setSizeListener = listener;
    }

    public void removeSetSizeListener() {
        this._setSizeListener = null;
    }

    public void centerViewOnOffset(int offset) {
        try {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            JViewport defViewPort = this._mainFrame.getDefViewport();
            double viewWidth = defViewPort.getWidth();
            double viewHeight = defViewPort.getHeight();
            Rectangle startRect = this.modelToView(offset);
            if (startRect != null) {
                int startRectX = (int)startRect.getX();
                int startRectY = (int)startRect.getY();
                startRect.setLocation(startRectX - (int)(viewWidth / 2.0), startRectY - (int)(viewHeight / 2.0));
                Point endPoint = new Point(startRectX + (int)(viewWidth / 2.0), startRectY + (int)(viewHeight / 2.0 + (double)(metrics.getHeight() / 2)));
                startRect.add(endPoint);
                this.scrollRectToVisible(startRect);
            }
            this.removeSetSizeListener();
            this.setCaretPosition(offset);
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
    }

    public void centerViewOnLine(int lineNumber) {
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        Point p = new Point(0, metrics.getHeight() * lineNumber);
        int offset = this.viewToModel(p);
        this.centerViewOnOffset(offset);
    }

    @Override
    public void select(int selectionStart, int selectionEnd) {
        if (selectionStart < 0) {
            selectionStart = 0;
        }
        if (selectionEnd < 0) {
            selectionEnd = 0;
        }
        this.setCaretPosition(selectionStart);
        this.moveCaretPosition(selectionEnd);
    }

    public void resetUndo() {
        this._doc.getUndoManager().discardAllEdits();
        this._undoAction.updateUndoState();
        this._redoAction.updateRedoState();
    }

    private void _resetUndo() {
        if (this._undoAction == null) {
            this._undoAction = new UndoAction();
        }
        if (this._redoAction == null) {
            this._redoAction = new RedoAction();
        }
        this._doc.resetUndoManager();
        this.getDocument().addUndoableEditListener(this._undoListener);
        this._undoAction.updateUndoState();
        this._redoAction.updateRedoState();
    }

    @Override
    protected EditorKit createDefaultEditorKit() {
        return EDITOR_KIT;
    }

    @Override
    protected boolean shouldIndent(int selStart, int selEnd) {
        if (selEnd > selStart + 10000) {
            Object[] options = new Object[]{"Yes", "No"};
            int n = JOptionPane.showOptionDialog(this._mainFrame, "Re-indenting this block may take a very long time.  Are you sure?", "Confirm Re-indent", 0, 3, null, options, options[1]);
            switch (n) {
                case -1: 
                case 1: 
                case 2: {
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    @Override
    protected void indentLines(int selStart, int selEnd, int reason, ProgressMonitor pm) {
        try {
            this._doc.indentLines(selStart, selEnd, reason, pm);
            this.endCompoundEdit();
        }
        catch (OperationCanceledException oce) {
            this.endCompoundEdit();
            this._doc.getUndoManager().undo();
            throw new UnexpectedException(oce);
        }
        catch (RuntimeException e) {
            this.endCompoundEdit();
            throw e;
        }
        this.setCaretPosition(this._doc.getCurrentLocation());
    }

    public void close() {
        for (Pair<Option<Color>, OptionListener<Color>> pair : this._colorOptionListeners) {
            DrJava.getConfig().removeOptionListener(pair.getFirst(), pair.getSecond());
        }
        for (Pair<Option<Serializable>, OptionListener<Serializable>> pair : this._booleanOptionListeners) {
            DrJava.getConfig().removeOptionListener(pair.getFirst(), pair.getSecond());
        }
        this._colorOptionListeners.clear();
        this._booleanOptionListeners.clear();
        this.ourMap.removeBindings();
        DefinitionsPane.removeKeymap(this.ourMap.getName());
        this._popMenu.removeAll();
    }

    @Override
    public void addFinalizationListener(FinalizationListener<DefinitionsPane> fl) {
        this._finalizationListeners.add(fl);
    }

    @Override
    public List<FinalizationListener<DefinitionsPane>> getFinalizationListeners() {
        return this._finalizationListeners;
    }

    protected void finalize() {
        FinalizationEvent<DefinitionsPane> fe = new FinalizationEvent<DefinitionsPane>(this);
        for (FinalizationListener<DefinitionsPane> fl : this._finalizationListeners) {
            fl.finalized(fe);
        }
    }

    static {
        BREAKPOINT_PAINTER = new DefaultHighlighter.DefaultHighlightPainter(DrJava.getConfig().getSetting(DEBUG_BREAKPOINT_COLOR));
        THREAD_PAINTER = new DefaultHighlighter.DefaultHighlightPainter(DrJava.getConfig().getSetting(DEBUG_THREAD_COLOR));
    }

    private class UndoWithPosition
    implements UndoableEdit {
        private UndoableEdit _undo;
        private int _pos;

        public UndoWithPosition(UndoableEdit undo, int pos) {
            this._undo = undo;
            this._pos = pos;
        }

        public int getPosition() {
            return this._pos;
        }

        public boolean addEdit(UndoableEdit ue) {
            return this._undo.addEdit(ue);
        }

        public boolean canRedo() {
            return this._undo.canRedo();
        }

        public boolean canUndo() {
            return this._undo.canUndo();
        }

        public void die() {
            this._undo.die();
        }

        public String getPresentationName() {
            return this._undo.getPresentationName();
        }

        public String getUndoPresentationName() {
            return this._undo.getUndoPresentationName();
        }

        public String getRedoPresentationName() {
            return this._undo.getRedoPresentationName();
        }

        public boolean isSignificant() {
            return this._undo.isSignificant();
        }

        public void redo() {
            this._undo.redo();
            if (this._pos > -1) {
                DefinitionsPane.this.setCaretPosition(this._pos);
            }
        }

        public boolean replaceEdit(UndoableEdit ue) {
            return this._undo.replaceEdit(ue);
        }

        public void undo() {
            if (this._pos > -1) {
                DefinitionsPane.this.setCaretPosition(this._pos);
            }
            this._undo.undo();
        }
    }

    public class RedoAction
    extends AbstractAction {
        private RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                DefinitionsPane.this._doc.getUndoManager().redo();
                DefinitionsPane.this._doc.updateModifiedSinceSave();
                DefinitionsPane.this._mainFrame.updateFileTitle();
            }
            catch (CannotRedoException ex) {
                throw new UnexpectedException(ex);
            }
            this.updateRedoState();
            DefinitionsPane.this._undoAction.updateUndoState();
        }

        protected void updateRedoState() {
            if (DefinitionsPane.this._doc.undoManagerCanRedo()) {
                this.setEnabled(true);
                this.putValue("Name", DefinitionsPane.this._doc.getUndoManager().getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }
    }

    public class UndoAction
    extends AbstractAction {
        private UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                DefinitionsPane.this._doc.getUndoManager().undo();
                DefinitionsPane.this._doc.updateModifiedSinceSave();
                DefinitionsPane.this._mainFrame.updateFileTitle();
            }
            catch (CannotUndoException ex) {
                throw new UnexpectedException(ex);
            }
            this.updateUndoState();
            DefinitionsPane.this._redoAction.updateRedoState();
        }

        protected void updateUndoState() {
            if (DefinitionsPane.this._doc.undoManagerCanUndo()) {
                this.setEnabled(true);
                this.putValue("Name", DefinitionsPane.this._doc.getUndoManager().getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }
    }

    private class PopupMenuMouseAdapter
    extends RightClickMouseAdapter {
        private MouseEvent _lastMouseClick = null;

        private PopupMenuMouseAdapter() {
        }

        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            this._lastMouseClick = e;
            DefinitionsPane.this.endCompoundEdit();
            if (DefinitionsPane.this.viewToModel(e.getPoint()) < DefinitionsPane.this.getSelectionStart() || DefinitionsPane.this.viewToModel(e.getPoint()) > DefinitionsPane.this.getSelectionEnd()) {
                DefinitionsPane.this.setCaretPosition(DefinitionsPane.this.viewToModel(e.getPoint()));
            }
            if (DefinitionsPane.this._toggleBreakpointMenuItem != null) {
                DefinitionsPane.this._toggleBreakpointMenuItem.setEnabled(DefinitionsPane.this._mainFrame.inDebugMode());
            }
        }

        protected void _popupAction(MouseEvent e) {
            DefinitionsPane.this.requestFocusInWindow();
            DefinitionsPane.this._popMenu.show(e.getComponent(), e.getX(), e.getY());
        }

        public MouseEvent getLastMouseClick() {
            return this._lastMouseClick;
        }
    }

    private class IndentKeyAction
    extends AbstractAction {
        private final String _key;
        private final Action _defaultAction;
        private final boolean _indentNonCode;

        IndentKeyAction(String key, Action defaultAction) {
            this(key, defaultAction, false);
        }

        IndentKeyAction(String key, Action defaultAction, boolean indentNonCode) {
            this._key = key;
            this._defaultAction = defaultAction;
            this._indentNonCode = indentNonCode;
        }

        protected int getIndentReason() {
            return 0;
        }

        public void actionPerformed(ActionEvent e) {
            this._defaultAction.actionPerformed(e);
            DefinitionsPane.this._doc.setCurrentLocation(DefinitionsPane.this.getCaretPosition());
            ReducedModelState state = DefinitionsPane.this._doc.getStateAtCurrent();
            if (state.equals(ReducedModelState.FREE) || this._indentNonCode) {
                DefinitionsPane.this.indent(this.getIndentReason());
            }
        }
    }

    private class IndentKeyActionTab
    extends AbstractAction {
        private IndentKeyActionTab() {
        }

        public void actionPerformed(ActionEvent e) {
            DefinitionsPane.this.indent();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AntiAliasOptionListener
    implements OptionListener<Boolean> {
        private AntiAliasOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Boolean> oce) {
            DefinitionsPane.this._antiAliasText = (Boolean)oce.value;
            DefinitionsPane.this.repaint();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThreadColorOptionListener
    implements OptionListener<Color> {
        private ThreadColorOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Color> oce) {
            THREAD_PAINTER = new DefaultHighlighter.DefaultHighlightPainter((Color)oce.value);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BreakpointColorOptionListener
    implements OptionListener<Color> {
        private BreakpointColorOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Color> oce) {
            BREAKPOINT_PAINTER = new DefaultHighlighter.DefaultHighlightPainter((Color)oce.value);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ErrorColorOptionListener
    implements OptionListener<Color> {
        private ErrorColorOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Color> oce) {
            AbstractDJPane.ERROR_PAINTER = new DefaultHighlighter.DefaultHighlightPainter((Color)oce.value);
            if (DefinitionsPane.this._errorHighlightTag != null) {
                int start = DefinitionsPane.this._errorHighlightTag.getStartOffset();
                int end = DefinitionsPane.this._errorHighlightTag.getEndOffset();
                DefinitionsPane.this._errorHighlightTag.remove();
                DefinitionsPane.this.addErrorHighlight(start, end);
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MatchColorOptionListener
    implements OptionListener<Color> {
        private MatchColorOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Color> oce) {
            AbstractDJPane.MATCH_PAINTER = new DefaultHighlighter.DefaultHighlightPainter((Color)oce.value);
            if (DefinitionsPane.this._matchHighlight != null) {
                int start = DefinitionsPane.this._matchHighlight.getStartOffset();
                int end = DefinitionsPane.this._matchHighlight.getEndOffset();
                DefinitionsPane.this._matchHighlight.remove();
                DefinitionsPane.this._addHighlight(start, end);
            }
        }
    }
}

