/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.SingleDisplayModel;
import edu.rice.cs.drjava.model.debug.Breakpoint;
import edu.rice.cs.drjava.model.debug.DebugException;
import edu.rice.cs.drjava.model.debug.DebugListener;
import edu.rice.cs.drjava.model.debug.DebugStackData;
import edu.rice.cs.drjava.model.debug.DebugThreadData;
import edu.rice.cs.drjava.model.debug.DebugWatchData;
import edu.rice.cs.drjava.model.debug.Debugger;
import edu.rice.cs.drjava.ui.BackgroundColorListener;
import edu.rice.cs.drjava.ui.CommonCloseButton;
import edu.rice.cs.drjava.ui.ForegroundColorListener;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.RightClickMouseAdapter;
import edu.rice.cs.util.swing.Utilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DebugPanel
extends JPanel
implements OptionConstants {
    private JSplitPane _tabsPane;
    private JTabbedPane _leftPane;
    private JTabbedPane _rightPane;
    private JPanel _tabsAndStatusPane;
    private JTable _watchTable;
    private DefaultMutableTreeNode _breakpointRootNode;
    private DefaultTreeModel _bpTreeModel;
    private JTree _bpTree;
    private JTable _stackTable;
    private JTable _threadTable;
    private long _currentThreadID;
    private JPopupMenu _threadSuspendedPopupMenu;
    private JPopupMenu _stackPopupMenu;
    private JPopupMenu _breakpointPopupMenu;
    private JPopupMenu _watchPopupMenu;
    private DebugThreadData _threadInPopup;
    private final SingleDisplayModel _model;
    private final MainFrame _frame;
    private final Debugger _debugger;
    private JPanel _buttonPanel;
    private JButton _closeButton;
    private JButton _resumeButton;
    private JButton _stepIntoButton;
    private JButton _stepOverButton;
    private JButton _stepOutButton;
    private JLabel _statusBar;
    private Vector<DebugWatchData> _watches;
    private Vector<DebugThreadData> _threads;
    private Vector<DebugStackData> _stackFrames;
    private DefaultTreeCellRenderer dtcr;

    public DebugPanel(MainFrame frame) {
        this.setLayout(new BorderLayout());
        this._frame = frame;
        this._model = frame.getModel();
        this._debugger = this._model.getDebugger();
        this._watches = new Vector();
        this._threads = new Vector();
        this._stackFrames = new Vector();
        this._leftPane = new JTabbedPane();
        this._rightPane = new JTabbedPane();
        this._setupTabPanes();
        this._tabsPane = new JSplitPane(1, true, this._leftPane, this._rightPane);
        this._tabsPane.setOneTouchExpandable(true);
        this._tabsPane.setDividerLocation((int)((double)this._frame.getWidth() / 2.5));
        this._tabsAndStatusPane = new JPanel(new BorderLayout());
        this._tabsAndStatusPane.add((Component)this._tabsPane, "Center");
        this._statusBar = new JLabel("");
        this._statusBar.setForeground(Color.blue.darker());
        this._tabsAndStatusPane.add((Component)this._statusBar, "South");
        this.add((Component)this._tabsAndStatusPane, "Center");
        this._buttonPanel = new JPanel(new BorderLayout());
        this._setupButtonPanel();
        this.add((Component)this._buttonPanel, "East");
        this._debugger.addListener(new DebugPanelListener());
        DebugPanel._setColors(this._watchTable);
        DebugPanel._setColors(this._bpTree);
        DebugPanel._setColors(this._stackTable);
        DebugPanel._setColors(this._threadTable);
    }

    private static void _setColors(Component c) {
        new ForegroundColorListener(c);
        new BackgroundColorListener(c);
    }

    public void updateData() {
        if (this._debugger.isReady()) {
            try {
                this._watches = this._debugger.getWatches();
                this._stackFrames = this._debugger.isCurrentThreadSuspended() ? this._debugger.getCurrentStackFrameData() : new Vector();
                this._threads = this._debugger.getCurrentThreadData();
            }
            catch (DebugException de) {
                this._frame._showDebugError(de);
            }
        } else {
            this._watches = new Vector();
            this._threads = new Vector();
            this._stackFrames = new Vector();
        }
        ((AbstractTableModel)this._watchTable.getModel()).fireTableDataChanged();
        ((AbstractTableModel)this._stackTable.getModel()).fireTableDataChanged();
        ((AbstractTableModel)this._threadTable.getModel()).fireTableDataChanged();
    }

    private void _setupTabPanes() {
        this._initWatchTable();
        this._breakpointRootNode = new DefaultMutableTreeNode("Breakpoints");
        this._bpTreeModel = new DefaultTreeModel(this._breakpointRootNode);
        this._bpTree = new BPTree(this._bpTreeModel);
        this._bpTree.setEditable(false);
        this._bpTree.getSelectionModel().setSelectionMode(1);
        this._bpTree.setShowsRootHandles(true);
        this._bpTree.setRootVisible(false);
        this._bpTree.putClientProperty("JTree.lineStyle", "Angled");
        this._bpTree.setScrollsOnExpand(true);
        this.dtcr = new BreakPointRenderer();
        this.dtcr.setOpaque(false);
        DebugPanel._setColors(this.dtcr);
        this._bpTree.setCellRenderer(this.dtcr);
        this._leftPane.addTab("Breakpoints", new JScrollPane(this._bpTree));
        this._stackTable = new JTable(new StackTableModel());
        this._stackTable.addMouseListener(new StackMouseAdapter());
        this._rightPane.addTab("Stack", new JScrollPane(this._stackTable));
        this._initThreadTable();
        TableColumn methodColumn = this._stackTable.getColumnModel().getColumn(0);
        TableColumn lineColumn = this._stackTable.getColumnModel().getColumn(1);
        methodColumn.setPreferredWidth(7 * lineColumn.getPreferredWidth());
        this._initPopup();
    }

    private void _initWatchTable() {
        this._watchTable = new JTable(new WatchTableModel());
        this._watchTable.setDefaultEditor(this._watchTable.getColumnClass(0), new WatchEditor());
        this._watchTable.setDefaultRenderer(this._watchTable.getColumnClass(0), new WatchRenderer());
        this._leftPane.addTab("Watches", new JScrollPane(this._watchTable));
    }

    private void _initThreadTable() {
        this._threadTable = new JTable(new ThreadTableModel());
        this._threadTable.addMouseListener(new ThreadMouseAdapter());
        this._rightPane.addTab("Threads", new JScrollPane(this._threadTable));
        TableColumn nameColumn = this._threadTable.getColumnModel().getColumn(0);
        TableColumn statusColumn = this._threadTable.getColumnModel().getColumn(1);
        nameColumn.setPreferredWidth(2 * statusColumn.getPreferredWidth());
        this._currentThreadID = 0L;
        DefaultTableCellRenderer threadTableRenderer = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component renderer = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this._setThreadCellFont(row);
                return renderer;
            }

            private void _setThreadCellFont(int row) {
                DebugThreadData currThread = (DebugThreadData)DebugPanel.this._threads.get(row);
                if (currThread.getUniqueID() == DebugPanel.this._currentThreadID && currThread.isSuspended()) {
                    this.setFont(this.getFont().deriveFont(1));
                }
            }
        };
        this._threadTable.getColumnModel().getColumn(0).setCellRenderer(threadTableRenderer);
        this._threadTable.getColumnModel().getColumn(1).setCellRenderer(threadTableRenderer);
    }

    private void _setupButtonPanel() {
        JPanel mainButtons = new JPanel();
        JPanel closeButtonPanel = new JPanel(new BorderLayout());
        mainButtons.setLayout(new GridLayout(0, 1));
        AbstractAction resumeAction = new AbstractAction("Resume"){

            public void actionPerformed(ActionEvent ae) {
                try {
                    DebugPanel.this._frame.debuggerResume();
                }
                catch (DebugException de) {
                    DebugPanel.this._frame._showDebugError(de);
                }
            }
        };
        this._resumeButton = new JButton(resumeAction);
        AbstractAction stepIntoAction = new AbstractAction("Step Into"){

            public void actionPerformed(ActionEvent ae) {
                DebugPanel.this._frame.debuggerStep(1);
            }
        };
        this._stepIntoButton = new JButton(stepIntoAction);
        AbstractAction stepOverAction = new AbstractAction("Step Over"){

            public void actionPerformed(ActionEvent ae) {
                DebugPanel.this._frame.debuggerStep(2);
            }
        };
        this._stepOverButton = new JButton(stepOverAction);
        AbstractAction stepOutAction = new AbstractAction("Step Out"){

            public void actionPerformed(ActionEvent ae) {
                DebugPanel.this._frame.debuggerStep(3);
            }
        };
        this._stepOutButton = new JButton(stepOutAction);
        ActionListener closeListener = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                DebugPanel.this._frame.debuggerToggle();
            }
        };
        this._closeButton = new CommonCloseButton(closeListener);
        closeButtonPanel.add((Component)this._closeButton, "North");
        mainButtons.add(this._resumeButton);
        mainButtons.add(this._stepIntoButton);
        mainButtons.add(this._stepOverButton);
        mainButtons.add(this._stepOutButton);
        this.disableButtons();
        this._buttonPanel.add((Component)mainButtons, "Center");
        this._buttonPanel.add((Component)closeButtonPanel, "East");
    }

    private void _initPopup() {
        AbstractAction selectAction = new AbstractAction("Select Thread"){

            public void actionPerformed(ActionEvent e) {
                DebugPanel.this._selectCurrentThread();
            }
        };
        this._threadSuspendedPopupMenu = new JPopupMenu("Thread Selection");
        this._threadSuspendedPopupMenu.add(selectAction);
        this._threadSuspendedPopupMenu.add(new AbstractAction("Resume Thread"){

            public void actionPerformed(ActionEvent e) {
                try {
                    if (DebugPanel.this._threadInPopup.isSuspended()) {
                        DebugPanel.this._debugger.resume(DebugPanel.this._threadInPopup);
                    }
                }
                catch (DebugException dbe) {
                    DebugPanel.this._frame._showDebugError(dbe);
                }
            }
        });
        this._stackPopupMenu = new JPopupMenu("Stack Selection");
        this._stackPopupMenu.add(new AbstractAction("Scroll to Source"){

            public void actionPerformed(ActionEvent e) {
                try {
                    DebugPanel.this._debugger.scrollToSource(DebugPanel.this.getSelectedStackItem());
                }
                catch (DebugException de) {
                    DebugPanel.this._frame._showDebugError(de);
                }
            }
        });
        this._breakpointPopupMenu = new JPopupMenu("Breakpoint");
        this._breakpointPopupMenu.add(new AbstractAction("Scroll to Source"){

            public void actionPerformed(ActionEvent e) {
                DebugPanel.this._scrollToSourceIfBreakpoint();
            }
        });
        this._breakpointPopupMenu.add(new AbstractAction("Remove Breakpoint"){

            public void actionPerformed(ActionEvent e) {
                try {
                    Breakpoint bp = DebugPanel.this._getSelectedBreakpoint();
                    if (bp != null) {
                        DebugPanel.this._debugger.removeBreakpoint(bp);
                    }
                }
                catch (DebugException de) {
                    DebugPanel.this._frame._showDebugError(de);
                }
            }
        });
        this._bpTree.addMouseListener(new BreakpointMouseAdapter());
        this._watchPopupMenu = new JPopupMenu("Watches");
        this._watchPopupMenu.add(new AbstractAction("Remove Watch"){

            public void actionPerformed(ActionEvent e) {
                try {
                    DebugPanel.this._debugger.removeWatch(DebugPanel.this._watchTable.getSelectedRow());
                    DebugPanel.this._watchTable.revalidate();
                    DebugPanel.this._watchTable.repaint();
                }
                catch (DebugException de) {
                    DebugPanel.this._frame._showDebugError(de);
                }
            }
        });
        this._watchTable.addMouseListener(new DebugTableMouseAdapter(this._watchTable){

            protected void _showPopup(MouseEvent e) {
                if (DebugPanel.this._watchTable.getSelectedRow() < DebugPanel.this._watchTable.getRowCount() - 1) {
                    DebugPanel.this._watchPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            protected void _action() {
            }
        });
    }

    private void _selectCurrentThread() {
        if (this._threadInPopup.isSuspended()) {
            try {
                this._debugger.setCurrentThread(this._threadInPopup);
            }
            catch (DebugException de) {
                this._frame._showDebugError(de);
            }
        }
    }

    private Breakpoint _getSelectedBreakpoint() throws DebugException {
        TreePath path = this._bpTree.getSelectionPath();
        if (path == null || path.getPathCount() != 3) {
            return null;
        }
        DefaultMutableTreeNode lineNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        int line = (Integer)lineNode.getUserObject();
        DefaultMutableTreeNode classNameNode = (DefaultMutableTreeNode)path.getPathComponent(1);
        String className = (String)classNameNode.getUserObject();
        return this._debugger.getBreakpoint(line, className);
    }

    private void _scrollToSourceIfBreakpoint() {
        try {
            Breakpoint bp = this._getSelectedBreakpoint();
            if (bp != null) {
                this._debugger.scrollToSource(bp);
            }
        }
        catch (DebugException de) {
            this._frame._showDebugError(de);
        }
    }

    public DebugThreadData getSelectedThread() {
        int row = this._threadTable.getSelectedRow();
        if (row == -1) {
            row = 0;
        }
        return this._threads.get(row);
    }

    public DebugStackData getSelectedStackItem() {
        return this._stackFrames.get(this._stackTable.getSelectedRow());
    }

    public DebugWatchData getSelectedWatch() {
        return this._watches.get(this._watchTable.getSelectedRow());
    }

    public void setThreadDependentButtons(boolean isSuspended) {
        this._resumeButton.setEnabled(isSuspended);
        this._stepIntoButton.setEnabled(isSuspended);
        this._stepOverButton.setEnabled(isSuspended);
        this._stepOutButton.setEnabled(isSuspended);
    }

    public void disableButtons() {
        this.setThreadDependentButtons(false);
    }

    public void setStatusText(String text) {
        this._statusBar.setText(text);
    }

    public String getStatusText() {
        return this._statusBar.getText();
    }

    private class BPTree
    extends JTree {
        public BPTree(DefaultTreeModel s) {
            super(s);
        }

        public void setForeground(Color c) {
            super.setForeground(c);
            if (DebugPanel.this.dtcr != null) {
                DebugPanel.this.dtcr.setTextNonSelectionColor(c);
            }
        }

        public void setBackground(Color c) {
            super.setBackground(c);
            if (DebugPanel.this != null && DebugPanel.this.dtcr != null) {
                DebugPanel.this.dtcr.setBackgroundNonSelectionColor(c);
            }
        }
    }

    private abstract class DebugTableMouseAdapter
    extends RightClickMouseAdapter {
        protected JTable _table;
        protected int _lastRow;

        public DebugTableMouseAdapter(JTable table) {
            this._table = table;
            this._lastRow = -1;
        }

        protected abstract void _showPopup(MouseEvent var1);

        protected abstract void _action();

        protected void _popupAction(MouseEvent e) {
            this._lastRow = this._table.rowAtPoint(e.getPoint());
            this._table.setRowSelectionInterval(this._lastRow, this._lastRow);
            this._showPopup(e);
        }

        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                this._lastRow = this._table.rowAtPoint(e.getPoint());
                this._action();
            }
        }
    }

    private class StackMouseAdapter
    extends DebugTableMouseAdapter {
        public StackMouseAdapter() {
            super(DebugPanel.this._stackTable);
        }

        protected void _showPopup(MouseEvent e) {
            DebugPanel.this._stackPopupMenu.show(e.getComponent(), e.getX(), e.getY());
        }

        protected void _action() {
            try {
                DebugPanel.this._debugger.scrollToSource((DebugStackData)DebugPanel.this._stackFrames.get(this._lastRow));
            }
            catch (DebugException de) {
                DebugPanel.this._frame._showDebugError(de);
            }
        }
    }

    private class ThreadMouseAdapter
    extends DebugTableMouseAdapter {
        public ThreadMouseAdapter() {
            super(DebugPanel.this._threadTable);
        }

        protected void _showPopup(MouseEvent e) {
            DebugPanel.this._threadInPopup = (DebugThreadData)DebugPanel.this._threads.get(this._lastRow);
            if (DebugPanel.this._threadInPopup.isSuspended()) {
                DebugPanel.this._threadSuspendedPopupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        protected void _action() {
            DebugPanel.this._threadInPopup = (DebugThreadData)DebugPanel.this._threads.get(this._lastRow);
            DebugPanel.this._selectCurrentThread();
        }
    }

    private class BreakpointMouseAdapter
    extends RightClickMouseAdapter {
        private BreakpointMouseAdapter() {
        }

        protected void _popupAction(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            TreePath path = DebugPanel.this._bpTree.getPathForLocation(x, y);
            if (path != null && path.getPathCount() == 3) {
                DebugPanel.this._bpTree.setSelectionRow(DebugPanel.this._bpTree.getRowForLocation(x, y));
                DebugPanel.this._breakpointPopupMenu.show(e.getComponent(), x, y);
            }
        }

        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                DebugPanel.this._scrollToSourceIfBreakpoint();
            }
        }
    }

    class DebugPanelListener
    implements DebugListener {
        DebugPanelListener() {
        }

        public void debuggerStarted() {
        }

        public void debuggerShutdown() {
        }

        public void threadLocationUpdated(OpenDefinitionsDocument doc, int lineNumber, boolean shouldHighlight) {
        }

        public void breakpointSet(Breakpoint bp) {
            DefaultMutableTreeNode bpDocNode = new DefaultMutableTreeNode(bp.getClassName());
            Enumeration<TreeNode> documents = DebugPanel.this._breakpointRootNode.children();
            while (documents.hasMoreElements()) {
                DefaultMutableTreeNode doc = (DefaultMutableTreeNode)documents.nextElement();
                if (!doc.getUserObject().equals(bpDocNode.getUserObject())) continue;
                Enumeration<TreeNode> lineNumbers = doc.children();
                while (lineNumbers.hasMoreElements()) {
                    DefaultMutableTreeNode lineNumber = (DefaultMutableTreeNode)lineNumbers.nextElement();
                    if ((Integer)lineNumber.getUserObject() <= bp.getLineNumber()) continue;
                    DefaultMutableTreeNode newBreakpoint = new DefaultMutableTreeNode(new Integer(bp.getLineNumber()));
                    DebugPanel.this._bpTreeModel.insertNodeInto(newBreakpoint, doc, doc.getIndex(lineNumber));
                    DebugPanel.this._bpTree.scrollPathToVisible(new TreePath(newBreakpoint.getPath()));
                    return;
                }
                DefaultMutableTreeNode newBreakpoint = new DefaultMutableTreeNode(new Integer(bp.getLineNumber()));
                DebugPanel.this._bpTreeModel.insertNodeInto(newBreakpoint, doc, doc.getChildCount());
                DebugPanel.this._bpTree.scrollPathToVisible(new TreePath(newBreakpoint.getPath()));
                return;
            }
            DebugPanel.this._bpTreeModel.insertNodeInto(bpDocNode, DebugPanel.this._breakpointRootNode, DebugPanel.this._breakpointRootNode.getChildCount());
            DefaultMutableTreeNode newBreakpoint = new DefaultMutableTreeNode(new Integer(bp.getLineNumber()));
            DebugPanel.this._bpTreeModel.insertNodeInto(newBreakpoint, bpDocNode, bpDocNode.getChildCount());
            TreePath pathToNewBreakpoint = new TreePath(newBreakpoint.getPath());
            DebugPanel.this._bpTree.scrollPathToVisible(pathToNewBreakpoint);
        }

        public void breakpointReached(final Breakpoint bp) {
            Runnable doCommand = new Runnable(){

                public void run() {
                    DefaultMutableTreeNode bpDoc = new DefaultMutableTreeNode(bp.getClassName());
                    Enumeration<TreeNode> documents = DebugPanel.this._breakpointRootNode.children();
                    while (documents.hasMoreElements()) {
                        DefaultMutableTreeNode doc = (DefaultMutableTreeNode)documents.nextElement();
                        if (!doc.getUserObject().equals(bpDoc.getUserObject())) continue;
                        Enumeration<TreeNode> lineNumbers = doc.children();
                        while (lineNumbers.hasMoreElements()) {
                            DefaultMutableTreeNode lineNumber = (DefaultMutableTreeNode)lineNumbers.nextElement();
                            if (!lineNumber.getUserObject().equals(new Integer(bp.getLineNumber()))) continue;
                            TreePath pathToNewBreakpoint = new TreePath(lineNumber.getPath());
                            DebugPanel.this._bpTree.scrollPathToVisible(pathToNewBreakpoint);
                            DebugPanel.this._bpTree.setSelectionPath(pathToNewBreakpoint);
                        }
                    }
                }
            };
            Utilities.invokeLater(doCommand);
        }

        public void breakpointRemoved(final Breakpoint bp) {
            Runnable doCommand = new Runnable(){

                public void run() {
                    DefaultMutableTreeNode bpDocNode = new DefaultMutableTreeNode(bp.getClassName());
                    Enumeration<TreeNode> documents = DebugPanel.this._breakpointRootNode.children();
                    while (documents.hasMoreElements()) {
                        DefaultMutableTreeNode doc = (DefaultMutableTreeNode)documents.nextElement();
                        if (!doc.getUserObject().equals(bpDocNode.getUserObject())) continue;
                        Enumeration<TreeNode> lineNumbers = doc.children();
                        while (lineNumbers.hasMoreElements()) {
                            DefaultMutableTreeNode lineNumber = (DefaultMutableTreeNode)lineNumbers.nextElement();
                            if (!lineNumber.getUserObject().equals(new Integer(bp.getLineNumber()))) continue;
                            DebugPanel.this._bpTreeModel.removeNodeFromParent(lineNumber);
                            if (doc.getChildCount() == 0) {
                                DebugPanel.this._bpTreeModel.removeNodeFromParent(doc);
                            }
                            return;
                        }
                    }
                }
            };
            Utilities.invokeLater(doCommand);
        }

        public void stepRequested() {
        }

        public void currThreadSuspended() {
            Utilities.invokeLater(new Runnable(){

                public void run() {
                    DebugPanel.this.updateData();
                }
            });
        }

        public void currThreadResumed() {
            Utilities.invokeLater(new Runnable(){

                public void run() {
                    DebugPanel.this.updateData();
                }
            });
        }

        public void threadStarted() {
            DebugPanel.this.updateData();
        }

        public void currThreadDied() {
            DebugPanel.this.updateData();
        }

        public void nonCurrThreadDied() {
            DebugPanel.this.updateData();
        }

        public void currThreadSet(DebugThreadData thread) {
            DebugPanel.this._currentThreadID = thread.getUniqueID();
            Utilities.invokeLater(new Runnable(){

                public void run() {
                    DebugPanel.this.updateData();
                }
            });
        }
    }

    public class ThreadTableModel
    extends AbstractTableModel {
        private String[] _columnNames = new String[]{"Name", "Status"};

        public String getColumnName(int col) {
            return this._columnNames[col];
        }

        public int getRowCount() {
            if (DebugPanel.this._threads == null) {
                return 0;
            }
            return DebugPanel.this._threads.size();
        }

        public int getColumnCount() {
            return this._columnNames.length;
        }

        public Object getValueAt(int row, int col) {
            DebugThreadData threadData = (DebugThreadData)DebugPanel.this._threads.get(row);
            switch (col) {
                case 0: {
                    return threadData.getName();
                }
                case 1: {
                    return threadData.getStatus();
                }
            }
            return null;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    public class StackTableModel
    extends AbstractTableModel {
        private String[] _columnNames = new String[]{"Method", "Line"};

        public String getColumnName(int col) {
            return this._columnNames[col];
        }

        public int getRowCount() {
            if (DebugPanel.this._stackFrames == null) {
                return 0;
            }
            return DebugPanel.this._stackFrames.size();
        }

        public int getColumnCount() {
            return this._columnNames.length;
        }

        public Object getValueAt(int row, int col) {
            DebugStackData frame = (DebugStackData)DebugPanel.this._stackFrames.get(row);
            switch (col) {
                case 0: {
                    return frame.getMethod();
                }
                case 1: {
                    return new Integer(frame.getLine());
                }
            }
            return null;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    public class WatchTableModel
    extends AbstractTableModel {
        private String[] _columnNames = new String[]{"Name", "Value", "Type"};

        public String getColumnName(int col) {
            return this._columnNames[col];
        }

        public int getRowCount() {
            return DebugPanel.this._watches.size() + 1;
        }

        public int getColumnCount() {
            return this._columnNames.length;
        }

        public Object getValueAt(int row, int col) {
            if (row < DebugPanel.this._watches.size()) {
                DebugWatchData watch = (DebugWatchData)DebugPanel.this._watches.get(row);
                switch (col) {
                    case 0: {
                        return watch.getName();
                    }
                    case 1: {
                        return watch.getValue();
                    }
                    case 2: {
                        return watch.getType();
                    }
                }
                this.fireTableRowsUpdated(row, DebugPanel.this._watches.size() - 1);
                return null;
            }
            this.fireTableRowsUpdated(row, DebugPanel.this._watches.size() - 1);
            return "";
        }

        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }

        public void setValueAt(Object value, int row, int col) {
            try {
                if (value == null || value.equals("")) {
                    DebugPanel.this._debugger.removeWatch(row);
                } else {
                    if (row < DebugPanel.this._watches.size()) {
                        DebugPanel.this._debugger.removeWatch(row);
                    }
                    DebugPanel.this._debugger.addWatch(String.valueOf(value));
                }
                this.fireTableRowsUpdated(row, DebugPanel.this._watches.size() - 1);
            }
            catch (DebugException de) {
                DebugPanel.this._frame._showDebugError(de);
            }
        }
    }

    private class WatchRenderer
    extends DefaultTableCellRenderer {
        private WatchRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component renderer = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            DebugPanel._setColors(renderer);
            this._setWatchCellFont(row);
            return renderer;
        }

        private void _setWatchCellFont(int row) {
            DebugWatchData currWatch;
            int numWatches = DebugPanel.this._watches.size();
            if (row < numWatches && (currWatch = (DebugWatchData)DebugPanel.this._watches.get(row)).isChanged()) {
                this.setFont(this.getFont().deriveFont(1));
            }
        }
    }

    private static class WatchEditor
    extends DefaultCellEditor {
        WatchEditor() {
            super(new JTextField());
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component editor = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            DebugPanel._setColors(editor);
            return editor;
        }
    }

    static class BreakPointRenderer
    extends DefaultTreeCellRenderer {
        public void setBackground(Color c) {
            this.setBackgroundNonSelectionColor(c);
        }

        public void setForeground(Color c) {
            this.setTextNonSelectionColor(c);
        }

        private BreakPointRenderer() {
            this.setTextSelectionColor(Color.black);
            this.setLeafIcon(null);
            this.setOpenIcon(null);
            this.setClosedIcon(null);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component renderer = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (renderer instanceof JComponent) {
                ((JComponent)renderer).setOpaque(false);
            }
            DebugPanel._setColors(renderer);
            return renderer;
        }
    }
}

