/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.model.repl.ConsoleDocument;
import edu.rice.cs.drjava.model.repl.InputListener;
import edu.rice.cs.drjava.model.repl.InteractionsDocumentAdapter;
import edu.rice.cs.drjava.ui.AbstractConsoleController;
import edu.rice.cs.drjava.ui.InteractionsPane;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

public class ConsoleController
extends AbstractConsoleController
implements Serializable {
    protected ConsoleDocument _doc;
    private Object _inputWaitObject = new Object();
    private boolean _blockedForConsoleInput;
    protected InputListener _inputListener = new InputListener(){

        public String getConsoleInput() {
            ConsoleController.this._pane.setEditable(true);
            ConsoleController.this._waitForInput();
            String s = ConsoleController.this._doc.getCurrentInput();
            ConsoleController.this._doc.disablePrompt();
            return s;
        }
    };
    AbstractAction enterAction = new EnterAction();
    AbstractAction moveLeftAction = new LeftAction();
    AbstractAction moveRightAction = new RightAction();
    AbstractAction moveUpDownAction = new UpDownAction();

    public ConsoleController(final ConsoleDocument doc, InteractionsDocumentAdapter adapter) {
        super(adapter, new InteractionsPane("CONSOLE_KEYMAP", adapter){

            public int getPromptPos() {
                return doc.getPromptPos();
            }
        });
        this._doc = doc;
        this._blockedForConsoleInput = false;
        this._pane.setEditable(false);
        this._init();
    }

    public ConsoleDocument getConsoleDoc() {
        return this._doc;
    }

    public InputListener getInputListener() {
        return this._inputListener;
    }

    protected void _setupModel() {
        this._adapter.addDocumentListener(new AbstractConsoleController.CaretUpdateListener());
        this._doc.setBeep(this._pane.getBeep());
    }

    Object getInputWaitObject() {
        return this._inputWaitObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _waitForInput() {
        Object object = this._inputWaitObject;
        synchronized (object) {
            try {
                this._blockedForConsoleInput = true;
                while (this._blockedForConsoleInput) {
                    this._inputWaitObject.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void _setupView() {
        super._setupView();
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 0), this.enterAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 1), this.newLineAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(66, mask), this.clearCurrentAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(226, 0), this.moveLeftAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(37, 0), this.moveLeftAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(227, 0), this.moveRightAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(39, 0), this.moveRightAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(224, 0), this.moveUpDownAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(38, 0), this.moveUpDownAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(225, 0), this.moveUpDownAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(40, 0), this.moveUpDownAction);
    }

    private class UpDownAction
    extends AbstractAction
    implements Serializable {
        private UpDownAction() {
        }

        public void actionPerformed(ActionEvent e) {
            int position = ConsoleController.this._pane.getCaretPosition();
            if (position < ConsoleController.this._doc.getPromptPos()) {
                ConsoleController.this.moveToPrompt();
            } else {
                ConsoleController.this._pane.getBeep().run();
            }
        }
    }

    private class RightAction
    extends AbstractAction
    implements Serializable {
        private RightAction() {
        }

        public void actionPerformed(ActionEvent e) {
            int position = ConsoleController.this._pane.getCaretPosition();
            if (position < ConsoleController.this._doc.getPromptPos()) {
                ConsoleController.this.moveToEnd();
            } else if (position >= ConsoleController.this._doc.getLength()) {
                ConsoleController.this._pane.getBeep().run();
            } else {
                ConsoleController.this._pane.setCaretPosition(position + 1);
            }
        }
    }

    private class LeftAction
    extends AbstractAction
    implements Serializable {
        private LeftAction() {
        }

        public void actionPerformed(ActionEvent e) {
            int position = ConsoleController.this._pane.getCaretPosition();
            if (position < ConsoleController.this._doc.getPromptPos()) {
                ConsoleController.this.moveToPrompt();
            } else if (position == ConsoleController.this._doc.getPromptPos()) {
                ConsoleController.this._pane.getBeep().run();
            } else {
                ConsoleController.this._pane.setCaretPosition(position - 1);
            }
        }
    }

    private class EnterAction
    extends AbstractAction
    implements Serializable {
        private EnterAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            Object object = ConsoleController.this._inputWaitObject;
            synchronized (object) {
                if (ConsoleController.this._blockedForConsoleInput) {
                    ConsoleController.this._pane.setEditable(false);
                    ConsoleController.this._pane.getCaret().setVisible(false);
                    ConsoleController.this._doc.insertNewLine(ConsoleController.this._doc.getLength());
                    ConsoleController.this._blockedForConsoleInput = false;
                    ConsoleController.this._inputWaitObject.notify();
                }
            }
        }
    }
}

