/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.project;

import edu.rice.cs.drjava.Version;
import edu.rice.cs.drjava.project.DocFile;
import edu.rice.cs.drjava.project.DocumentInfoGetter;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.Pair;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class ProjectFileBuilder {
    private List<DocFile> _sourceFiles = new Vector<DocFile>();
    private List<DocFile> _auxFiles = new Vector<DocFile>();
    private List<String> _collapsedPaths = new Vector<String>();
    private File _buildDir = null;
    private List<File> _classpathFiles = new Vector<File>();
    private File _mainClass = null;
    private File _projRoot = null;
    private File _projectFile;

    public ProjectFileBuilder(String filename) {
        this._projectFile = new File(filename);
    }

    public ProjectFileBuilder(File f) {
        this._projectFile = f;
    }

    public void addSourceFile(DocumentInfoGetter getter) {
        if (!getter.isUntitled()) {
            try {
                this._sourceFiles.add(this.docFileFromGetter(getter));
            }
            catch (IOException e) {
                throw new UnexpectedException(e);
            }
        }
    }

    public void addAuxiliaryFile(DocumentInfoGetter getter) {
        if (!getter.isUntitled()) {
            try {
                this._auxFiles.add(this.docFileFromGetter(getter));
            }
            catch (IOException e) {
                throw new UnexpectedException(e);
            }
        }
    }

    public void addClasspathFile(File cp) {
        if (cp != null) {
            this._classpathFiles.add(cp);
        }
    }

    public void addCollapsedPath(String cp) {
        if (cp != null) {
            this._collapsedPaths.add(cp);
        }
    }

    public void setBuildDirectory(File dir) {
        this._buildDir = dir;
    }

    public void setMainClass(File main) {
        this._mainClass = main;
    }

    public void setProjectRoot(File root) {
        this._projRoot = root;
    }

    public void write() throws IOException {
        DocFile df;
        Iterator<Object> i$;
        FileWriter fw = new FileWriter(this._projectFile);
        fw.write(";; DrJava project file, written by build " + Version.getBuildTimeString());
        fw.write(";; relative files are made relative to: " + this._projectFile.getParentFile().getCanonicalFile());
        if (this._projRoot != null) {
            fw.write("\n(proj-root");
            fw.write("\n" + this.encodeFile(this._projRoot, "  ", true));
            fw.write(")");
        }
        if (!this._sourceFiles.isEmpty()) {
            fw.write("\n(source");
            i$ = this._sourceFiles.iterator();
            while (i$.hasNext()) {
                df = i$.next();
                fw.write("\n" + this.encodeDocFile(df, "  "));
            }
            fw.write(")");
        } else {
            fw.write("\n;; no source files");
        }
        if (!this._auxFiles.isEmpty()) {
            fw.write("\n(auxiliary");
            i$ = this._auxFiles.iterator();
            while (i$.hasNext()) {
                df = i$.next();
                fw.write("\n" + this.encodeDocFile(df, "  ", false));
            }
            fw.write(")");
        } else {
            fw.write("\n;; no aux files");
        }
        if (!this._collapsedPaths.isEmpty()) {
            fw.write("\n(collapsed");
            i$ = this._collapsedPaths.iterator();
            while (i$.hasNext()) {
                String s = (String)i$.next();
                fw.write("\n  (path " + StringOps.convertToLiteral(s) + ")");
            }
            fw.write(")");
        } else {
            fw.write("\n;; no collapsed branches");
        }
        if (!this._classpathFiles.isEmpty()) {
            fw.write("\n(classpaths");
            i$ = this._classpathFiles.iterator();
            while (i$.hasNext()) {
                File f = (File)i$.next();
                fw.write("\n" + this.encodeFile(f, "  ", false));
            }
            fw.write(")");
        } else {
            fw.write("\n;; no classpaths files");
        }
        if (this._buildDir != null) {
            fw.write("\n(build-dir");
            fw.write("\n" + this.encodeFile(this._buildDir, "  ", true));
            fw.write(")");
        } else {
            fw.write("\n;; no build directory");
        }
        if (this._mainClass != null) {
            fw.write("\n(main-class");
            fw.write("\n" + this.encodeFile(this._mainClass, "  ", true));
            fw.write(")");
        } else {
            fw.write("\n;; no main class");
        }
        fw.close();
    }

    private DocFile docFileFromGetter(DocumentInfoGetter getter) throws IOException {
        return new DocFile(getter.getFile().getCanonicalPath(), getter.getSelection(), getter.getScroll(), getter.isActive(), getter.getPackage());
    }

    private String encodeFile(File f, String prefix, boolean relative) throws IOException {
        String path = relative ? this.makeRelative(f) : f.getCanonicalPath();
        path = StringOps.replace(path, File.separator, "/");
        return prefix + "(file (name " + StringOps.convertToLiteral(path) + "))";
    }

    private String encodeFile(File f, String prefix) throws IOException {
        return this.encodeFile(f, prefix, true);
    }

    private String encodeDocFile(DocFile df, String prefix, boolean relative, boolean hasDate) throws IOException {
        String pack;
        String ret = "";
        String path = relative ? this.makeRelative(df) : df.getCanonicalPath();
        path = StringOps.replace(path, File.separator, "/");
        ret = ret + prefix + "(file (name " + StringOps.convertToLiteral(path) + ")";
        Pair<Integer, Integer> p1 = df.getSelection();
        Pair<Integer, Integer> p2 = df.getScroll();
        boolean active = df.isActive();
        long modDate = df.lastModified();
        if (p1 != null || p2 != null || active) {
            ret = ret + "\n" + prefix + "      ";
        }
        if (p1 != null) {
            ret = ret + "(select " + p1.getFirst() + " " + p1.getSecond() + ")";
        }
        if (p2 != null) {
            ret = ret + "(scroll " + p2.getFirst() + " " + p2.getSecond() + ")";
        }
        if (hasDate && modDate > 0L) {
            String s = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss").format(new Date(modDate));
            ret = ret + "(mod-date " + StringOps.convertToLiteral(s) + ")";
        }
        if (active) {
            ret = ret + "(active)";
        }
        if ((pack = df.getPackage()) != null) {
            ret = ret + "\n" + prefix + "      ";
            ret = ret + "(package " + StringOps.convertToLiteral(pack) + ")";
        }
        ret = ret + ")";
        return ret;
    }

    private String encodeDocFile(DocFile df, String prefix) throws IOException {
        return this.encodeDocFile(df, prefix, true, true);
    }

    private String encodeDocFile(DocFile df, String prefix, boolean relative) throws IOException {
        return this.encodeDocFile(df, prefix, relative, true);
    }

    private String makeRelative(File f) throws IOException {
        return FileOps.makeRelativeTo(f, this._projectFile).getPath();
    }
}

