/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.repl.newjvm;

import edu.rice.cs.drjava.model.ClasspathEntry;
import edu.rice.cs.drjava.model.junit.JUnitError;
import edu.rice.cs.drjava.model.junit.JUnitModelCallback;
import edu.rice.cs.drjava.model.junit.JUnitTestManager;
import edu.rice.cs.drjava.model.repl.DynamicJavaAdapter;
import edu.rice.cs.drjava.model.repl.ExceptionReturnedException;
import edu.rice.cs.drjava.model.repl.Interpreter;
import edu.rice.cs.drjava.model.repl.JavaDebugInterpreter;
import edu.rice.cs.drjava.model.repl.JavaInterpreter;
import edu.rice.cs.drjava.model.repl.newjvm.ClasspathManager;
import edu.rice.cs.drjava.model.repl.newjvm.ExceptionResult;
import edu.rice.cs.drjava.model.repl.newjvm.InterpreterData;
import edu.rice.cs.drjava.model.repl.newjvm.InterpreterJVMRemoteI;
import edu.rice.cs.drjava.model.repl.newjvm.MainJVMRemoteI;
import edu.rice.cs.drjava.model.repl.newjvm.SyntaxErrorResult;
import edu.rice.cs.drjava.model.repl.newjvm.ValueResult;
import edu.rice.cs.drjava.model.repl.newjvm.VoidResult;
import edu.rice.cs.drjava.platform.PlatformFactory;
import edu.rice.cs.util.ClasspathVector;
import edu.rice.cs.util.InputStreamRedirector;
import edu.rice.cs.util.Log;
import edu.rice.cs.util.OutputStreamRedirector;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.classloader.ClassFileError;
import edu.rice.cs.util.newjvm.AbstractSlaveJVM;
import edu.rice.cs.util.newjvm.MasterRemote;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import koala.dynamicjava.interpreter.UninitializedObject;
import koala.dynamicjava.parser.ParseException;
import koala.dynamicjava.parser.TokenMgrError;
import koala.dynamicjava.parser.wrapper.ParseError;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterpreterJVM
extends AbstractSlaveJVM
implements InterpreterJVMRemoteI,
JUnitModelCallback {
    private static final boolean printMessages = false;
    public static final InterpreterJVM ONLY = new InterpreterJVM();
    public static final String EMPTY_TRACE_TEXT = "";
    private MainJVMRemoteI _mainJVM;
    private InterpreterData _defaultInterpreter;
    private Hashtable<String, InterpreterData> _interpreters;
    private InterpreterData _activeInterpreter;
    private ClasspathVector _classpath;
    private JUnitTestManager _junitTestManager;
    ClasspathManager classpathManager;
    private boolean _messageOnResetFailure;
    private static final Log _log = new Log("IntJVMLog", false);

    private InterpreterJVM() {
        this._quitSlaveThreadName = "Reset Interactions Thread";
        this._pollMasterThreadName = "Poll DrJava Thread";
        this.reset();
        this._messageOnResetFailure = true;
    }

    private void reset() {
        this.classpathManager = new ClasspathManager();
        this._activeInterpreter = this._defaultInterpreter = new InterpreterData(new DynamicJavaAdapter(this.classpathManager));
        this._interpreters = new Hashtable();
        this._classpath = new ClasspathVector();
        this._junitTestManager = new JUnitTestManager(this);
        try {
            this._activeInterpreter.getInterpreter().interpret("0");
        }
        catch (ExceptionReturnedException e) {
            throw new UnexpectedException(e);
        }
    }

    private static void _dialog(String s) {
        _log.logTime(s);
    }

    @Override
    protected void handleStart(MasterRemote mainJVM) {
        this._mainJVM = (MainJVMRemoteI)mainJVM;
        System.setIn(new InputStreamRedirector(){

            protected String _getInput() {
                try {
                    return InterpreterJVM.this._mainJVM.getConsoleInput();
                }
                catch (RemoteException re) {
                    _log.logTime("System.in: " + re.toString());
                    throw new IllegalStateException("Main JVM can't be reached for input.\n" + re);
                }
            }
        });
        System.setOut(new PrintStream(new OutputStreamRedirector(){

            public void print(String s) {
                try {
                    InterpreterJVM.this._mainJVM.systemOutPrint(s);
                }
                catch (RemoteException re) {
                    _log.logTime("System.out: " + re.toString());
                }
            }
        }));
        System.setErr(new PrintStream(new OutputStreamRedirector(){

            public void print(String s) {
                try {
                    InterpreterJVM.this._mainJVM.systemErrPrint(s);
                }
                catch (RemoteException re) {
                    _log.logTime("System.err: " + re.toString());
                }
            }
        }));
        if (PlatformFactory.ONLY.isWindowsPlatform()) {
            JDialog d = new JDialog();
            d.setSize(0, 0);
            d.setVisible(true);
            d.setVisible(false);
        }
    }

    @Override
    public void interpret(String s) {
        this.interpret(s, this._activeInterpreter);
    }

    public void interpret(String s, String interpreterName) {
        this.interpret(s, this.getInterpreter(interpreterName));
    }

    public void interpret(final String input, final InterpreterData interpreter) {
        Thread thread = new Thread(new StringBuffer().append("interpret thread: ").append(input).toString()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block16: {
                    String s = input;
                    try {
                        interpreter.setInProgress(true);
                        try {
                            InterpreterJVM._dialog("to interp: " + s);
                            String s1 = s;
                            Object result = interpreter.getInterpreter().interpret(s1);
                            String resultString = String.valueOf(result);
                            if (result == Interpreter.NO_RESULT) {
                                InterpreterJVM.this._mainJVM.interpretResult(new VoidResult());
                                break block16;
                            }
                            String style = "object.return.style";
                            if (result instanceof String) {
                                style = "string.return.style";
                                String possibleChar = (String)result;
                                if (possibleChar.startsWith("'") && possibleChar.endsWith("'") && possibleChar.length() == 3) {
                                    style = "character.return.style";
                                }
                            }
                            if (result instanceof Number) {
                                style = "number.return.style";
                            }
                            InterpreterJVM.this._mainJVM.interpretResult(new ValueResult(resultString, style));
                        }
                        catch (ExceptionReturnedException e) {
                            Throwable t = e.getContainedException();
                            InterpreterJVM._dialog("interp exception: " + t);
                            if (t instanceof ParseException) {
                                InterpreterJVM.this._mainJVM.interpretResult(new SyntaxErrorResult((ParseException)t, input));
                                break block16;
                            }
                            if (t instanceof TokenMgrError) {
                                InterpreterJVM.this._mainJVM.interpretResult(new SyntaxErrorResult((TokenMgrError)t, input));
                                break block16;
                            }
                            if (t instanceof ParseError) {
                                InterpreterJVM.this._mainJVM.interpretResult(new SyntaxErrorResult((ParseError)t, input));
                                break block16;
                            }
                            InterpreterJVM.this._mainJVM.interpretResult(new ExceptionResult(t.getClass().getName(), t.getMessage(), InterpreterJVM.getStackTrace(t), null));
                        }
                        catch (Throwable t) {
                            String shortMsg = null;
                            if (t instanceof ParseError && ((ParseError)t).getParseException() != null) {
                                shortMsg = ((ParseError)t).getMessage();
                            }
                            InterpreterJVM.this._mainJVM.interpretResult(new ExceptionResult(t.getClass().getName(), t.getMessage(), InterpreterJVM.getStackTrace(t), shortMsg));
                        }
                    }
                    catch (RemoteException re) {
                        _log.logTime("interpret: " + re.toString());
                    }
                    finally {
                        interpreter.setInProgress(false);
                    }
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    private String _processReturnValue(Object o) {
        if (o instanceof String) {
            return new StringBuffer().append("\"").append(o).append("\"").toString();
        }
        if (o instanceof Character) {
            return new StringBuffer().append("'").append(o).append("'").toString();
        }
        return o.toString();
    }

    @Override
    public String getVariableToString(String var) throws RemoteException {
        Interpreter i = this._activeInterpreter.getInterpreter();
        if (i instanceof JavaInterpreter) {
            try {
                Object value = ((JavaInterpreter)i).getVariable(var);
                if (value == null) {
                    return "null";
                }
                if (value instanceof UninitializedObject) {
                    return null;
                }
                return this._processReturnValue(value);
            }
            catch (IllegalStateException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getVariableClassName(String var) throws RemoteException {
        Interpreter i = this._activeInterpreter.getInterpreter();
        if (i instanceof JavaInterpreter) {
            try {
                Class c = ((JavaInterpreter)i).getVariableClass(var);
                if (c == null) {
                    return "null";
                }
                return c.getName();
            }
            catch (IllegalStateException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public void addJavaInterpreter(String name) {
        DynamicJavaAdapter interpreter = new DynamicJavaAdapter(this.classpathManager);
        this._updateInterpreterClasspath(interpreter);
        this.addInterpreter(name, interpreter);
    }

    @Override
    public void addDebugInterpreter(String name, String className) {
        JavaDebugInterpreter interpreter = new JavaDebugInterpreter(name, className);
        interpreter.setPrivateAccessible(true);
        this._updateInterpreterClasspath(interpreter);
        this.addInterpreter(name, interpreter);
    }

    public void addInterpreter(String name, Interpreter interpreter) {
        if (this._interpreters.containsKey(name)) {
            throw new IllegalArgumentException(new StringBuffer().append("'").append(name).append("' is not a unique interpreter name").toString());
        }
        this._interpreters.put(name, new InterpreterData(interpreter));
    }

    @Override
    public void removeInterpreter(String name) {
        this._interpreters.remove(name);
    }

    InterpreterData getInterpreter(String name) {
        InterpreterData interpreter = this._interpreters.get(name);
        if (interpreter != null) {
            return interpreter;
        }
        throw new IllegalArgumentException(new StringBuffer().append("Interpreter '").append(name).append("' does not exist.").toString());
    }

    public JavaInterpreter getJavaInterpreter(String name) {
        InterpreterData interpreterData = this.getInterpreter(name);
        Interpreter interpreter = interpreterData.getInterpreter();
        if (interpreter instanceof JavaInterpreter) {
            return (JavaInterpreter)interpreter;
        }
        throw new IllegalArgumentException(new StringBuffer().append("Interpreter '").append(name).append("' is not a JavaInterpreter.").toString());
    }

    @Override
    public boolean setActiveInterpreter(String name) {
        this._activeInterpreter = this.getInterpreter(name);
        return this._activeInterpreter.isInProgress();
    }

    @Override
    public boolean setToDefaultInterpreter() {
        this._activeInterpreter = this._defaultInterpreter;
        return this._activeInterpreter.isInProgress();
    }

    Hashtable<String, InterpreterData> getInterpreters() {
        return this._interpreters;
    }

    Interpreter getActiveInterpreter() {
        return this._activeInterpreter.getInterpreter();
    }

    public static String getStackTrace(Throwable t) {
        BufferedReader reader = new BufferedReader(new StringReader(StringOps.getStackTrace(t)));
        LinkedList<String> traceItems = new LinkedList<String>();
        try {
            String s;
            reader.readLine();
            while ((s = reader.readLine()) != null) {
                traceItems.add(s);
            }
        }
        catch (IOException ioe) {
            return "Unable to get stack trace";
        }
        int index = -1;
        for (int i = 0; i < traceItems.size(); ++i) {
            String item = (String)traceItems.get(i);
            if (!(item = item.trim()).startsWith("at edu.rice.cs.drjava.") && !item.startsWith("at koala.dynamicjava.")) continue;
            index = i;
            break;
        }
        if (index > -1) {
            while (traceItems.size() > index) {
                traceItems.removeLast();
            }
        }
        if (traceItems.isEmpty()) {
            traceItems.add(EMPTY_TRACE_TEXT);
        }
        StringBuffer buf = new StringBuffer();
        ListIterator itor = traceItems.listIterator();
        String newLine = System.getProperty("line.separator");
        boolean first = true;
        while (itor.hasNext()) {
            if (first) {
                first = false;
            } else {
                buf.append(newLine);
            }
            buf.append(new StringBuffer().append("  ").append(((String)itor.next()).trim()).toString());
        }
        return buf.toString();
    }

    @Override
    public void setPackageScope(String s) {
        Interpreter active = this._activeInterpreter.getInterpreter();
        if (active instanceof JavaInterpreter) {
            ((JavaInterpreter)active).setPackageScope(s);
        }
    }

    @Override
    public void setShowMessageOnResetFailure(boolean show) {
        this._messageOnResetFailure = show;
    }

    @Override
    protected void quitFailed(Throwable th) {
        if (this._messageOnResetFailure) {
            String msg = new StringBuffer().append("The interactions pane could not be reset:\n").append(th).toString();
            JOptionPane.showMessageDialog(null, msg);
        }
        try {
            this._mainJVM.quitFailed(th);
        }
        catch (RemoteException re) {
            _log.logTime(new StringBuffer().append("quitFailed: ").append(re.toString()).toString());
        }
    }

    @Override
    public void setPrivateAccessible(boolean allow) {
        Interpreter active = this._activeInterpreter.getInterpreter();
        if (active instanceof JavaInterpreter) {
            ((JavaInterpreter)active).setPrivateAccessible(allow);
        }
    }

    @Override
    public List<String> findTestClasses(List<String> classNames, List<File> files) throws RemoteException {
        return this._junitTestManager.findTestClasses(classNames, files);
    }

    @Override
    public boolean runTestSuite() throws RemoteException {
        return this._junitTestManager.runTestSuite();
    }

    @Override
    public void nonTestCase(boolean isTestAll) {
        try {
            this._mainJVM.nonTestCase(isTestAll);
        }
        catch (RemoteException re) {
            _log.logTime(new StringBuffer().append("nonTestCase: ").append(re.toString()).toString());
        }
    }

    @Override
    public void classFileError(ClassFileError e) {
        try {
            this._mainJVM.classFileError(e);
        }
        catch (RemoteException re) {
            _log.logTime(new StringBuffer().append("classFileError: ").append(re.toString()).toString());
        }
    }

    @Override
    public void testSuiteStarted(int numTests) {
        try {
            this._mainJVM.testSuiteStarted(numTests);
        }
        catch (RemoteException re) {
            _log.logTime(new StringBuffer().append("testSuiteStarted: ").append(re.toString()).toString());
        }
    }

    @Override
    public void testStarted(String testName) {
        try {
            this._mainJVM.testStarted(testName);
        }
        catch (RemoteException re) {
            _log.logTime(new StringBuffer().append("testStarted").append(re.toString()).toString());
        }
    }

    @Override
    public void testEnded(String testName, boolean wasSuccessful, boolean causedError) {
        try {
            this._mainJVM.testEnded(testName, wasSuccessful, causedError);
        }
        catch (RemoteException re) {
            _log.logTime(new StringBuffer().append("testEnded: ").append(re.toString()).toString());
        }
    }

    @Override
    public void testSuiteEnded(JUnitError[] errors) {
        try {
            this._mainJVM.testSuiteEnded(errors);
        }
        catch (RemoteException re) {
            _log.logTime(new StringBuffer().append("testSuiteFinished: ").append(re.toString()).toString());
        }
    }

    @Override
    public File getFileForClassName(String className) {
        try {
            return this._mainJVM.getFileForClassName(className);
        }
        catch (RemoteException re) {
            _log.logTime(new StringBuffer().append("getFileForClassName: ").append(re.toString()).toString());
            return null;
        }
    }

    @Override
    public void junitJVMReady() {
    }

    protected void _updateInterpreterClasspath(JavaInterpreter interpreter) {
        List<ClasspathEntry> locpe = this.classpathManager.getProjectCP();
        for (ClasspathEntry e : locpe) {
            interpreter.addProjectClassPath(e.getEntry());
        }
        locpe = this.classpathManager.getBuildDirectoryCP();
        for (ClasspathEntry e : locpe) {
            interpreter.addBuildDirectoryClassPath(e.getEntry());
        }
        locpe = this.classpathManager.getProjectFilesCP();
        for (ClasspathEntry e : locpe) {
            interpreter.addProjectFilesClassPath(e.getEntry());
        }
        locpe = this.classpathManager.getExternalFilesCP();
        for (ClasspathEntry e : locpe) {
            interpreter.addExternalFilesClassPath(e.getEntry());
        }
        locpe = this.classpathManager.getExtraCP();
        for (ClasspathEntry e : locpe) {
            interpreter.addExtraClassPath(e.getEntry());
        }
    }

    public void addExtraClassPath(URL s) {
        if (this._classpath.contains(s)) {
            return;
        }
        if (this._defaultInterpreter.getInterpreter() instanceof JavaInterpreter) {
            ((JavaInterpreter)this._defaultInterpreter.getInterpreter()).addExtraClassPath(s);
        }
        Enumeration<InterpreterData> interpreters = this._interpreters.elements();
        while (interpreters.hasMoreElements()) {
            Interpreter interpreter = interpreters.nextElement().getInterpreter();
            if (!(interpreter instanceof JavaInterpreter)) continue;
            ((JavaInterpreter)interpreter).addExtraClassPath(s);
        }
        this._classpath.add(s);
    }

    public void addProjectClassPath(URL s) {
        if (this._classpath.contains(s)) {
            return;
        }
        if (this._defaultInterpreter.getInterpreter() instanceof JavaInterpreter) {
            ((JavaInterpreter)this._defaultInterpreter.getInterpreter()).addProjectClassPath(s);
        }
        Enumeration<InterpreterData> interpreters = this._interpreters.elements();
        while (interpreters.hasMoreElements()) {
            Interpreter interpreter = interpreters.nextElement().getInterpreter();
            if (!(interpreter instanceof JavaInterpreter)) continue;
            ((JavaInterpreter)interpreter).addProjectClassPath(s);
        }
        this._classpath.add(s);
    }

    public void addBuildDirectoryClassPath(URL s) {
        if (this._classpath.contains(s)) {
            return;
        }
        if (this._defaultInterpreter.getInterpreter() instanceof JavaInterpreter) {
            ((JavaInterpreter)this._defaultInterpreter.getInterpreter()).addBuildDirectoryClassPath(s);
        }
        Enumeration<InterpreterData> interpreters = this._interpreters.elements();
        while (interpreters.hasMoreElements()) {
            Interpreter interpreter = interpreters.nextElement().getInterpreter();
            if (!(interpreter instanceof JavaInterpreter)) continue;
            ((JavaInterpreter)interpreter).addBuildDirectoryClassPath(s);
        }
        this._classpath.add(s);
    }

    public void addProjectFilesClassPath(URL s) {
        if (this._classpath.contains(s)) {
            return;
        }
        if (this._defaultInterpreter.getInterpreter() instanceof JavaInterpreter) {
            ((JavaInterpreter)this._defaultInterpreter.getInterpreter()).addProjectFilesClassPath(s);
        }
        Enumeration<InterpreterData> interpreters = this._interpreters.elements();
        while (interpreters.hasMoreElements()) {
            Interpreter interpreter = interpreters.nextElement().getInterpreter();
            if (!(interpreter instanceof JavaInterpreter)) continue;
            ((JavaInterpreter)interpreter).addProjectFilesClassPath(s);
        }
        this._classpath.add(s);
    }

    public void addExternalFilesClassPath(URL s) {
        if (this._classpath.contains(s)) {
            return;
        }
        if (this._defaultInterpreter.getInterpreter() instanceof JavaInterpreter) {
            ((JavaInterpreter)this._defaultInterpreter.getInterpreter()).addExternalFilesClassPath(s);
        }
        Enumeration<InterpreterData> interpreters = this._interpreters.elements();
        while (interpreters.hasMoreElements()) {
            Interpreter interpreter = interpreters.nextElement().getInterpreter();
            if (!(interpreter instanceof JavaInterpreter)) continue;
            ((JavaInterpreter)interpreter).addExternalFilesClassPath(s);
        }
        this._classpath.add(s);
    }

    @Override
    public Vector<String> getAugmentedClasspath() {
        Vector<String> ret = new Vector<String>();
        List<ClasspathEntry> locpe = this.classpathManager.getProjectCP();
        for (ClasspathEntry e : locpe) {
            ret.add(e.getEntry().toString());
        }
        locpe = this.classpathManager.getBuildDirectoryCP();
        for (ClasspathEntry e : locpe) {
            ret.add(e.getEntry().toString());
        }
        locpe = this.classpathManager.getProjectFilesCP();
        for (ClasspathEntry e : locpe) {
            ret.add(e.getEntry().toString());
        }
        locpe = this.classpathManager.getExternalFilesCP();
        for (ClasspathEntry e : locpe) {
            ret.add(e.getEntry().toString());
        }
        locpe = this.classpathManager.getExtraCP();
        for (ClasspathEntry e : locpe) {
            ret.add(e.getEntry().toString());
        }
        return ret;
    }

    @Override
    public void addExtraClassPath(String s) {
        try {
            this.addExtraClassPath(new URL(s));
        }
        catch (MalformedURLException e) {
            throw new UnexpectedException(e);
        }
    }

    @Override
    public void addProjectClassPath(String s) {
        try {
            this.addProjectClassPath(new URL(s));
        }
        catch (MalformedURLException e) {
            throw new UnexpectedException(e);
        }
    }

    @Override
    public void addBuildDirectoryClassPath(String s) {
        try {
            this.addBuildDirectoryClassPath(new URL(s));
        }
        catch (MalformedURLException e) {
            throw new UnexpectedException(e);
        }
    }

    @Override
    public void addProjectFilesClassPath(String s) {
        try {
            this.addProjectFilesClassPath(new URL(s));
        }
        catch (MalformedURLException e) {
            throw new UnexpectedException(e);
        }
    }

    @Override
    public void addExternalFilesClassPath(String s) {
        try {
            this.addExternalFilesClassPath(new URL(s));
        }
        catch (MalformedURLException e) {
            throw new UnexpectedException(e);
        }
    }

    @Override
    public ClasspathVector getClasspath() {
        ClasspathVector ret = new ClasspathVector();
        List<ClasspathEntry> locpe = this.classpathManager.getProjectCP();
        for (ClasspathEntry e : locpe) {
            ret.add(e.getEntry());
        }
        locpe = this.classpathManager.getBuildDirectoryCP();
        for (ClasspathEntry e : locpe) {
            ret.add(e.getEntry());
        }
        locpe = this.classpathManager.getProjectFilesCP();
        for (ClasspathEntry e : locpe) {
            ret.add(e.getEntry());
        }
        locpe = this.classpathManager.getExternalFilesCP();
        for (ClasspathEntry e : locpe) {
            ret.add(e.getEntry());
        }
        locpe = this.classpathManager.getExtraCP();
        for (ClasspathEntry e : locpe) {
            ret.add(e.getEntry());
        }
        return ret;
    }
}

