/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.repl;

import edu.rice.cs.drjava.model.repl.DynamicJavaAdapter;
import edu.rice.cs.drjava.model.repl.ExceptionReturnedException;
import edu.rice.cs.drjava.model.repl.InteractionsDocumentAdapter;
import edu.rice.cs.drjava.model.repl.InteractionsModel;
import edu.rice.cs.drjava.model.repl.Interpreter;
import edu.rice.cs.drjava.model.repl.JavaInterpreter;
import edu.rice.cs.drjava.model.repl.newjvm.ClasspathManager;
import edu.rice.cs.drjava.model.repl.newjvm.InterpreterJVM;
import edu.rice.cs.util.swing.Utilities;
import java.net.URL;

public class SimpleInteractionsModel
extends InteractionsModel {
    protected static final int WRITE_DELAY = 5;
    protected JavaInterpreter _interpreter = new DynamicJavaAdapter(new ClasspathManager());

    public SimpleInteractionsModel() {
        this(new InteractionsDocumentAdapter());
    }

    public SimpleInteractionsModel(InteractionsDocumentAdapter document) {
        super(document, 1000, 5);
        this._interpreter.defineVariable("INTERPRETER", this._interpreter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _interpret(String toEval) {
        try {
            Object result = this._interpreter.interpret(toEval);
            if (result != Interpreter.NO_RESULT) {
                this._docAppend(String.valueOf(result) + System.getProperty("line.separator"), "object.return.style");
            }
        }
        catch (ExceptionReturnedException e) {
            Throwable t = e.getContainedException();
            this._document.appendExceptionResult(t.getClass().getName(), t.getMessage(), InterpreterJVM.getStackTrace(t), "default");
        }
        finally {
            this._interactionIsOver();
        }
    }

    public String getVariableToString(String var) {
        Object value = this._interpreter.getVariable(var);
        return value.toString();
    }

    public String getVariableClassName(String var) {
        Class c = this._interpreter.getVariableClass(var);
        return c.getName();
    }

    public void addProjectClassPath(URL path) {
        this._interpreter.addProjectClassPath(path);
    }

    public void addBuildDirectoryClassPath(URL path) {
        this._interpreter.addBuildDirectoryClassPath(path);
    }

    public void addProjectFilesClassPath(URL path) {
        this._interpreter.addProjectFilesClassPath(path);
    }

    public void addExternalFilesClassPath(URL path) {
        this._interpreter.addExternalFilesClassPath(path);
    }

    public void addExtraClassPath(URL path) {
        this._interpreter.addExtraClassPath(path);
    }

    public void defineVariable(String name, Object value) {
        this._interpreter.defineVariable(name, value);
    }

    public void defineConstant(String name, Object value) {
        this._interpreter.defineConstant(name, value);
    }

    public void setInterpreterPrivateAccessible(boolean accessible) {
        this._interpreter.setPrivateAccessible(accessible);
    }

    protected void _interpreterResetFailed(Throwable t) {
        this._document.insertBeforeLastPrompt("Reset Failed!" + _newLine, "error");
    }

    protected void _resetInterpreter() {
        this.interpreterResetting();
        this._interpreter = new DynamicJavaAdapter(new ClasspathManager());
        this.interpreterReady();
    }

    protected void _notifyInteractionStarted() {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                SimpleInteractionsModel.this._notifier.interactionStarted();
            }
        });
    }

    protected void _notifyInteractionEnded() {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                SimpleInteractionsModel.this._notifier.interactionEnded();
            }
        });
    }

    protected void _notifySyntaxErrorOccurred(final int offset, final int length) {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                SimpleInteractionsModel.this._notifier.interactionErrorOccurred(offset, length);
            }
        });
    }

    protected void _notifyInterpreterResetting() {
    }

    protected void _notifyInterpreterReady() {
    }

    protected void _notifyInterpreterExited(int status) {
    }

    protected void _notifyInterpreterResetFailed(Throwable t) {
    }

    protected void _notifyInteractionIncomplete() {
    }
}

