/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.repl;

import edu.rice.cs.drjava.model.repl.InteractionsModel;
import edu.rice.cs.drjava.model.repl.newjvm.MainJVM;
import edu.rice.cs.util.text.ConsoleInterface;
import java.net.URL;
import java.util.Vector;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RMIInteractionsModel
extends InteractionsModel {
    protected final MainJVM _interpreterControl;

    public RMIInteractionsModel(MainJVM control, ConsoleInterface adapter, int historySize, int writeDelay) {
        super(adapter, historySize, writeDelay);
        this._interpreterControl = control;
    }

    @Override
    protected void _interpret(String toEval) {
        this._interpreterControl.interpret(toEval);
    }

    @Override
    public String getVariableToString(String var) {
        return this._interpreterControl.getVariableToString(var);
    }

    @Override
    public String getVariableClassName(String var) {
        return this._interpreterControl.getVariableClassName(var);
    }

    @Override
    public void addProjectClassPath(URL path) {
        this._interpreterControl.addProjectClassPath(path);
    }

    @Override
    public void addBuildDirectoryClassPath(URL path) {
        this._interpreterControl.addBuildDirectoryClassPath(path);
    }

    @Override
    public void addProjectFilesClassPath(URL path) {
        this._interpreterControl.addProjectFilesClassPath(path);
    }

    @Override
    public void addExternalFilesClassPath(URL path) {
        this._interpreterControl.addExternalFilesClassPath(path);
    }

    @Override
    public void addExtraClassPath(URL path) {
        this._interpreterControl.addExtraClassPath(path);
    }

    @Override
    protected void _resetInterpreter() {
        this._interpreterControl.killInterpreter(true);
    }

    public void addJavaInterpreter(String name) {
        this._interpreterControl.addJavaInterpreter(name);
    }

    public void addDebugInterpreter(String name, String className) {
        this._interpreterControl.addDebugInterpreter(name, className);
    }

    public void removeInterpreter(String name) {
        this._interpreterControl.removeInterpreter(name);
    }

    public void setActiveInterpreter(String name, String prompt) {
        String currName = this._interpreterControl.getCurrentInterpreterName();
        boolean inProgress = this._interpreterControl.setActiveInterpreter(name);
        this._updateDocument(prompt, inProgress, !currName.equals(name));
        this._notifyInterpreterChanged(inProgress);
    }

    public void setToDefaultInterpreter() {
        String currName = this._interpreterControl.getCurrentInterpreterName();
        boolean printPrompt = !"DEFAULT".equals(currName);
        boolean inProgress = this._interpreterControl.setToDefaultInterpreter();
        this._updateDocument("> ", inProgress, printPrompt);
        this._notifyInterpreterChanged(inProgress);
    }

    protected void _updateDocument(String prompt, boolean inProgress, boolean updatePrompt) {
        if (updatePrompt) {
            this._document.setPrompt(prompt);
            this._document.insertNewLine(this._document.getLength());
            this._document.insertPrompt();
        }
        this._document.setInProgress(inProgress);
    }

    protected abstract void _notifyInterpreterChanged(boolean var1);

    public void setPrivateAccessible(boolean allow) {
        this._interpreterControl.setPrivateAccessible(allow);
    }

    public Vector<URL> getClasspath() {
        return this._interpreterControl.getClasspath();
    }
}

