/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.repl;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.model.DefaultGlobalModel;
import edu.rice.cs.drjava.model.repl.RMIInteractionsModel;
import edu.rice.cs.drjava.model.repl.newjvm.MainJVM;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.swing.Utilities;
import edu.rice.cs.util.text.ConsoleInterface;

public class DefaultInteractionsModel
extends RMIInteractionsModel {
    protected final DefaultGlobalModel _model;

    public DefaultInteractionsModel(DefaultGlobalModel model, MainJVM control, ConsoleInterface adapter) {
        super(control, adapter, DrJava.getConfig().getSetting(OptionConstants.HISTORY_MAX_SIZE), 5);
        this._model = model;
        Boolean allow = DrJava.getConfig().getSetting(OptionConstants.JAVAC_ALLOW_ASSERT);
        this._interpreterControl.setAllowAssertions(allow);
        DrJava.getConfig().addOptionListener(OptionConstants.HISTORY_MAX_SIZE, this._document.getHistoryOptionListener());
        DrJava.getConfig().addOptionListener(OptionConstants.JAVAC_ALLOW_ASSERT, new OptionListener<Boolean>(){

            @Override
            public void optionChanged(OptionEvent<Boolean> oce) {
                DefaultInteractionsModel.this._interpreterControl.setAllowAssertions((Boolean)oce.value);
            }
        });
    }

    public void replSystemOutPrint(String s) {
        super.replSystemOutPrint(s);
        this._model.systemOutPrint(s);
    }

    public void replSystemErrPrint(String s) {
        super.replSystemErrPrint(s);
        this._model.systemErrPrint(s);
    }

    protected void _interpreterResetFailed(Throwable t) {
        this._document.insertBeforeLastPrompt("Reset Failed! See the console tab for details." + _newLine, "error");
        this._model.systemErrPrint(StringOps.getStackTrace(t));
    }

    public void interpreterReady() {
        this._model.resetInteractionsClasspath();
        super.interpreterReady();
    }

    protected void _notifyInteractionStarted() {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                DefaultInteractionsModel.this._notifier.interactionStarted();
            }
        });
    }

    protected void _notifyInteractionEnded() {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                DefaultInteractionsModel.this._notifier.interactionEnded();
            }
        });
    }

    protected void _notifySyntaxErrorOccurred(final int offset, final int length) {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                DefaultInteractionsModel.this._notifier.interactionErrorOccurred(offset, length);
            }
        });
    }

    protected void _notifyInterpreterChanged(final boolean inProgress) {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                DefaultInteractionsModel.this._notifier.interpreterChanged(inProgress);
            }
        });
    }

    protected void _notifyInterpreterResetting() {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                DefaultInteractionsModel.this._notifier.interpreterResetting();
            }
        });
    }

    protected void _notifyInterpreterReady() {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                DefaultInteractionsModel.this._notifier.interpreterReady();
            }
        });
    }

    protected void _notifyInterpreterExited(final int status) {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                DefaultInteractionsModel.this._notifier.interpreterExited(status);
            }
        });
    }

    protected void _notifyInterpreterResetFailed(final Throwable t) {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                DefaultInteractionsModel.this._notifier.interpreterResetFailed(t);
            }
        });
    }

    protected void _notifyInteractionIncomplete() {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                DefaultInteractionsModel.this._notifier.interactionIncomplete();
            }
        });
    }
}

