/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.junit;

import edu.rice.cs.drjava.model.junit.DrJavaTestSuiteLoader;
import edu.rice.cs.drjava.model.junit.JUnitModelCallback;
import java.io.PrintStream;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.runner.TestSuiteLoader;
import junit.textui.TestRunner;

public class JUnitTestRunner
extends TestRunner {
    private JUnitModelCallback _jmc;
    private PrintStream _writer;
    private TestSuiteLoader _classLoader;
    private TestResult _result;
    private int _errorCount;
    private int _failureCount;

    public JUnitTestRunner(JUnitModelCallback jmc) {
        this._jmc = jmc;
        this._classLoader = new DrJavaTestSuiteLoader(jmc);
        this._writer = new PrintStream(System.out){

            public void print(String s) {
            }

            public void println(String s) {
            }

            public void println() {
            }
        };
        this._errorCount = 0;
        this._failureCount = 0;
    }

    public synchronized TestResult doRun(Test suite) {
        this._errorCount = 0;
        this._failureCount = 0;
        this._jmc.testSuiteStarted(suite.countTestCases());
        this._result = this.createTestResult();
        this._result.addListener(this);
        suite.run(this._result);
        return this._result;
    }

    public TestSuiteLoader getLoader() {
        return this._classLoader;
    }

    protected PrintStream getWriter() {
        return this._writer;
    }

    protected PrintStream writer() {
        return this.getWriter();
    }

    public synchronized void startTest(Test test) {
        this._jmc.testStarted(test.toString());
    }

    public synchronized void endTest(Test test) {
        boolean error = false;
        boolean failure = false;
        if (this._result.errorCount() > this._errorCount) {
            error = true;
            ++this._errorCount;
        }
        if (this._result.failureCount() > this._failureCount) {
            failure = true;
            ++this._failureCount;
        }
        boolean success = !failure && !error;
        this._jmc.testEnded(test.toString(), success, failure);
    }
}

