/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.junit;

import edu.rice.cs.drjava.model.junit.JUnitError;
import edu.rice.cs.drjava.model.junit.JUnitModelCallback;
import edu.rice.cs.drjava.model.junit.JUnitTestRunner;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.classloader.ClassFileError;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitTestManager {
    private final JUnitModelCallback _jmc;
    private JUnitTestRunner _testRunner;
    private TestSuite _suite = null;
    private List<String> _testClassNames = null;
    private List<File> _testFiles = null;
    static /* synthetic */ Class class$junit$framework$Test;

    public JUnitTestManager(JUnitModelCallback jmc) {
        this._jmc = jmc;
    }

    public JUnitTestRunner getTestRunner() {
        return this._testRunner;
    }

    public List<String> findTestClasses(List<String> classNames, List<File> files) {
        if (this._testClassNames != null && !this._testClassNames.isEmpty()) {
            throw new IllegalStateException("Test suite is still pending!");
        }
        this._testRunner = new JUnitTestRunner(this._jmc);
        this._testClassNames = new ArrayList<String>();
        this._testFiles = new ArrayList<File>();
        this._suite = new TestSuite();
        int i = 0;
        try {
            for (i = 0; i < classNames.size(); ++i) {
                String cName = classNames.get(i);
                try {
                    if (!this._isTestCase(cName)) continue;
                    this._testClassNames.add(cName);
                    this._testFiles.add(files.get(i));
                    this._suite.addTest(this._testRunner.getTest(cName));
                    continue;
                }
                catch (LinkageError e) {
                    this._jmc.classFileError(new ClassFileError(cName, files.get(i).getCanonicalPath(), e));
                }
            }
        }
        catch (IOException e) {
            throw new UnexpectedException(e);
        }
        return this._testClassNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runTestSuite() {
        if (this._testClassNames == null || this._testClassNames.isEmpty()) {
            return false;
        }
        try {
            TestResult result = this._testRunner.doRun(this._suite);
            JUnitError[] errors = new JUnitError[result.errorCount() + result.failureCount()];
            Enumeration failures = result.failures();
            Enumeration errEnum = result.errors();
            int i = 0;
            while (errEnum.hasMoreElements()) {
                TestFailure tErr = (TestFailure)errEnum.nextElement();
                errors[i] = this._makeJUnitError(tErr, this._testClassNames, true, this._testFiles);
                ++i;
            }
            while (failures.hasMoreElements()) {
                TestFailure tFail = (TestFailure)failures.nextElement();
                errors[i] = this._makeJUnitError(tFail, this._testClassNames, false, this._testFiles);
                ++i;
            }
            this._jmc.testSuiteEnded(errors);
        }
        catch (Throwable t) {
            JUnitError[] errors = new JUnitError[]{new JUnitError(null, -1, -1, t.getMessage(), false, "", "", StringOps.getStackTrace(t))};
            this._jmc.testSuiteEnded(errors);
        }
        finally {
            this._suite = null;
            this._testClassNames = null;
            this._testFiles = null;
        }
        return true;
    }

    private boolean _isJUnitTest(Class c) {
        return (class$junit$framework$Test == null ? (class$junit$framework$Test = JUnitTestManager.class$("junit.framework.Test")) : class$junit$framework$Test).isAssignableFrom(c) && !Modifier.isAbstract(c.getModifiers()) && !Modifier.isInterface(c.getModifiers());
    }

    private boolean _isTestCase(String className) {
        try {
            return this._isJUnitTest(this._testRunner.getLoader().load(className));
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
    }

    private JUnitError _makeJUnitError(TestFailure failure, List<String> classNames, boolean isError, List<File> files) {
        Test failedTest = failure.failedTest();
        String testName = failedTest instanceof TestCase ? ((TestCase)failedTest).getName() : failedTest.getClass().getName();
        String testString = failure.toString();
        int firstIndex = testString.indexOf(40) + 1;
        int secondIndex = testString.indexOf(41);
        String className1 = testString.substring(firstIndex, secondIndex);
        String className2 = testString.substring(0, firstIndex - 1);
        String className = firstIndex == secondIndex ? className2 : className1;
        String classNameAndTest = new StringBuffer().append(className).append(".").append(testName).toString();
        String stackTrace = StringOps.getStackTrace(failure.thrownException());
        if (stackTrace.indexOf(className) == -1) {
            String trace = failure.trace();
            trace = trace.substring(trace.indexOf(10) + 1);
            while (trace.indexOf("junit.framework.Assert") != -1 && trace.indexOf("junit.framework.Assert") < trace.indexOf("(")) {
                trace = trace.substring(trace.indexOf(10) + 1);
            }
            trace = trace.substring(trace.indexOf(40) + 1);
            trace = trace.substring(0, trace.indexOf(41));
            className = trace.substring(0, trace.indexOf(58));
            className = trace.substring(0, trace.lastIndexOf(46));
            classNameAndTest = new StringBuffer().append(className).append(".").append(testName).toString();
        }
        int lineNum = this._lineNumber(stackTrace, classNameAndTest);
        String exception = isError ? failure.thrownException().toString() : failure.thrownException().getMessage();
        boolean isFailure = failure.thrownException() instanceof AssertionFailedError && !classNameAndTest.equals("junit.framework.TestSuite$1.warning");
        int indexOfClass = classNames.indexOf(className);
        File file = indexOfClass != -1 ? files.get(indexOfClass) : this._jmc.getFileForClassName(className);
        if (file == null) {
            return new JUnitError(new File("nofile"), 0, 0, exception, !isFailure, testName, className, stackTrace);
        }
        return new JUnitError(file, file.getName().endsWith(".dj0") ? lineNum - 1 : lineNum, 0, exception, !isFailure, testName, className, stackTrace);
    }

    private int _lineNumber(String sw, String classname) {
        int lineNum;
        int idxClassname = sw.indexOf(classname);
        if (idxClassname == -1) {
            return -1;
        }
        String theLine = sw.substring(idxClassname, sw.length());
        theLine = theLine.substring(theLine.indexOf(classname), theLine.length());
        theLine = theLine.substring(theLine.indexOf("(") + 1, theLine.length());
        theLine = theLine.substring(0, theLine.indexOf(")"));
        try {
            int i = theLine.indexOf(":") + 1;
            lineNum = Integer.parseInt(theLine.substring(i, theLine.length())) - 1;
        }
        catch (NumberFormatException e) {
            throw new UnexpectedException(e);
        }
        return lineNum;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

