/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.junit;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import junit.runner.TestCaseClassLoader;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DrJavaTestCaseClassLoader
extends TestCaseClassLoader {
    ClassLoader _loader;
    private Vector<String> fPathItems;
    private String[] defaultExclusions = new String[]{"junit.framework.", "junit.extensions.", "junit.runner.", "java."};
    static final String EXCLUDED_FILE = "excluded.properties";
    private Vector<String> fExcluded;

    public DrJavaTestCaseClassLoader() {
        this(System.getProperty("java.class.path"));
    }

    public DrJavaTestCaseClassLoader(String classPath) {
        this._loader = this.getClass().getClassLoader();
        this.scanPath(classPath);
        this.readExcludedPackages();
    }

    private void scanPath(String classPath) {
        String separator = System.getProperty("path.separator");
        this.fPathItems = new Vector(10);
        StringTokenizer st = new StringTokenizer(classPath, separator);
        while (st.hasMoreTokens()) {
            String item = st.nextToken();
            this.fPathItems.addElement(item);
            try {
                this._loader = new DrJavaURLClassLoader(new URL[]{new File(item).toURL()}, this._loader);
            }
            catch (MalformedURLException e) {}
        }
    }

    @Override
    public URL getResource(String name) {
        return this._loader.getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this._loader.getResourceAsStream(name);
    }

    @Override
    public boolean isExcluded(String name) {
        for (int i = 0; i < this.fExcluded.size(); ++i) {
            if (!name.startsWith(this.fExcluded.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        if (this.isExcluded(name)) {
            try {
                c = this.findSystemClass(name);
                return c;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        try {
            if (c == null) {
                byte[] data = this.lookupClassData(name);
                if (data == null) {
                    throw new ClassNotFoundException();
                }
                c = this.defineClass(name, data, 0, data.length);
            }
            if (resolve) {
                this.resolveClass(c);
            }
        }
        catch (ClassNotFoundException e) {
            return this.findSystemClass(name);
        }
        return c;
    }

    private byte[] lookupClassData(String className) throws ClassNotFoundException {
        byte[] data = null;
        for (int i = 0; i < this.fPathItems.size(); ++i) {
            String path = this.fPathItems.elementAt(i);
            String fileName = new StringBuffer().append(className.replace('.', '/')).append(".class").toString();
            data = this.isJar(path) ? this.loadJarData(path, fileName) : this.loadFileData(path, fileName);
            if (data == null) continue;
            return data;
        }
        throw new ClassNotFoundException(className);
    }

    boolean isJar(String pathEntry) {
        return pathEntry.endsWith(".jar") || pathEntry.endsWith(".zip");
    }

    private byte[] loadFileData(String path, String fileName) {
        File file = new File(path, fileName);
        if (file.exists()) {
            return this.getClassData(file);
        }
        return null;
    }

    private byte[] getClassData(File f) {
        try {
            int n;
            FileInputStream stream = new FileInputStream(f);
            ByteArrayOutputStream out = new ByteArrayOutputStream(1000);
            byte[] b = new byte[1000];
            while ((n = stream.read(b)) != -1) {
                out.write(b, 0, n);
            }
            stream.close();
            out.close();
            return out.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadJarData(String path, String fileName) {
        ZipFile zipFile = null;
        InputStream stream = null;
        File archive = new File(path);
        if (!archive.exists()) {
            return null;
        }
        try {
            zipFile = new ZipFile(archive);
        }
        catch (IOException io) {
            return null;
        }
        ZipEntry entry = zipFile.getEntry(fileName);
        if (entry == null) {
            return null;
        }
        int size = (int)entry.getSize();
        try {
            int n;
            stream = zipFile.getInputStream(entry);
            byte[] data = new byte[size];
            for (int pos = 0; pos < size; pos += n) {
                n = stream.read(data, pos, data.length - pos);
            }
            zipFile.close();
            byte[] byArray = data;
            return byArray;
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void readExcludedPackages() {
        Properties p;
        block14: {
            this.fExcluded = new Vector(10);
            for (String de : this.defaultExclusions) {
                this.fExcluded.addElement(de);
            }
            InputStream is = this.getClass().getResourceAsStream(EXCLUDED_FILE);
            if (is == null) {
                return;
            }
            p = new Properties();
            p.load(is);
            try {
                is.close();
            }
            catch (IOException e) {}
            break block14;
            catch (IOException e) {
                try {
                    is.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                return;
                catch (Throwable throwable) {
                    try {
                        is.close();
                    }
                    catch (IOException e3) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        Enumeration<?> pnames = p.propertyNames();
        while (pnames.hasMoreElements()) {
            String key = (String)pnames.nextElement();
            if (!key.startsWith("excluded.")) continue;
            String path = p.getProperty(key);
            if ((path = path.trim()).endsWith("*")) {
                path = path.substring(0, path.length() - 1);
            }
            if (path.length() <= 0) continue;
            this.fExcluded.addElement(path);
        }
    }

    private static class DrJavaURLClassLoader
    extends URLClassLoader {
        public DrJavaURLClassLoader(URL[] urls, ClassLoader c) {
            super(urls, c);
        }

        public URL getResource(String name) {
            URL ret = this.getParent().getResource(name);
            if (ret == null) {
                ret = super.getResource(name);
            }
            return ret;
        }
    }
}

