/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.junit;

import edu.rice.cs.drjava.model.GlobalModel;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.compiler.CompilerModel;
import edu.rice.cs.drjava.model.definitions.InvalidPackageException;
import edu.rice.cs.drjava.model.junit.JUnitError;
import edu.rice.cs.drjava.model.junit.JUnitErrorModel;
import edu.rice.cs.drjava.model.junit.JUnitEventNotifier;
import edu.rice.cs.drjava.model.junit.JUnitListener;
import edu.rice.cs.drjava.model.junit.JUnitModel;
import edu.rice.cs.drjava.model.junit.JUnitModelCallback;
import edu.rice.cs.drjava.model.repl.newjvm.MainJVM;
import edu.rice.cs.util.ClasspathVector;
import edu.rice.cs.util.ExitingNotAllowedException;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.classloader.ClassFileError;
import edu.rice.cs.util.text.SwingDocument;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJUnitModel
implements JUnitModel,
JUnitModelCallback {
    private final JUnitEventNotifier _notifier = new JUnitEventNotifier();
    private final MainJVM _jvm;
    private final CompilerModel _compilerModel;
    private final GlobalModel _model;
    private JUnitErrorModel _junitErrorModel;
    private boolean _testInProgress = false;
    private final Object _testLock = new Object();
    private final SwingDocument _junitDoc = new SwingDocument();

    public DefaultJUnitModel(MainJVM jvm, CompilerModel compilerModel, GlobalModel model) {
        this._jvm = jvm;
        this._compilerModel = compilerModel;
        this._model = model;
        this._junitErrorModel = new JUnitErrorModel(new JUnitError[0], this._model, false);
    }

    @Override
    public void addListener(JUnitListener listener) {
        this._notifier.addListener(listener);
    }

    @Override
    public void removeListener(JUnitListener listener) {
        this._notifier.removeListener(listener);
    }

    @Override
    public void removeAllListeners() {
        this._notifier.removeAllListeners();
    }

    @Override
    public SwingDocument getJUnitDocument() {
        return this._junitDoc;
    }

    @Override
    public void junitAll() {
        this.junitDocs(this._model.getOpenDefinitionsDocuments());
    }

    @Override
    public void junitProject() {
        LinkedList<OpenDefinitionsDocument> lod = new LinkedList<OpenDefinitionsDocument>();
        for (OpenDefinitionsDocument doc : this._model.getOpenDefinitionsDocuments()) {
            if (!doc.isInProjectPath() && !doc.isAuxiliaryFile()) continue;
            lod.add(doc);
        }
        this.junitDocs(lod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void junitClasses(List<String> qualifiedClassnames, List<File> files) {
        Object object = this._compilerModel.getSlaveJVMLock();
        synchronized (object) {
            List<String> testClasses;
            Object object2 = this._testLock;
            synchronized (object2) {
                if (this._testInProgress) {
                    return;
                }
                this._testInProgress = true;
            }
            try {
                testClasses = this._jvm.findTestClasses(qualifiedClassnames, files);
            }
            catch (IOException e) {
                throw new UnexpectedException(e);
            }
            if (testClasses.isEmpty()) {
                this.nonTestCase(true);
                return;
            }
            this._notifier.junitClassesStarted();
            try {
                this._jvm.runTestSuite();
            }
            catch (Throwable t) {
                this._notifier.junitEnded();
                Object object3 = this._testLock;
                synchronized (object3) {
                    this._testInProgress = false;
                }
                throw new UnexpectedException(t);
            }
        }
    }

    @Override
    public void junitDocs(List<OpenDefinitionsDocument> lod) {
        this.junitOpenDefDocs(lod, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void junit(OpenDefinitionsDocument doc) throws ClassNotFoundException, IOException {
        try {
            File testFile = doc.getFile();
            LinkedList<OpenDefinitionsDocument> lod = new LinkedList<OpenDefinitionsDocument>();
            lod.add(doc);
            this.junitOpenDefDocs(lod, false);
        }
        catch (IllegalStateException e) {
            this.nonTestCase(false);
            return;
        }
        catch (NoClassDefFoundError e) {
            this._notifier.junitEnded();
            Object object = this._testLock;
            synchronized (object) {
                this._testInProgress = false;
            }
            throw e;
        }
        catch (ExitingNotAllowedException enae) {
            this._notifier.junitEnded();
            Object object = this._testLock;
            synchronized (object) {
                this._testInProgress = false;
            }
            throw enae;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void junitOpenDefDocs(List<OpenDefinitionsDocument> lod, boolean allTests) {
        String packageName;
        Object object = this._testLock;
        synchronized (object) {
            if (this._testInProgress) {
                return;
            }
            this._testInProgress = true;
        }
        this._junitErrorModel = new JUnitErrorModel(new JUnitError[0], null, false);
        File builtDir = this._model.getBuildDirectory();
        LinkedList<File> classDirs = new LinkedList<File>();
        LinkedList sourceFiles = new LinkedList();
        LinkedList<String> classpaths = new LinkedList<String>();
        String cpString = this.getClasspath().toString();
        int cpLength = cpString.length();
        if (cpString.indexOf(File.pathSeparatorChar) == -1 && cpLength > 0) {
            classpaths.add(cpString);
        } else {
            int cpIndex;
            while ((cpIndex = cpString.indexOf(File.pathSeparatorChar)) != -1 && cpLength != 1) {
                if (cpIndex == 0) {
                    cpString = cpString.substring(1, cpLength);
                    continue;
                }
                classpaths.add(cpString.substring(0, cpIndex));
                cpString = cpString.substring(cpIndex, cpLength - 1);
                cpLength = cpString.length();
            }
        }
        for (OpenDefinitionsDocument doc : lod) {
            try {
                File temp;
                try {
                    packageName = doc.getPackageName();
                }
                catch (InvalidPackageException e) {
                    packageName = "";
                }
                packageName = packageName.replace('.', File.separatorChar);
                if (builtDir == null) {
                    builtDir = doc.getSourceRoot();
                }
                if (classDirs.contains(temp = new File(new StringBuffer().append(builtDir.getCanonicalPath()).append(File.separator).append(packageName).toString()))) continue;
                classDirs.add(temp);
            }
            catch (IOException e) {
            }
            catch (InvalidPackageException e) {}
        }
        for (OpenDefinitionsDocument doc : lod) {
            try {
                try {
                    packageName = doc.getPackageName();
                }
                catch (InvalidPackageException e) {
                    packageName = "";
                }
                packageName = packageName.replace('.', File.separatorChar);
                for (String classpath : classpaths) {
                    File temp = new File(new File(classpath).getCanonicalPath());
                    if (!temp.isDirectory() || classDirs.contains(temp = new File(new StringBuffer().append(temp.getCanonicalPath()).append(File.separator).append(packageName).toString()))) continue;
                    classDirs.addLast(temp);
                }
            }
            catch (IOException e) {
            }
        }
        ArrayList<File> files = new ArrayList<File>();
        ArrayList<String> classNames = new ArrayList<String>();
        HashMap<String, OpenDefinitionsDocument> classNamesToODDs = new HashMap<String, OpenDefinitionsDocument>();
        try {
            block37: for (File dir : classDirs) {
                File[] listing = dir.listFiles();
                if (listing == null) continue;
                block38: for (File entry : listing) {
                    if (!entry.isFile() || !entry.getPath().endsWith(".class")) continue;
                    try {
                        JavaClass clazz = new ClassParser(entry.getCanonicalPath()).parse();
                        String classname = clazz.getClassName();
                        int indexOfDot = classname.lastIndexOf(46);
                        String prefixString = classname.substring(0, indexOfDot + 1);
                        String prefixPath = prefixString.replace('.', File.separatorChar);
                        String filePath = new StringBuffer().append(prefixPath).append(clazz.getSourceFileName()).toString();
                        int indexOfExtDot = filePath.lastIndexOf(46);
                        if (indexOfExtDot == -1) continue block37;
                        String pathName = filePath.substring(0, indexOfExtDot);
                        for (OpenDefinitionsDocument doc : lod) {
                            try {
                                File f = doc.getFile();
                                String fullPathName = new StringBuffer().append(doc.getSourceRoot().getCanonicalPath()).append(File.separator).append(pathName).toString();
                                String pathForF = f.getCanonicalPath();
                                int index = pathForF.lastIndexOf(46);
                                if (index == -1) continue block38;
                                String fullPathNameFromDoc = pathForF.substring(0, index);
                                String ext = pathForF.substring(index, pathForF.length());
                                if (!fullPathNameFromDoc.equals(fullPathName) || !ext.equals(".java") && !ext.equals(".dj0") && !ext.equals(".dj1") && !ext.equals(".dj2")) continue;
                                if (classNamesToODDs.containsKey(classname)) continue block38;
                                classNames.add(classname);
                                files.add(f);
                                classNamesToODDs.put(classname, doc);
                                continue block38;
                            }
                            catch (InvalidPackageException e) {
                            }
                            catch (IOException e) {
                            }
                            catch (IllegalStateException e) {
                            }
                        }
                    }
                    catch (IOException e) {
                    }
                    catch (ClassFormatException e) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Throwable t) {
            throw new UnexpectedException(t);
        }
        Object object2 = this._compilerModel.getSlaveJVMLock();
        synchronized (object2) {
            List<String> tests;
            try {
                tests = this._jvm.findTestClasses(classNames, files);
            }
            catch (IOException e) {
                throw new UnexpectedException(e);
            }
            if (tests == null || tests.isEmpty()) {
                this.nonTestCase(allTests);
                return;
            }
            ArrayList<OpenDefinitionsDocument> odds = new ArrayList<OpenDefinitionsDocument>();
            for (String name : tests) {
                odds.add((OpenDefinitionsDocument)classNamesToODDs.get(name));
            }
            try {
                this._notifier.junitStarted(odds);
                this._jvm.runTestSuite();
            }
            catch (Throwable t) {
                this._notifier.junitEnded();
                Object object3 = this._testLock;
                synchronized (object3) {
                    this._testInProgress = false;
                }
                throw new UnexpectedException(t);
            }
        }
    }

    @Override
    public JUnitErrorModel getJUnitErrorModel() {
        return this._junitErrorModel;
    }

    @Override
    public void resetJUnitErrors() {
        this._junitErrorModel = new JUnitErrorModel(new JUnitError[0], this._model, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nonTestCase(boolean isTestAll) {
        this._notifier.nonTestCase(isTestAll);
        Object object = this._testLock;
        synchronized (object) {
            this._testInProgress = false;
        }
    }

    @Override
    public void classFileError(ClassFileError e) {
        this._notifier.classFileError(e);
    }

    @Override
    public void testSuiteStarted(int numTests) {
        this._notifier.junitSuiteStarted(numTests);
    }

    @Override
    public void testStarted(String testName) {
        this._notifier.junitTestStarted(testName);
    }

    @Override
    public void testEnded(String testName, boolean wasSuccessful, boolean causedError) {
        this._notifier.junitTestEnded(testName, wasSuccessful, causedError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testSuiteEnded(JUnitError[] errors) {
        this._junitErrorModel = new JUnitErrorModel(errors, this._model, true);
        this._notifier.junitEnded();
        Object object = this._testLock;
        synchronized (object) {
            this._testInProgress = false;
        }
    }

    @Override
    public File getFileForClassName(String className) {
        return this._model.getSourceFile(new StringBuffer().append(className).append(".java").toString());
    }

    @Override
    public ClasspathVector getClasspath() {
        return this._jvm.getClasspath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void junitJVMReady() {
        Object object = this._testLock;
        synchronized (object) {
            if (!this._testInProgress) {
                return;
            }
        }
        JUnitError[] errors = new JUnitError[]{new JUnitError("Previous test suite was interrupted", true, "")};
        this._junitErrorModel = new JUnitErrorModel(errors, this._model, true);
        this._notifier.junitEnded();
        Object object2 = this._testLock;
        synchronized (object2) {
            this._testInProgress = false;
        }
    }
}

