/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.definitions.indent;

import edu.rice.cs.drjava.model.AbstractDJDocument;
import edu.rice.cs.drjava.model.definitions.indent.IndentRule;
import edu.rice.cs.drjava.model.definitions.indent.IndentRuleQuestion;
import edu.rice.cs.drjava.model.definitions.reducedmodel.IndentInfo;
import edu.rice.cs.util.UnexpectedException;
import javax.swing.text.BadLocationException;

public class QuestionStartAfterOpenBrace
extends IndentRuleQuestion {
    public QuestionStartAfterOpenBrace(IndentRule yesRule, IndentRule noRule) {
        super(yesRule, noRule);
    }

    boolean applyRule(AbstractDJDocument doc, int reason) {
        int origin = doc.getCurrentLocation();
        int lineStart = doc.getLineStartPos(doc.getCurrentLocation());
        doc.move(lineStart - origin);
        IndentInfo info = doc.getIndentInformation();
        doc.move(origin - lineStart);
        if (!info.braceType.equals("{") || info.distToBrace < 0) {
            return false;
        }
        int bracePos = lineStart - info.distToBrace;
        int braceEndLinePos = doc.getLineEndPos(bracePos);
        int nextNonWS = -1;
        try {
            nextNonWS = doc.getFirstNonWSCharPos(braceEndLinePos);
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        if (nextNonWS == -1) {
            return true;
        }
        return nextNonWS >= lineStart;
    }
}

