/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.definitions;

import edu.rice.cs.drjava.model.AbstractDJDocument;
import edu.rice.cs.drjava.model.Finalizable;
import edu.rice.cs.drjava.model.FinalizationEvent;
import edu.rice.cs.drjava.model.FinalizationListener;
import edu.rice.cs.drjava.model.GlobalEventNotifier;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.definitions.ClassNameNotFoundException;
import edu.rice.cs.drjava.model.definitions.CompoundUndoManager;
import edu.rice.cs.drjava.model.definitions.DocumentClosedListener;
import edu.rice.cs.drjava.model.definitions.InvalidPackageException;
import edu.rice.cs.drjava.model.definitions.indent.Indenter;
import edu.rice.cs.drjava.model.definitions.reducedmodel.BraceReduction;
import edu.rice.cs.drjava.model.definitions.reducedmodel.IndentInfo;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelStates;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedToken;
import edu.rice.cs.util.UnexpectedException;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefinitionsDocument
extends AbstractDJDocument
implements Finalizable<DefinitionsDocument> {
    private final int NO_COMMENT_OFFSET = 0;
    private final int WING_COMMENT_OFFSET = 2;
    List<DocumentClosedListener> _closedListeners = new LinkedList<DocumentClosedListener>();
    private static final int UNDO_LIMIT = 1000;
    private static boolean _tabsRemoved = true;
    private boolean _modifiedSinceSave = false;
    private boolean _classFileInSync = false;
    private int _cachedLocation;
    private int _cachedLineNum;
    private int _cachedPrevLineLoc;
    private int _cachedNextLineLoc;
    private File _classFile;
    private OpenDefinitionsDocument _odd;
    private CompoundUndoManager _undoManager;
    private final GlobalEventNotifier _notifier;
    private List<FinalizationListener<DefinitionsDocument>> _finalizationListeners = new LinkedList<FinalizationListener<DefinitionsDocument>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocumentClosedListener(DocumentClosedListener l) {
        List<DocumentClosedListener> list = this._closedListeners;
        synchronized (list) {
            this._closedListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDocumentClosedListener(DocumentClosedListener l) {
        List<DocumentClosedListener> list = this._closedListeners;
        synchronized (list) {
            this._closedListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this._removeIndenter();
        List<DocumentClosedListener> list = this._closedListeners;
        synchronized (list) {
            for (DocumentClosedListener l : this._closedListeners) {
                l.close();
            }
            this._closedListeners = new LinkedList<DocumentClosedListener>();
        }
    }

    public DefinitionsDocument(Indenter indenter, GlobalEventNotifier notifier) {
        super(indenter);
        this._notifier = notifier;
        this._init();
        this.resetUndoManager();
    }

    public DefinitionsDocument(GlobalEventNotifier notifier) {
        this._notifier = notifier;
        this._init();
        this.resetUndoManager();
    }

    public DefinitionsDocument(GlobalEventNotifier notifier, CompoundUndoManager undoManager) {
        this._notifier = notifier;
        this._init();
        this._undoManager = undoManager;
    }

    @Override
    protected Indenter makeNewIndenter(int indentLevel) {
        return new Indenter(indentLevel);
    }

    private void _init() {
        this._odd = null;
        this._cachedLocation = 0;
        this._cachedLineNum = 1;
        this._cachedPrevLineLoc = -1;
        this._cachedNextLineLoc = -1;
        this._classFile = null;
        this._cacheInUse = false;
    }

    public void aquireWriteLock() {
        this.writeLock();
    }

    @Override
    public void releaseWriteLock() {
        this.writeUnlock();
    }

    public void aquireReadLock() {
        this.readLock();
    }

    @Override
    public void releaseReadLock() {
        this.readUnlock();
    }

    public void setOpenDefDoc(OpenDefinitionsDocument odd) {
        if (this._odd == null) {
            this._odd = odd;
        }
    }

    public OpenDefinitionsDocument getOpenDefDoc() {
        if (this._odd == null) {
            throw new IllegalStateException("The OpenDefinitionsDocument for this DefinitionsDocument has never been set");
        }
        return this._odd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _styleChanged() {
        this.writeLock();
        try {
            int length = this.getLength() - this._currentLocation;
            AbstractDocument.DefaultDocumentEvent evt = new AbstractDocument.DefaultDocumentEvent(this, this._currentLocation, length, DocumentEvent.EventType.CHANGE);
            this.fireChangedUpdate(evt);
        }
        finally {
            this.writeUnlock();
        }
    }

    public String getQualifiedClassName() throws ClassNameNotFoundException {
        return new StringBuffer().append(this._getPackageQualifier()).append(this.getFirstTopLevelClassName()).toString();
    }

    public String getQualifiedClassName(int pos) throws ClassNameNotFoundException {
        return new StringBuffer().append(this._getPackageQualifier()).append(this.getEnclosingTopLevelClassName(pos)).toString();
    }

    protected String _getPackageQualifier() {
        String packageName = "";
        try {
            packageName = this.getPackageName();
        }
        catch (InvalidPackageException invalidPackageException) {
            // empty catch block
        }
        if (packageName != null && !packageName.equals("")) {
            packageName = new StringBuffer().append(packageName).append(".").toString();
        }
        return packageName;
    }

    public void setClassFileInSync(boolean inSync) {
        this._classFileInSync = inSync;
    }

    public boolean getClassFileInSync() {
        return this._classFileInSync;
    }

    public void setCachedClassFile(File classFile) {
        this._classFile = classFile;
    }

    public File getCachedClassFile() {
        return this._classFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        this.writeLock();
        try {
            if (_tabsRemoved) {
                str = DefinitionsDocument._removeTabs(str);
            }
            this.setModifiedSinceSave();
            super.insertString(offset, str, a);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(int offset, int len) throws BadLocationException {
        this.writeLock();
        try {
            this.setModifiedSinceSave();
            super.remove(offset, len);
        }
        finally {
            this.writeUnlock();
        }
    }

    static String _removeTabs(String source) {
        return source.replace('\t', ' ');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateModifiedSinceSave() {
        this.writeLock();
        try {
            this._modifiedSinceSave = this._undoManager.isModified();
        }
        finally {
            this.writeUnlock();
            if (!this._modifiedSinceSave && this._odd != null) {
                this._odd.documentReset();
            }
        }
    }

    private void setModifiedSinceSave() {
        if (!this._modifiedSinceSave) {
            this._modifiedSinceSave = true;
            this._classFileInSync = false;
            if (this._odd != null) {
                this._odd.documentModified();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetModification() {
        this.writeLock();
        try {
            this._modifiedSinceSave = false;
            this._undoManager.documentSaved();
        }
        finally {
            this.writeUnlock();
            if (this._odd != null) {
                this._odd.documentReset();
            }
        }
    }

    public boolean isModifiedSinceSave() {
        return this._modifiedSinceSave;
    }

    public int getCurrentCol() {
        int here = this._currentLocation;
        int startOfLine = this.getLineStartPos(here);
        return here - startOfLine;
    }

    public int getCurrentLine() {
        int here = this._currentLocation;
        if (this._cachedLocation > this.getLength()) {
            this._cachedLocation = 0;
            this._cachedLineNum = 1;
        }
        if (this._cachedNextLineLoc > this.getLength()) {
            this._cachedNextLineLoc = -1;
        }
        if (this._cachedPrevLineLoc >= here || here >= this._cachedNextLineLoc) {
            if (this._cachedLocation - here > here) {
                this._cachedLocation = 0;
                this._cachedLineNum = 1;
            }
            int lineOffset = this._getRelativeLine();
            this._cachedLineNum += lineOffset;
        }
        this._cachedLocation = here;
        this._cachedPrevLineLoc = this.getLineStartPos(here);
        this._cachedNextLineLoc = this.getLineEndPos(here);
        return this._cachedLineNum;
    }

    private int _getRelativeLine() {
        int count = 0;
        int currLoc = this._currentLocation;
        this.setCurrentLocation(this._cachedLocation);
        if (this._cachedLocation > currLoc) {
            int prevLineLoc = this.getLineStartPos(this._cachedLocation);
            while (prevLineLoc > currLoc) {
                --count;
                prevLineLoc = this.getLineStartPos(prevLineLoc - 1);
                this.setCurrentLocation(prevLineLoc);
            }
        } else {
            int nextLineLoc = this.getLineEndPos(this._cachedLocation);
            while (nextLineLoc < currLoc) {
                ++count;
                nextLineLoc = this.getLineEndPos(nextLineLoc + 1);
                this.setCurrentLocation(nextLineLoc);
            }
        }
        this.setCurrentLocation(currLoc);
        return count;
    }

    public int getOffset(int lineNum) {
        if (lineNum < 0) {
            return -1;
        }
        String defsText = this.getText();
        int curLine = 1;
        int offset = 0;
        while (offset < defsText.length()) {
            if (curLine == lineNum) {
                return offset;
            }
            int nextNewline = defsText.indexOf(10, offset);
            if (nextNewline == -1) {
                return -1;
            }
            ++curLine;
            offset = nextNewline + 1;
        }
        return -1;
    }

    public boolean tabsRemoved() {
        return _tabsRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int commentLines(int selStart, int selEnd) {
        int toReturn;
        block9: {
            toReturn = selEnd;
            if (selStart == selEnd) {
                this.writeLock();
                try {
                    BraceReduction braceReduction = this._reduced;
                    synchronized (braceReduction) {
                        this.setCurrentLocation(selStart);
                        Position oldCurrentPosition = this.createPosition(this._currentLocation);
                        this._commentLine();
                        toReturn += 2;
                        break block9;
                    }
                }
                catch (BadLocationException e) {
                    throw new UnexpectedException(e);
                }
                finally {
                    this.writeUnlock();
                }
            }
            toReturn = this._commentBlock(selStart, selEnd);
        }
        this._undoManager.endLastCompoundEdit();
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _commentBlock(int start, int end) {
        int afterCommentEnd = end;
        this.writeLock();
        try {
            Position endPos = this.createPosition(end);
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                for (int walker = start; walker < endPos.getOffset(); walker += this._reduced.getDistToNextNewline() + 1) {
                    this.setCurrentLocation(walker);
                    Position walkerPos = this.createPosition(walker);
                    this._commentLine();
                    afterCommentEnd += 2;
                    this.setCurrentLocation(walkerPos.getOffset());
                    walker = walkerPos.getOffset();
                }
            }
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        finally {
            this.writeUnlock();
        }
        return afterCommentEnd;
    }

    private void _commentLine() {
        try {
            this.insertString(this._currentLocation - this.getCurrentCol(), "//", null);
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int uncommentLines(int selStart, int selEnd) {
        int toReturn;
        block9: {
            toReturn = selEnd;
            if (selStart == selEnd) {
                this.writeLock();
                try {
                    BraceReduction braceReduction = this._reduced;
                    synchronized (braceReduction) {
                        this.setCurrentLocation(selStart);
                        Position oldCurrentPosition = this.createPosition(this._currentLocation);
                        this._uncommentLine();
                        toReturn -= 2;
                        break block9;
                    }
                }
                catch (BadLocationException e) {
                    throw new UnexpectedException(e);
                }
                finally {
                    this.writeUnlock();
                }
            }
            toReturn = this._uncommentBlock(selStart, selEnd);
        }
        this._undoManager.endLastCompoundEdit();
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _uncommentBlock(int start, int end) {
        int afterUncommentEnd = end;
        this.writeLock();
        try {
            Position endPos = this.createPosition(end);
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                for (int walker = start; walker < endPos.getOffset(); walker += this._reduced.getDistToNextNewline() + 1) {
                    this.setCurrentLocation(walker);
                    Position walkerPos = this.createPosition(walker);
                    afterUncommentEnd -= this._uncommentLine();
                    this.setCurrentLocation(walkerPos.getOffset());
                    walker = walkerPos.getOffset();
                }
            }
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        finally {
            this.writeUnlock();
        }
        return afterUncommentEnd;
    }

    private int _uncommentLine() throws BadLocationException {
        int curCol = this.getCurrentCol();
        int lineStart = this._currentLocation - curCol;
        String text = this.getText(lineStart, curCol + this._reduced.getDistToNextNewline());
        int pos = text.indexOf("//");
        boolean goodWing = true;
        for (int i = pos - 1; i >= 0; --i) {
            char c = text.charAt(i);
            if (c == ' ') continue;
            goodWing = false;
            return 0;
        }
        if (pos >= 0 && goodWing) {
            this.remove(lineStart + pos, 2);
            return 2;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gotoLine(int line) {
        if (line < 0) {
            return;
        }
        int actualLine = 1;
        this.readLock();
        int len = this.getLength();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                this.setCurrentLocation(0);
                for (int i = 1; i < line && this._currentLocation < len; ++i) {
                    int dist = this._reduced.getDistToNextNewline();
                    if (this._currentLocation + dist < len) {
                        ++dist;
                    }
                    ++actualLine;
                    this.move(dist);
                }
                this._cachedLineNum = actualLine;
                this._cachedLocation = this._currentLocation;
                this._cachedPrevLineLoc = this.getLineStartPos(this._currentLocation);
                this._cachedNextLineLoc = this.getLineEndPos(this._currentLocation);
            }
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public String getPackageName() throws InvalidPackageException {
        int afterPackage;
        int firstNormalLocation;
        int docLength;
        String text;
        int oldLocation;
        StringBuffer buf;
        block13: {
            String curChar2;
            buf = new StringBuffer();
            oldLocation = 0;
            this.readLock();
            try {
                text = this.getText();
                BraceReduction braceReduction = this._reduced;
                // MONITORENTER : braceReduction
                oldLocation = this._currentLocation;
                this.setCurrentLocation(0);
                docLength = text.length();
                for (firstNormalLocation = 0; firstNormalLocation < docLength; ++firstNormalLocation) {
                    char curChar2;
                    this.setCurrentLocation(firstNormalLocation);
                    if (this._reduced.currentToken().getHighlightState() == 0 && !Character.isWhitespace(curChar2 = text.charAt(firstNormalLocation))) break;
                }
                if (firstNormalLocation != docLength) break block13;
                curChar2 = "";
                // MONITOREXIT : braceReduction
            }
            catch (Throwable throwable) {
                this.setCurrentLocation(0);
                this.setCurrentLocation(oldLocation);
                this.readUnlock();
                throw throwable;
            }
            this.setCurrentLocation(0);
            this.setCurrentLocation(oldLocation);
            this.readUnlock();
            return curChar2;
        }
        int strlen = "package".length();
        int endLocation = firstNormalLocation + strlen;
        if (firstNormalLocation + strlen > docLength || !text.substring(firstNormalLocation, endLocation).equals("package")) {
            String string = "";
            // MONITOREXIT : braceReduction
            this.setCurrentLocation(0);
            this.setCurrentLocation(oldLocation);
            this.readUnlock();
            return string;
        }
        int semicolonLocation = afterPackage = firstNormalLocation + strlen;
        do {
            if ((semicolonLocation = text.indexOf(";", semicolonLocation + 1)) == -1) {
                throw new InvalidPackageException(firstNormalLocation, "No semicolon found to terminate package statement!");
            }
            this.setCurrentLocation(semicolonLocation);
        } while (this._reduced.currentToken().getHighlightState() != 0);
        for (int walk = afterPackage + 1; walk < semicolonLocation; ++walk) {
            char curChar;
            this.setCurrentLocation(walk);
            if (this._reduced.currentToken().getHighlightState() != 0 || Character.isWhitespace(curChar = text.charAt(walk))) continue;
            buf.append(curChar);
        }
        String toReturn = buf.toString();
        if (toReturn.equals("")) {
            throw new InvalidPackageException(firstNormalLocation, "Package name was not specified after the package keyword!");
        }
        String string = toReturn;
        // MONITOREXIT : braceReduction
        this.setCurrentLocation(0);
        this.setCurrentLocation(oldLocation);
        this.readUnlock();
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getEnclosingTopLevelClassName(int pos) throws ClassNameNotFoundException {
        this.readLock();
        BraceReduction braceReduction = this._reduced;
        synchronized (braceReduction) {
            int oldLocation = this._currentLocation;
            try {
                this.setCurrentLocation(pos);
                IndentInfo info = this.getIndentInformation();
                int topLevelBracePos = -1;
                String braceType = info.braceTypeCurrent;
                while (!braceType.equals("")) {
                    if (braceType.equals("{")) {
                        topLevelBracePos = this._currentLocation - info.distToBraceCurrent;
                    }
                    this.move(-info.distToBraceCurrent);
                    info = this.getIndentInformation();
                    braceType = info.braceTypeCurrent;
                }
                if (topLevelBracePos == -1) {
                    this.setCurrentLocation(oldLocation);
                    throw new ClassNameNotFoundException("no top level brace found");
                }
                char[] delims = new char[]{'{', '}', ';'};
                int prevDelimPos = this.findPrevDelimiter(topLevelBracePos, delims);
                prevDelimPos = prevDelimPos == -1 ? 0 : ++prevDelimPos;
                this.setCurrentLocation(oldLocation);
                String string = this.getNextTopLevelClassName(prevDelimPos, topLevelBracePos);
                return string;
            }
            catch (BadLocationException ble) {
                throw new UnexpectedException(ble);
            }
            finally {
                this.setCurrentLocation(oldLocation);
                this.readUnlock();
            }
        }
    }

    public String getFirstTopLevelClassName() throws ClassNameNotFoundException {
        return this.getNextTopLevelClassName(0, this.getLength());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getNextTopLevelClassName(int startPos, int endPos) throws ClassNameNotFoundException {
        int oldLocation = this._currentLocation;
        this.readLock();
        BraceReduction braceReduction = this._reduced;
        synchronized (braceReduction) {
            try {
                int index;
                this.setCurrentLocation(startPos);
                int textLength = endPos - startPos;
                String text = this.getText(startPos, textLength);
                int indexOfClass = this._findKeywordAtToplevel("class", text, startPos);
                int indexOfInterface = this._findKeywordAtToplevel("interface", text, startPos);
                int indexOfEnum = this._findKeywordAtToplevel("enum", text, startPos);
                if (!(indexOfClass <= -1 || indexOfInterface > -1 && indexOfClass >= indexOfInterface || indexOfEnum > -1 && indexOfClass >= indexOfEnum)) {
                    index = indexOfClass + "class".length();
                } else if (!(indexOfInterface <= -1 || indexOfClass > -1 && indexOfInterface >= indexOfClass || indexOfEnum > -1 && indexOfInterface >= indexOfEnum)) {
                    index = indexOfInterface + "interface".length();
                } else if (!(indexOfEnum <= -1 || indexOfClass > -1 && indexOfEnum >= indexOfClass || indexOfInterface > -1 && indexOfEnum >= indexOfInterface)) {
                    index = indexOfEnum + "enum".length();
                } else {
                    throw new ClassNameNotFoundException("No top level class name found");
                }
                index = this.getFirstNonWSCharPos(startPos + index) - startPos;
                if (index == -1) {
                    throw new ClassNameNotFoundException("No top level class name found");
                }
                int endIndex = textLength;
                for (int i = index; i < textLength; ++i) {
                    char c = text.charAt(i);
                    if (Character.isJavaIdentifierPart(c)) continue;
                    endIndex = i;
                    break;
                }
                this.setCurrentLocation(oldLocation);
                String string = text.substring(index, endIndex);
                return string;
            }
            catch (BadLocationException ble) {
                throw new UnexpectedException(ble);
            }
            finally {
                this.setCurrentLocation(oldLocation);
                this.readUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _findKeywordAtToplevel(String keyword, String text, int textOffset) {
        this.readLock();
        BraceReduction braceReduction = this._reduced;
        synchronized (braceReduction) {
            int n;
            int oldLocation = this._currentLocation;
            int index = 0;
            try {
                while ((index = text.indexOf(keyword, index)) != -1) {
                    this.setCurrentLocation(textOffset + index);
                    ReducedToken rt = this._reduced.currentToken();
                    int indexPastKeyword = index + keyword.length();
                    if (indexPastKeyword < text.length()) {
                        if (rt.getState() == ReducedModelStates.FREE && Character.isWhitespace(text.charAt(indexPastKeyword))) {
                            if (this.posNotInBlock(index)) break;
                            index = -1;
                            break;
                        }
                        ++index;
                        continue;
                    }
                    index = -1;
                    break;
                }
                this.setCurrentLocation(oldLocation);
                n = index;
            }
            catch (Throwable throwable) {
                this.readUnlock();
                throw throwable;
            }
            this.readUnlock();
            return n;
        }
    }

    public CompoundUndoManager getUndoManager() {
        return this._undoManager;
    }

    public void resetUndoManager() {
        this._undoManager = new CompoundUndoManager(this._notifier);
        this._undoManager.setLimit(1000);
    }

    public UndoableEdit getNextUndo() {
        return this._undoManager.getNextUndo();
    }

    public UndoableEdit getNextRedo() {
        return this._undoManager.getNextRedo();
    }

    public void documentSaved() {
        this._undoManager.documentSaved();
    }

    @Override
    protected int startCompoundEdit() {
        return this._undoManager.startCompoundEdit();
    }

    @Override
    protected void endCompoundEdit(int key) {
        this._undoManager.endCompoundEdit(key);
    }

    @Override
    protected void endLastCompoundEdit() {
        this._undoManager.endLastCompoundEdit();
    }

    @Override
    protected void addUndoRedo(AbstractDocument.DefaultDocumentEvent chng, Runnable undoCommand, Runnable doCommand) {
        chng.addEdit(new CommandUndoableEdit(undoCommand, doCommand));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFinalizationListener(FinalizationListener<DefinitionsDocument> fl) {
        List<FinalizationListener<DefinitionsDocument>> list = this._finalizationListeners;
        synchronized (list) {
            this._finalizationListeners.add(fl);
        }
    }

    @Override
    public List<FinalizationListener<DefinitionsDocument>> getFinalizationListeners() {
        return this._finalizationListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        FinalizationEvent<DefinitionsDocument> fe = new FinalizationEvent<DefinitionsDocument>(this);
        List<FinalizationListener<DefinitionsDocument>> list = this._finalizationListeners;
        synchronized (list) {
            for (FinalizationListener<DefinitionsDocument> fl : this._finalizationListeners) {
                fl.finalized(fe);
            }
        }
    }

    public String toString() {
        return new StringBuffer().append("ddoc for ").append(this._odd).toString();
    }

    private static class CommandUndoableEdit
    extends AbstractUndoableEdit {
        private final Runnable _undoCommand;
        private final Runnable _redoCommand;

        public CommandUndoableEdit(Runnable undoCommand, Runnable redoCommand) {
            this._undoCommand = undoCommand;
            this._redoCommand = redoCommand;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this._undoCommand.run();
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this._redoCommand.run();
        }

        public boolean isSignificant() {
            return false;
        }
    }
}

