/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.definitions;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.model.AbstractDJDocument;
import edu.rice.cs.drjava.model.definitions.DefinitionsDocument;
import edu.rice.cs.drjava.model.definitions.DocumentClosedListener;
import edu.rice.cs.drjava.model.definitions.reducedmodel.HighlightStatus;
import edu.rice.cs.drjava.model.repl.InteractionsDocumentAdapter;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Shape;
import java.util.Vector;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.ViewFactory;

public class ColoringView
extends PlainView
implements OptionConstants {
    public static Color COMMENTED_COLOR = DrJava.getConfig().getSetting(DEFINITIONS_COMMENT_COLOR);
    public static Color DOUBLE_QUOTED_COLOR = DrJava.getConfig().getSetting(DEFINITIONS_DOUBLE_QUOTED_COLOR);
    public static Color SINGLE_QUOTED_COLOR = DrJava.getConfig().getSetting(DEFINITIONS_SINGLE_QUOTED_COLOR);
    public static Color NORMAL_COLOR = DrJava.getConfig().getSetting(DEFINITIONS_NORMAL_COLOR);
    public static Color KEYWORD_COLOR = DrJava.getConfig().getSetting(DEFINITIONS_KEYWORD_COLOR);
    public static Color NUMBER_COLOR = DrJava.getConfig().getSetting(DEFINITIONS_NUMBER_COLOR);
    public static Color TYPE_COLOR = DrJava.getConfig().getSetting(DEFINITIONS_TYPE_COLOR);
    public static Font MAIN_FONT = DrJava.getConfig().getSetting(FONT_MAIN);
    public static Color INTERACTIONS_SYSTEM_ERR_COLOR = DrJava.getConfig().getSetting(SYSTEM_ERR_COLOR);
    public static Color INTERACTIONS_SYSTEM_IN_COLOR = DrJava.getConfig().getSetting(SYSTEM_IN_COLOR);
    public static Color INTERACTIONS_SYSTEM_OUT_COLOR = DrJava.getConfig().getSetting(SYSTEM_OUT_COLOR);
    public static Color ERROR_COLOR = DrJava.getConfig().getSetting(INTERACTIONS_ERROR_COLOR);
    public static Color DEBUGGER_COLOR = DrJava.getConfig().getSetting(DEBUG_MESSAGE_COLOR);
    private final Object _lock = new Object();

    public ColoringView(Element elem) {
        super(elem);
        final ColorOptionListener col = new ColorOptionListener();
        final FontOptionListener fol = new FontOptionListener();
        Document doc = this.getDocument();
        if (doc instanceof AbstractDJDocument) {
            DrJava.getConfig().addOptionListener(OptionConstants.DEFINITIONS_COMMENT_COLOR, col);
            DrJava.getConfig().addOptionListener(OptionConstants.DEFINITIONS_DOUBLE_QUOTED_COLOR, col);
            DrJava.getConfig().addOptionListener(OptionConstants.DEFINITIONS_SINGLE_QUOTED_COLOR, col);
            DrJava.getConfig().addOptionListener(OptionConstants.DEFINITIONS_NORMAL_COLOR, col);
            DrJava.getConfig().addOptionListener(OptionConstants.DEFINITIONS_KEYWORD_COLOR, col);
            DrJava.getConfig().addOptionListener(OptionConstants.DEFINITIONS_NUMBER_COLOR, col);
            DrJava.getConfig().addOptionListener(OptionConstants.DEFINITIONS_TYPE_COLOR, col);
            DrJava.getConfig().addOptionListener(OptionConstants.FONT_MAIN, fol);
            DrJava.getConfig().addOptionListener(OptionConstants.SYSTEM_ERR_COLOR, col);
            DrJava.getConfig().addOptionListener(OptionConstants.SYSTEM_IN_COLOR, col);
            DrJava.getConfig().addOptionListener(OptionConstants.SYSTEM_OUT_COLOR, col);
            DrJava.getConfig().addOptionListener(OptionConstants.INTERACTIONS_ERROR_COLOR, col);
            DrJava.getConfig().addOptionListener(OptionConstants.DEBUG_MESSAGE_COLOR, col);
        }
        if (doc instanceof DefinitionsDocument) {
            ((DefinitionsDocument)doc).addDocumentClosedListener(new DocumentClosedListener(){

                public void close() {
                    DrJava.getConfig().removeOptionListener(OptionConstants.DEFINITIONS_COMMENT_COLOR, col);
                    DrJava.getConfig().removeOptionListener(OptionConstants.DEFINITIONS_DOUBLE_QUOTED_COLOR, col);
                    DrJava.getConfig().removeOptionListener(OptionConstants.DEFINITIONS_SINGLE_QUOTED_COLOR, col);
                    DrJava.getConfig().removeOptionListener(OptionConstants.DEFINITIONS_NORMAL_COLOR, col);
                    DrJava.getConfig().removeOptionListener(OptionConstants.DEFINITIONS_KEYWORD_COLOR, col);
                    DrJava.getConfig().removeOptionListener(OptionConstants.DEFINITIONS_NUMBER_COLOR, col);
                    DrJava.getConfig().removeOptionListener(OptionConstants.DEFINITIONS_TYPE_COLOR, col);
                    DrJava.getConfig().removeOptionListener(OptionConstants.FONT_MAIN, fol);
                    DrJava.getConfig().removeOptionListener(OptionConstants.SYSTEM_ERR_COLOR, col);
                    DrJava.getConfig().removeOptionListener(OptionConstants.SYSTEM_IN_COLOR, col);
                    DrJava.getConfig().removeOptionListener(OptionConstants.SYSTEM_OUT_COLOR, col);
                    DrJava.getConfig().removeOptionListener(OptionConstants.INTERACTIONS_ERROR_COLOR, col);
                    DrJava.getConfig().removeOptionListener(OptionConstants.DEBUG_MESSAGE_COLOR, col);
                }
            });
        }
    }

    protected int drawUnselectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        Document doc = this.getDocument();
        AbstractDJDocument _doc = null;
        if (!(doc instanceof AbstractDJDocument)) {
            return x;
        }
        _doc = (AbstractDJDocument)doc;
        if (p0 == p1) {
            return x;
        }
        Vector<HighlightStatus> stats = _doc.getHighlightStatus(p0, p1);
        if (stats.size() < 1) {
            throw new RuntimeException("GetHighlightStatus returned nothing!");
        }
        for (int i = 0; i < stats.size(); ++i) {
            HighlightStatus stat = stats.get(i);
            int length = stat.getLength();
            int location = stat.getLocation();
            if (location + length > p1) {
                length = p1 - stat.getLocation();
            }
            Segment text = this.getLineBuffer();
            if (!(_doc instanceof InteractionsDocumentAdapter) || !((InteractionsDocumentAdapter)_doc).setColoring((p0 + p1) / 2, g)) {
                this.setFormattingForState(g, stat.getState());
            }
            _doc.getText(location, length, text);
            x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, location);
        }
        return x;
    }

    protected int drawSelectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        Document doc = this.getDocument();
        if (doc instanceof InteractionsDocumentAdapter) {
            ((InteractionsDocumentAdapter)doc).setBoldFonts(p1, g);
        }
        return super.drawSelectedText(g, x, y, p0, p1);
    }

    private void setFormattingForState(Graphics g, int state) {
        switch (state) {
            case 0: {
                g.setColor(NORMAL_COLOR);
                break;
            }
            case 1: {
                g.setColor(COMMENTED_COLOR);
                break;
            }
            case 2: {
                g.setColor(SINGLE_QUOTED_COLOR);
                break;
            }
            case 3: {
                g.setColor(DOUBLE_QUOTED_COLOR);
                break;
            }
            case 4: {
                g.setColor(KEYWORD_COLOR);
                break;
            }
            case 5: {
                g.setColor(NUMBER_COLOR);
                break;
            }
            case 6: {
                g.setColor(TYPE_COLOR);
                break;
            }
            default: {
                throw new RuntimeException("Can't get color for invalid state: " + state);
            }
        }
        g.setFont(MAIN_FONT);
    }

    public void changedUpdate(DocumentEvent changes, Shape a, ViewFactory f) {
        super.changedUpdate(changes, a, f);
        Container c = this.getContainer();
        if (c != null) {
            c.repaint();
        }
    }

    public void updateColors() {
        COMMENTED_COLOR = DrJava.getConfig().getSetting(DEFINITIONS_COMMENT_COLOR);
        DOUBLE_QUOTED_COLOR = DrJava.getConfig().getSetting(DEFINITIONS_DOUBLE_QUOTED_COLOR);
        SINGLE_QUOTED_COLOR = DrJava.getConfig().getSetting(DEFINITIONS_SINGLE_QUOTED_COLOR);
        NORMAL_COLOR = DrJava.getConfig().getSetting(DEFINITIONS_NORMAL_COLOR);
        KEYWORD_COLOR = DrJava.getConfig().getSetting(DEFINITIONS_KEYWORD_COLOR);
        NUMBER_COLOR = DrJava.getConfig().getSetting(DEFINITIONS_NUMBER_COLOR);
        TYPE_COLOR = DrJava.getConfig().getSetting(DEFINITIONS_TYPE_COLOR);
        INTERACTIONS_SYSTEM_ERR_COLOR = DrJava.getConfig().getSetting(SYSTEM_ERR_COLOR);
        INTERACTIONS_SYSTEM_IN_COLOR = DrJava.getConfig().getSetting(SYSTEM_IN_COLOR);
        INTERACTIONS_SYSTEM_OUT_COLOR = DrJava.getConfig().getSetting(SYSTEM_OUT_COLOR);
        ERROR_COLOR = DrJava.getConfig().getSetting(INTERACTIONS_ERROR_COLOR);
        DEBUGGER_COLOR = DrJava.getConfig().getSetting(DEBUG_MESSAGE_COLOR);
        if (this.getContainer() != null) {
            this.getContainer().repaint();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FontOptionListener
    implements OptionListener<Font> {
        private FontOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Font> oce) {
            MAIN_FONT = DrJava.getConfig().getSetting(OptionConstants.FONT_MAIN);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ColorOptionListener
    implements OptionListener<Color> {
        private ColorOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Color> oce) {
            ColoringView.this.updateColors();
        }
    }
}

