/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.debug;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.Bootstrap;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Field;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.LongValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VMMismatchException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.StepRequest;
import com.sun.jdi.request.ThreadDeathRequest;
import edu.rice.cs.drjava.model.DefaultGlobalModel;
import edu.rice.cs.drjava.model.DummyGlobalModelListener;
import edu.rice.cs.drjava.model.GlobalModelListener;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.debug.Breakpoint;
import edu.rice.cs.drjava.model.debug.DebugEventNotifier;
import edu.rice.cs.drjava.model.debug.DebugException;
import edu.rice.cs.drjava.model.debug.DebugListener;
import edu.rice.cs.drjava.model.debug.DebugModelCallback;
import edu.rice.cs.drjava.model.debug.DebugStackData;
import edu.rice.cs.drjava.model.debug.DebugThreadData;
import edu.rice.cs.drjava.model.debug.DebugWatchData;
import edu.rice.cs.drjava.model.debug.Debugger;
import edu.rice.cs.drjava.model.debug.EventHandlerThread;
import edu.rice.cs.drjava.model.debug.PendingRequestManager;
import edu.rice.cs.drjava.model.debug.Step;
import edu.rice.cs.drjava.model.repl.DefaultInteractionsModel;
import edu.rice.cs.util.Log;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.Utilities;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPDADebugger
implements Debugger,
DebugModelCallback {
    private static final boolean printMessages = false;
    private static final int OBJECT_COLLECTED_TRIES = 5;
    private DefaultGlobalModel _model;
    private volatile VirtualMachine _vm;
    private EventRequestManager _eventManager;
    private Vector<Breakpoint> _breakpoints;
    private Vector<DebugWatchData> _watches;
    private PendingRequestManager _pendingRequestManager;
    private final DebugEventNotifier _notifier = new DebugEventNotifier();
    private ThreadReference _runningThread;
    private RandomAccessStack _suspendedThreads;
    private ObjectReference _interpreterJVM;
    private GlobalModelListener _watchListener;
    private Throwable _eventHandlerError;
    protected final Log _log;

    public JPDADebugger(DefaultGlobalModel model) {
        this._model = model;
        this._vm = null;
        this._eventManager = null;
        this._breakpoints = new Vector();
        this._watches = new Vector();
        this._suspendedThreads = new RandomAccessStack();
        this._pendingRequestManager = new PendingRequestManager(this);
        this._runningThread = null;
        this._interpreterJVM = null;
        this._eventHandlerError = null;
        this._log = new Log("DebuggerLog", false);
        this._watchListener = new DummyGlobalModelListener(){

            public void interactionEnded() {
                try {
                    JPDADebugger.this._updateWatches();
                }
                catch (DebugException de) {
                    JPDADebugger.this._log("couldn't update watches", de);
                }
            }
        };
    }

    @Override
    public void addListener(DebugListener listener) {
        this._notifier.addListener(listener);
    }

    @Override
    public void removeListener(DebugListener listener) {
        this._notifier.removeListener(listener);
    }

    protected VirtualMachine getVM() {
        return this._vm;
    }

    protected void _log(String message) {
        this._log.logTime(message);
    }

    protected void _log(String message, Throwable t) {
        this._log.logTime(message, t);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean isReady() {
        return this._vm != null;
    }

    @Override
    public boolean inDebugMode() {
        return this.isReady();
    }

    protected synchronized void _ensureReady() throws DebugException {
        if (!this.isReady()) {
            throw new IllegalStateException("Debugger is not active.");
        }
        if (this._eventHandlerError != null) {
            Throwable t = this._eventHandlerError;
            this._eventHandlerError = null;
            throw new DebugException(new StringBuffer().append("Error in Debugger Event Handler: ").append(t).toString());
        }
    }

    synchronized void eventHandlerError(Throwable t) {
        this._log(new StringBuffer().append("Error in EventHandlerThread: ").append(t).toString());
        this._eventHandlerError = t;
    }

    @Override
    public synchronized void startup() throws DebugException {
        if (!this.isReady()) {
            for (OpenDefinitionsDocument doc : this._model.getOpenDefinitionsDocuments()) {
                doc.checkIfClassFileInSync();
            }
        } else {
            throw new IllegalStateException("Debugger has already been started.");
        }
        this._attachToVM();
        ThreadDeathRequest tdr = this._eventManager.createThreadDeathRequest();
        tdr.setSuspendPolicy(1);
        tdr.enable();
        EventHandlerThread eventHandler = new EventHandlerThread(this, this._vm);
        eventHandler.start();
        this._model.addListener(this._watchListener);
    }

    private void _attachToVM() throws DebugException {
        this._model.waitForInterpreter();
        AttachingConnector connector = this._getAttachingConnector();
        Map<String, Connector.Argument> args = connector.defaultArguments();
        Connector.Argument port = args.get("port");
        Connector.Argument host = args.get("hostname");
        try {
            int debugPort = this._model.getDebugPort();
            port.setValue(new StringBuffer().append("").append(debugPort).toString());
            host.setValue("127.0.0.1");
            this._vm = connector.attach(args);
            this._eventManager = this._vm.eventRequestManager();
        }
        catch (IOException ioe) {
            throw new DebugException(new StringBuffer().append("Could not connect to VM: ").append(ioe).toString());
        }
        catch (IllegalConnectorArgumentsException icae) {
            throw new DebugException(new StringBuffer().append("Could not connect to VM: ").append(icae).toString());
        }
        this._interpreterJVM = this._getInterpreterJVMRef();
    }

    protected AttachingConnector _getAttachingConnector() throws DebugException {
        VirtualMachineManager vmm = Bootstrap.virtualMachineManager();
        List<AttachingConnector> connectors = vmm.attachingConnectors();
        AttachingConnector connector = null;
        for (AttachingConnector conn : connectors) {
            if (!conn.name().equals("com.sun.jdi.SocketAttach")) continue;
            connector = conn;
        }
        if (connector == null) {
            throw new DebugException("Could not find an AttachingConnector!");
        }
        return connector;
    }

    protected ObjectReference _getInterpreterJVMRef() throws DebugException {
        String className = "edu.rice.cs.drjava.model.repl.newjvm.InterpreterJVM";
        List<ReferenceType> referenceTypes = this._vm.classesByName(className);
        if (referenceTypes.size() > 0) {
            ReferenceType rt = referenceTypes.get(0);
            Field field = rt.fieldByName("ONLY");
            if (field == null) {
                throw new DebugException("Unable to get ONLY field");
            }
            return (ObjectReference)rt.getValue(field);
        }
        throw new DebugException("Could not get a reference to interpreterJVM");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void shutdown() {
        if (!this.isReady()) {
            throw new IllegalStateException("Cannot shut down if debugger is not active.");
        }
        this._model.removeListener(this._watchListener);
        try {
            this._removeAllDebugInterpreters();
            this.removeAllBreakpoints();
            this.removeAllWatches();
        }
        catch (DebugException de) {
            this._log(new StringBuffer().append("Could not remove breakpoints/watches: ").append(de).toString());
        }
        try {
            this._vm.dispose();
        }
        catch (VMDisconnectedException vMDisconnectedException) {
        }
        finally {
            this._model.getInteractionsModel().setToDefaultInterpreter();
            this._vm = null;
            this._suspendedThreads = new RandomAccessStack();
            this._eventManager = null;
            this._runningThread = null;
        }
    }

    synchronized EventRequestManager getEventRequestManager() {
        return this._eventManager;
    }

    synchronized PendingRequestManager getPendingRequestManager() {
        return this._pendingRequestManager;
    }

    synchronized boolean setCurrentThread(ThreadReference thread) {
        if (!thread.isSuspended()) {
            throw new IllegalArgumentException(new StringBuffer().append("Thread must be suspended to set as current.  Given: ").append(thread).toString());
        }
        try {
            if ((this._suspendedThreads.isEmpty() || !this._suspendedThreads.contains(thread.uniqueID())) && thread.frameCount() > 0) {
                this._suspendedThreads.push(thread);
                return true;
            }
            return false;
        }
        catch (IncompatibleThreadStateException itse) {
            throw new UnexpectedException(itse);
        }
    }

    @Override
    public synchronized void setCurrentThread(DebugThreadData threadData) throws DebugException {
        this._ensureReady();
        if (threadData == null) {
            throw new IllegalArgumentException("Cannot set current thread to null.");
        }
        ThreadReference threadRef = this._getThreadFromDebugThreadData(threadData);
        if (this._suspendedThreads.contains(threadRef.uniqueID())) {
            this._suspendedThreads.remove(threadRef.uniqueID());
        }
        if (!threadRef.isSuspended()) {
            throw new IllegalArgumentException("Given thread must be suspended.");
        }
        this._suspendedThreads.push(threadRef);
        try {
            if (threadRef.frameCount() <= 0) {
                this.printMessage(new StringBuffer().append(threadRef.name()).append(" could not be suspended since it has no stackframes.").toString());
                this.resume();
                return;
            }
        }
        catch (IncompatibleThreadStateException e) {
            throw new DebugException(new StringBuffer().append("Could not suspend thread: ").append(e).toString());
        }
        this._switchToInterpreterForThreadReference(threadRef);
        this._switchToSuspendedThread();
        this.printMessage("The current thread has changed.");
    }

    synchronized ThreadReference getCurrentThread() {
        return this._suspendedThreads.peek();
    }

    synchronized ThreadReference getThreadAt(int i) {
        return this._suspendedThreads.peekAt(i);
    }

    synchronized ThreadReference getCurrentRunningThread() {
        return this._runningThread;
    }

    @Override
    public synchronized boolean hasSuspendedThreads() throws DebugException {
        this._ensureReady();
        return this._suspendedThreads.size() > 0;
    }

    @Override
    public synchronized boolean isCurrentThreadSuspended() throws DebugException {
        this._ensureReady();
        return this.hasSuspendedThreads() && !this.hasRunningThread();
    }

    @Override
    public synchronized boolean hasRunningThread() throws DebugException {
        this._ensureReady();
        return this._runningThread != null;
    }

    synchronized Vector<ReferenceType> getReferenceTypes(String className) {
        return this.getReferenceTypes(className, -1);
    }

    synchronized Vector<ReferenceType> getReferenceTypes(String className, int lineNumber) {
        List<ReferenceType> classes;
        try {
            classes = this._vm.classesByName(className);
        }
        catch (VMDisconnectedException vmde) {
            return new Vector<ReferenceType>();
        }
        Vector<ReferenceType> refTypes = new Vector<ReferenceType>();
        for (int i = 0; i < classes.size(); ++i) {
            ReferenceType ref = classes.get(i);
            if (lineNumber != -1) {
                List<Object> lines = new LinkedList();
                try {
                    lines = ref.locationsOfLine(lineNumber);
                }
                catch (AbsentInformationException aie) {
                }
                catch (ClassNotPreparedException cnpe) {
                    continue;
                }
                if (lines.size() == 0) {
                    List<ReferenceType> innerRefs = ref.nestedTypes();
                    ref = null;
                    for (int j = 0; j < innerRefs.size(); ++j) {
                        try {
                            ReferenceType currRef = innerRefs.get(j);
                            lines = currRef.locationsOfLine(lineNumber);
                            if (lines.size() <= 0) continue;
                            ref = currRef;
                            break;
                        }
                        catch (AbsentInformationException aie) {
                            continue;
                        }
                        catch (ClassNotPreparedException cnpe) {
                            // empty catch block
                        }
                    }
                }
            }
            if (ref == null || !ref.isPrepared()) continue;
            refTypes.add(ref);
        }
        return refTypes;
    }

    protected ThreadReference _getThreadFromDebugThreadData(DebugThreadData d) throws NoSuchElementException {
        List<ThreadReference> threads = this._vm.allThreads();
        for (ThreadReference threadRef : threads) {
            if (threadRef.uniqueID() != d.getUniqueID()) continue;
            return threadRef;
        }
        throw new NoSuchElementException(new StringBuffer().append("Thread ").append(d.getName()).append(" not found in virtual machine!").toString());
    }

    protected synchronized void _resumeFromStep() throws DebugException {
        this._resumeHelper(true);
    }

    @Override
    public synchronized void resume() throws DebugException {
        this._ensureReady();
        this._resumeHelper(false);
    }

    protected synchronized void _resumeHelper(boolean fromStep) throws DebugException {
        try {
            ThreadReference thread = this._suspendedThreads.pop();
            this._resumeThread(thread, fromStep);
        }
        catch (NoSuchElementException e) {
            throw new DebugException("No thread to resume.");
        }
    }

    @Override
    public synchronized void resume(DebugThreadData threadData) throws DebugException {
        this._ensureReady();
        ThreadReference thread = this._suspendedThreads.remove(threadData.getUniqueID());
        this._resumeThread(thread, false);
    }

    private void _resumeThread(ThreadReference thread, boolean fromStep) throws DebugException {
        if (thread == null) {
            throw new IllegalArgumentException("Cannot resume a null thread");
        }
        int suspendCount = thread.suspendCount();
        this._runningThread = thread;
        if (!fromStep) {
            this._copyVariablesFromInterpreter();
            this._updateWatches();
        }
        try {
            this._removeCurrentDebugInterpreter(fromStep);
            this.currThreadResumed();
        }
        catch (DebugException e) {
            throw new UnexpectedException(e);
        }
        for (int i = suspendCount; i > 0; --i) {
            thread.resume();
        }
        if (!fromStep && !this._suspendedThreads.isEmpty()) {
            this._switchToSuspendedThread();
        }
    }

    @Override
    public synchronized void step(int flag) throws DebugException {
        this._ensureReady();
        this._stepHelper(flag, true);
    }

    private synchronized void _stepHelper(int flag, boolean shouldNotify) throws DebugException {
        ThreadReference thread;
        if (this._suspendedThreads.size() <= 0 || this._runningThread != null) {
            throw new IllegalStateException("Cannot step if the current thread is not suspended.");
        }
        this._runningThread = thread = this._suspendedThreads.peek();
        this._copyVariablesFromInterpreter();
        List<StepRequest> steps = this._eventManager.stepRequests();
        for (int i = 0; i < steps.size(); ++i) {
            StepRequest step = steps.get(i);
            if (!step.thread().equals(thread)) continue;
            this._eventManager.deleteEventRequest(step);
            break;
        }
        new Step(this, -2, flag);
        if (shouldNotify) {
            this.notifyStepRequested();
        }
        this._resumeFromStep();
    }

    @Override
    public synchronized void addWatch(String field) throws DebugException {
        this._ensureReady();
        this._watches.add(new DebugWatchData(field));
        this._updateWatches();
    }

    @Override
    public synchronized void removeWatch(String field) throws DebugException {
        this._ensureReady();
        for (int i = 0; i < this._watches.size(); ++i) {
            DebugWatchData watch = this._watches.get(i);
            if (!watch.getName().equals(field)) continue;
            this._watches.remove(i);
        }
    }

    @Override
    public synchronized void removeWatch(int index) throws DebugException {
        this._ensureReady();
        if (index < this._watches.size()) {
            this._watches.remove(index);
        }
    }

    @Override
    public synchronized void removeAllWatches() throws DebugException {
        this._ensureReady();
        this._watches.clear();
    }

    @Override
    public synchronized void toggleBreakpoint(OpenDefinitionsDocument doc, int offset, int lineNum) throws DebugException {
        this._ensureReady();
        Breakpoint breakpoint = doc.getBreakpointAt(offset);
        if (breakpoint == null) {
            this.setBreakpoint(new Breakpoint(doc, offset, lineNum, this));
        } else {
            this.removeBreakpoint(breakpoint);
        }
    }

    @Override
    public synchronized void setBreakpoint(final Breakpoint breakpoint) throws DebugException {
        this._ensureReady();
        breakpoint.getDocument().checkIfClassFileInSync();
        this._breakpoints.add(breakpoint);
        breakpoint.getDocument().addBreakpoint(breakpoint);
        Utilities.invokeLater(new Runnable(){

            public void run() {
                JPDADebugger.this._notifier.breakpointSet(breakpoint);
            }
        });
    }

    @Override
    public synchronized void removeBreakpoint(final Breakpoint breakpoint) throws DebugException {
        this._ensureReady();
        this._breakpoints.remove(breakpoint);
        Vector requests = breakpoint.getRequests();
        if (requests.size() > 0 && this._eventManager != null) {
            try {
                for (int i = 0; i < requests.size(); ++i) {
                    this._eventManager.deleteEventRequest((EventRequest)requests.get(i));
                }
            }
            catch (VMMismatchException vme) {
                this._log("VMMismatch when removing breakpoint.", vme);
            }
            catch (VMDisconnectedException vmde) {
                this._log("VMDisconnected when removing breakpoint.", vmde);
            }
        }
        this._pendingRequestManager.removePendingRequest(breakpoint);
        breakpoint.getDocument().removeBreakpoint(breakpoint);
        Utilities.invokeLater(new Runnable(){

            public void run() {
                JPDADebugger.this._notifier.breakpointRemoved(breakpoint);
            }
        });
    }

    @Override
    public synchronized void removeAllBreakpoints() throws DebugException {
        this._ensureReady();
        while (this._breakpoints.size() > 0) {
            this.removeBreakpoint(this._breakpoints.get(0));
        }
    }

    synchronized void reachedBreakpoint(BreakpointRequest request) {
        Object property = request.getProperty("debugAction");
        if (property != null && property instanceof Breakpoint) {
            final Breakpoint breakpoint = (Breakpoint)property;
            this.printMessage(new StringBuffer().append("Breakpoint hit in class ").append(breakpoint.getClassName()).append("  [line ").append(breakpoint.getLineNumber()).append("]").toString());
            Utilities.invokeLater(new Runnable(){

                public void run() {
                    JPDADebugger.this._notifier.breakpointReached(breakpoint);
                }
            });
        } else {
            this._log(new StringBuffer().append("Reached a breakpoint without a debugAction property: ").append(request).toString());
        }
    }

    @Override
    public synchronized Vector<Breakpoint> getBreakpoints() throws DebugException {
        this._ensureReady();
        Vector<Breakpoint> sortedBreakpoints = new Vector<Breakpoint>();
        List<OpenDefinitionsDocument> docs = this._model.getOpenDefinitionsDocuments();
        for (int i = 0; i < docs.size(); ++i) {
            Vector<Breakpoint> docBreakpoints = docs.get(i).getBreakpoints();
            for (int j = 0; j < docBreakpoints.size(); ++j) {
                sortedBreakpoints.add(docBreakpoints.get(j));
            }
        }
        return sortedBreakpoints;
    }

    @Override
    public synchronized void printBreakpoints() throws DebugException {
        this._ensureReady();
        Enumeration<Breakpoint> breakpoints = this.getBreakpoints().elements();
        if (breakpoints.hasMoreElements()) {
            this.printMessage("Breakpoints: ");
            while (breakpoints.hasMoreElements()) {
                Breakpoint breakpoint = breakpoints.nextElement();
                this.printMessage(new StringBuffer().append("  ").append(breakpoint.getClassName()).append("  [line ").append(breakpoint.getLineNumber()).append("]").toString());
            }
        } else {
            this.printMessage("No breakpoints set.");
        }
    }

    @Override
    public synchronized Vector<DebugWatchData> getWatches() throws DebugException {
        this._ensureReady();
        return this._watches;
    }

    @Override
    public synchronized Vector<DebugThreadData> getCurrentThreadData() throws DebugException {
        List<ThreadReference> listThreads;
        this._ensureReady();
        try {
            listThreads = this._vm.allThreads();
        }
        catch (VMDisconnectedException vmde) {
            return new Vector<DebugThreadData>();
        }
        Iterator<ThreadReference> iter = listThreads.iterator();
        Vector<DebugThreadData> threads = new Vector<DebugThreadData>();
        while (iter.hasNext()) {
            try {
                threads.add(new DebugThreadData(iter.next()));
            }
            catch (ObjectCollectedException e) {}
        }
        return threads;
    }

    @Override
    public synchronized Vector<DebugStackData> getCurrentStackFrameData() throws DebugException {
        this._ensureReady();
        if (this._runningThread != null || this._suspendedThreads.size() <= 0) {
            throw new DebugException("No suspended thread to obtain stack frames.");
        }
        try {
            ThreadReference thread = this._suspendedThreads.peek();
            Iterator<StackFrame> iter = thread.frames().iterator();
            Vector<DebugStackData> frames = new Vector<DebugStackData>();
            while (iter.hasNext()) {
                frames.add(new DebugStackData(iter.next()));
            }
            return frames;
        }
        catch (IncompatibleThreadStateException itse) {
            throw new DebugException(new StringBuffer().append("Unable to obtain stack frame: ").append(itse).toString());
        }
        catch (VMDisconnectedException vmde) {
            this._log("VMDisconnected when getting the current stack frame data.", vmde);
            return new Vector<DebugStackData>();
        }
    }

    synchronized void scrollToSource(LocatableEvent e) {
        Location location = e.location();
        EventRequest request = e.request();
        Object docProp = request.getProperty("document");
        if (docProp != null && docProp instanceof OpenDefinitionsDocument) {
            this.openAndScroll((OpenDefinitionsDocument)docProp, location, true);
        } else {
            this.scrollToSource(location);
        }
    }

    synchronized void scrollToSource(Location location) {
        this.scrollToSource(location, true);
    }

    synchronized void scrollToSource(Location location, boolean shouldHighlight) {
        String filename;
        OpenDefinitionsDocument doc = null;
        ReferenceType rt = location.declaringType();
        try {
            filename = new StringBuffer().append(this.getPackageDir(rt.name())).append(rt.sourceName()).toString();
        }
        catch (AbsentInformationException aie) {
            String className = rt.name();
            String ps = System.getProperty("file.separator");
            className = StringOps.replace(className, ".", ps);
            int indexOfDollar = className.indexOf(36);
            if (indexOfDollar > -1) {
                className = className.substring(0, indexOfDollar);
            }
            filename = new StringBuffer().append(className).append(".java").toString();
        }
        File f = this._model.getSourceFile(filename);
        if (f != null) {
            try {
                doc = this._model.getDocumentForFile(f);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        this.openAndScroll(doc, location, shouldHighlight);
    }

    @Override
    public synchronized void scrollToSource(DebugStackData stackData) throws DebugException {
        Iterator<StackFrame> i;
        this._ensureReady();
        if (this._runningThread != null) {
            throw new DebugException("Cannot scroll to source unless thread is suspended.");
        }
        ThreadReference threadRef = this._suspendedThreads.peek();
        try {
            if (threadRef.frameCount() <= 0) {
                this.printMessage("Could not scroll to source. The current thread had no stack frames.");
                return;
            }
            i = threadRef.frames().iterator();
        }
        catch (IncompatibleThreadStateException e) {
            throw new DebugException(new StringBuffer().append("Unable to find stack frames: ").append(e).toString());
        }
        while (i.hasNext()) {
            StackFrame frame = i.next();
            if (frame.location().lineNumber() != stackData.getLine() || !stackData.getMethod().equals(new StringBuffer().append(frame.location().declaringType().name()).append(".").append(frame.location().method().name()).toString())) continue;
            this.scrollToSource(frame.location(), false);
        }
    }

    @Override
    public synchronized void scrollToSource(Breakpoint bp) {
        this.openAndScroll(bp.getDocument(), bp.getLineNumber(), bp.getClassName(), false);
    }

    @Override
    public synchronized Breakpoint getBreakpoint(int line, String className) {
        for (int i = 0; i < this._breakpoints.size(); ++i) {
            Breakpoint bp = this._breakpoints.get(i);
            if (bp.getLineNumber() != line || !bp.getClassName().equals(className)) continue;
            return bp;
        }
        return null;
    }

    synchronized void openAndScroll(OpenDefinitionsDocument doc, Location location, boolean shouldHighlight) {
        this.openAndScroll(doc, location.lineNumber(), location.declaringType().name(), shouldHighlight);
    }

    synchronized void openAndScroll(final OpenDefinitionsDocument doc, final int line, String className, final boolean shouldHighlight) {
        if (doc != null) {
            doc.checkIfClassFileInSync();
            Utilities.invokeLater(new Runnable(){

                public void run() {
                    JPDADebugger.this._notifier.threadLocationUpdated(doc, line, shouldHighlight);
                }
            });
        } else {
            this.printMessage(new StringBuffer().append("  (Source for ").append(className).append(" not found.)").toString());
        }
    }

    String getPackageDir(String className) {
        int lastDotIndex = className.lastIndexOf(".");
        if (lastDotIndex == -1) {
            return "";
        }
        String packageName = className.substring(0, lastDotIndex);
        String ps = System.getProperty("file.separator");
        packageName = StringOps.replace(packageName, ".", ps);
        return new StringBuffer().append(packageName).append(ps).toString();
    }

    synchronized void printMessage(String message) {
        this._model.printDebugMessage(message);
    }

    private boolean hasAnonymous(ReferenceType rt) {
        String className = rt.name();
        StringTokenizer st = new StringTokenizer(className, "$");
        while (st.hasMoreElements()) {
            String currToken = st.nextToken();
            try {
                Integer anonymousNum = Integer.valueOf(currToken);
                return true;
            }
            catch (NumberFormatException nfe) {
            }
        }
        return false;
    }

    private boolean _getWatchFromInterpreter(DebugWatchData currWatch) {
        String currName = currWatch.getName();
        String value = this._model.getInteractionsModel().getVariableToString(currName);
        if (value != null) {
            String type = this._model.getInteractionsModel().getVariableClassName(currName);
            currWatch.setValue(value);
            currWatch.setType(type);
            return true;
        }
        return false;
    }

    private synchronized void _hideWatches() {
        for (int i = 0; i < this._watches.size(); ++i) {
            DebugWatchData currWatch = this._watches.get(i);
            currWatch.hideValueAndType();
        }
    }

    private synchronized void _updateWatches() throws DebugException {
        this._ensureReady();
        if (this._suspendedThreads.size() <= 0) {
            for (int i = 0; i < this._watches.size(); ++i) {
                DebugWatchData currWatch = this._watches.get(i);
                if (this._getWatchFromInterpreter(currWatch)) continue;
                currWatch.hideValueAndType();
            }
            return;
        }
        try {
            ThreadReference thread = this._suspendedThreads.peek();
            if (thread.frameCount() <= 0) {
                this.printMessage("Could not update watch values. The current thread had no stack frames.");
                return;
            }
            List<StackFrame> frames = thread.frames();
            StackFrame currFrame = frames.get(0);
            Location location = currFrame.location();
            ReferenceType rt = location.declaringType();
            ObjectReference obj = currFrame.thisObject();
            String rtName = rt.name();
            int numDollars = 0;
            int dollarIndex = rtName.indexOf("$", 0);
            while (dollarIndex != -1) {
                ++numDollars;
                dollarIndex = rtName.indexOf("$", dollarIndex + 1);
            }
            for (int i = 0; i < this._watches.size(); ++i) {
                DebugWatchData currWatch = this._watches.get(i);
                String currName = currWatch.getName();
                if (this._getWatchFromInterpreter(currWatch)) continue;
                ReferenceType outerRt = rt;
                ObjectReference outer = obj;
                Field field = outerRt.fieldByName(currName);
                if (obj != null) {
                    int outerIndex = numDollars - 1;
                    if (this.hasAnonymous(outerRt)) {
                        List<Field> fields = outerRt.allFields();
                        for (Field f : fields) {
                            String name = f.name();
                            if (!name.startsWith("this$")) continue;
                            int lastIndex = name.lastIndexOf("$");
                            outerIndex = Integer.valueOf(name.substring(lastIndex + 1, name.length()));
                            break;
                        }
                    }
                    Field outerThis = outerRt.fieldByName(new StringBuffer().append("this$").append(outerIndex).toString());
                    if (field == null) {
                        field = outerRt.fieldByName(new StringBuffer().append("val$").append(currName).toString());
                    }
                    while (field == null && outerThis != null && (outer = (ObjectReference)outer.getValue(outerThis)) != null) {
                        outerRt = outer.referenceType();
                        field = outerRt.fieldByName(currName);
                        if (field != null || (field = outerRt.fieldByName(new StringBuffer().append("val$").append(currName).toString())) != null) continue;
                        outerThis = outerRt.fieldByName(new StringBuffer().append("this$").append(--outerIndex).toString());
                    }
                } else {
                    List<ReferenceType> l;
                    String rtClassName = outerRt.name();
                    int index = rtClassName.lastIndexOf("$");
                    while (field == null && index != -1 && !(l = this._vm.classesByName(rtClassName = rtClassName.substring(0, index))).isEmpty()) {
                        outerRt = l.get(0);
                        field = outerRt.fieldByName(currName);
                        if (field != null) continue;
                        index = rtClassName.lastIndexOf("$");
                    }
                }
                if (field != null && (field.isStatic() || outer != null)) {
                    Value v = field.isStatic() ? outerRt.getValue(field) : outer.getValue(field);
                    currWatch.setValue(this._getValue(v));
                    try {
                        currWatch.setType(field.type().name());
                    }
                    catch (ClassNotLoadedException cnle) {
                        List<ReferenceType> classes = this._vm.classesByName(field.typeName());
                        if (!classes.isEmpty()) {
                            currWatch.setType(classes.get(0).name());
                            continue;
                        }
                        currWatch.setTypeNotLoaded();
                    }
                    continue;
                }
                currWatch.setNoValue();
                currWatch.setNoType();
            }
        }
        catch (IncompatibleThreadStateException itse) {
            this._log("Exception updating watches.", itse);
        }
        catch (InvalidStackFrameException isfe) {
            this._log("Exception updating watches.", isfe);
        }
    }

    private String _getValue(Value value) throws DebugException {
        if (value == null) {
            return "null";
        }
        if (!(value instanceof ObjectReference)) {
            return value.toString();
        }
        ObjectReference object = (ObjectReference)value;
        ReferenceType rt = object.referenceType();
        ThreadReference thread = this._suspendedThreads.peek();
        List<Method> toStrings = rt.methodsByName("toString");
        if (toStrings.size() == 0) {
            return value.toString();
        }
        Method method = toStrings.get(0);
        try {
            Value stringValue = object.invokeMethod(thread, method, new LinkedList(), 1);
            if (stringValue == null) {
                return "null";
            }
            return stringValue.toString();
        }
        catch (InvalidTypeException ite) {
            throw new UnexpectedException(ite);
        }
        catch (ClassNotLoadedException cnle) {
            throw new UnexpectedException(cnle);
        }
        catch (IncompatibleThreadStateException itse) {
            throw new DebugException(new StringBuffer().append("Cannot determine value from thread: ").append(itse).toString());
        }
        catch (InvocationException ie) {
            throw new DebugException(new StringBuffer().append("Could not invoke toString: ").append(ie).toString());
        }
    }

    private Method _getDefineVariableMethod(ReferenceType interpreterRef, Value val) throws DebugException {
        String signature_mid;
        String signature_beginning = "(Ljava/lang/String;";
        String signature_end = ")V";
        if (val == null || val instanceof ObjectReference) {
            signature_mid = "Ljava/lang/Object;Ljava/lang/Class;";
        } else if (val instanceof BooleanValue) {
            signature_mid = "Z";
        } else if (val instanceof ByteValue) {
            signature_mid = "B";
        } else if (val instanceof CharValue) {
            signature_mid = "C";
        } else if (val instanceof DoubleValue) {
            signature_mid = "D";
        } else if (val instanceof FloatValue) {
            signature_mid = "F";
        } else if (val instanceof IntegerValue) {
            signature_mid = "I";
        } else if (val instanceof LongValue) {
            signature_mid = "J";
        } else if (val instanceof ShortValue) {
            signature_mid = "S";
        } else {
            throw new IllegalArgumentException(new StringBuffer().append("Tried to define a variable which is\nnot an Object or a primitive type:\n").append(val).toString());
        }
        String signature = new StringBuffer().append(signature_beginning).append(signature_mid).append(signature_end).toString();
        List<Method> methods = interpreterRef.methodsByName("defineVariable", signature);
        if (methods.size() <= 0) {
            throw new DebugException("Could not find defineVariable method.");
        }
        Method tempMethod = methods.get(0);
        for (int i = 1; i < methods.size() && tempMethod.isAbstract(); ++i) {
            tempMethod = methods.get(i);
        }
        if (tempMethod.isAbstract()) {
            throw new DebugException("Could not find concrete defineVariable method.");
        }
        return tempMethod;
    }

    private ObjectReference _getDebugInterpreter() throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException, DebugException {
        ThreadReference threadRef = this._suspendedThreads.peek();
        String interpreterName = this._getUniqueThreadName(threadRef);
        return this._getDebugInterpreter(interpreterName, threadRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectReference _getDebugInterpreter(String interpreterName, ThreadReference threadRef) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException, DebugException {
        if (!threadRef.isSuspended()) {
            throw new IllegalStateException("threadRef must be suspended to get a debug interpreter.");
        }
        Method m = this._getMethod(this._interpreterJVM.referenceType(), "getJavaInterpreter");
        int tries = 0;
        ObjectReference sr = null;
        while (tries < 5) {
            try {
                ObjectReference tmpInterpreter;
                LinkedList<ObjectReference> args = new LinkedList<ObjectReference>();
                sr = this._vm.mirrorOf(interpreterName);
                sr.disableCollection();
                args.add(sr);
                ObjectReference objectReference = tmpInterpreter = (ObjectReference)this._interpreterJVM.invokeMethod(threadRef, m, args, 1);
                return objectReference;
            }
            catch (ObjectCollectedException e) {
                ++tries;
            }
            finally {
                sr.enableCollection();
            }
        }
        throw new DebugException(new StringBuffer().append("The debugInterpreter: ").append(interpreterName).append(" could not be obtained from interpreterJVM").toString());
    }

    private void _dumpVariablesIntoInterpreterAndSwitch() throws DebugException, AbsentInformationException {
        try {
            ThreadReference suspendedThreadRef = this._suspendedThreads.peek();
            StackFrame frame = suspendedThreadRef.frame(0);
            Location l = frame.location();
            ReferenceType rt = l.declaringType();
            String className = rt.name();
            String interpreterName = this._getUniqueThreadName(suspendedThreadRef);
            this._model.getInteractionsModel().addDebugInterpreter(interpreterName, className);
            ObjectReference debugInterpreter = this._getDebugInterpreter();
            frame = suspendedThreadRef.frame(0);
            List<LocalVariable> vars = frame.visibleVariables();
            for (LocalVariable localVar : vars) {
                Type type;
                frame = suspendedThreadRef.frame(0);
                Value val = frame.getValue(localVar);
                if (val != null) {
                    type = val.type();
                } else {
                    try {
                        type = localVar.type();
                    }
                    catch (ClassNotLoadedException e) {
                        List<ReferenceType> classes = this._vm.classesByName(localVar.typeName());
                        type = !classes.isEmpty() ? (Type)classes.get(0) : null;
                    }
                }
                this._defineVariable(suspendedThreadRef, debugInterpreter, localVar.name(), val, type);
            }
            frame = suspendedThreadRef.frame(0);
            ObjectReference thisVal = frame.thisObject();
            if (thisVal != null) {
                this._defineVariable(suspendedThreadRef, debugInterpreter, "this", thisVal, thisVal.type());
            }
            String prompt = this._getPromptString(suspendedThreadRef);
            this._model.getInteractionsModel().setActiveInterpreter(interpreterName, prompt);
        }
        catch (InvalidTypeException exc) {
            throw new DebugException(exc.toString());
        }
        catch (IncompatibleThreadStateException e2) {
            throw new DebugException(e2.toString());
        }
        catch (ClassNotLoadedException e3) {
            throw new DebugException(e3.toString());
        }
        catch (InvocationException e4) {
            throw new DebugException(e4.toString());
        }
    }

    private String _getPromptString(ThreadReference threadRef) {
        return new StringBuffer().append("[").append(threadRef.name()).append("] > ").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _defineVariable(ThreadReference suspendedThreadRef, ObjectReference debugInterpreter, String name, Value val, Type type) throws InvalidTypeException, IncompatibleThreadStateException, ClassNotLoadedException, InvocationException, DebugException {
        ReferenceType rtDebugInterpreter = debugInterpreter.referenceType();
        Method method2Call = this._getDefineVariableMethod(rtDebugInterpreter, val);
        int tries = 0;
        ObjectReference sr = null;
        while (tries < 5) {
            try {
                LinkedList<Value> args = new LinkedList<Value>();
                sr = this._vm.mirrorOf(name);
                sr.disableCollection();
                args.add(sr);
                args.add(val);
                if (type == null) {
                    args.add(null);
                } else if (type instanceof ReferenceType) {
                    args.add(((ReferenceType)type).classObject());
                }
                debugInterpreter.invokeMethod(suspendedThreadRef, method2Call, args, 1);
                return;
            }
            catch (ObjectCollectedException oce) {
                ++tries;
            }
            finally {
                sr.enableCollection();
            }
        }
        throw new DebugException(new StringBuffer().append("The variable: ").append(name).append(" could not be defined in the debug interpreter").toString());
    }

    synchronized void currThreadSuspended() {
        try {
            try {
                this._dumpVariablesIntoInterpreterAndSwitch();
                this._switchToSuspendedThread();
            }
            catch (AbsentInformationException aie) {
                this.printMessage("No debug information available for this class.\nMake sure to compile classes to be debugged with the -g flag.");
                this._hideWatches();
                this._switchToSuspendedThread(false);
            }
        }
        catch (DebugException de) {
            throw new UnexpectedException(de);
        }
    }

    private void _switchToSuspendedThread() throws DebugException {
        this._switchToSuspendedThread(true);
    }

    private void _switchToSuspendedThread(boolean updateWatches) throws DebugException {
        this._runningThread = null;
        if (updateWatches) {
            this._updateWatches();
        }
        ThreadReference currThread = this._suspendedThreads.peek();
        this._notifier.currThreadSuspended();
        this._notifier.currThreadSet(new DebugThreadData(currThread));
        try {
            if (currThread.frameCount() > 0) {
                this.scrollToSource(currThread.frame(0).location());
            }
        }
        catch (IncompatibleThreadStateException itse) {
            throw new UnexpectedException(itse);
        }
    }

    private String _getUniqueThreadName(ThreadReference thread) {
        return Long.toString(thread.uniqueID());
    }

    private Method _getGetVariableMethod(ReferenceType rtInterpreter) {
        return this._getMethod(rtInterpreter, "getVariable");
    }

    private Method _getMethod(ReferenceType rt, String name) {
        List<Method> methods = rt.methodsByName(name);
        for (Method m : methods) {
            if (m.isAbstract()) continue;
            return m;
        }
        throw new NoSuchElementException(new StringBuffer().append("No non-abstract method called ").append(name).append(" found in ").append(rt.name()).toString());
    }

    private Value _convertToActualType(ThreadReference threadRef, LocalVariable localVar, Value v) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException {
        Method m;
        String typeSignature;
        try {
            typeSignature = localVar.type().signature();
        }
        catch (ClassNotLoadedException cnle) {
            return v;
        }
        ObjectReference ref = (ObjectReference)v;
        ReferenceType rt = ref.referenceType();
        if (typeSignature.equals("Z")) {
            m = this._getMethod(rt, "booleanValue");
        } else if (typeSignature.equals("B")) {
            m = this._getMethod(rt, "byteValue");
        } else if (typeSignature.equals("C")) {
            m = this._getMethod(rt, "charValue");
        } else if (typeSignature.equals("S")) {
            m = this._getMethod(rt, "shortValue");
        } else if (typeSignature.equals("I")) {
            m = this._getMethod(rt, "intValue");
        } else if (typeSignature.equals("J")) {
            m = this._getMethod(rt, "longValue");
        } else if (typeSignature.equals("F")) {
            m = this._getMethod(rt, "floatValue");
        } else if (typeSignature.equals("D")) {
            m = this._getMethod(rt, "doubleValue");
        } else {
            return v;
        }
        return ref.invokeMethod(threadRef, m, new LinkedList(), 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Value _getValueOfLocalVariable(LocalVariable var, ThreadReference thread) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException, DebugException {
        ObjectReference interpreter = this._getDebugInterpreter(this._getUniqueThreadName(thread), thread);
        ReferenceType rtInterpreter = interpreter.referenceType();
        Method method2Call = this._getGetVariableMethod(rtInterpreter);
        int tries = 0;
        ObjectReference sr = null;
        String varName = var.name();
        while (tries < 5) {
            try {
                LinkedList<ObjectReference> args = new LinkedList<ObjectReference>();
                sr = this._vm.mirrorOf(varName);
                sr.disableCollection();
                args.add(sr);
                Value v = interpreter.invokeMethod(thread, method2Call, args, 1);
                if (v != null) {
                    v = this._convertToActualType(thread, var, v);
                }
                Value value = v;
                return value;
            }
            catch (ObjectCollectedException oce) {
                ++tries;
            }
            finally {
                sr.enableCollection();
            }
        }
        throw new DebugException(new StringBuffer().append("The value of variable: ").append(varName).append(" could not be obtained from the debug interpreter").toString());
    }

    private void _copyBack(ThreadReference threadRef) throws IncompatibleThreadStateException, AbsentInformationException, InvocationException, DebugException {
        StackFrame frame = threadRef.frame(0);
        List<LocalVariable> vars = frame.visibleVariables();
        for (LocalVariable localVar : vars) {
            try {
                Value v = this._getValueOfLocalVariable(localVar, threadRef);
                frame = threadRef.frame(0);
                frame.setValue(localVar, v);
            }
            catch (ClassNotLoadedException cnle) {
                this.printMessage(new StringBuffer().append("Could not update the value of '").append(localVar.name()).append("' (class not loaded)").toString());
            }
            catch (InvalidTypeException ite) {
                this.printMessage(new StringBuffer().append("Could not update the value of '").append(localVar.name()).append("' (invalid type exception)").toString());
            }
        }
    }

    protected void _copyVariablesFromInterpreter() throws DebugException {
        try {
            this._copyBack(this._runningThread);
        }
        catch (AbsentInformationException e2) {
        }
        catch (IncompatibleThreadStateException e) {
            throw new DebugException(e.toString());
        }
        catch (InvocationException e4) {
            throw new DebugException(e4.toString());
        }
    }

    private void _removeAllDebugInterpreters() {
        String oldInterpreterName;
        DefaultInteractionsModel interactionsModel = this._model.getInteractionsModel();
        if (this._runningThread != null) {
            oldInterpreterName = this._getUniqueThreadName(this._runningThread);
            interactionsModel.removeInterpreter(oldInterpreterName);
        }
        while (!this._suspendedThreads.isEmpty()) {
            ThreadReference threadRef = this._suspendedThreads.pop();
            oldInterpreterName = this._getUniqueThreadName(threadRef);
            interactionsModel.removeInterpreter(oldInterpreterName);
        }
    }

    private void _removeCurrentDebugInterpreter(boolean fromStep) {
        DefaultInteractionsModel interactionsModel = this._model.getInteractionsModel();
        if (fromStep || this._suspendedThreads.isEmpty()) {
            interactionsModel.setToDefaultInterpreter();
        } else {
            ThreadReference threadRef = this._suspendedThreads.peek();
            this._switchToInterpreterForThreadReference(threadRef);
        }
        String oldInterpreterName = this._getUniqueThreadName(this._runningThread);
        interactionsModel.removeInterpreter(oldInterpreterName);
    }

    synchronized void currThreadResumed() throws DebugException {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                JPDADebugger.this._notifier.currThreadResumed();
            }
        });
    }

    private void _switchToInterpreterForThreadReference(ThreadReference threadRef) {
        String threadName = this._getUniqueThreadName(threadRef);
        String prompt = this._getPromptString(threadRef);
        this._model.getInteractionsModel().setActiveInterpreter(threadName, prompt);
    }

    synchronized void threadStarted() {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                JPDADebugger.this._notifier.threadStarted();
            }
        });
    }

    synchronized void currThreadDied() throws DebugException {
        this.printMessage("The current thread has finished.");
        this._runningThread = null;
        this._updateWatches();
        if (this._suspendedThreads.size() > 0) {
            ThreadReference thread = this._suspendedThreads.peek();
            this._switchToInterpreterForThreadReference(thread);
            try {
                if (thread.frameCount() <= 0) {
                    this.printMessage(new StringBuffer().append("Could not scroll to source for ").append(thread.name()).append(". It has no stackframes.").toString());
                } else {
                    this.scrollToSource(thread.frame(0).location());
                }
            }
            catch (IncompatibleThreadStateException e) {
                throw new UnexpectedException(e);
            }
            this._switchToSuspendedThread();
        }
        Utilities.invokeLater(new Runnable(){

            public void run() {
                JPDADebugger.this._notifier.currThreadDied();
            }
        });
    }

    synchronized void nonCurrThreadDied() {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                JPDADebugger.this._notifier.nonCurrThreadDied();
            }
        });
    }

    synchronized void notifyDebuggerShutdown() {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                JPDADebugger.this._notifier.debuggerShutdown();
            }
        });
    }

    synchronized void notifyDebuggerStarted() {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                JPDADebugger.this._notifier.debuggerStarted();
            }
        });
    }

    synchronized void notifyStepRequested() {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                JPDADebugger.this._notifier.stepRequested();
            }
        });
    }

    protected static class RandomAccessStack {
        private Vector<ThreadReference> _data = new Vector();

        protected RandomAccessStack() {
        }

        public synchronized void push(ThreadReference t) {
            this._data.add(0, t);
        }

        public synchronized ThreadReference peek() throws NoSuchElementException {
            try {
                return this._data.get(0);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new NoSuchElementException("Cannot peek at the top of an empty RandomAccessStack!");
            }
        }

        public synchronized ThreadReference peekAt(int i) throws NoSuchElementException {
            try {
                return this._data.get(i);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new NoSuchElementException("Cannot peek at element " + i + " of this stack!");
            }
        }

        public synchronized ThreadReference remove(long id) throws NoSuchElementException {
            for (int i = 0; i < this._data.size(); ++i) {
                if (this._data.get(i).uniqueID() != id) continue;
                ThreadReference t = this._data.get(i);
                this._data.remove(i);
                return t;
            }
            throw new NoSuchElementException("Thread " + id + " not found in debugger suspended threads stack!");
        }

        public synchronized ThreadReference pop() throws NoSuchElementException {
            try {
                ThreadReference t = this._data.get(0);
                this._data.remove(0);
                return t;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new NoSuchElementException("Cannot pop from an empty RandomAccessStack!");
            }
        }

        public synchronized boolean contains(long id) {
            for (int i = 0; i < this._data.size(); ++i) {
                if (this._data.get(i).uniqueID() != id) continue;
                return true;
            }
            return false;
        }

        public int size() {
            return this._data.size();
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

