/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler;

import com.sun.tools.javac.v8.JavaCompiler;
import com.sun.tools.javac.v8.util.Hashtable;
import com.sun.tools.javac.v8.util.List;
import com.sun.tools.javac.v8.util.Log;
import com.sun.tools.javac.v8.util.Position;
import edu.rice.cs.drjava.model.compiler.CompilerError;
import edu.rice.cs.drjava.model.compiler.CompilerInterface;
import edu.rice.cs.drjava.model.compiler.CompilerOptions;
import edu.rice.cs.util.UnexpectedException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;

public class JavacGJCompiler
implements CompilerInterface {
    private String _extraClassPath = "";
    private boolean _allowAssertions = false;
    private boolean _warningsEnabled = true;
    public static final CompilerInterface ONLY = new JavacGJCompiler();
    public static final String COMPILER_CLASS_NAME = "com.sun.tools.javac.v8.JavaCompiler";
    private String _builtPath = "";
    private static final Writer NULL_WRITER = new Writer(){

        public void write(char[] cbuf, int off, int len) throws IOException {
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }
    };
    private static final PrintWriter NULL_PRINT_WRITER = new PrintWriter(NULL_WRITER);
    protected JavaCompiler compiler;
    protected OurLogI compilerLog;
    static /* synthetic */ Class class$com$sun$tools$javac$v8$util$Log;
    static /* synthetic */ Class class$java$io$PrintWriter;

    protected JavacGJCompiler() {
        if (!this._isValidVersion()) {
            throw new RuntimeException("Invalid version of Java compiler.");
        }
    }

    public void setBuildDirectory(File dir) {
        this._builtPath = dir == null ? "" : dir.getAbsolutePath();
    }

    protected boolean _isValidVersion() {
        Class log = class$com$sun$tools$javac$v8$util$Log == null ? (class$com$sun$tools$javac$v8$util$Log = JavacGJCompiler.class$("com.sun.tools.javac.v8.util.Log")) : class$com$sun$tools$javac$v8$util$Log;
        Class[] validArgs1 = new Class[]{Boolean.TYPE, Boolean.TYPE};
        Class[] validArgs2 = new Class[]{Boolean.TYPE, Boolean.TYPE, class$java$io$PrintWriter == null ? (class$java$io$PrintWriter = JavacGJCompiler.class$("java.io.PrintWriter")) : class$java$io$PrintWriter, class$java$io$PrintWriter == null ? (class$java$io$PrintWriter = JavacGJCompiler.class$("java.io.PrintWriter")) : class$java$io$PrintWriter, class$java$io$PrintWriter == null ? (class$java$io$PrintWriter = JavacGJCompiler.class$("java.io.PrintWriter")) : class$java$io$PrintWriter};
        try {
            log.getConstructor(validArgs1);
            return true;
        }
        catch (NoSuchMethodException e) {
            try {
                log.getConstructor(validArgs2);
                return true;
            }
            catch (NoSuchMethodException e2) {
                return false;
            }
        }
    }

    public CompilerError[] compile(File sourceRoot, File[] files) {
        File[] sourceRoots = new File[]{sourceRoot};
        return this.compile(sourceRoots, files);
    }

    public CompilerError[] compile(File[] sourceRoots, File[] files) {
        this.initCompiler(sourceRoots);
        List filesToCompile = new List();
        for (int i = 0; i < files.length; ++i) {
            filesToCompile = filesToCompile.prepend((Object)files[i].getAbsolutePath());
        }
        try {
            this.compiler.compile(filesToCompile);
        }
        catch (Throwable t) {
            CompilerError[] errorArray = new CompilerError[this.compilerLog.getErrors().length + 1];
            for (int i = 0; i < this.compilerLog.getErrors().length; ++i) {
                errorArray[i + 1] = this.compilerLog.getErrors()[i];
            }
            errorArray[0] = new CompilerError("Compile exception: " + t, false);
            return errorArray;
        }
        CompilerError[] errors = this.compilerLog.getErrors();
        this.compiler = null;
        this.compilerLog = null;
        return errors;
    }

    public boolean isAvailable() {
        try {
            Class.forName(COMPILER_CLASS_NAME);
            try {
                Class.forName("java.lang.Enum");
                return false;
            }
            catch (Throwable t) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getName() {
        return "javac";
    }

    public String toString() {
        return this.getName();
    }

    public void setExtraClassPath(String extraClassPath) {
        this._extraClassPath = extraClassPath;
    }

    public void setAllowAssertions(boolean allow) {
        this._allowAssertions = allow;
    }

    public void setWarningsEnabled(boolean warningsEnabled) {
        this._warningsEnabled = warningsEnabled;
    }

    public void addToBootClassPath(File cp) {
        throw new UnexpectedException(new Exception("Method only implemented in JSR14Compiler"));
    }

    protected Hashtable createOptionsHashtable(File[] sourceRoots) {
        Hashtable options = Hashtable.make();
        HashMap<String, String> toAdd = CompilerOptions.getOptions(this._warningsEnabled);
        LinkedList<String> keys = new LinkedList<String>(toAdd.keySet());
        LinkedList<String> values = new LinkedList<String>(toAdd.values());
        for (int i = 0; i < toAdd.size(); ++i) {
            options.put((Object)values.get(i), (Object)values.get(i));
        }
        options.put((Object)"-g", (Object)"");
        options.put((Object)"-gj", (Object)"");
        options.put((Object)"-target", (Object)"1.1");
        String version = System.getProperty("java.version");
        if (this._allowAssertions && version != null && "1.4.0".compareTo(version) <= 0) {
            options.put((Object)"-source", (Object)"1.4");
        }
        String sourceRootString = this.getSourceRootString(sourceRoots);
        options.put((Object)"-sourcepath", (Object)sourceRootString);
        String cp = System.getProperty("java.class.path");
        cp = cp + this._extraClassPath;
        cp = cp + File.pathSeparator + sourceRootString;
        options.put((Object)"-classpath", (Object)cp);
        return options;
    }

    protected String getSourceRootString(File[] sourceRoots) {
        StringBuffer roots = new StringBuffer();
        for (int i = 0; i < sourceRoots.length; ++i) {
            roots.append(sourceRoots[i].getAbsolutePath());
            if (i >= sourceRoots.length - 1) continue;
            roots.append(File.pathSeparator);
        }
        return roots.toString();
    }

    protected void initCompiler(File[] sourceRoots) {
        Hashtable options = this.createOptionsHashtable(sourceRoots);
        try {
            this.compilerLog = new OurLog14();
        }
        catch (NoSuchMethodError error) {
            this.compilerLog = new OurLog13();
        }
        this.compiler = JavaCompiler.make((Log)((Log)this.compilerLog), (Hashtable)options);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static interface OurLogI {
        public CompilerError[] getErrors();
    }

    private class OurLog14
    extends Log
    implements OurLogI {
        private LinkedList _errors = new LinkedList();
        private String _sourceName = "";

        public OurLog14() {
            super(false, true, NULL_PRINT_WRITER, NULL_PRINT_WRITER, NULL_PRINT_WRITER);
        }

        public void warning(int pos, String key, String arg0, String arg1, String arg2, String arg3) {
            super.warning(pos, key, arg0, arg1, arg2, arg3);
            String msg = OurLog14.getText((String)("compiler.warn." + key), (String)arg0, (String)arg1, (String)arg2, (String)arg3, null, null, null);
            this._errors.addLast(new CompilerError(new File(this.currentSource().toString()), Position.line((int)pos) - 1, Position.column((int)pos) - 1, msg, true));
        }

        public void error(int pos, String key, String arg0, String arg1, String arg2, String arg3, String arg4, String arg5, String arg6) {
            super.error(pos, key, arg0, arg1, arg2, arg3, arg4, arg5, arg6);
            String msg = OurLog14.getText((String)("compiler.err." + key), (String)arg0, (String)arg1, (String)arg2, (String)arg3, (String)arg4, (String)arg5, (String)arg6);
            this._errors.addLast(new CompilerError(new File(this.currentSource().toString()), Position.line((int)pos) - 1, Position.column((int)pos) - 1, msg, false));
        }

        public void print(String s) {
        }

        public void println(String s) {
        }

        public CompilerError[] getErrors() {
            return this._errors.toArray(new CompilerError[0]);
        }
    }

    private class OurLog13
    extends Log
    implements OurLogI {
        private LinkedList _errors = new LinkedList();
        private String _sourceName = "";

        public OurLog13() {
            super(false, true);
        }

        public void warning(int pos, String key, String arg0, String arg1, String arg2, String arg3) {
            super.warning(pos, key, arg0, arg1, arg2, arg3);
            String msg = OurLog13.getText((String)("compiler.warn." + key), (String)arg0, (String)arg1, (String)arg2, (String)arg3, null, null, null);
            this._errors.addLast(new CompilerError(new File(this.currentSource().toString()), Position.line((int)pos) - 1, Position.column((int)pos) - 1, msg, true));
        }

        public void error(int pos, String key, String arg0, String arg1, String arg2, String arg3, String arg4, String arg5, String arg6) {
            super.error(pos, key, arg0, arg1, arg2, arg3, arg4, arg5, arg6);
            String msg = OurLog13.getText((String)("compiler.err." + key), (String)arg0, (String)arg1, (String)arg2, (String)arg3, (String)arg4, (String)arg5, (String)arg6);
            this._errors.addLast(new CompilerError(new File(this.currentSource().toString()), Position.line((int)pos) - 1, Position.column((int)pos) - 1, msg, false));
        }

        public void print(String s) {
        }

        public void println(String s) {
        }

        public CompilerError[] getErrors() {
            return this._errors.toArray(new CompilerError[0]);
        }
    }
}

