/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler;

import edu.rice.cs.drjava.model.compiler.CompilerError;
import edu.rice.cs.drjava.model.compiler.CompilerInterface;
import edu.rice.cs.util.ClasspathVector;
import edu.rice.cs.util.UnexpectedException;
import gjc.v6.JavaCompiler;
import gjc.v6.util.Hashtable;
import gjc.v6.util.List;
import gjc.v6.util.Log;
import gjc.v6.util.Name;
import gjc.v6.util.Position;
import java.io.File;
import java.util.LinkedList;

public class GJv6Compiler
implements CompilerInterface {
    private String _extraClassPath = "";
    public static final CompilerInterface ONLY = new GJv6Compiler();
    public static final String COMPILER_CLASS_NAME = "gj.v6.JavaCompiler";
    private JavaCompiler _compiler;
    private OurLog _compilerLog;

    private GJv6Compiler() {
        float javaVersion = Float.parseFloat(System.getProperty("java.specification.version"));
        if (javaVersion > 1.3f) {
            throw new RuntimeException("GJv6 can't work with java version > 1.3!");
        }
    }

    private void _initCompiler(File[] sourceRoots) {
        this._compilerLog = new OurLog();
        Hashtable options = Hashtable.make();
        options.put((Object)"-g", (Object)"");
        String oldclasspath = System.getProperty("java.class.path");
        String sourceRootString = this.getSourceRootString(sourceRoots);
        StringBuffer newclasspath = new StringBuffer(sourceRootString);
        if (oldclasspath.length() > 0) {
            newclasspath.append(File.pathSeparator);
            newclasspath.append(oldclasspath);
        }
        newclasspath.append(this._extraClassPath);
        options.put((Object)"-classpath", (Object)newclasspath.toString());
        this._compiler = JavaCompiler.make((Log)this._compilerLog, (Hashtable)options);
    }

    public CompilerError[] compile(File sourceRoot, File[] files) {
        File[] sourceRoots = new File[]{sourceRoot};
        return this.compile(sourceRoots, files);
    }

    public CompilerError[] compile(File[] sourceRoots, File[] files) {
        this._initCompiler(sourceRoots);
        List filesToCompile = new List();
        for (int i = 0; i < files.length; ++i) {
            filesToCompile = filesToCompile.prepend((Object)files[i].getAbsolutePath());
        }
        try {
            this._compiler.compile(filesToCompile);
        }
        catch (Throwable t) {
            System.err.println("Compile error: " + t);
            t.printStackTrace();
            return new CompilerError[]{new CompilerError("Compile exception: " + t, false)};
        }
        return this._compilerLog.getErrors();
    }

    public boolean isAvailable() {
        return true;
    }

    public String getName() {
        return "GJ compiler v6";
    }

    public String toString() {
        return this.getName();
    }

    public void setExtraClassPath(String extraClassPath) {
        this._extraClassPath = extraClassPath;
    }

    public void setExtraClassPath(ClasspathVector extraClassPath) {
        this._extraClassPath = extraClassPath.toString();
    }

    public void setAllowAssertions(boolean allow) {
    }

    public void addToBootClassPath(File cp) {
        throw new UnexpectedException(new Exception("Method only implemented in JSR14Compiler"));
    }

    protected String getSourceRootString(File[] sourceRoots) {
        StringBuffer roots = new StringBuffer();
        for (int i = 0; i < sourceRoots.length; ++i) {
            roots.append(sourceRoots[i].getAbsolutePath());
            if (i >= sourceRoots.length - 1) continue;
            roots.append(File.pathSeparator);
        }
        return roots.toString();
    }

    public void setBuildDirectory(File builddir) {
    }

    public void setWarningsEnabled(boolean warningsEnabled) {
    }

    private static class OurLog
    extends Log {
        private LinkedList<CompilerError> _errors = new LinkedList();
        private String _sourceName = "";

        private OurLog() {
        }

        public Name useSource(Name source) {
            this._sourceName = source.toString();
            return super.useSource(source);
        }

        public void print(String s) {
        }

        public void warning(int pos, String msg) {
            super.warning(pos, msg);
            this._errors.addLast(new CompilerError(new File(this._sourceName), Position.line((int)pos) - 1, Position.column((int)pos) - 1, msg, true));
        }

        public void error(int pos, String msg) {
            super.error(pos, msg);
            this._errors.addLast(new CompilerError(new File(this._sourceName), Position.line((int)pos) - 1, Position.column((int)pos) - 1, msg, false));
        }

        public CompilerError[] getErrors() {
            return this._errors.toArray(new CompilerError[this._errors.size()]);
        }
    }
}

