/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.IGetDocuments;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.compiler.CompilerError;
import edu.rice.cs.drjava.model.compiler.CompilerErrorModel;
import edu.rice.cs.drjava.model.compiler.CompilerEventNotifier;
import edu.rice.cs.drjava.model.compiler.CompilerInterface;
import edu.rice.cs.drjava.model.compiler.CompilerListener;
import edu.rice.cs.drjava.model.compiler.CompilerModel;
import edu.rice.cs.drjava.model.compiler.CompilerRegistry;
import edu.rice.cs.drjava.model.definitions.InvalidPackageException;
import edu.rice.cs.javalanglevels.JExprParseException;
import edu.rice.cs.javalanglevels.LanguageLevelConverter;
import edu.rice.cs.javalanglevels.Pair;
import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.parser.JExprParser;
import edu.rice.cs.javalanglevels.tree.JExpressionIF;
import edu.rice.cs.util.ClasspathVector;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCompilerModel
implements CompilerModel {
    private final CompilerEventNotifier _notifier = new CompilerEventNotifier();
    private final IGetDocuments _model;
    private CompilerErrorModel<? extends CompilerError> _compilerErrorModel;
    private Object _slaveJVMLock = new Object();

    private String[] getCompilableExtensions() {
        return new String[]{".java", ".dj0", ".dj1", ".dj2"};
    }

    public DefaultCompilerModel(IGetDocuments getter) {
        this._model = getter;
        this._compilerErrorModel = new CompilerErrorModel(new CompilerError[0], this._model);
    }

    @Override
    public Object getSlaveJVMLock() {
        return this._slaveJVMLock;
    }

    @Override
    public void addListener(CompilerListener listener) {
        this._notifier.addListener(listener);
    }

    @Override
    public void removeListener(CompilerListener listener) {
        this._notifier.removeListener(listener);
    }

    @Override
    public void removeAllListeners() {
        this._notifier.removeAllListeners();
    }

    @Override
    public void compileAll() throws IOException {
        boolean isProjActive = this._model.getFileGroupingState().isProjectActive();
        List<OpenDefinitionsDocument> defDocs = this._model.getOpenDefinitionsDocuments();
        if (isProjActive) {
            LinkedList<OpenDefinitionsDocument> projectDocs = new LinkedList<OpenDefinitionsDocument>();
            for (OpenDefinitionsDocument doc : defDocs) {
                if (!doc.isInProjectPath() && !doc.isAuxiliaryFile()) continue;
                projectDocs.add(doc);
            }
            defDocs = projectDocs;
        }
        this.compile(defDocs);
    }

    @Override
    public void compileAll(List<File> sourceRootSet, List<File> filesToCompile) throws IOException {
        List<OpenDefinitionsDocument> defDocs;
        File buildDir = null;
        if (this._model.getFileGroupingState().isProjectActive()) {
            buildDir = this._model.getFileGroupingState().getBuildDirectory();
        }
        if (this._hasModifiedFiles(defDocs = this._model.getOpenDefinitionsDocuments())) {
            this._notifier.saveBeforeCompile();
        }
        if (this._hasModifiedFiles(defDocs)) {
            return;
        }
        this._rawCompile(sourceRootSet.toArray(new File[0]), filesToCompile.toArray(new File[0]), buildDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _rawCompile(File[] sourceRoots, File[] files, File buildDir) throws IOException {
        this._notifier.compileStarted();
        try {
            this._compileFiles(sourceRoots, files, buildDir);
        }
        catch (Throwable t) {
            CompilerError err = new CompilerError(t.toString(), false);
            CompilerError[] errors = new CompilerError[]{err};
            this._distributeErrors(errors);
        }
        finally {
            this._notifier.compileEnded();
        }
    }

    @Override
    public void compile(List<OpenDefinitionsDocument> defDocs) throws IOException {
        File buildDir = null;
        if (this._model.getFileGroupingState().isProjectActive()) {
            buildDir = this._model.getFileGroupingState().getBuildDirectory();
        }
        if (this._hasModifiedFiles(defDocs)) {
            this._notifier.saveBeforeCompile();
        }
        if (this._hasModifiedFiles(defDocs)) {
            return;
        }
        ArrayList<File> filesToCompile = new ArrayList<File>();
        String[] exts = this.getCompilableExtensions();
        for (OpenDefinitionsDocument doc : defDocs) {
            try {
                File f = doc.getFile();
                if (!DefaultCompilerModel.endsWithExt(f, exts)) continue;
                filesToCompile.add(f);
            }
            catch (IllegalStateException ise) {}
        }
        this._rawCompile(this.getSourceRootSet(), filesToCompile.toArray(new File[0]), buildDir);
    }

    @Override
    public void compile(OpenDefinitionsDocument doc) throws IOException {
        List<OpenDefinitionsDocument> defDocs;
        File buildDir = null;
        if (doc.isInProjectPath() || doc.isAuxiliaryFile()) {
            buildDir = this._model.getFileGroupingState().getBuildDirectory();
        }
        if (this._hasModifiedFiles(defDocs = this._model.getOpenDefinitionsDocuments())) {
            this._notifier.saveBeforeCompile();
        }
        if (this._hasModifiedFiles(defDocs)) {
            return;
        }
        if (doc.isUntitled()) {
            this._notifier.saveUntitled();
            if (doc.isUntitled()) {
                return;
            }
        }
        File[] files = new File[]{doc.getFile()};
        this._rawCompile(new File[]{doc.getSourceRoot()}, files, buildDir);
    }

    private LinkedList<CompilerError> _parseExceptions2CompilerErrors(LinkedList<JExprParseException> pes) {
        LinkedList<CompilerError> errors = new LinkedList<CompilerError>();
        for (JExprParseException pe : pes) {
            errors.addLast(new CompilerError(pe.getFile(), pe.currentToken.beginLine - 1, pe.currentToken.beginColumn - 1, pe.getMessage(), false));
        }
        return errors;
    }

    private LinkedList<CompilerError> _visitorErrors2CompilerErrors(LinkedList<Pair<String, JExpressionIF>> visitorErrors) {
        LinkedList<CompilerError> errors = new LinkedList<CompilerError>();
        for (Pair pair : visitorErrors) {
            String message = (String)pair.getFirst();
            JExpressionIF jexpr = (JExpressionIF)pair.getSecond();
            SourceInfo si = jexpr == null ? JExprParser.NO_SOURCE_INFO : ((JExpressionIF)pair.getSecond()).getSourceInfo();
            errors.addLast(new CompilerError(si.getFile(), si.getStartLine() - 1, si.getStartColumn() - 1, message, false));
        }
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _compileFiles(File[] sourceRoots, File[] files, File buildDir) throws IOException {
        LinkedList<CompilerError> compilerErrors = new LinkedList<CompilerError>();
        CompilerInterface compiler = CompilerRegistry.ONLY.getActiveCompiler();
        compiler.setBuildDirectory(buildDir);
        ClasspathVector extraClasspath = new ClasspathVector();
        if (this._model.getFileGroupingState().isProjectActive()) {
            extraClasspath.addAll(this._model.getFileGroupingState().getExtraClasspath());
        }
        for (File f : (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTRA_CLASSPATH))) {
            extraClasspath.add(f);
        }
        compiler.setExtraClassPath(extraClasspath);
        if (files.length > 0) {
            LanguageLevelConverter llc = new LanguageLevelConverter(this.getActiveCompiler().getName());
            Pair<LinkedList<JExprParseException>, LinkedList<Pair<String, JExpressionIF>>> errors = llc.convert(files);
            compiler.setWarningsEnabled(true);
            HashSet<File> javaFileSet = new HashSet<File>();
            for (File f : files) {
                File canonicalFile;
                try {
                    canonicalFile = f.getCanonicalFile();
                }
                catch (IOException e) {
                    canonicalFile = f.getAbsoluteFile();
                }
                String fileName = canonicalFile.getPath();
                int lastIndex = fileName.lastIndexOf(".dj");
                if (lastIndex != -1) {
                    compiler.setWarningsEnabled(false);
                    javaFileSet.add(new File(new StringBuffer().append(fileName.substring(0, lastIndex)).append(".java").toString()));
                    continue;
                }
                javaFileSet.add(canonicalFile);
            }
            files = javaFileSet.toArray(new File[javaFileSet.size()]);
            LinkedList<JExprParseException> parseExceptions = errors.getFirst();
            compilerErrors.addAll(this._parseExceptions2CompilerErrors(parseExceptions));
            LinkedList<Pair<String, JExpressionIF>> visitorErrors = errors.getSecond();
            compilerErrors.addAll(this._visitorErrors2CompilerErrors(visitorErrors));
            CompilerError[] compilerErrorsArray = null;
            compilerErrorsArray = compilerErrors.toArray(new CompilerError[compilerErrors.size()]);
            if (compilerErrorsArray.length == 0) {
                Object object = this._slaveJVMLock;
                synchronized (object) {
                    compilerErrorsArray = compiler.compile(sourceRoots, files);
                }
            }
            this._distributeErrors(compilerErrorsArray);
        } else {
            this._distributeErrors(new CompilerError[0]);
        }
    }

    private static boolean endsWithExt(File f, String[] exts) {
        for (String ext : exts) {
            if (!f.getName().endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    private void _distributeErrors(CompilerError[] errors) throws IOException {
        this.resetCompilerErrors();
        this._compilerErrorModel = new CompilerErrorModel(errors, this._model);
    }

    public File[] getSourceRootSet() {
        List<OpenDefinitionsDocument> defDocs = this._model.getOpenDefinitionsDocuments();
        return DefaultCompilerModel.getSourceRootSet(defDocs);
    }

    public static File[] getSourceRootSet(List<OpenDefinitionsDocument> defDocs) {
        LinkedList<File> roots = new LinkedList<File>();
        for (int i = 0; i < defDocs.size(); ++i) {
            OpenDefinitionsDocument doc = defDocs.get(i);
            try {
                File root = doc.getSourceRoot();
                if (roots.contains(root)) continue;
                roots.add(root);
                continue;
            }
            catch (InvalidPackageException e) {
                // empty catch block
            }
        }
        return roots.toArray(new File[roots.size()]);
    }

    protected boolean _hasModifiedFiles(List<OpenDefinitionsDocument> defDocs) {
        boolean isProjActive = this._model.getFileGroupingState().isProjectActive();
        for (OpenDefinitionsDocument doc : defDocs) {
            if (!doc.isModifiedSinceSave() || isProjActive && doc.isUntitled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CompilerErrorModel<? extends CompilerError> getCompilerErrorModel() {
        return this._compilerErrorModel;
    }

    @Override
    public int getNumErrors() {
        return this.getCompilerErrorModel().getNumErrors();
    }

    public int getNumCompErrors() {
        return this.getCompilerErrorModel().getNumCompErrors();
    }

    public int getNumWarnings() {
        return this.getCompilerErrorModel().getNumWarnings();
    }

    @Override
    public void resetCompilerErrors() {
        this._compilerErrorModel = new CompilerErrorModel(new CompilerError[0], this._model);
    }

    @Override
    public CompilerInterface[] getAvailableCompilers() {
        return CompilerRegistry.ONLY.getAvailableCompilers();
    }

    @Override
    public CompilerInterface getActiveCompiler() {
        return CompilerRegistry.ONLY.getActiveCompiler();
    }

    @Override
    public void setActiveCompiler(CompilerInterface compiler) {
        CompilerRegistry.ONLY.setActiveCompiler(compiler);
    }
}

