/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.FileOption;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.compiler.CompilerError;
import edu.rice.cs.drjava.model.compiler.CompilerInterface;
import edu.rice.cs.drjava.model.compiler.CompilerRegistry;
import edu.rice.cs.util.ClasspathVector;
import edu.rice.cs.util.classloader.StickyClassLoader;
import java.io.File;

public class CompilerProxy
implements CompilerInterface {
    private CompilerInterface _realCompiler = null;
    private final String _className;
    private final ClassLoader _newLoader;
    private boolean _warningsEnabled = true;
    private File _buildDir;
    private ClasspathVector _extraClasspath = new ClasspathVector();
    private static final String[] _useOldLoader = new String[]{"edu.rice.cs.drjava.model.Configuration", "edu.rice.cs.drjava.model.compiler.CompilerInterface", "edu.rice.cs.drjava.model.compiler.CompilerError"};

    public CompilerProxy(String className, ClassLoader newLoader) {
        this._className = className;
        this._newLoader = newLoader;
        this._recreateCompiler();
    }

    private void _recreateCompiler() {
        File collectionsPath = DrJava.getConfig().getSetting(OptionConstants.JSR14_COLLECTIONSPATH);
        StickyClassLoader loader = new StickyClassLoader(this._newLoader, this.getClass().getClassLoader(), _useOldLoader);
        try {
            Class<?> c = loader.loadClass(this._className);
            this._realCompiler = CompilerRegistry.createCompiler(c);
            this._realCompiler.setBuildDirectory(this._buildDir);
            this._realCompiler.setExtraClassPath(File.pathSeparator + this._extraClasspath.toString());
            this._realCompiler.setWarningsEnabled(this._warningsEnabled);
            boolean allowAssertions = DrJava.getConfig().getSetting(OptionConstants.JAVAC_ALLOW_ASSERT);
            this._realCompiler.setAllowAssertions(allowAssertions);
            String compilerClass = this._realCompiler.getClass().getName();
            if ((compilerClass.equals("edu.rice.cs.drjava.model.compiler.JSR14v10Compiler") || compilerClass.equals("edu.rice.cs.drjava.model.compiler.JSR14v12Compiler") || compilerClass.equals("edu.rice.cs.drjava.model.compiler.JSR14v20Compiler")) && collectionsPath != FileOption.NULL_FILE) {
                this._realCompiler.addToBootClassPath(collectionsPath);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public CompilerError[] compile(File sourceRoot, File[] files) {
        this._recreateCompiler();
        CompilerError[] ret = this._realCompiler.compile(sourceRoot, files);
        return ret;
    }

    public CompilerError[] compile(File[] sourceRoots, File[] files) {
        this._recreateCompiler();
        CompilerError[] ret = this._realCompiler.compile(sourceRoots, files);
        return ret;
    }

    public boolean isAvailable() {
        if (this._realCompiler == null) {
            return false;
        }
        return this._realCompiler.isAvailable();
    }

    public String getName() {
        if (!this.isAvailable()) {
            return "(unavailable)";
        }
        return this._realCompiler.getName();
    }

    public String toString() {
        return this.getName();
    }

    public void setExtraClassPath(String extraClassPath) {
        this._realCompiler.setExtraClassPath(extraClassPath);
    }

    public void setExtraClassPath(ClasspathVector extraClassPath) {
        this._extraClasspath = extraClassPath;
    }

    public void setAllowAssertions(boolean allow) {
        this._realCompiler.setAllowAssertions(allow);
    }

    public void setWarningsEnabled(boolean warningsEnabled) {
        this._realCompiler.setWarningsEnabled(warningsEnabled);
        this._warningsEnabled = warningsEnabled;
    }

    public void addToBootClassPath(File cp) {
        this._realCompiler.addToBootClassPath(cp);
    }

    public void setBuildDirectory(File buildDir) {
        this._realCompiler.setBuildDirectory(buildDir);
        this._buildDir = buildDir;
    }
}

