/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.model.AbstractGlobalModel;
import edu.rice.cs.drjava.model.ClassAndInterfaceFinder;
import edu.rice.cs.drjava.model.DefaultJavadocModel;
import edu.rice.cs.drjava.model.FileGroupingState;
import edu.rice.cs.drjava.model.FileMovedException;
import edu.rice.cs.drjava.model.FileOpenSelector;
import edu.rice.cs.drjava.model.FileSaveSelector;
import edu.rice.cs.drjava.model.GlobalModelNaming;
import edu.rice.cs.drjava.model.JavadocModel;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.OperationCanceledException;
import edu.rice.cs.drjava.model.compiler.CompilerListener;
import edu.rice.cs.drjava.model.compiler.CompilerModel;
import edu.rice.cs.drjava.model.compiler.DefaultCompilerModel;
import edu.rice.cs.drjava.model.debug.Breakpoint;
import edu.rice.cs.drjava.model.debug.DebugException;
import edu.rice.cs.drjava.model.debug.Debugger;
import edu.rice.cs.drjava.model.debug.JPDADebugger;
import edu.rice.cs.drjava.model.debug.NoDebuggerAvailable;
import edu.rice.cs.drjava.model.definitions.ClassNameNotFoundException;
import edu.rice.cs.drjava.model.definitions.DefinitionsDocument;
import edu.rice.cs.drjava.model.definitions.InvalidPackageException;
import edu.rice.cs.drjava.model.junit.DefaultJUnitModel;
import edu.rice.cs.drjava.model.junit.JUnitModel;
import edu.rice.cs.drjava.model.repl.DefaultInteractionsModel;
import edu.rice.cs.drjava.model.repl.InteractionsDocument;
import edu.rice.cs.drjava.model.repl.InteractionsDocumentAdapter;
import edu.rice.cs.drjava.model.repl.InteractionsListener;
import edu.rice.cs.drjava.model.repl.InteractionsScriptModel;
import edu.rice.cs.drjava.model.repl.newjvm.MainJVM;
import edu.rice.cs.util.ClasspathVector;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.OrderedHashSet;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.text.DocumentAdapterException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGlobalModel
extends AbstractGlobalModel {
    protected final InteractionsDocumentAdapter _interactionsDocAdapter;
    final MainJVM _interpreterControl = new MainJVM();
    protected DefaultInteractionsModel _interactionsModel;
    protected boolean _isClosingAllDocs;
    protected InteractionsListener _interactionsListener = new InteractionsListener(){

        public void interactionStarted() {
        }

        public void interactionEnded() {
        }

        public void interactionErrorOccurred(int offset, int length) {
        }

        public void interpreterResetting() {
        }

        public void interpreterReady() {
            File buildDir = DefaultGlobalModel.this._state.getBuildDirectory();
            if (buildDir != null) {
                try {
                    DefaultGlobalModel.this._interpreterControl.addBuildDirectoryClassPath(new File(buildDir.getAbsolutePath()).toURL());
                }
                catch (MalformedURLException murle) {
                    throw new RuntimeException(murle);
                }
            }
        }

        public void interpreterResetFailed(Throwable t) {
        }

        public void interpreterExited(int status) {
        }

        public void interpreterChanged(boolean inProgress) {
        }

        public void interactionIncomplete() {
        }
    };
    private CompilerListener _clearInteractionsListener = new CompilerListener(){

        public void compileStarted() {
        }

        public void compileEnded() {
            if ((DefaultGlobalModel.this._compilerModel.getNumErrors() == 0 || DefaultGlobalModel.this._compilerModel.getCompilerErrorModel().hasOnlyWarnings()) && DefaultGlobalModel.this._resetAfterCompile) {
                DefaultGlobalModel.this.resetInteractions();
            }
        }

        public void saveBeforeCompile() {
        }

        public void saveUntitled() {
        }
    };
    private final CompilerModel _compilerModel = new DefaultCompilerModel(this);
    private boolean _resetAfterCompile = true;
    private final DefaultJUnitModel _junitModel = new DefaultJUnitModel(this._interpreterControl, this._compilerModel, this);
    protected JavadocModel _javadocModel = new DefaultJavadocModel(this);
    private Debugger _debugger = NoDebuggerAvailable.ONLY;
    private static int ID_COUNTER = 0;

    public DefaultGlobalModel() {
        this._interactionsDocAdapter = new InteractionsDocumentAdapter();
        this._interactionsModel = new DefaultInteractionsModel(this, this._interpreterControl, this._interactionsDocAdapter);
        this._interactionsModel.addListener(this._interactionsListener);
        this._interpreterControl.setInteractionsModel(this._interactionsModel);
        this._interpreterControl.setJUnitModel(this._junitModel);
        this._interpreterControl.setOptionArgs(DrJava.getConfig().getSetting(JVM_ARGS));
        DrJava.getConfig().addOptionListener(JVM_ARGS, new OptionListener<String>(){

            @Override
            public void optionChanged(OptionEvent<String> oe) {
                DefaultGlobalModel.this._interpreterControl.setOptionArgs((String)oe.value);
            }
        });
        this._createDebugger();
        this._interactionsModel.addListener(this._notifier);
        this._compilerModel.addListener(this._notifier);
        this._junitModel.addListener(this._notifier);
        this._javadocModel.addListener(this._notifier);
        this._compilerModel.addListener(this._clearInteractionsListener);
        this._interpreterControl.startInterpreterJVM();
    }

    @Override
    public void compileAll() throws IOException {
        this._state.compileAll();
    }

    @Override
    public void junitAll() {
        this._state.junitAll();
    }

    @Override
    public void setBuildDirectory(File f) {
        this._state.setBuildDirectory(f);
        if (f != null) {
            try {
                this._interpreterControl.addBuildDirectoryClassPath(new File(f.getAbsolutePath()).toURL());
            }
            catch (MalformedURLException murle) {
                throw new RuntimeException(murle);
            }
        }
        this._notifier.projectBuildDirChanged();
        this.setProjectChanged(true);
    }

    @Override
    protected FileGroupingState makeProjectFileGroupingState(File main, File dir, File project, File[] files, ClasspathVector cp) {
        return new ProjectFileGroupingState(main, dir, project, files, cp);
    }

    @Override
    protected FileGroupingState makeFlatFileGroupingState() {
        return new FlatFileGroupingState();
    }

    @Override
    public String getSourceBinTitle() {
        return "[ Source Files ]";
    }

    @Override
    public String getExternalBinTitle() {
        return "[ External Files ]";
    }

    @Override
    public String getAuxiliaryBinTitle() {
        return "[ Included External Files ]";
    }

    @Override
    public DefaultInteractionsModel getInteractionsModel() {
        return this._interactionsModel;
    }

    @Override
    public InteractionsDocumentAdapter getSwingInteractionsDocument() {
        return this._interactionsDocAdapter;
    }

    @Override
    public InteractionsDocument getInteractionsDocument() {
        return this._interactionsModel.getDocument();
    }

    @Override
    public CompilerModel getCompilerModel() {
        return this._compilerModel;
    }

    @Override
    public JUnitModel getJUnitModel() {
        return this._junitModel;
    }

    @Override
    public JavadocModel getJavadocModel() {
        return this._javadocModel;
    }

    @Override
    public void dispose() {
        this._interpreterControl.killInterpreter(false);
        super.dispose();
    }

    @Override
    public void resetInteractions() {
        if (this._debugger.inDebugMode()) {
            this._debugger.shutdown();
        }
        this._interactionsModel.resetInterpreter();
        if (DrJava.getConfig().getSetting(OptionConstants.RESET_CLEAR_CONSOLE).booleanValue()) {
            this.resetConsole();
        }
    }

    @Override
    public void interpretCurrentInteraction() {
        this._interactionsModel.interpretCurrentInteraction();
    }

    @Override
    public void loadHistory(FileOpenSelector selector) throws IOException {
        this._interactionsModel.loadHistory(selector);
    }

    @Override
    public InteractionsScriptModel loadHistoryAsScript(FileOpenSelector selector) throws IOException, OperationCanceledException {
        return this._interactionsModel.loadHistoryAsScript(selector);
    }

    @Override
    public void clearHistory() {
        this._interactionsModel.getDocument().clearHistory();
    }

    @Override
    public void saveHistory(FileSaveSelector selector) throws IOException {
        this._interactionsModel.getDocument().saveHistory(selector);
    }

    @Override
    public void saveHistory(FileSaveSelector selector, String editedVersion) throws IOException {
        this._interactionsModel.getDocument().saveHistory(selector, editedVersion);
    }

    @Override
    public String getHistoryAsStringWithSemicolons() {
        return this._interactionsModel.getDocument().getHistoryAsStringWithSemicolons();
    }

    @Override
    public String getHistoryAsString() {
        return this._interactionsModel.getDocument().getHistoryAsString();
    }

    @Override
    public void printDebugMessage(String s) {
        this._interactionsModel.getDocument().insertBeforeLastPrompt(new StringBuffer().append(s).append("\n").toString(), "debugger");
    }

    @Override
    public void waitForInterpreter() {
        this._interpreterControl.ensureInterpreterConnected();
    }

    @Override
    public ClasspathVector getClasspath() {
        return this._interpreterControl.getClasspath();
    }

    @Override
    public ClasspathVector getProjectExtraClasspath() {
        return this._state.getExtraClasspath();
    }

    @Override
    public void setProjectExtraClasspath(ClasspathVector cp) {
        this._state.setExtraClasspath(cp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File[] getSourceRootSet() {
        OpenDefinitionsDocument[] docs;
        LinkedList<File> roots = new LinkedList<File>();
        OrderedHashSet orderedHashSet = this._documentsRepos;
        synchronized (orderedHashSet) {
            docs = this._documentsRepos.toArray(new OpenDefinitionsDocument[0]);
        }
        for (OpenDefinitionsDocument doc : docs) {
            try {
                File root = doc.getSourceRoot();
                if (roots.contains(root)) continue;
                roots.add(root);
            }
            catch (InvalidPackageException e) {
                // empty catch block
            }
        }
        return roots.toArray(new File[roots.size()]);
    }

    @Override
    public String getDisplayFilename(OpenDefinitionsDocument doc) {
        int extIndex;
        String filename = doc.getFilename();
        if (filename.endsWith(".java") && (extIndex = filename.lastIndexOf(".java")) > 0) {
            filename = filename.substring(0, extIndex);
        }
        if (doc.isModifiedSinceSave()) {
            filename = new StringBuffer().append(filename).append("*").toString();
        }
        return filename;
    }

    @Override
    public String getDisplayFullPath(int index) {
        OpenDefinitionsDocument doc = this.getOpenDefinitionsDocuments().get(index);
        if (doc == null) {
            throw new RuntimeException(new StringBuffer().append("Document not found with index ").append(index).toString());
        }
        return GlobalModelNaming.getDisplayFullPath(doc);
    }

    void setResetAfterCompile(boolean shouldReset) {
        this._resetAfterCompile = shouldReset;
    }

    @Override
    public Debugger getDebugger() {
        return this._debugger;
    }

    @Override
    public int getDebugPort() throws IOException {
        return this._interactionsModel.getDebugPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasModifiedDocuments() {
        OpenDefinitionsDocument[] docs;
        OrderedHashSet orderedHashSet = this._documentsRepos;
        synchronized (orderedHashSet) {
            docs = this._documentsRepos.toArray(new OpenDefinitionsDocument[0]);
        }
        for (OpenDefinitionsDocument doc : docs) {
            if (!doc.isModifiedSinceSave()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasUntitledDocuments() {
        OpenDefinitionsDocument[] docs;
        OrderedHashSet orderedHashSet = this._documentsRepos;
        synchronized (orderedHashSet) {
            docs = this._documentsRepos.toArray(new OpenDefinitionsDocument[0]);
        }
        for (OpenDefinitionsDocument doc : docs) {
            if (!doc.isUntitled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public File getSourceFile(String filename) {
        File[] sourceRoots;
        for (File s : sourceRoots = this.getSourceRootSet()) {
            File f = this._getSourceFileFromPath(filename, s);
            if (f == null) continue;
            return f;
        }
        Vector sourcepath = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.DEBUG_SOURCEPATH));
        return this.getSourceFileFromPaths(filename, sourcepath);
    }

    @Override
    public File getSourceFileFromPaths(String filename, Vector<File> paths) {
        for (File p : paths) {
            File f = this._getSourceFileFromPath(filename, p);
            if (f == null) continue;
            return f;
        }
        return null;
    }

    private File _getSourceFileFromPath(String filename, File path) {
        String root = path.getAbsolutePath();
        File f = new File(new StringBuffer().append(root).append(System.getProperty("file.separator")).append(filename).toString());
        return f.exists() ? f : null;
    }

    @Override
    public void jarAll() {
        this.getFileGroupingState().jarAll();
    }

    @Override
    protected ConcreteOpenDefDoc _createOpenDefinitionsDocument() {
        return new ConcreteOpenDefDoc();
    }

    @Override
    protected ConcreteOpenDefDoc _createOpenDefinitionsDocument(File f) throws IOException {
        return new ConcreteOpenDefDoc(f);
    }

    @Override
    protected void addDocToClasspath(OpenDefinitionsDocument doc) {
        block5: {
            try {
                File classpath = doc.getSourceRoot();
                try {
                    if (doc.inProject() || doc.isAuxiliaryFile()) {
                        this._interactionsModel.addProjectFilesClassPath(classpath.toURI().toURL());
                        break block5;
                    }
                    this._interactionsModel.addExternalFilesClassPath(classpath.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {}
            }
            catch (InvalidPackageException invalidPackageException) {
                // empty catch block
            }
        }
    }

    private void _createDebugger() {
        try {
            this._debugger = new JPDADebugger(this);
            this._interpreterControl.setDebugModel((JPDADebugger)this._debugger);
        }
        catch (NoClassDefFoundError ncdfe) {
            this._debugger = NoDebuggerAvailable.ONLY;
        }
        catch (UnsupportedClassVersionError ucve) {
            this._debugger = NoDebuggerAvailable.ONLY;
        }
        catch (Throwable t) {
            this._debugger = NoDebuggerAvailable.ONLY;
        }
    }

    public void resetInteractionsClasspath() {
        Vector cp;
        ClasspathVector projectExtras = this.getProjectExtraClasspath();
        if (projectExtras != null) {
            for (URL cpE : projectExtras) {
                this._interactionsModel.addProjectClassPath(cpE);
            }
        }
        if ((cp = (Vector)DrJava.getConfig().getSetting(EXTRA_CLASSPATH)) != null) {
            for (File f : cp) {
                try {
                    this._interactionsModel.addExtraClassPath(f.toURL());
                }
                catch (MalformedURLException murle) {
                    System.err.println(new StringBuffer().append("File ").append(f).append(" in your extra classpath could not be parsed to a URL, maybe it contains un-URL-encodable characters?").toString());
                }
            }
        }
        List<OpenDefinitionsDocument> odds = this.getProjectDocuments();
        for (OpenDefinitionsDocument odd : odds) {
            try {
                this._interactionsModel.addProjectFilesClassPath(odd.getSourceRoot().toURL());
            }
            catch (MalformedURLException murle) {
            }
            catch (InvalidPackageException e) {}
        }
        odds = this.getNonProjectDocuments();
        for (OpenDefinitionsDocument odd : odds) {
            try {
                this._interactionsModel.addExternalFilesClassPath(odd.getSourceRoot().toURL());
            }
            catch (MalformedURLException murle) {
            }
            catch (InvalidPackageException e) {}
        }
    }

    @Override
    protected /* synthetic */ AbstractGlobalModel.ConcreteOpenDefDoc _createOpenDefinitionsDocument(File x0) throws IOException {
        return this._createOpenDefinitionsDocument(x0);
    }

    @Override
    protected /* synthetic */ AbstractGlobalModel.ConcreteOpenDefDoc _createOpenDefinitionsDocument() {
        return this._createOpenDefinitionsDocument();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BackUpFileOptionListener
    implements OptionListener<Boolean> {
        private BackUpFileOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Boolean> oe) {
            Boolean value = (Boolean)oe.value;
            FileOps.DefaultFileSaver.setBackupsEnabled(value);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExtraClasspathOptionListener
    implements OptionListener<Vector<File>> {
        private ExtraClasspathOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Vector<File>> oce) {
            Vector cp = (Vector)oce.value;
            if (cp != null) {
                for (File f : cp) {
                    try {
                        DefaultGlobalModel.this._interactionsModel.addExtraClassPath(f.toURL());
                    }
                    catch (MalformedURLException murle) {}
                }
            }
        }
    }

    private static class TrivialFSS
    implements FileSaveSelector {
        private File _file;

        private TrivialFSS(File file) {
            this._file = file;
        }

        public File getFile() throws OperationCanceledException {
            return this._file;
        }

        public boolean warnFileOpen(File f) {
            return true;
        }

        public boolean verifyOverwrite() {
            return true;
        }

        public boolean shouldSaveAfterFileMoved(OpenDefinitionsDocument doc, File oldFile) {
            return true;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ConcreteOpenDefDoc
    extends AbstractGlobalModel.ConcreteOpenDefDoc {
        ConcreteOpenDefDoc(File f) throws IOException {
            super(f);
        }

        ConcreteOpenDefDoc() {
        }

        @Override
        public boolean saveFileAs(FileSaveSelector com) throws IOException {
            try {
                boolean openInOtherDoc;
                ConcreteOpenDefDoc openDoc = this;
                File file = com.getFile();
                OpenDefinitionsDocument otherDoc = DefaultGlobalModel.this._getOpenDocument(file);
                boolean shouldSave = false;
                boolean bl = openInOtherDoc = otherDoc != null && openDoc != otherDoc;
                if (openInOtherDoc) {
                    shouldSave = com.warnFileOpen(file);
                }
                if (shouldSave && openInOtherDoc || !openInOtherDoc && (!file.exists() || com.verifyOverwrite())) {
                    block13: {
                        if (!file.getCanonicalFile().getName().equals(file.getName())) {
                            file.renameTo(file);
                        }
                        if (file.getAbsolutePath().indexOf("#") != -1) {
                            DefaultGlobalModel.this._notifier.filePathContainsPound();
                        }
                        FileOps.saveFile(new FileOps.DefaultFileSaver(file){

                            public void saveTo(OutputStream os) throws IOException {
                                DefinitionsDocument doc = ConcreteOpenDefDoc.this.getDocument();
                                try {
                                    ((ConcreteOpenDefDoc)ConcreteOpenDefDoc.this).DefaultGlobalModel.this._editorKit.write(os, (Document)doc, 0, doc.getLength());
                                }
                                catch (BadLocationException docFailed) {
                                    throw new UnexpectedException(docFailed);
                                }
                            }
                        });
                        this.resetModification();
                        this.setFile(file);
                        try {
                            this._packageName = this.getDocument().getPackageName();
                        }
                        catch (InvalidPackageException e) {
                            this._packageName = null;
                        }
                        this.getDocument().setCachedClassFile(null);
                        this.checkIfClassFileInSync();
                        DefaultGlobalModel.this._notifier.fileSaved(openDoc);
                        try {
                            File classpath = this.getSourceRoot();
                            try {
                                if (this.inProject() || this.isAuxiliaryFile()) {
                                    DefaultGlobalModel.this._interactionsModel.addProjectFilesClassPath(new File(classpath.getAbsolutePath()).toURL());
                                    break block13;
                                }
                                DefaultGlobalModel.this._interactionsModel.addExternalFilesClassPath(new File(classpath.getAbsolutePath()).toURL());
                            }
                            catch (MalformedURLException murle) {}
                        }
                        catch (InvalidPackageException e) {
                            // empty catch block
                        }
                    }
                    DefaultGlobalModel.this._documentNavigator.refreshDocument(this, DefaultGlobalModel.this.fixPathForNavigator(file.getCanonicalPath()));
                }
                return true;
            }
            catch (OperationCanceledException oce) {
                return false;
            }
        }

        @Override
        public void startCompile() throws IOException {
            DefaultGlobalModel.this._compilerModel.compile(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runMain() throws ClassNameNotFoundException, IOException {
            try {
                String className = this.getDocument().getQualifiedClassName();
                InteractionsDocument iDoc = DefaultGlobalModel.this._interactionsModel.getDocument();
                MainJVM mainJVM = DefaultGlobalModel.this._interpreterControl;
                synchronized (mainJVM) {
                    iDoc.clearCurrentInput();
                    if (!this.checkIfClassFileInSync()) {
                        iDoc.insertBeforeLastPrompt("Current document is out of sync with the Interactions Pane and should be recompiled!\n", "error");
                    }
                    iDoc.insertText(iDoc.getLength(), new StringBuffer().append("java ").append(className).toString(), null);
                    DefaultGlobalModel.this._notifier.runStarted(this);
                    DefaultGlobalModel.this._interactionsModel.interpretCurrentInteraction();
                }
            }
            catch (DocumentAdapterException e) {
                throw new UnexpectedException(e);
            }
        }

        @Override
        public void startJUnit() throws ClassNotFoundException, IOException {
            DefaultGlobalModel.this._junitModel.junit(this);
        }

        @Override
        public void generateJavadoc(FileSaveSelector saver) throws IOException {
            DefaultGlobalModel.this._javadocModel.javadocDocument(this, saver, DefaultGlobalModel.this.getClasspath().toString());
        }

        @Override
        public Breakpoint getBreakpointAt(int offset) {
            for (int i = 0; i < this._breakpoints.size(); ++i) {
                Breakpoint bp = (Breakpoint)this._breakpoints.get(i);
                if (offset < bp.getStartOffset() || offset > bp.getEndOffset()) continue;
                return bp;
            }
            return null;
        }

        @Override
        public void addBreakpoint(Breakpoint breakpoint) {
            for (int i = 0; i < this._breakpoints.size(); ++i) {
                Breakpoint bp = (Breakpoint)this._breakpoints.get(i);
                int oldStart = bp.getStartOffset();
                int newStart = breakpoint.getStartOffset();
                if (newStart < oldStart) {
                    this._breakpoints.add(i, breakpoint);
                    return;
                }
                if (newStart != oldStart) continue;
                int oldEnd = bp.getEndOffset();
                int newEnd = breakpoint.getEndOffset();
                if (newEnd >= oldEnd) continue;
                this._breakpoints.add(i, breakpoint);
                return;
            }
            this._breakpoints.add(breakpoint);
        }

        @Override
        public void removeBreakpoint(Breakpoint breakpoint) {
            this._breakpoints.remove(breakpoint);
        }

        @Override
        public Vector<Breakpoint> getBreakpoints() {
            return this._breakpoints;
        }

        @Override
        public void clearBreakpoints() {
            this._breakpoints.clear();
        }

        @Override
        public void removeFromDebugger() {
            if (DefaultGlobalModel.this._debugger.isAvailable() && DefaultGlobalModel.this._debugger.isReady()) {
                try {
                    while (this._breakpoints.size() > 0) {
                        DefaultGlobalModel.this._debugger.removeBreakpoint((Breakpoint)this._breakpoints.get(0));
                    }
                }
                catch (DebugException de) {
                    throw new UnexpectedException(de);
                }
            } else {
                this.clearBreakpoints();
            }
        }
    }

    class FlatFileGroupingState
    extends AbstractGlobalModel.FlatFileGroupingState {
        FlatFileGroupingState() {
        }

        public void compileAll() throws IOException {
            DefaultGlobalModel.this.getCompilerModel().compileAll();
        }

        public void junitAll() {
            DefaultGlobalModel.this.getJUnitModel().junitAll();
        }

        public void jarAll() {
        }
    }

    class ProjectFileGroupingState
    extends AbstractGlobalModel.ProjectFileGroupingState {
        ProjectFileGroupingState(File main, File dir, File project, File[] files, ClasspathVector cp) {
            super(main, dir, project, files, cp);
        }

        public void compileAll() throws IOException {
            File dir = this.getProjectFile().getParentFile();
            ArrayList<File> files = FileOps.getFilesInDir(dir, true, new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.isDirectory() || pathname.getPath().toLowerCase().endsWith(".java") || pathname.getPath().toLowerCase().endsWith(".dj0") || pathname.getPath().toLowerCase().endsWith(".dj1") || pathname.getPath().toLowerCase().endsWith(".dj2");
                }
            });
            LinkedList<File> lof = new LinkedList<File>();
            LinkedList<File> los = new LinkedList<File>();
            Iterator<File> i$ = files.iterator();
            while (i$.hasNext()) {
                File f = i$.next();
                ClassAndInterfaceFinder finder = new ClassAndInterfaceFinder(f);
                String classname = finder.getClassOrInterfaceName();
                String packagename = AbstractGlobalModel.getPackageName(classname);
                try {
                    File sourceroot = DefaultGlobalModel.this.getSourceRoot(packagename, f);
                    if (!los.contains(sourceroot)) {
                        los.add(sourceroot);
                    }
                    lof.add(f);
                }
                catch (InvalidPackageException e) {}
            }
            String[] exts = new String[]{".java", ".dj0", ".dj1", ".dj2"};
            List<OpenDefinitionsDocument> lod = DefaultGlobalModel.this.getOpenDefinitionsDocuments();
            Iterator<OpenDefinitionsDocument> i$2 = lod.iterator();
            while (i$2.hasNext()) {
                OpenDefinitionsDocument d = i$2.next();
                if (!d.isAuxiliaryFile()) continue;
                try {
                    File f;
                    File sourceRoot = d.getSourceRoot();
                    try {
                        f = d.getFile();
                        String[] arr$ = exts;
                        int len$ = arr$.length;
                        for (int i$3 = 0; i$3 < len$; ++i$3) {
                            String ext = arr$[i$3];
                            if (!f.getName().endsWith(ext)) continue;
                            lof.add(f);
                            los.add(sourceRoot);
                        }
                    }
                    catch (FileMovedException fme) {
                        f = fme.getFile();
                        lof.add(f);
                        los.add(sourceRoot);
                    }
                    catch (IllegalStateException e) {
                    }
                }
                catch (InvalidPackageException e) {}
            }
            DefaultGlobalModel.this.getCompilerModel().compileAll(los, lof);
        }

        public void junitAll() {
            File dir = this.getProjectFile().getParentFile();
            ArrayList<File> files = FileOps.getFilesInDir(dir, true, new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.isDirectory() || pathname.getPath().toLowerCase().endsWith(".java") || pathname.getPath().toLowerCase().endsWith(".dj0") || pathname.getPath().toLowerCase().endsWith(".dj1") || pathname.getPath().toLowerCase().endsWith(".dj2");
                }
            });
            LinkedList<String> los = new LinkedList<String>();
            LinkedList<File> lof = new LinkedList<File>();
            Iterator<File> i$ = files.iterator();
            while (i$.hasNext()) {
                File f = i$.next();
                ClassAndInterfaceFinder finder = new ClassAndInterfaceFinder(f);
                String classname = finder.getClassName();
                if (classname.length() <= 0) continue;
                los.add(classname);
                lof.add(f);
            }
            List<OpenDefinitionsDocument> lod = DefaultGlobalModel.this.getOpenDefinitionsDocuments();
            Iterator<OpenDefinitionsDocument> i$2 = lod.iterator();
            while (i$2.hasNext()) {
                OpenDefinitionsDocument d = i$2.next();
                if (!d.isAuxiliaryFile()) continue;
                try {
                    File f;
                    String classname = d.getQualifiedClassName();
                    try {
                        f = d.getFile();
                        lof.add(f);
                        los.add(classname);
                    }
                    catch (FileMovedException fme) {
                        f = fme.getFile();
                        lof.add(f);
                        los.add(classname);
                    }
                    catch (IllegalStateException e) {
                    }
                }
                catch (ClassNameNotFoundException e) {}
            }
            DefaultGlobalModel.this.getJUnitModel().junitClasses(los, lof);
        }

        public void jarAll() {
        }
    }
}

