/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.model.AlreadyOpenException;
import edu.rice.cs.drjava.model.DocumentClosedException;
import edu.rice.cs.drjava.model.FileGroupingState;
import edu.rice.cs.drjava.model.FileMovedException;
import edu.rice.cs.drjava.model.FileOpenSelector;
import edu.rice.cs.drjava.model.FileSaveSelector;
import edu.rice.cs.drjava.model.FinalizationListener;
import edu.rice.cs.drjava.model.GlobalEventNotifier;
import edu.rice.cs.drjava.model.GlobalModelListener;
import edu.rice.cs.drjava.model.GlobalModelNaming;
import edu.rice.cs.drjava.model.JavadocModel;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.OperationCanceledException;
import edu.rice.cs.drjava.model.SingleDisplayModel;
import edu.rice.cs.drjava.model.cache.DCacheAdapter;
import edu.rice.cs.drjava.model.cache.DDReconstructor;
import edu.rice.cs.drjava.model.cache.DocumentCache;
import edu.rice.cs.drjava.model.compiler.CompilerModel;
import edu.rice.cs.drjava.model.debug.Breakpoint;
import edu.rice.cs.drjava.model.debug.Debugger;
import edu.rice.cs.drjava.model.definitions.ClassNameNotFoundException;
import edu.rice.cs.drjava.model.definitions.CompoundUndoManager;
import edu.rice.cs.drjava.model.definitions.DefinitionsDocument;
import edu.rice.cs.drjava.model.definitions.DefinitionsEditorKit;
import edu.rice.cs.drjava.model.definitions.DocumentUIListener;
import edu.rice.cs.drjava.model.definitions.InvalidPackageException;
import edu.rice.cs.drjava.model.definitions.reducedmodel.HighlightStatus;
import edu.rice.cs.drjava.model.definitions.reducedmodel.IndentInfo;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelState;
import edu.rice.cs.drjava.model.junit.JUnitModel;
import edu.rice.cs.drjava.model.print.DrJavaBook;
import edu.rice.cs.drjava.model.repl.ConsoleDocument;
import edu.rice.cs.drjava.model.repl.DefaultInteractionsModel;
import edu.rice.cs.drjava.model.repl.InputListener;
import edu.rice.cs.drjava.model.repl.InteractionsDocument;
import edu.rice.cs.drjava.model.repl.InteractionsDocumentAdapter;
import edu.rice.cs.drjava.model.repl.InteractionsScriptModel;
import edu.rice.cs.drjava.project.DocFile;
import edu.rice.cs.drjava.project.DocumentInfoGetter;
import edu.rice.cs.drjava.project.MalformedProjectFileException;
import edu.rice.cs.drjava.project.ProjectFileBuilder;
import edu.rice.cs.drjava.project.ProjectFileIR;
import edu.rice.cs.drjava.project.ProjectFileParser;
import edu.rice.cs.util.ClasspathVector;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.OrderedHashSet;
import edu.rice.cs.util.Pair;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.docnavigation.AWTContainerNavigatorFactory;
import edu.rice.cs.util.docnavigation.IDocumentNavigator;
import edu.rice.cs.util.docnavigation.INavigationListener;
import edu.rice.cs.util.docnavigation.INavigatorItem;
import edu.rice.cs.util.docnavigation.INavigatorItemFilter;
import edu.rice.cs.util.docnavigation.JTreeSortNavigator;
import edu.rice.cs.util.docnavigation.NodeData;
import edu.rice.cs.util.docnavigation.NodeDataVisitor;
import edu.rice.cs.util.swing.DocumentIterator;
import edu.rice.cs.util.swing.Utilities;
import edu.rice.cs.util.text.AbstractDocumentInterface;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.ProgressMonitor;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.Style;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractGlobalModel
implements SingleDisplayModel,
OptionConstants,
DocumentIterator {
    protected DocumentCache _cache;
    static final String DOCUMENT_OUT_OF_SYNC_MSG = "Current document is out of sync with the Interactions Pane and should be recompiled!\n";
    static final String CLASSPATH_OUT_OF_SYNC_MSG = "Interactions Pane is out of sync with the current classpath and should be reset!\n";
    protected LinkedList<File> _auxiliaryFiles = new LinkedList();
    final GlobalEventNotifier _notifier = new GlobalEventNotifier();
    protected final DefinitionsEditorKit _editorKit = new DefinitionsEditorKit(this._notifier);
    protected final OrderedHashSet<OpenDefinitionsDocument> _documentsRepos = new OrderedHashSet();
    protected final ConsoleDocument _consoleDoc;
    protected final InteractionsDocumentAdapter _consoleDocAdapter;
    protected boolean _isClosingAllDocs;
    private final Object _systemWriterLock = new Object();
    public static final int WRITE_DELAY = 5;
    protected PageFormat _pageFormat = new PageFormat();
    private InputListener _inputListener;
    private OpenDefinitionsDocument _activeDocument;
    private File _activeDirectory;
    protected IDocumentNavigator _documentNavigator = AWTContainerNavigatorFactory.Singleton.makeListNavigator();
    protected FileGroupingState _state;
    private static int ID_COUNTER = 0;
    static /* synthetic */ Class class$edu$rice$cs$drjava$model$AbstractGlobalModel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAuxiliaryFile(OpenDefinitionsDocument doc) {
        if (!doc.inProject()) {
            File f;
            try {
                f = doc.getFile();
            }
            catch (FileMovedException fme) {
                f = fme.getFile();
            }
            LinkedList<File> linkedList = this._auxiliaryFiles;
            synchronized (linkedList) {
                this._auxiliaryFiles.add(f);
            }
            this.setProjectChanged(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAuxiliaryFile(OpenDefinitionsDocument doc) {
        File file;
        try {
            file = doc.getFile();
        }
        catch (FileMovedException fme) {
            file = fme.getFile();
        }
        String path = "";
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new UnexpectedException(e);
        }
        LinkedList<File> linkedList = this._auxiliaryFiles;
        synchronized (linkedList) {
            ListIterator it = this._auxiliaryFiles.listIterator();
            while (it.hasNext()) {
                try {
                    if (!((File)it.next()).getCanonicalPath().equals(path)) continue;
                    it.remove();
                    this.setProjectChanged(true);
                    break;
                }
                catch (IOException e) {
                }
            }
        }
    }

    public AbstractGlobalModel() {
        this._cache = new DocumentCache();
        this._consoleDocAdapter = new InteractionsDocumentAdapter();
        this._consoleDoc = new ConsoleDocument(this._consoleDocAdapter);
        this._registerOptionListeners();
        this.setFileGroupingState(this.makeFlatFileGroupingState());
        this._notifier.projectRunnableChanged();
        this._init();
    }

    private void _init() {
        final NodeDataVisitor<Boolean> _gainVisitor = new NodeDataVisitor<Boolean>(){

            @Override
            public Boolean itemCase(INavigatorItem docu) {
                AbstractGlobalModel.this._setActiveDoc(docu);
                File dir = AbstractGlobalModel.this._activeDocument.getParentDirectory();
                if (dir != null) {
                    AbstractGlobalModel.this._activeDirectory = dir;
                    AbstractGlobalModel.this._notifier.currentDirectoryChanged(AbstractGlobalModel.this._activeDirectory);
                }
                return true;
            }

            @Override
            public Boolean fileCase(File f) {
                if (!f.isAbsolute()) {
                    File root = AbstractGlobalModel.this._state.getProjectFile().getParentFile().getAbsoluteFile();
                    f = new File(root, f.getPath());
                }
                AbstractGlobalModel.this._activeDirectory = f;
                AbstractGlobalModel.this._notifier.currentDirectoryChanged(f);
                return true;
            }

            @Override
            public Boolean stringCase(String s) {
                return false;
            }

            @Override
            public /* synthetic */ Object itemCase(INavigatorItem x0) {
                return this.itemCase(x0);
            }

            @Override
            public /* synthetic */ Object stringCase(String x0) {
                return this.stringCase(x0);
            }

            @Override
            public /* synthetic */ Object fileCase(File x0) {
                return this.fileCase(x0);
            }
        };
        this._documentNavigator.addNavigationListener(new INavigationListener(){

            public void gainedSelection(NodeData dat) {
                dat.execute(_gainVisitor);
            }

            public void lostSelection(NodeData dat) {
            }
        });
        this._isClosingAllDocs = false;
        this._ensureNotEmpty();
        this.setActiveFirstDocument();
    }

    protected File getSourceRoot(String packageName, File sourceFile) throws InvalidPackageException {
        if (packageName.equals("")) {
            return sourceFile.getParentFile();
        }
        ArrayList<String> packageStack = new ArrayList<String>();
        int dotIndex = packageName.indexOf(46);
        int curPartBegins = 0;
        while (dotIndex != -1) {
            packageStack.add(packageName.substring(curPartBegins, dotIndex));
            curPartBegins = dotIndex + 1;
            dotIndex = packageName.indexOf(46, dotIndex + 1);
        }
        packageStack.add(packageName.substring(curPartBegins));
        try {
            File parentDir = sourceFile.getCanonicalFile();
            while (!packageStack.isEmpty()) {
                String part = (String)AbstractGlobalModel.pop(packageStack);
                if ((parentDir = parentDir.getParentFile()) == null) {
                    throw new RuntimeException("parent dir is null?!");
                }
                if (part.equals(parentDir.getName())) continue;
                String msg = new StringBuffer().append("The source file ").append(sourceFile.getAbsolutePath()).append(" is in the wrong directory or in the wrong package. ").append("The directory name ").append(parentDir.getName()).append(" does not match the package component ").append(part).append(".").toString();
                throw new InvalidPackageException(-1, msg);
            }
            if ((parentDir = parentDir.getParentFile()) == null) {
                throw new RuntimeException("parent dir of first component is null?!");
            }
            return parentDir;
        }
        catch (IOException ioe) {
            String msg = new StringBuffer().append("Could not locate directory of the source file: ").append(ioe).toString();
            throw new InvalidPackageException(-1, msg);
        }
    }

    @Override
    public void compileAll() throws IOException {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support compilation");
    }

    public void setFileGroupingState(FileGroupingState state) {
        this._state = state;
        this._notifier.projectRunnableChanged();
        this._notifier.projectBuildDirChanged();
        this._notifier.projectModified();
    }

    @Override
    public FileGroupingState getFileGroupingState() {
        return this._state;
    }

    protected FileGroupingState makeProjectFileGroupingState(File main, File dir, File project, File[] files, ClasspathVector cp) {
        return new ProjectFileGroupingState(main, dir, project, files, cp);
    }

    @Override
    public void setProjectChanged(boolean changed) {
        this._state.setProjectChanged(changed);
        this._notifier.projectModified();
    }

    @Override
    public boolean isProjectChanged() {
        return this._state.isProjectChanged();
    }

    @Override
    public boolean isProjectActive() {
        return this._state.isProjectActive();
    }

    @Override
    public File getProjectFile() {
        return this._state.getProjectFile();
    }

    @Override
    public File[] getProjectFiles() {
        return this._state.getProjectFiles();
    }

    @Override
    public boolean inProject(File f) {
        return this._state.inProject(f);
    }

    @Override
    public boolean isInProjectPath(OpenDefinitionsDocument doc) {
        return this._state.isInProjectPath(doc);
    }

    @Override
    public void setMainClass(File f) {
        this._state.setMainClass(f);
        this._notifier.projectRunnableChanged();
        this.setProjectChanged(true);
    }

    @Override
    public File getMainClass() {
        return this._state.getMainClass();
    }

    @Override
    public void junitAll() {
        throw new UnsupportedOperationException("AbstractGlobalDocument does not support unit testing");
    }

    @Override
    public void setBuildDirectory(File f) {
        this._state.setBuildDirectory(f);
        if (f != null) {
            throw new UnsupportedOperationException("Cannot create new build directory without an interpreter");
        }
        this._notifier.projectBuildDirChanged();
        this.setProjectChanged(true);
    }

    @Override
    public File getBuildDirectory() {
        return this._state.getBuildDirectory();
    }

    @Override
    public void cleanBuildDirectory() throws FileMovedException, IOException {
        this._state.cleanBuildDirectory();
    }

    protected static String getPackageName(String classname) {
        int index = classname.lastIndexOf(".");
        if (index != -1) {
            return classname.substring(0, index);
        }
        return "";
    }

    protected FileGroupingState makeFlatFileGroupingState() {
        return new FlatFileGroupingState();
    }

    @Override
    public String getSourceBinTitle() {
        return "[ Source Files ]";
    }

    @Override
    public String getExternalBinTitle() {
        return "[ External Files ]";
    }

    @Override
    public String getAuxiliaryBinTitle() {
        return "[ Included External Files ]";
    }

    @Override
    public void addListener(GlobalModelListener listener) {
        this._notifier.addListener(listener);
    }

    @Override
    public void removeListener(GlobalModelListener listener) {
        this._notifier.removeListener(listener);
    }

    @Override
    public DefinitionsEditorKit getEditorKit() {
        return this._editorKit;
    }

    @Override
    public DefaultInteractionsModel getInteractionsModel() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interaction");
    }

    @Override
    public InteractionsDocumentAdapter getSwingInteractionsDocument() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interaction");
    }

    @Override
    public InteractionsDocument getInteractionsDocument() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interaction");
    }

    @Override
    public ConsoleDocument getConsoleDocument() {
        return this._consoleDoc;
    }

    @Override
    public InteractionsDocumentAdapter getSwingConsoleDocument() {
        return this._consoleDocAdapter;
    }

    @Override
    public PageFormat getPageFormat() {
        return this._pageFormat;
    }

    @Override
    public void setPageFormat(PageFormat format) {
        this._pageFormat = format;
    }

    @Override
    public CompilerModel getCompilerModel() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support compilation");
    }

    @Override
    public JUnitModel getJUnitModel() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support unit testing");
    }

    @Override
    public JavadocModel getJavadocModel() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support javadoc");
    }

    @Override
    public IDocumentNavigator getDocumentNavigator() {
        return this._documentNavigator;
    }

    @Override
    public void setDocumentNavigator(IDocumentNavigator newnav) {
        this._documentNavigator = newnav;
    }

    public OpenDefinitionsDocument newFile(File parentDir) {
        ConcreteOpenDefDoc doc = this._createOpenDefinitionsDocument();
        doc.setParentDirectory(parentDir);
        doc.setFile(null);
        this.addDocToNavigator(doc);
        this._notifier.newFileCreated(doc);
        return doc;
    }

    @Override
    public OpenDefinitionsDocument newFile() {
        OpenDefinitionsDocument doc = this.newFile(this._activeDirectory);
        this.setActiveDocument(doc);
        return doc;
    }

    @Override
    public OpenDefinitionsDocument newTestCase(String name, boolean makeSetUp, boolean makeTearDown) {
        boolean elementary = DrJava.getConfig().getSetting(LANGUAGE_LEVEL) == 1;
        StringBuffer buf = new StringBuffer();
        if (!elementary) {
            buf.append("import junit.framework.TestCase;\n\n");
        }
        buf.append("/**\n");
        buf.append("* A JUnit test case class.\n");
        buf.append("* Every method starting with the word \"test\" will be called when running\n");
        buf.append("* the test with JUnit.\n");
        buf.append("*/\n");
        if (!elementary) {
            buf.append("public ");
        }
        buf.append("class ");
        buf.append(name);
        buf.append(" extends TestCase {\n\n");
        if (makeSetUp) {
            buf.append("/**\n");
            buf.append("* This method is called before each test method, to perform any common\n");
            buf.append("* setup if necessary.\n");
            buf.append("*/\n");
            if (!elementary) {
                buf.append("public ");
            }
            buf.append("void setUp() {\n}\n\n");
        }
        if (makeTearDown) {
            buf.append("/**\n");
            buf.append("* This method is called after each test method, to perform any common\n");
            buf.append("* clean-up if necessary.\n");
            buf.append("*/\n");
            if (!elementary) {
                buf.append("public ");
            }
            buf.append("void tearDown() {\n}\n\n");
        }
        buf.append("/**\n");
        buf.append("* A test method.\n");
        buf.append("* (Replace \"X\" with a name describing the test.  You may write as\n");
        buf.append("* many \"testSomething\" methods in this class as you wish, and each\n");
        buf.append("* one will be called when running JUnit over this class.)\n");
        buf.append("*/\n");
        if (!elementary) {
            buf.append("public ");
        }
        buf.append("void testX() {\n}\n\n");
        buf.append("}\n");
        String test = buf.toString();
        OpenDefinitionsDocument openDoc = this.newFile();
        try {
            openDoc.insertString(0, test, null);
            openDoc.indentLines(0, test.length());
        }
        catch (BadLocationException ble) {
            throw new UnexpectedException(ble);
        }
        return openDoc;
    }

    public DocumentCache getDocumentCache() {
        return this._cache;
    }

    @Override
    public OpenDefinitionsDocument openFile(FileOpenSelector com) throws IOException, OperationCanceledException, AlreadyOpenException {
        boolean closeUntitled = this._hasOneEmptyDocument();
        OpenDefinitionsDocument oldDoc = this._activeDocument;
        OpenDefinitionsDocument openedDoc = this.openFileHelper(com);
        if (closeUntitled) {
            this.closeFileHelper(oldDoc);
        }
        this.setActiveDocument(openedDoc);
        this.setProjectChanged(true);
        return openedDoc;
    }

    protected OpenDefinitionsDocument openFileHelper(FileOpenSelector com) throws IOException, OperationCanceledException, AlreadyOpenException {
        File file = com.getFiles()[0].getCanonicalFile();
        OpenDefinitionsDocument odd = this._openFile(file);
        try {
            File classpath = odd.getSourceRoot();
            if (odd.inProject() || odd.isAuxiliaryFile()) {
                throw new UnsupportedOperationException("Cannot add new project files to classPath");
            }
        }
        catch (InvalidPackageException e) {
            // empty catch block
        }
        return odd;
    }

    @Override
    public OpenDefinitionsDocument openFiles(FileOpenSelector com) throws IOException, OperationCanceledException, AlreadyOpenException {
        boolean closeUntitled = this._hasOneEmptyDocument();
        OpenDefinitionsDocument oldDoc = this._activeDocument;
        OpenDefinitionsDocument openedDoc = this.openFilesHelper(com);
        if (closeUntitled) {
            this.closeFileHelper(oldDoc);
        }
        this.setActiveDocument(openedDoc);
        return openedDoc;
    }

    protected OpenDefinitionsDocument openFilesHelper(FileOpenSelector com) throws IOException, OperationCanceledException, AlreadyOpenException {
        File[] files = com.getFiles();
        if (files == null) {
            throw new IOException("No Files returned from FileSelector");
        }
        OpenDefinitionsDocument doc = this._openFiles(files);
        return doc;
    }

    private OpenDefinitionsDocument _openFiles(File[] files) throws IOException, OperationCanceledException, AlreadyOpenException {
        AlreadyOpenException storedAOE = null;
        OpenDefinitionsDocument retDoc = null;
        LinkedList<File> filesNotFound = new LinkedList<File>();
        LinkedList<OpenDefinitionsDocument> filesOpened = new LinkedList<OpenDefinitionsDocument>();
        for (File f : files) {
            if (f == null) {
                throw new IOException("File name returned from FileSelector is null");
            }
            try {
                retDoc = this._rawOpenFile(f.getAbsoluteFile());
                filesOpened.add(retDoc);
            }
            catch (AlreadyOpenException aoe) {
                retDoc = aoe.getOpenDocument();
                if (storedAOE != null) continue;
                storedAOE = aoe;
            }
            catch (FileNotFoundException e) {
                filesNotFound.add(f);
            }
        }
        for (OpenDefinitionsDocument d : filesOpened) {
            this.addDocToNavigator(d);
            this.addDocToClasspath(d);
            this._notifier.fileOpened(d);
        }
        for (File f : filesNotFound) {
            this._notifier.fileNotFound(f);
        }
        if (storedAOE != null) {
            throw storedAOE;
        }
        if (retDoc != null) {
            return retDoc;
        }
        throw new OperationCanceledException();
    }

    @Override
    public void openFolder(File dir, boolean rec) throws IOException, OperationCanceledException, AlreadyOpenException {
        if (dir == null) {
            return;
        }
        if (dir.isDirectory()) {
            ArrayList<File> files = FileOps.getFilesInDir(dir, rec, new FileFilter(){

                public boolean accept(File f) {
                    return f.isDirectory() || f.isFile() && f.getName().endsWith(DrJava.LANGUAGE_LEVEL_EXTENSIONS[DrJava.getConfig().getSetting(OptionConstants.LANGUAGE_LEVEL)]);
                }
            });
            if (this.isProjectActive()) {
                Collections.sort(files, new Comparator<File>(){

                    @Override
                    public int compare(File o1, File o2) {
                        return -o1.getAbsolutePath().compareTo(o2.getAbsolutePath());
                    }

                    @Override
                    public /* synthetic */ int compare(Object x0, Object x1) {
                        return this.compare((File)x0, (File)x1);
                    }
                });
            } else {
                Collections.sort(files, new Comparator<File>(){

                    @Override
                    public int compare(File o1, File o2) {
                        return -o1.getName().compareTo(o2.getName());
                    }

                    @Override
                    public /* synthetic */ int compare(Object x0, Object x1) {
                        return this.compare((File)x0, (File)x1);
                    }
                });
            }
            int ct = files.size();
            final File[] sfiles = files.toArray(new File[ct]);
            this.openFiles(new FileOpenSelector(){

                public File[] getFiles() {
                    return sfiles;
                }
            });
            if (ct > 0 && this._state.isInProjectPath(dir)) {
                this.setProjectChanged(true);
            }
        }
    }

    @Override
    public void saveAllFiles(FileSaveSelector com) throws IOException {
        OpenDefinitionsDocument curdoc = this.getActiveDocument();
        this.saveAllFilesHelper(com);
        this.setActiveDocument(curdoc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveAllFilesHelper(FileSaveSelector com) throws IOException {
        OpenDefinitionsDocument[] docs;
        boolean isProjActive = this.isProjectActive();
        OrderedHashSet<OpenDefinitionsDocument> orderedHashSet = this._documentsRepos;
        synchronized (orderedHashSet) {
            docs = this._documentsRepos.toArray(new OpenDefinitionsDocument[0]);
        }
        for (OpenDefinitionsDocument doc : docs) {
            if (doc.isUntitled() && isProjActive) continue;
            this.aboutToSaveFromSaveAll(doc);
            doc.saveFile(com);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveProject(String filename, Hashtable<OpenDefinitionsDocument, DocumentInfoGetter> info) throws IOException {
        File mainClass;
        File d;
        ClasspathVector exCp;
        OpenDefinitionsDocument[] docs;
        ProjectFileBuilder builder = new ProjectFileBuilder(filename);
        ArrayList<File> srcFileList = new ArrayList<File>();
        LinkedList<File> auxFileList = new LinkedList<File>();
        OrderedHashSet<OpenDefinitionsDocument> orderedHashSet = this._documentsRepos;
        synchronized (orderedHashSet) {
            docs = this._documentsRepos.toArray(new OpenDefinitionsDocument[0]);
        }
        for (OpenDefinitionsDocument doc : docs) {
            DocumentInfoGetter g;
            if (doc.isUntitled()) continue;
            String projectPath = new StringBuffer().append(new File(filename).getParentFile().getCanonicalPath()).append(File.separator).toString();
            String filePath = new StringBuffer().append(doc.getFile().getParentFile().getCanonicalPath()).append(File.separator).toString();
            if (filePath.startsWith(projectPath)) {
                g = info.get(doc);
                builder.addSourceFile(g);
                srcFileList.add(g.getFile());
                continue;
            }
            if (!doc.isAuxiliaryFile()) continue;
            g = info.get(doc);
            builder.addAuxiliaryFile(g);
            auxFileList.add(g.getFile());
        }
        if (this._documentNavigator instanceof JTreeSortNavigator) {
            String[] paths;
            for (String s : paths = ((JTreeSortNavigator)this._documentNavigator).getCollapsedPaths()) {
                builder.addCollapsedPath(s);
            }
        }
        if ((exCp = this.getProjectExtraClasspath()) != null) {
            Vector<File> exCpF = exCp.asFileVector();
            for (File f : exCpF) {
                builder.addClasspathFile(f);
            }
        }
        if ((d = this.getBuildDirectory()) != null) {
            builder.setBuildDirectory(d);
        }
        if ((mainClass = this.getMainClass()) != null) {
            builder.setMainClass(mainClass);
        }
        builder.write();
        File[] srcFiles = srcFileList.toArray(new File[srcFileList.size()]);
        LinkedList<File> linkedList = this._auxiliaryFiles;
        synchronized (linkedList) {
            this._auxiliaryFiles = auxFileList;
        }
        this.setFileGroupingState(this.makeProjectFileGroupingState(mainClass, d, new File(filename), srcFiles, exCp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File[] openProject(File projectFile) throws IOException, MalformedProjectFileException {
        File file;
        File f;
        int i$;
        ProjectFileIR ir = ProjectFileParser.ONLY.parse(projectFile);
        File[] srcFiles = ir.getSourceFiles();
        DocFile[] auxFiles = ir.getAuxiliaryFiles();
        File buildDir = ir.getBuildDirectory();
        File mainClass = ir.getMainClass();
        File[] projectClasspaths = ir.getClasspaths();
        String projfilepath = projectFile.getCanonicalPath();
        List<OpenDefinitionsDocument> oldProjDocs = this.getProjectDocuments();
        final FileGroupingState oldState = this._state;
        LinkedList<Pair<String, INavigatorItemFilter>> l = new LinkedList<Pair<String, INavigatorItemFilter>>();
        l.add(new Pair<String, 7>(this.getSourceBinTitle(), new INavigatorItemFilter(){

            public boolean accept(INavigatorItem n) {
                OpenDefinitionsDocument d = (OpenDefinitionsDocument)n;
                return d.isInProjectPath();
            }
        }));
        l.add(new Pair<String, 8>(this.getAuxiliaryBinTitle(), new INavigatorItemFilter(){

            public boolean accept(INavigatorItem n) {
                OpenDefinitionsDocument d = (OpenDefinitionsDocument)n;
                return d.isAuxiliaryFile();
            }
        }));
        l.add(new Pair<String, 9>(this.getExternalBinTitle(), new INavigatorItemFilter(){

            public boolean accept(INavigatorItem n) {
                OpenDefinitionsDocument d = (OpenDefinitionsDocument)n;
                return !d.inProject() && !d.isAuxiliaryFile() || d.isUntitled();
            }
        }));
        IDocumentNavigator newNav = AWTContainerNavigatorFactory.Singleton.makeTreeNavigator(projfilepath, this.getDocumentNavigator(), l);
        this.setDocumentNavigator(newNav);
        LinkedList<File> linkedList = this._auxiliaryFiles;
        synchronized (linkedList) {
            this._auxiliaryFiles.clear();
            for (DocFile file2 : auxFiles) {
                this._auxiliaryFiles.add(file2);
            }
        }
        ClasspathVector extraClasspaths = new ClasspathVector();
        for (File f2 : projectClasspaths) {
            extraClasspaths.add(f2);
        }
        this.setFileGroupingState(this.makeProjectFileGroupingState(mainClass, buildDir, projectFile, srcFiles, extraClasspaths));
        ArrayList<File> projFiles = new ArrayList<File>();
        File active = null;
        File[] arr$ = srcFiles;
        int len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            file = f = arr$[i$];
            if (f.lastModified() > ((DocFile)f).getSavedModDate()) {
                file = new File(f.getPath());
            }
            if (((DocFile)f).isActive() && active == null) {
                active = file;
                continue;
            }
            projFiles.add(file);
        }
        arr$ = auxFiles;
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            file = f = arr$[i$];
            if (f.lastModified() > ((DocFile)f).getSavedModDate()) {
                file = new File(f.getPath());
            }
            if (((DocFile)f).isActive() && active == null) {
                active = file;
                continue;
            }
            projFiles.add(file);
        }
        if (active != null) {
            projFiles.add(active);
        }
        final List<OpenDefinitionsDocument> projDocs = this.getProjectDocuments();
        Utilities.invokeAndWait(new Runnable(){

            public void run() {
                Iterator i$ = projDocs.iterator();
                while (i$.hasNext()) {
                    OpenDefinitionsDocument d = (OpenDefinitionsDocument)i$.next();
                    if (oldState.inProject(d.file())) {
                        AbstractGlobalModel.this.closeFile(d);
                        continue;
                    }
                    try {
                        OpenDefinitionsDocument idoc = d;
                        String path = AbstractGlobalModel.this.fixPathForNavigator(d.getFile().getCanonicalPath());
                        AbstractGlobalModel.this._documentNavigator.refreshDocument(idoc, path);
                    }
                    catch (IOException iOException) {}
                }
            }
        });
        final File[] filesToOpen = projFiles.toArray(new File[projFiles.size()]);
        this._notifier.projectOpened(projectFile, new FileOpenSelector(){

            public File[] getFiles() {
                return filesToOpen;
            }
        });
        if (this._documentNavigator instanceof JTreeSortNavigator) {
            ((JTreeSortNavigator)this._documentNavigator).collapsePaths(ir.getCollapsedPaths());
        }
        return srcFiles;
    }

    @Override
    public void closeProject() {
        this.setDocumentNavigator(AWTContainerNavigatorFactory.Singleton.makeListNavigator(this.getDocumentNavigator()));
        this.setFileGroupingState(this.makeFlatFileGroupingState());
        this.resetInteractions();
        this._notifier.projectClosed();
    }

    public void aboutToSaveFromSaveAll(OpenDefinitionsDocument doc) {
        if (doc.isUntitled()) {
            this.setActiveDocument(doc);
        }
    }

    @Override
    public boolean closeFile(OpenDefinitionsDocument doc) {
        LinkedList<OpenDefinitionsDocument> list = new LinkedList<OpenDefinitionsDocument>();
        list.add(doc);
        return this.closeFiles(list);
    }

    @Override
    public boolean closeAllFiles() {
        List<OpenDefinitionsDocument> docs = this.getOpenDefinitionsDocuments();
        return this.closeFiles(docs);
    }

    @Override
    public boolean closeFiles(List<OpenDefinitionsDocument> docList) {
        if (docList.size() == 0) {
            return true;
        }
        for (OpenDefinitionsDocument doc : docList) {
            if (doc.canAbandonFile()) continue;
            return false;
        }
        OpenDefinitionsDocument newDoc = null;
        if (docList.size() == this.getOpenDefinitionsDocumentsSize()) {
            newDoc = this.newFile();
        }
        this._ensureNotActive(docList);
        for (OpenDefinitionsDocument doc : docList) {
            this.closeFileWithoutPrompt(doc);
        }
        return true;
    }

    protected boolean closeFileHelper(OpenDefinitionsDocument doc) {
        boolean canClose = doc.canAbandonFile();
        if (canClose) {
            return this.closeFileWithoutPrompt(doc);
        }
        return false;
    }

    protected void closeFileOnQuitHelper(OpenDefinitionsDocument doc) {
        doc.quitFile();
        this.closeFileWithoutPrompt(doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean closeFileWithoutPrompt(final OpenDefinitionsDocument doc) {
        boolean found;
        OrderedHashSet<OpenDefinitionsDocument> orderedHashSet = this._documentsRepos;
        synchronized (orderedHashSet) {
            found = this._documentsRepos.remove(doc);
        }
        if (!found) {
            return false;
        }
        Utilities.invokeLater(new Runnable(){

            public void run() {
                AbstractGlobalModel.this._documentNavigator.removeDocument(doc);
            }
        });
        this._notifier.fileClosed(doc);
        doc.close();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllFilesOnQuit() {
        OpenDefinitionsDocument[] docs;
        OrderedHashSet<OpenDefinitionsDocument> orderedHashSet = this._documentsRepos;
        synchronized (orderedHashSet) {
            docs = this._documentsRepos.toArray(new OpenDefinitionsDocument[0]);
        }
        for (OpenDefinitionsDocument doc : docs) {
            this.closeFileOnQuitHelper(doc);
        }
    }

    @Override
    public void quit() {
        this.closeAllFilesOnQuit();
        this.dispose();
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this._notifier.removeAllListeners();
        OrderedHashSet<OpenDefinitionsDocument> orderedHashSet = this._documentsRepos;
        synchronized (orderedHashSet) {
            this._documentsRepos.clear();
        }
        Utilities.invokeAndWait(new Runnable(){

            public void run() {
                AbstractGlobalModel.this._documentNavigator.clear();
            }
        });
    }

    @Override
    public OpenDefinitionsDocument getDocumentForFile(File file) throws IOException {
        OpenDefinitionsDocument doc = this._getOpenDocument(file);
        if (doc == null) {
            final File f = file;
            FileOpenSelector selector = new FileOpenSelector(){

                public File[] getFiles() {
                    return new File[]{f};
                }
            };
            try {
                doc = this.openFile(selector);
            }
            catch (AlreadyOpenException e) {
                doc = e.getOpenDocument();
            }
            catch (OperationCanceledException e) {
                throw new UnexpectedException(e);
            }
        }
        return doc;
    }

    @Override
    public boolean isAlreadyOpen(File file) {
        return this._getOpenDocument(file) != null;
    }

    @Override
    public OpenDefinitionsDocument getODDForDocument(AbstractDocumentInterface doc) {
        if (doc instanceof OpenDefinitionsDocument) {
            return (OpenDefinitionsDocument)doc;
        }
        if (doc instanceof DefinitionsDocument) {
            return ((DefinitionsDocument)doc).getOpenDefDoc();
        }
        throw new IllegalStateException(new StringBuffer().append("Could not get the OpenDefinitionsDocument for Document: ").append(doc).toString());
    }

    @Override
    public DocumentIterator getDocumentIterator() {
        return this;
    }

    @Override
    public OpenDefinitionsDocument getNextDocument(AbstractDocumentInterface d) {
        OpenDefinitionsDocument nextdoc = null;
        OpenDefinitionsDocument doc = this.getODDForDocument(d);
        nextdoc = this._documentNavigator.getNext(doc);
        if (nextdoc == doc) {
            nextdoc = (OpenDefinitionsDocument)this._documentNavigator.getFirst();
        }
        OpenDefinitionsDocument res = this.getNextDocHelper(nextdoc);
        return res;
    }

    private OpenDefinitionsDocument getNextDocHelper(OpenDefinitionsDocument nextdoc) {
        if (nextdoc.isUntitled() || nextdoc.verifyExists()) {
            return nextdoc;
        }
        return this.getNextDocument(nextdoc);
    }

    @Override
    public OpenDefinitionsDocument getPrevDocument(AbstractDocumentInterface d) {
        OpenDefinitionsDocument prevdoc = null;
        OpenDefinitionsDocument doc = this.getODDForDocument(d);
        prevdoc = this._documentNavigator.getPrevious(doc);
        if (prevdoc == doc) {
            prevdoc = (OpenDefinitionsDocument)this._documentNavigator.getLast();
        }
        return this.getPrevDocHelper(prevdoc);
    }

    private OpenDefinitionsDocument getPrevDocHelper(OpenDefinitionsDocument prevdoc) {
        if (prevdoc.isUntitled() || prevdoc.verifyExists()) {
            return prevdoc;
        }
        return this.getPrevDocument(prevdoc);
    }

    @Override
    public int getDocumentCount() {
        return this._documentsRepos.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OpenDefinitionsDocument> getOpenDefinitionsDocuments() {
        OrderedHashSet<OpenDefinitionsDocument> orderedHashSet = this._documentsRepos;
        synchronized (orderedHashSet) {
            ArrayList<OpenDefinitionsDocument> docs = new ArrayList<OpenDefinitionsDocument>(this._documentsRepos.size());
            for (OpenDefinitionsDocument doc : this._documentsRepos) {
                docs.add(doc);
            }
            return docs;
        }
    }

    public int getOpenDefinitionsDocumentsSize() {
        return this._documentsRepos.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDefinitionsIndent(int indent) {
        OpenDefinitionsDocument[] docs;
        OrderedHashSet<OpenDefinitionsDocument> orderedHashSet = this._documentsRepos;
        synchronized (orderedHashSet) {
            docs = this._documentsRepos.toArray(new OpenDefinitionsDocument[0]);
        }
        for (OpenDefinitionsDocument doc : docs) {
            doc.setIndent(indent);
        }
    }

    @Override
    public void resetInteractions() {
    }

    @Override
    public void resetConsole() {
        this._consoleDoc.reset();
        this._notifier.consoleReset();
    }

    @Override
    public void interpretCurrentInteraction() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interactions");
    }

    @Override
    public void loadHistory(FileOpenSelector selector) throws IOException {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interactions");
    }

    @Override
    public InteractionsScriptModel loadHistoryAsScript(FileOpenSelector selector) throws IOException, OperationCanceledException {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interactions");
    }

    @Override
    public void clearHistory() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interactions");
    }

    @Override
    public void saveHistory(FileSaveSelector selector) throws IOException {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interactions");
    }

    @Override
    public void saveHistory(FileSaveSelector selector, String editedVersion) throws IOException {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interactions");
    }

    @Override
    public String getHistoryAsStringWithSemicolons() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interactions");
    }

    @Override
    public String getHistoryAsString() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interactions");
    }

    private void _registerOptionListeners() {
        DrJava.getConfig().addOptionListener(BACKUP_FILES, new BackUpFileOptionListener());
        Boolean makeBackups = DrJava.getConfig().getSetting(BACKUP_FILES);
        FileOps.DefaultFileSaver.setBackupsEnabled(makeBackups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _docAppend(ConsoleDocument doc, String s, String style) {
        Object object = this._systemWriterLock;
        synchronized (object) {
            try {
                doc.insertBeforeLastPrompt(s, style);
                this._systemWriterLock.wait(5L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    @Override
    public void systemOutPrint(String s) {
        this._docAppend(this._consoleDoc, s, "System.out");
    }

    @Override
    public void systemErrPrint(String s) {
        this._docAppend(this._consoleDoc, s, "System.err");
    }

    @Override
    public void printDebugMessage(String s) {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support debugging");
    }

    @Override
    public void waitForInterpreter() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interactions");
    }

    @Override
    public ClasspathVector getClasspath() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support classPaths");
    }

    @Override
    public ClasspathVector getProjectExtraClasspath() {
        return this._state.getExtraClasspath();
    }

    @Override
    public void setProjectExtraClasspath(ClasspathVector cp) {
        this._state.setExtraClasspath(cp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File[] getSourceRootSet() {
        OpenDefinitionsDocument[] docs;
        LinkedList<File> roots = new LinkedList<File>();
        OrderedHashSet<OpenDefinitionsDocument> orderedHashSet = this._documentsRepos;
        synchronized (orderedHashSet) {
            docs = this._documentsRepos.toArray(new OpenDefinitionsDocument[0]);
        }
        for (OpenDefinitionsDocument doc : docs) {
            try {
                File root = doc.getSourceRoot();
                if (roots.contains(root)) continue;
                roots.add(root);
            }
            catch (InvalidPackageException e) {
                // empty catch block
            }
        }
        return roots.toArray(new File[roots.size()]);
    }

    @Override
    public String getDisplayFilename(OpenDefinitionsDocument doc) {
        int extIndex;
        String filename = doc.getFilename();
        if (filename.endsWith(".java") && (extIndex = filename.lastIndexOf(".java")) > 0) {
            filename = filename.substring(0, extIndex);
        }
        if (doc.isModifiedSinceSave()) {
            filename = new StringBuffer().append(filename).append("*").toString();
        }
        return filename;
    }

    @Override
    public String getDisplayFullPath(int index) {
        OpenDefinitionsDocument doc = this.getOpenDefinitionsDocuments().get(index);
        if (doc == null) {
            throw new RuntimeException(new StringBuffer().append("Document not found with index ").append(index).toString());
        }
        return GlobalModelNaming.getDisplayFullPath(doc);
    }

    @Override
    public Debugger getDebugger() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support debugging");
    }

    @Override
    public int getDebugPort() throws IOException {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support debugging");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasModifiedDocuments() {
        OpenDefinitionsDocument[] docs;
        OrderedHashSet<OpenDefinitionsDocument> orderedHashSet = this._documentsRepos;
        synchronized (orderedHashSet) {
            docs = this._documentsRepos.toArray(new OpenDefinitionsDocument[0]);
        }
        for (OpenDefinitionsDocument doc : docs) {
            if (!doc.isModifiedSinceSave()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasUntitledDocuments() {
        OpenDefinitionsDocument[] docs;
        OrderedHashSet<OpenDefinitionsDocument> orderedHashSet = this._documentsRepos;
        synchronized (orderedHashSet) {
            docs = this._documentsRepos.toArray(new OpenDefinitionsDocument[0]);
        }
        for (OpenDefinitionsDocument doc : docs) {
            if (!doc.isUntitled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public File getSourceFile(String filename) {
        File[] sourceRoots;
        for (File s : sourceRoots = this.getSourceRootSet()) {
            File f = this._getSourceFileFromPath(filename, s);
            if (f == null) continue;
            return f;
        }
        Vector sourcepath = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.DEBUG_SOURCEPATH));
        return this.getSourceFileFromPaths(filename, sourcepath);
    }

    @Override
    public File getSourceFileFromPaths(String filename, Vector<File> paths) {
        for (File p : paths) {
            File f = this._getSourceFileFromPath(filename, p);
            if (f == null) continue;
            return f;
        }
        return null;
    }

    private File _getSourceFileFromPath(String filename, File path) {
        String root = path.getAbsolutePath();
        File f = new File(new StringBuffer().append(root).append(System.getProperty("file.separator")).append(filename).toString());
        return f.exists() ? f : null;
    }

    @Override
    public void jarAll() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support jarring documents");
    }

    protected ConcreteOpenDefDoc _createOpenDefinitionsDocument() {
        return new ConcreteOpenDefDoc();
    }

    protected ConcreteOpenDefDoc _createOpenDefinitionsDocument(File f) throws IOException {
        return new ConcreteOpenDefDoc(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OpenDefinitionsDocument _getOpenDocument(File file) {
        OpenDefinitionsDocument[] docs;
        OrderedHashSet<OpenDefinitionsDocument> orderedHashSet = this._documentsRepos;
        synchronized (orderedHashSet) {
            docs = this._documentsRepos.toArray(new OpenDefinitionsDocument[0]);
        }
        for (OpenDefinitionsDocument doc : docs) {
            try {
                File thisFile = null;
                try {
                    thisFile = doc.getFile();
                    return thisFile;
                }
                catch (FileMovedException fme) {
                    thisFile = fme.getFile();
                    return thisFile;
                }
                finally {
                    if (thisFile == null) continue;
                    try {
                        if (!thisFile.getCanonicalFile().equals(file.getCanonicalFile())) continue;
                        return doc;
                    }
                    catch (IOException ioe) {
                        if (!thisFile.equals(file)) continue;
                        return doc;
                    }
                }
            }
            catch (IllegalStateException ise) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public List<OpenDefinitionsDocument> getNonProjectDocuments() {
        List<OpenDefinitionsDocument> allDocs = this.getOpenDefinitionsDocuments();
        LinkedList<OpenDefinitionsDocument> projectDocs = new LinkedList<OpenDefinitionsDocument>();
        for (OpenDefinitionsDocument tempDoc : allDocs) {
            if (tempDoc.isInProjectPath()) continue;
            projectDocs.add(tempDoc);
        }
        return projectDocs;
    }

    @Override
    public List<OpenDefinitionsDocument> getProjectDocuments() {
        List<OpenDefinitionsDocument> allDocs = this.getOpenDefinitionsDocuments();
        LinkedList<OpenDefinitionsDocument> projectDocs = new LinkedList<OpenDefinitionsDocument>();
        for (OpenDefinitionsDocument tempDoc : allDocs) {
            if (!tempDoc.isInProjectPath() && !tempDoc.isAuxiliaryFile()) continue;
            projectDocs.add(tempDoc);
        }
        return projectDocs;
    }

    @Override
    public String fixPathForNavigator(String path) throws IOException {
        String _topLevelPath;
        path = path.substring(0, path.lastIndexOf(File.separator));
        if (this.getProjectFile() != null) {
            _topLevelPath = this.getProjectFile().getCanonicalPath();
            _topLevelPath = _topLevelPath.substring(0, _topLevelPath.lastIndexOf(File.separator));
        } else {
            _topLevelPath = "";
        }
        if (!path.equals(_topLevelPath) && !path.startsWith(new StringBuffer().append(_topLevelPath).append(File.separator).toString())) {
            return "";
        }
        path = path.substring(_topLevelPath.length());
        return path;
    }

    private OpenDefinitionsDocument _rawOpenFile(File file) throws IOException, AlreadyOpenException {
        OpenDefinitionsDocument openDoc = this._getOpenDocument(file);
        if (openDoc != null) {
            throw new AlreadyOpenException(openDoc);
        }
        ConcreteOpenDefDoc doc = this._createOpenDefinitionsDocument(file);
        if (file instanceof DocFile) {
            DocFile df = (DocFile)file;
            Pair<Integer, Integer> scroll = df.getScroll();
            Pair<Integer, Integer> sel = df.getSelection();
            doc.setPackage(df.getPackage());
            doc.setInitialVScroll(scroll.getFirst());
            doc.setInitialHScroll(scroll.getSecond());
            doc.setInitialSelStart(sel.getFirst());
            doc.setInitialSelEnd(sel.getSecond());
        }
        return doc;
    }

    protected static <T> T pop(ArrayList<T> stack) {
        return stack.remove(stack.size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDocToNavigator(final OpenDefinitionsDocument doc) {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    if (doc.isUntitled()) {
                        AbstractGlobalModel.this._documentNavigator.addDocument(doc);
                    } else {
                        String path = doc.getFile().getCanonicalPath();
                        AbstractGlobalModel.this._documentNavigator.addDocument(doc, AbstractGlobalModel.this.fixPathForNavigator(path));
                    }
                }
                catch (IOException e) {
                    AbstractGlobalModel.this._documentNavigator.addDocument(doc);
                }
            }
        });
        OrderedHashSet<OpenDefinitionsDocument> orderedHashSet = this._documentsRepos;
        synchronized (orderedHashSet) {
            this._documentsRepos.add(doc);
        }
    }

    protected void addDocToClasspath(OpenDefinitionsDocument doc) {
    }

    private OpenDefinitionsDocument _openFile(File file) throws IOException, AlreadyOpenException {
        OpenDefinitionsDocument doc = this._rawOpenFile(file);
        this.addDocToNavigator(doc);
        this.addDocToClasspath(doc);
        this._notifier.fileOpened(doc);
        return doc;
    }

    @Override
    public OpenDefinitionsDocument getActiveDocument() {
        return this._activeDocument;
    }

    @Override
    public void setActiveDocument(final OpenDefinitionsDocument doc) {
        try {
            Utilities.invokeAndWait(new Runnable(){

                public void run() {
                    AbstractGlobalModel.this._documentNavigator.setActiveDoc(doc);
                }
            });
        }
        catch (Exception e) {
            throw new UnexpectedException(e);
        }
    }

    @Override
    public Container getDocCollectionWidget() {
        return this._documentNavigator.asContainer();
    }

    @Override
    public void setActiveNextDocument() {
        OpenDefinitionsDocument key = this._activeDocument;
        OpenDefinitionsDocument nextKey = this._documentNavigator.getNext(key);
        if (key != nextKey) {
            this.setActiveDocument(nextKey);
        } else {
            this.setActiveDocument((OpenDefinitionsDocument)this._documentNavigator.getFirst());
        }
    }

    @Override
    public void setActivePreviousDocument() {
        OpenDefinitionsDocument key = this._activeDocument;
        OpenDefinitionsDocument prevKey = this._documentNavigator.getPrevious(key);
        if (key != prevKey) {
            this.setActiveDocument(prevKey);
        } else {
            this.setActiveDocument((OpenDefinitionsDocument)this._documentNavigator.getLast());
        }
    }

    private boolean _hasOneEmptyDocument() {
        return this.getOpenDefinitionsDocumentsSize() == 1 && this._activeDocument.isUntitled() && !this._activeDocument.isModifiedSinceSave();
    }

    private void _ensureNotEmpty() {
        if (!this._isClosingAllDocs && this.getOpenDefinitionsDocumentsSize() == 0) {
            this.newFile(null);
        }
    }

    private void _ensureNotActive(List<OpenDefinitionsDocument> docs) {
        if (docs.contains(this.getActiveDocument())) {
            INavigatorItem item;
            IDocumentNavigator nav = this.getDocumentNavigator();
            OpenDefinitionsDocument nextActive = (OpenDefinitionsDocument)nav.getNext(item = (INavigatorItem)docs.get(docs.size() - 1));
            if (!nextActive.equals(item)) {
                this.setActiveDocument(nextActive);
                return;
            }
            item = docs.get(0);
            nextActive = (OpenDefinitionsDocument)nav.getPrevious(item);
            if (!nextActive.equals(item)) {
                this.setActiveDocument(nextActive);
                return;
            }
            throw new RuntimeException("No document to set active before closing");
        }
    }

    @Override
    public void setActiveFirstDocument() {
        List<OpenDefinitionsDocument> docs = this.getOpenDefinitionsDocuments();
        this.setActiveDocument(docs.get(0));
    }

    private synchronized void _setActiveDoc(INavigatorItem idoc) {
        this._activeDocument = (OpenDefinitionsDocument)idoc;
        this.refreshActiveDocument();
    }

    @Override
    public void refreshActiveDocument() {
        try {
            this._activeDocument.checkIfClassFileInSync();
            this._notifier.activeDocumentChanged(this._activeDocument);
        }
        catch (DocumentClosedException documentClosedException) {
            // empty catch block
        }
    }

    @Override
    public /* synthetic */ AbstractDocumentInterface getPrevDocument(AbstractDocumentInterface x0) {
        return this.getPrevDocument(x0);
    }

    @Override
    public /* synthetic */ AbstractDocumentInterface getNextDocument(AbstractDocumentInterface x0) {
        return this.getNextDocument(x0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BackUpFileOptionListener
    implements OptionListener<Boolean> {
        private BackUpFileOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Boolean> oe) {
            Boolean value = (Boolean)oe.value;
            FileOps.DefaultFileSaver.setBackupsEnabled(value);
        }
    }

    private static class TrivialFSS
    implements FileSaveSelector {
        private File _file;

        private TrivialFSS(File file) {
            this._file = file;
        }

        public File getFile() throws OperationCanceledException {
            return this._file;
        }

        public boolean warnFileOpen(File f) {
            return true;
        }

        public boolean verifyOverwrite() {
            return true;
        }

        public boolean shouldSaveAfterFileMoved(OpenDefinitionsDocument doc, File oldFile) {
            return true;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ConcreteOpenDefDoc
    implements OpenDefinitionsDocument,
    AbstractDocumentInterface {
        private int _id;
        private DrJavaBook _book;
        protected Vector<Breakpoint> _breakpoints;
        private File _file;
        private long _timestamp;
        private File _parentDir;
        protected String _packageName = null;
        private int _initVScroll;
        private int _initHScroll;
        private int _initSelStart;
        private int _initSelEnd;
        private DCacheAdapter _cacheAdapter;
        List<UndoableEditListener> _undoableEditListeners = new LinkedList<UndoableEditListener>();

        ConcreteOpenDefDoc(File f) throws IOException {
            if (!f.exists()) {
                throw new FileNotFoundException(new StringBuffer().append("file ").append(f).append(" cannot be found").toString());
            }
            this._file = f;
            this._parentDir = f.getParentFile();
            this._timestamp = f.lastModified();
            this.init();
        }

        ConcreteOpenDefDoc() {
            this._file = null;
            this._parentDir = null;
            this.init();
        }

        public void init() {
            this._id = ID_COUNTER++;
            try {
                DDReconstructor ddr = this.makeReconstructor();
                this._cacheAdapter = AbstractGlobalModel.this._cache.register(this, ddr);
            }
            catch (IllegalStateException e) {
                throw new UnexpectedException(e);
            }
            this._breakpoints = new Vector();
        }

        @Override
        public int id() {
            return this._id;
        }

        public void setParentDirectory(File pd) {
            if (this._file != null) {
                throw new IllegalArgumentException("The parent directory can only be set for untitled documents");
            }
            this._parentDir = pd;
        }

        @Override
        public File getParentDirectory() {
            return this._parentDir;
        }

        @Override
        public boolean isInProjectPath() {
            return AbstractGlobalModel.this._state.isInProjectPath(this);
        }

        @Override
        public boolean inProject() {
            return !this.isUntitled() && AbstractGlobalModel.this._state.inProject(this._file);
        }

        @Override
        public boolean isAuxiliaryFile() {
            return !this.isUntitled() && AbstractGlobalModel.this._state.isAuxiliaryFile(this._file);
        }

        protected DDReconstructor makeReconstructor() {
            return new DDReconstructor(){
                private int _loc = 0;
                private DocumentListener[] _list = new DocumentListener[0];
                private UndoableEditListener[] _undoListeners = new UndoableEditListener[0];
                private List<FinalizationListener<DefinitionsDocument>> _finalListeners = new LinkedList<FinalizationListener<DefinitionsDocument>>();
                static final /* synthetic */ boolean $assertionsDisabled;

                public DefinitionsDocument make() throws IOException, BadLocationException, FileMovedException {
                    int i$;
                    DefinitionsDocument tempDoc = new DefinitionsDocument(((ConcreteOpenDefDoc)ConcreteOpenDefDoc.this).AbstractGlobalModel.this._notifier);
                    tempDoc.setOpenDefDoc(ConcreteOpenDefDoc.this);
                    if (ConcreteOpenDefDoc.this._file != null) {
                        FileReader reader = new FileReader(ConcreteOpenDefDoc.this._file);
                        ((ConcreteOpenDefDoc)ConcreteOpenDefDoc.this).AbstractGlobalModel.this._editorKit.read(reader, (Document)tempDoc, 0);
                        reader.close();
                    }
                    this._loc = Math.min(this._loc, tempDoc.getLength());
                    this._loc = Math.max(this._loc, 0);
                    tempDoc.setCurrentLocation(this._loc);
                    EventListener[] arr$ = this._list;
                    int len$ = arr$.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        DocumentListener d = arr$[i$];
                        if (!(d instanceof DocumentUIListener)) continue;
                        tempDoc.addDocumentListener(d);
                    }
                    arr$ = this._undoListeners;
                    len$ = arr$.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        EventListener l = arr$[i$];
                        tempDoc.addUndoableEditListener((UndoableEditListener)l);
                    }
                    Iterator<FinalizationListener<DefinitionsDocument>> i$2 = this._finalListeners.iterator();
                    while (i$2.hasNext()) {
                        FinalizationListener<DefinitionsDocument> l = i$2.next();
                        tempDoc.addFinalizationListener(l);
                    }
                    tempDoc.resetModification();
                    if (!$assertionsDisabled && tempDoc.isModifiedSinceSave()) {
                        throw new AssertionError();
                    }
                    try {
                        ConcreteOpenDefDoc.this._packageName = tempDoc.getPackageName();
                    }
                    catch (InvalidPackageException e) {
                        ConcreteOpenDefDoc.this._packageName = null;
                    }
                    return tempDoc;
                }

                public void saveDocInfo(DefinitionsDocument doc) {
                    this._loc = doc.getCurrentLocation();
                    this._list = doc.getDocumentListeners();
                    this._finalListeners = doc.getFinalizationListeners();
                }

                public void addDocumentListener(DocumentListener dl) {
                    ArrayList<DocumentListener> tmp = new ArrayList<DocumentListener>();
                    DocumentListener[] arr$ = this._list;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        DocumentListener l = arr$[i$];
                        if (dl == l) continue;
                        tmp.add(l);
                    }
                    tmp.add(dl);
                    this._list = tmp.toArray(new DocumentListener[tmp.size()]);
                }

                public String toString() {
                    return ConcreteOpenDefDoc.this.toString();
                }

                static {
                    $assertionsDisabled = !(class$edu$rice$cs$drjava$model$AbstractGlobalModel == null ? (class$edu$rice$cs$drjava$model$AbstractGlobalModel = AbstractGlobalModel.class$("edu.rice.cs.drjava.model.AbstractGlobalModel")) : class$edu$rice$cs$drjava$model$AbstractGlobalModel).desiredAssertionStatus();
                }
            };
        }

        @Override
        public int getInitialVerticalScroll() {
            return this._initVScroll;
        }

        @Override
        public int getInitialHorizontalScroll() {
            return this._initHScroll;
        }

        @Override
        public int getInitialSelectionStart() {
            return this._initSelStart;
        }

        @Override
        public int getInitialSelectionEnd() {
            return this._initSelEnd;
        }

        void setPackage(String pack) {
            this._packageName = pack;
        }

        void setInitialVScroll(int i) {
            this._initVScroll = i;
        }

        void setInitialHScroll(int i) {
            this._initHScroll = i;
        }

        void setInitialSelStart(int i) {
            this._initSelStart = i;
        }

        void setInitialSelEnd(int i) {
            this._initSelEnd = i;
        }

        @Override
        public void updateModifiedSinceSave() {
            this.getDocument().updateModifiedSinceSave();
        }

        protected DefinitionsDocument getDocument() {
            try {
                return this._cacheAdapter.getDocument();
            }
            catch (IOException ioe) {
                try {
                    AbstractGlobalModel.this._notifier.documentNotFound(this, this._file);
                    final String path = AbstractGlobalModel.this.fixPathForNavigator(this.getFile().getCanonicalFile().getCanonicalPath());
                    Utilities.invokeAndWait(new Runnable(){

                        public void run() {
                            ((ConcreteOpenDefDoc)ConcreteOpenDefDoc.this).AbstractGlobalModel.this._documentNavigator.refreshDocument(ConcreteOpenDefDoc.this, path);
                        }
                    });
                    return this._cacheAdapter.getDocument();
                }
                catch (Throwable t) {
                    throw new UnexpectedException(t);
                }
            }
        }

        @Override
        public String getFirstTopLevelClassName() throws ClassNameNotFoundException {
            return this.getDocument().getFirstTopLevelClassName();
        }

        @Override
        public boolean isUntitled() {
            return this._file == null;
        }

        @Override
        public File getFile() throws IllegalStateException, FileMovedException {
            if (this._file == null) {
                throw new IllegalStateException("This document does not yet have a file.");
            }
            if (this._file.exists()) {
                return this._file;
            }
            throw new FileMovedException(this._file, "This document's file has been moved or deleted.");
        }

        @Override
        public boolean fileExists() {
            return this._file != null && this._file.exists();
        }

        @Override
        public File file() {
            return this._file;
        }

        @Override
        public boolean verifyExists() {
            if (this.fileExists()) {
                return true;
            }
            try {
                AbstractGlobalModel.this._notifier.documentNotFound(this, this._file);
                String path = AbstractGlobalModel.this.fixPathForNavigator(this.getFile().getCanonicalPath());
                AbstractGlobalModel.this._documentNavigator.refreshDocument(this, path);
                return true;
            }
            catch (Throwable t) {
                return false;
            }
        }

        @Override
        public String getFilename() {
            if (this._file == null) {
                return "(Untitled)";
            }
            return this._file.getName();
        }

        @Override
        public String getName() {
            String filename = this.getFilename();
            filename = this.isModifiedSinceSave() ? new StringBuffer().append(filename).append("*").toString() : new StringBuffer().append(filename).append("  ").toString();
            return filename;
        }

        @Override
        public boolean saveFile(FileSaveSelector com) throws IOException {
            if (!this.isModifiedSinceSave() && !this.isUntitled()) {
                return true;
            }
            try {
                FileSaveSelector realCommand;
                if (this.isUntitled()) {
                    realCommand = com;
                } else {
                    try {
                        File file = this.getFile();
                        realCommand = new TrivialFSS(file);
                    }
                    catch (FileMovedException fme) {
                        if (com.shouldSaveAfterFileMoved(this, fme.getFile())) {
                            realCommand = com;
                        }
                        return false;
                    }
                }
                return this.saveFileAs(realCommand);
            }
            catch (IllegalStateException ise) {
                throw new UnexpectedException(ise);
            }
        }

        @Override
        public boolean saveFileAs(FileSaveSelector com) throws IOException {
            try {
                boolean openInOtherDoc;
                ConcreteOpenDefDoc openDoc = this;
                File file = com.getFile();
                OpenDefinitionsDocument otherDoc = AbstractGlobalModel.this._getOpenDocument(file);
                boolean shouldSave = false;
                boolean bl = openInOtherDoc = otherDoc != null && openDoc != otherDoc;
                if (openInOtherDoc) {
                    shouldSave = com.warnFileOpen(file);
                }
                if (shouldSave && openInOtherDoc || !openInOtherDoc && (!file.exists() || com.verifyOverwrite())) {
                    if (!file.getCanonicalFile().getName().equals(file.getName())) {
                        file.renameTo(file);
                    }
                    if (file.getAbsolutePath().indexOf("#") != -1) {
                        AbstractGlobalModel.this._notifier.filePathContainsPound();
                    }
                    FileOps.saveFile(new FileOps.DefaultFileSaver(file){

                        public void saveTo(OutputStream os) throws IOException {
                            DefinitionsDocument doc = ConcreteOpenDefDoc.this.getDocument();
                            try {
                                ((ConcreteOpenDefDoc)ConcreteOpenDefDoc.this).AbstractGlobalModel.this._editorKit.write(os, (Document)doc, 0, doc.getLength());
                            }
                            catch (BadLocationException docFailed) {
                                throw new UnexpectedException(docFailed);
                            }
                        }
                    });
                    this.resetModification();
                    this.setFile(file);
                    try {
                        this._packageName = this.getDocument().getPackageName();
                    }
                    catch (InvalidPackageException e) {
                        this._packageName = null;
                    }
                    this.getDocument().setCachedClassFile(null);
                    this.checkIfClassFileInSync();
                    AbstractGlobalModel.this._notifier.fileSaved(openDoc);
                    AbstractGlobalModel.this.addDocToClasspath(this);
                    AbstractGlobalModel.this._documentNavigator.refreshDocument(this, AbstractGlobalModel.this.fixPathForNavigator(file.getCanonicalPath()));
                }
                return true;
            }
            catch (OperationCanceledException oce) {
                return false;
            }
        }

        @Override
        public void resetModification() {
            this.getDocument().resetModification();
            if (this._file != null) {
                this._timestamp = this._file.lastModified();
            }
        }

        @Override
        public void setFile(File file) {
            this._file = file;
            if (this._file != null) {
                this._timestamp = this._file.lastModified();
            }
        }

        @Override
        public long getTimestamp() {
            return this._timestamp;
        }

        @Override
        public void preparePrintJob() throws BadLocationException, FileMovedException {
            String filename = "(Untitled)";
            try {
                filename = this.getFile().getAbsolutePath();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this._book = new DrJavaBook(this.getDocument().getText(), filename, AbstractGlobalModel.this._pageFormat);
        }

        @Override
        public void print() throws PrinterException, BadLocationException, FileMovedException {
            this.preparePrintJob();
            PrinterJob printJob = PrinterJob.getPrinterJob();
            printJob.setPageable(this._book);
            if (printJob.printDialog()) {
                printJob.print();
            }
            this.cleanUpPrintJob();
        }

        @Override
        public Pageable getPageable() throws IllegalStateException {
            return this._book;
        }

        @Override
        public void cleanUpPrintJob() {
            this._book = null;
        }

        @Override
        public void startCompile() throws IOException {
            throw new UnsupportedOperationException("AbstractGlobalModel does not support compilation");
        }

        @Override
        public void runMain() throws IOException, ClassNameNotFoundException {
            throw new UnsupportedOperationException("AbstractGlobalModel does not support running");
        }

        @Override
        public void startJUnit() throws IOException, ClassNotFoundException {
            throw new UnsupportedOperationException("AbstractGlobalModel does not support unit testing");
        }

        @Override
        public void generateJavadoc(FileSaveSelector saver) throws IOException {
            throw new UnsupportedOperationException("AbstractGlobalModel does not support javadoc");
        }

        @Override
        public boolean isModifiedSinceSave() {
            if (this._cacheAdapter != null && this._cacheAdapter.isReady()) {
                return this.getDocument().isModifiedSinceSave();
            }
            return false;
        }

        @Override
        public void documentSaved() {
            this._cacheAdapter.documentSaved(this.getFilename());
        }

        @Override
        public void documentModified() {
            this._cacheAdapter.documentModified();
        }

        @Override
        public void documentReset() {
            this._cacheAdapter.documentReset();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isModifiedOnDisk() {
            boolean ret = false;
            try {
                this.getDocument().aquireReadLock();
                if (this._file != null) {
                    ret = this._file.lastModified() > this._timestamp;
                }
            }
            finally {
                this.getDocument().releaseReadLock();
            }
            return ret;
        }

        @Override
        public boolean checkIfClassFileInSync() {
            File sourceFile;
            if (this.isModifiedSinceSave()) {
                this.getDocument().setClassFileInSync(false);
                return false;
            }
            File classFile = this.getDocument().getCachedClassFile();
            if (classFile == null) {
                classFile = this._locateClassFile();
                this.getDocument().setCachedClassFile(classFile);
                if (classFile == null) {
                    this.getDocument().setClassFileInSync(false);
                    return false;
                }
            }
            try {
                sourceFile = this.getFile();
            }
            catch (IllegalStateException ise) {
                throw new UnexpectedException(ise);
            }
            catch (FileMovedException fme) {
                this.getDocument().setClassFileInSync(false);
                return false;
            }
            if (sourceFile.lastModified() > classFile.lastModified()) {
                this.getDocument().setClassFileInSync(false);
                return false;
            }
            this.getDocument().setClassFileInSync(true);
            return true;
        }

        private File _locateClassFile() {
            try {
                Vector<File> roots;
                File[] sourceRoots;
                String filename;
                block14: {
                    String className = this.getDocument().getQualifiedClassName();
                    String ps = System.getProperty("file.separator");
                    className = StringOps.replace(className, ".", ps);
                    filename = new StringBuffer().append(className).append(".class").toString();
                    sourceRoots = new File[]{};
                    roots = new Vector<File>();
                    if (AbstractGlobalModel.this.getBuildDirectory() != null) {
                        roots.add(AbstractGlobalModel.this.getBuildDirectory());
                    }
                    try {
                        roots.add(this.getSourceRoot());
                    }
                    catch (InvalidPackageException ipe) {
                        try {
                            File f = this.getFile().getParentFile();
                            if (f != null) {
                                roots.add(f);
                            }
                        }
                        catch (IllegalStateException ise) {
                        }
                        catch (FileMovedException fme) {
                            File root = fme.getFile().getParentFile();
                            if (root == null) break block14;
                            roots.add(root);
                        }
                    }
                }
                for (int i = 0; i < sourceRoots.length; ++i) {
                    roots.add(sourceRoots[i]);
                }
                File classFile = AbstractGlobalModel.this.getSourceFileFromPaths(filename, roots);
                if (classFile == null) {
                    String cp = System.getProperty("java.class.path");
                    String pathSeparator = System.getProperty("path.separator");
                    Vector<File> cpVector = new Vector<File>();
                    int i = 0;
                    while (i < cp.length()) {
                        int nextSeparator = cp.indexOf(pathSeparator, i);
                        if (nextSeparator == -1) {
                            cpVector.add(new File(cp.substring(i, cp.length())));
                            break;
                        }
                        cpVector.add(new File(cp.substring(i, nextSeparator)));
                        i = nextSeparator + 1;
                    }
                    classFile = AbstractGlobalModel.this.getSourceFileFromPaths(filename, cpVector);
                }
                if (classFile == null) {
                    classFile = AbstractGlobalModel.this.getSourceFileFromPaths(filename, (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTRA_CLASSPATH)));
                }
                return classFile;
            }
            catch (ClassNameNotFoundException cnnfe) {
                return null;
            }
        }

        @Override
        public boolean revertIfModifiedOnDisk() throws IOException {
            ConcreteOpenDefDoc doc = this;
            if (this.isModifiedOnDisk()) {
                boolean shouldRevert = AbstractGlobalModel.this._notifier.shouldRevertFile(doc);
                if (shouldRevert) {
                    doc.revertFile();
                }
                return shouldRevert;
            }
            return false;
        }

        @Override
        public void close() {
            this.removeFromDebugger();
            this._cacheAdapter.close();
        }

        @Override
        public void revertFile() throws IOException {
            this.removeFromDebugger();
            ConcreteOpenDefDoc doc = this;
            try {
                File file = doc.getFile();
                FileReader reader = new FileReader(file);
                doc.clear();
                AbstractGlobalModel.this._editorKit.read(reader, (Document)doc, 0);
                reader.close();
                this.resetModification();
                doc.checkIfClassFileInSync();
                this.setCurrentLocation(0);
                AbstractGlobalModel.this._notifier.fileReverted(doc);
            }
            catch (IllegalStateException docFailed) {
                throw new UnexpectedException(docFailed);
            }
            catch (BadLocationException docFailed) {
                throw new UnexpectedException(docFailed);
            }
        }

        @Override
        public boolean canAbandonFile() {
            if (this.isModifiedSinceSave() || this._file != null && !this._file.exists() && this._cacheAdapter.isReady()) {
                return AbstractGlobalModel.this._notifier.canAbandonFile(this);
            }
            return true;
        }

        @Override
        public void quitFile() {
            if (this.isModifiedSinceSave() || this._file != null && !this._file.exists() && this._cacheAdapter.isReady()) {
                AbstractGlobalModel.this._notifier.quitFile(this);
            }
        }

        @Override
        public int gotoLine(int line) {
            this.getDocument().gotoLine(line);
            return this.getDocument().getCurrentLocation();
        }

        @Override
        public void setCurrentLocation(int location) {
            this.getDocument().setCurrentLocation(location);
        }

        @Override
        public int getCurrentLocation() {
            return this.getDocument().getCurrentLocation();
        }

        @Override
        public int balanceBackward() {
            return this.getDocument().balanceBackward();
        }

        @Override
        public int balanceForward() {
            return this.getDocument().balanceForward();
        }

        @Override
        public Breakpoint getBreakpointAt(int offset) {
            throw new UnsupportedOperationException("AbstractGlobalModel does not support debugger");
        }

        @Override
        public void addBreakpoint(Breakpoint breakpoint) {
            throw new UnsupportedOperationException("AbstractGlobalModel does not support debugger");
        }

        @Override
        public void removeBreakpoint(Breakpoint breakpoint) {
            throw new UnsupportedOperationException("AbstractGlobalModel does not support debugger");
        }

        @Override
        public Vector<Breakpoint> getBreakpoints() {
            throw new UnsupportedOperationException("AbstractGlobalModel does not support debugger");
        }

        @Override
        public void clearBreakpoints() {
            throw new UnsupportedOperationException("AbstractGlobalModel does not support debugger");
        }

        @Override
        public void removeFromDebugger() {
        }

        @Override
        public File getSourceRoot() throws InvalidPackageException {
            if (this._packageName == null) {
                this._packageName = this.getPackageName();
            }
            return this._getSourceRoot(this._packageName);
        }

        @Override
        public String getPackageName() throws InvalidPackageException {
            if (this.isUntitled()) {
                this._packageName = "";
            } else if (this._packageName == null) {
                this._packageName = this.getDocument().getPackageName();
            }
            return this._packageName;
        }

        File _getSourceRoot(String packageName) throws InvalidPackageException {
            File sourceFile;
            try {
                sourceFile = this.getFile();
            }
            catch (IllegalStateException ise) {
                throw new InvalidPackageException(-1, "Can not get source root for unsaved file. Please save.");
            }
            catch (FileMovedException fme) {
                throw new InvalidPackageException(-1, "File has been moved or deleted from its previous location. Please save.");
            }
            if (packageName.equals("")) {
                return sourceFile.getParentFile();
            }
            ArrayList<String> packageStack = new ArrayList<String>();
            int dotIndex = packageName.indexOf(46);
            int curPartBegins = 0;
            while (dotIndex != -1) {
                packageStack.add(packageName.substring(curPartBegins, dotIndex));
                curPartBegins = dotIndex + 1;
                dotIndex = packageName.indexOf(46, dotIndex + 1);
            }
            packageStack.add(packageName.substring(curPartBegins));
            try {
                File parentDir = sourceFile.getCanonicalFile();
                while (!packageStack.isEmpty()) {
                    String part = (String)AbstractGlobalModel.pop(packageStack);
                    if ((parentDir = parentDir.getParentFile()) == null) {
                        throw new RuntimeException("parent dir is null?!");
                    }
                    if (part.equals(parentDir.getName())) continue;
                    String msg = new StringBuffer().append("The source file ").append(sourceFile.getAbsolutePath()).append(" is in the wrong directory or in the wrong package. ").append("The directory name ").append(parentDir.getName()).append(" does not match the package component ").append(part).append(".").toString();
                    throw new InvalidPackageException(-1, msg);
                }
                if ((parentDir = parentDir.getParentFile()) == null) {
                    throw new RuntimeException("parent dir of first component is null?!");
                }
                return parentDir;
            }
            catch (IOException ioe) {
                String msg = new StringBuffer().append("Could not locate directory of the source file: ").append(ioe).toString();
                throw new InvalidPackageException(-1, msg);
            }
        }

        public String toString() {
            return this.getFilename();
        }

        @Override
        public int compareTo(OpenDefinitionsDocument o) {
            return this._id - o.id();
        }

        @Override
        public void addDocumentListener(DocumentListener listener) {
            if (this._cacheAdapter.isReady()) {
                this.getDocument().addDocumentListener(listener);
            } else {
                this._cacheAdapter.getReconstructor().addDocumentListener(listener);
            }
        }

        @Override
        public void addUndoableEditListener(UndoableEditListener listener) {
            this._undoableEditListeners.add(listener);
            this.getDocument().addUndoableEditListener(listener);
        }

        @Override
        public void removeUndoableEditListener(UndoableEditListener listener) {
            this._undoableEditListeners.remove(listener);
            this.getDocument().removeUndoableEditListener(listener);
        }

        @Override
        public UndoableEditListener[] getUndoableEditListeners() {
            return this.getDocument().getUndoableEditListeners();
        }

        @Override
        public Position createPosition(int offs) throws BadLocationException {
            return this.getDocument().createPosition(offs);
        }

        @Override
        public Element getDefaultRootElement() {
            return this.getDocument().getDefaultRootElement();
        }

        @Override
        public Position getEndPosition() {
            return this.getDocument().getEndPosition();
        }

        @Override
        public int getLength() {
            return this.getDocument().getLength();
        }

        @Override
        public Object getProperty(Object key) {
            return this.getDocument().getProperty(key);
        }

        @Override
        public Element[] getRootElements() {
            return this.getDocument().getRootElements();
        }

        @Override
        public Position getStartPosition() {
            return this.getDocument().getStartPosition();
        }

        @Override
        public String getText(int offset, int length) throws BadLocationException {
            return this.getDocument().getText(offset, length);
        }

        @Override
        public void getText(int offset, int length, Segment txt) throws BadLocationException {
            this.getDocument().getText(offset, length, txt);
        }

        @Override
        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            this.getDocument().insertString(offset, str, a);
        }

        @Override
        public void append(String str, AttributeSet set) {
            this.getDocument().append(str, set);
        }

        @Override
        public void append(String str, Style style) {
            this.getDocument().append(str, style);
        }

        @Override
        public void putProperty(Object key, Object value) {
            this.getDocument().putProperty(key, value);
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            this.getDocument().remove(offs, len);
        }

        @Override
        public void removeDocumentListener(DocumentListener listener) {
            this.getDocument().removeDocumentListener(listener);
        }

        @Override
        public void render(Runnable r) {
            this.getDocument().render(r);
        }

        @Override
        public boolean undoManagerCanUndo() {
            return this._cacheAdapter.isReady() && this.getUndoManager().canUndo();
        }

        @Override
        public boolean undoManagerCanRedo() {
            return this._cacheAdapter.isReady() && this.getUndoManager().canRedo();
        }

        @Override
        public CompoundUndoManager getUndoManager() {
            return this.getDocument().getUndoManager();
        }

        @Override
        public int getLineStartPos(int pos) {
            return this.getDocument().getLineStartPos(pos);
        }

        @Override
        public int getLineEndPos(int pos) {
            return this.getDocument().getLineEndPos(pos);
        }

        @Override
        public int commentLines(int selStart, int selEnd) {
            return this.getDocument().commentLines(selStart, selEnd);
        }

        @Override
        public int uncommentLines(int selStart, int selEnd) {
            return this.getDocument().uncommentLines(selStart, selEnd);
        }

        @Override
        public void indentLines(int selStart, int selEnd) {
            this.getDocument().indentLines(selStart, selEnd);
        }

        @Override
        public int getCurrentCol() {
            return this.getDocument().getCurrentCol();
        }

        @Override
        public boolean getClassFileInSync() {
            return this.getDocument().getClassFileInSync();
        }

        @Override
        public int getIntelligentBeginLinePos(int currPos) throws BadLocationException {
            return this.getDocument().getIntelligentBeginLinePos(currPos);
        }

        @Override
        public int getOffset(int lineNum) {
            return this.getDocument().getOffset(lineNum);
        }

        @Override
        public String getQualifiedClassName() throws ClassNameNotFoundException {
            return this.getDocument().getQualifiedClassName();
        }

        @Override
        public String getQualifiedClassName(int pos) throws ClassNameNotFoundException {
            return this.getDocument().getQualifiedClassName(pos);
        }

        @Override
        public ReducedModelState getStateAtCurrent() {
            return this.getDocument().getStateAtCurrent();
        }

        @Override
        public void resetUndoManager() {
            if (this._cacheAdapter.isReady()) {
                this.getDocument().resetUndoManager();
            }
        }

        @Override
        public File getCachedClassFile() {
            return this.getDocument().getCachedClassFile();
        }

        @Override
        public DocumentListener[] getDocumentListeners() {
            return this.getDocument().getDocumentListeners();
        }

        @Override
        public void setTab(String tab, int pos) {
            this.getDocument().setTab(tab, pos);
        }

        @Override
        public int getWhiteSpace() {
            return this.getDocument().getWhiteSpace();
        }

        @Override
        public boolean posInParenPhrase(int pos) {
            return this.getDocument().posInParenPhrase(pos);
        }

        @Override
        public boolean posInParenPhrase() {
            return this.getDocument().posInParenPhrase();
        }

        @Override
        public int findPrevNonWSCharPos(int pos) throws BadLocationException {
            return this.getDocument().findPrevNonWSCharPos(pos);
        }

        @Override
        public int getFirstNonWSCharPos(int pos) throws BadLocationException {
            return this.getDocument().getFirstNonWSCharPos(pos);
        }

        @Override
        public int getFirstNonWSCharPos(int pos, boolean acceptComments) throws BadLocationException {
            return this.getDocument().getFirstNonWSCharPos(pos, acceptComments);
        }

        @Override
        public int getFirstNonWSCharPos(int pos, char[] whitespace, boolean acceptComments) throws BadLocationException {
            return this.getDocument().getFirstNonWSCharPos(pos, whitespace, acceptComments);
        }

        @Override
        public int getLineFirstCharPos(int pos) throws BadLocationException {
            return this.getDocument().getLineFirstCharPos(pos);
        }

        @Override
        public int findCharOnLine(int pos, char findChar) {
            return this.getDocument().findCharOnLine(pos, findChar);
        }

        @Override
        public String getIndentOfCurrStmt(int pos) throws BadLocationException {
            return this.getDocument().getIndentOfCurrStmt(pos);
        }

        @Override
        public String getIndentOfCurrStmt(int pos, char[] delims) throws BadLocationException {
            return this.getDocument().getIndentOfCurrStmt(pos, delims);
        }

        @Override
        public String getIndentOfCurrStmt(int pos, char[] delims, char[] whitespace) throws BadLocationException {
            return this.getDocument().getIndentOfCurrStmt(pos, delims, whitespace);
        }

        @Override
        public void indentLines(int selStart, int selEnd, int reason, ProgressMonitor pm) throws OperationCanceledException {
            this.getDocument().indentLines(selStart, selEnd, reason, pm);
        }

        @Override
        public int findPrevCharPos(int pos, char[] whitespace) throws BadLocationException {
            return this.getDocument().findPrevCharPos(pos, whitespace);
        }

        @Override
        public boolean findCharInStmtBeforePos(char findChar, int position) {
            return this.getDocument().findCharInStmtBeforePos(findChar, position);
        }

        @Override
        public int findPrevDelimiter(int pos, char[] delims) throws BadLocationException {
            return this.getDocument().findPrevDelimiter(pos, delims);
        }

        @Override
        public int findPrevDelimiter(int pos, char[] delims, boolean skipParenPhrases) throws BadLocationException {
            return this.getDocument().findPrevDelimiter(pos, delims, skipParenPhrases);
        }

        @Override
        public void resetReducedModelLocation() {
            this.getDocument().resetReducedModelLocation();
        }

        @Override
        public ReducedModelState stateAtRelLocation(int dist) {
            return this.getDocument().stateAtRelLocation(dist);
        }

        @Override
        public IndentInfo getIndentInformation() {
            return this.getDocument().getIndentInformation();
        }

        @Override
        public void move(int dist) {
            this.getDocument().move(dist);
        }

        @Override
        public Vector<HighlightStatus> getHighlightStatus(int start, int end) {
            return this.getDocument().getHighlightStatus(start, end);
        }

        @Override
        public void setIndent(int indent) {
            this.getDocument().setIndent(indent);
        }

        @Override
        public int getIndent() {
            return this.getDocument().getIndent();
        }

        @Override
        public void addFinalizationListener(FinalizationListener<DefinitionsDocument> fl) {
            this.getDocument().addFinalizationListener(fl);
        }

        @Override
        public List<FinalizationListener<DefinitionsDocument>> getFinalizationListeners() {
            return this.getDocument().getFinalizationListeners();
        }

        @Override
        public Font getFont(AttributeSet attr) {
            return this.getDocument().getFont(attr);
        }

        @Override
        public Color getBackground(AttributeSet attr) {
            return this.getDocument().getBackground(attr);
        }

        @Override
        public Color getForeground(AttributeSet attr) {
            return this.getDocument().getForeground(attr);
        }

        @Override
        public Element getCharacterElement(int pos) {
            return this.getDocument().getCharacterElement(pos);
        }

        @Override
        public Element getParagraphElement(int pos) {
            return this.getDocument().getParagraphElement(pos);
        }

        @Override
        public Style getLogicalStyle(int p) {
            return this.getDocument().getLogicalStyle(p);
        }

        @Override
        public void setLogicalStyle(int pos, Style s) {
            this.getDocument().setLogicalStyle(pos, s);
        }

        @Override
        public void setCharacterAttributes(int offset, int length, AttributeSet s, boolean replace) {
            this.getDocument().setCharacterAttributes(offset, length, s, replace);
        }

        @Override
        public void setParagraphAttributes(int offset, int length, AttributeSet s, boolean replace) {
            this.getDocument().setParagraphAttributes(offset, length, s, replace);
        }

        @Override
        public Style getStyle(String nm) {
            return this.getDocument().getStyle(nm);
        }

        @Override
        public void removeStyle(String nm) {
            this.getDocument().removeStyle(nm);
        }

        @Override
        public Style addStyle(String nm, Style parent) {
            return this.getDocument().addStyle(nm, parent);
        }

        @Override
        public String getText() {
            DefinitionsDocument doc = this.getDocument();
            doc.acquireReadLock();
            try {
                String string = doc.getText(0, doc.getLength());
                return string;
            }
            catch (BadLocationException e) {
                throw new UnexpectedException(e);
            }
            finally {
                this.releaseReadLock();
            }
        }

        @Override
        public void clear() {
            DefinitionsDocument doc = this.getDocument();
            doc.acquireWriteLock();
            try {
                doc.remove(0, doc.getLength());
            }
            catch (BadLocationException e) {
                throw new UnexpectedException(e);
            }
            finally {
                this.releaseWriteLock();
            }
        }

        @Override
        public void acquireReadLock() {
            this.getDocument().readLock();
        }

        @Override
        public void releaseReadLock() {
            this.getDocument().readUnlock();
        }

        @Override
        public void acquireWriteLock() {
            this.getDocument().acquireWriteLock();
        }

        @Override
        public void releaseWriteLock() {
            this.getDocument().releaseWriteLock();
        }

        @Override
        public /* synthetic */ int compareTo(Object x0) {
            return this.compareTo((OpenDefinitionsDocument)x0);
        }
    }

    class FlatFileGroupingState
    implements FileGroupingState {
        FlatFileGroupingState() {
        }

        public File getBuildDirectory() {
            return null;
        }

        public boolean isProjectActive() {
            return false;
        }

        public boolean isInProjectPath(OpenDefinitionsDocument doc) {
            return false;
        }

        public boolean isInProjectPath(File f) {
            return false;
        }

        public File getProjectFile() {
            return null;
        }

        public void setBuildDirectory(File f) {
        }

        public File[] getProjectFiles() {
            return null;
        }

        public boolean inProject(File f) {
            return false;
        }

        public File getMainClass() {
            return null;
        }

        public void setMainClass(File f) {
        }

        public boolean isProjectChanged() {
            return false;
        }

        public void setProjectChanged(boolean changed) {
        }

        public boolean isAuxiliaryFile(File f) {
            return false;
        }

        public void compileAll() throws IOException {
            throw new UnsupportedOperationException("AbstractGlobalModel does not suport compilation");
        }

        public void junitAll() {
            throw new UnsupportedOperationException("AbstractGlobalModel does not support unit tests");
        }

        public void cleanBuildDirectory() throws FileMovedException, IOException {
        }

        public void jarAll() {
            throw new UnsupportedOperationException("AbstractGlobalModel does not support jarring");
        }

        public ClasspathVector getExtraClasspath() {
            return new ClasspathVector();
        }

        public void setExtraClasspath(ClasspathVector cp) {
            throw new UnsupportedOperationException("Flat grouping states do not have extra classpath entries.");
        }
    }

    class ProjectFileGroupingState
    implements FileGroupingState {
        File _mainFile;
        File _builtDir;
        final File projectFile;
        final File[] projectFiles;
        ClasspathVector _projExtraClasspath;
        private boolean _isProjectChanged = false;
        HashSet<String> _projFilePaths = new HashSet();

        ProjectFileGroupingState(File main, File dir, File project, File[] files, ClasspathVector cp) {
            this._mainFile = main;
            this._builtDir = dir;
            this.projectFile = project;
            this.projectFiles = files;
            this._projExtraClasspath = cp;
            try {
                File[] arr$ = this.projectFiles;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    File file = arr$[i$];
                    this._projFilePaths.add(file.getCanonicalPath());
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }

        public boolean isProjectActive() {
            return true;
        }

        public boolean isInProjectPath(OpenDefinitionsDocument doc) {
            File f;
            File projectRoot = this.projectFile.getParentFile();
            if (doc.isUntitled()) {
                return false;
            }
            try {
                f = doc.getFile();
            }
            catch (FileMovedException fme) {
                f = fme.getFile();
            }
            return this.isInProjectPath(f);
        }

        public boolean isInProjectPath(File f) {
            try {
                File projectRoot = this.projectFile.getParentFile();
                String filePath = f.getParentFile().getCanonicalPath() + File.separator;
                String projectPath = projectRoot.getCanonicalPath() + File.separator;
                return filePath.startsWith(projectPath);
            }
            catch (IOException e) {
                return false;
            }
        }

        public File getProjectFile() {
            return this.projectFile;
        }

        public boolean inProject(File f) {
            if (f == null) {
                return false;
            }
            try {
                String path = f.getCanonicalPath();
                return this._projFilePaths.contains(path);
            }
            catch (IOException ioe) {
                return false;
            }
        }

        public File[] getProjectFiles() {
            return this.projectFiles;
        }

        public File getBuildDirectory() {
            return this._builtDir;
        }

        public void setBuildDirectory(File f) {
            this._builtDir = f;
        }

        public File getMainClass() {
            return this._mainFile;
        }

        public void setMainClass(File f) {
            this._mainFile = f;
        }

        public boolean isProjectChanged() {
            return this._isProjectChanged;
        }

        public void setProjectChanged(boolean changed) {
            this._isProjectChanged = changed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isAuxiliaryFile(File f) {
            String path;
            if (f == null) {
                return false;
            }
            try {
                path = f.getCanonicalPath();
            }
            catch (IOException ioe) {
                return false;
            }
            LinkedList<File> linkedList = AbstractGlobalModel.this._auxiliaryFiles;
            synchronized (linkedList) {
                Iterator i$ = AbstractGlobalModel.this._auxiliaryFiles.iterator();
                while (i$.hasNext()) {
                    File file = (File)i$.next();
                    try {
                        if (!file.getCanonicalPath().equals(path)) continue;
                        return true;
                    }
                    catch (IOException ioe) {
                    }
                }
                return false;
            }
        }

        public void cleanBuildDirectory() throws FileMovedException, IOException {
            File dir = this.getBuildDirectory();
            this.cleanHelper(dir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
        }

        private void cleanHelper(File f) {
            if (f.isDirectory()) {
                File[] fs;
                File[] arr$ = fs = f.listFiles(new FilenameFilter(){

                    public boolean accept(File parent, String name) {
                        return new File(parent, name).isDirectory() || name.endsWith(".class");
                    }
                });
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    File kid = arr$[i$];
                    this.cleanHelper(kid);
                }
                if (f.listFiles().length == 0) {
                    f.delete();
                }
            } else if (f.getName().endsWith(".class")) {
                f.delete();
            }
        }

        public void compileAll() throws IOException {
            throw new UnsupportedOperationException("AbstractGlobalModel does not support compilation");
        }

        public void junitAll() {
            throw new UnsupportedOperationException("AbstractGlobalModel does not support JUnit testing");
        }

        public void jarAll() {
            throw new UnsupportedOperationException("AbstractGlobaModel does not support jarring");
        }

        public ClasspathVector getExtraClasspath() {
            return this._projExtraClasspath;
        }

        public void setExtraClasspath(ClasspathVector cp) {
            this._projExtraClasspath = cp;
        }
    }
}

