/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.config;

import edu.rice.cs.drjava.config.FormatStrategy;
import edu.rice.cs.drjava.config.Option;
import edu.rice.cs.drjava.config.OptionParseException;
import edu.rice.cs.drjava.config.ParseStrategy;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VectorOption<T>
extends Option<Vector<T>> {
    protected ParseStrategy<T> parser;
    protected FormatStrategy<T> formatter;
    public final String header;
    public final char delim;
    public final String footer;

    private VectorOption(String key, ParseStrategy<T> parser, FormatStrategy<T> formatter, String header, char delim, String footer, Vector<T> def) {
        super(key, def);
        this.parser = parser;
        this.formatter = formatter;
        this.header = header;
        this.delim = delim;
        this.footer = footer;
    }

    public VectorOption(String key, Option<T> strategy, String header, char delim, String footer, Vector<T> def) {
        this(key, strategy, strategy, header, delim, footer, def);
    }

    public VectorOption(String key, Option<T> option, Vector<T> def) {
        this(key, option, option, "[", ',', "]", def);
    }

    @Override
    public Vector<T> parse(String s) {
        s = s.trim();
        int startFirstElement = this.header.length();
        int startFooter = s.length() - this.footer.length();
        if (startFooter < startFirstElement || !s.startsWith(this.header) || !s.endsWith(this.footer)) {
            throw new OptionParseException(this.name, s, new StringBuffer().append("Value must start with ").append(this.header).append(" and end ").append("with ").append(this.footer).append(" to be a valid vector.").toString());
        }
        s = s.substring(startFirstElement, startFooter);
        String d = String.valueOf(this.delim);
        StringTokenizer st = new StringTokenizer(s, d, true);
        Vector<T> res = new Vector<T>();
        boolean sawDelim = st.hasMoreTokens();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            boolean isDelim = token.equals(d);
            if (!isDelim) {
                res.add(this.parser.parse(token));
            } else if (sawDelim) {
                throw new OptionParseException(this.name, s, "Argument contains delimiter with no preceding list element.");
            }
            sawDelim = isDelim;
        }
        if (sawDelim) {
            throw new OptionParseException(this.name, s, "Value shouldn't end with a delimiter.");
        }
        return res;
    }

    @Override
    public String format(Vector<T> v) {
        StringBuffer res = new StringBuffer(this.header);
        int size = v.size();
        int i = 0;
        while (i < size) {
            res.append(this.formatter.format(v.get(i)));
            if (++i >= size) continue;
            res.append(this.delim);
        }
        return res.append(this.footer).toString();
    }

    @Override
    public /* synthetic */ String format(Object x0) {
        return this.format((Vector)x0);
    }

    @Override
    public /* synthetic */ Object parse(String x0) {
        return this.parse(x0);
    }
}

