/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.config;

import edu.rice.cs.drjava.config.DefaultOptionMap;
import edu.rice.cs.drjava.config.Option;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionMap;
import edu.rice.cs.drjava.config.OptionParser;
import edu.rice.cs.util.UnexpectedException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.Properties;

public class OptionMapLoader
implements OptionConstants {
    private static DefaultOptionMap DEFAULTS = new DefaultOptionMap();
    private static Properties DEFAULT_STRINGS = new Properties();
    public static final OptionMapLoader DEFAULT;
    private final Properties prop;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OptionMapLoader(InputStream is) throws IOException {
        this(new Properties(DEFAULT_STRINGS));
        try {
            this.prop.load(is);
        }
        finally {
            is.close();
        }
    }

    private OptionMapLoader(Properties prop) {
        this.prop = prop;
    }

    public void loadInto(OptionMap map) {
        Iterator<OptionParser<?>> options = DEFAULTS.keys();
        while (options.hasNext()) {
            OptionParser<?> option = options.next();
            String val = this.prop.getProperty(option.name);
            map.setString(option, val);
        }
    }

    static {
        Field[] fields = OptionConstants.class.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Option option;
            Field field = fields[i];
            int mods = field.getModifiers();
            if (!Modifier.isStatic(mods) || !Modifier.isPublic(mods) || !Modifier.isFinal(mods)) continue;
            try {
                Object o = field.get(null);
                if (o == null || !(o instanceof Option)) continue;
                option = (Option)o;
            }
            catch (IllegalAccessException e) {
                throw new UnexpectedException(e);
            }
            String sval = option.getDefaultString();
            DEFAULT_STRINGS.setProperty(option.name, sval);
            DEFAULTS.setString(option, sval);
        }
        DEFAULT = new OptionMapLoader(DEFAULT_STRINGS);
    }
}

